/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class ReceiveAllUpdatesRequest
implements ExtendedRequest {
    private String partitionDN;
    private String toServerDN;
    private String fromServerDN;

    public ReceiveAllUpdatesRequest() {
    }

    public ReceiveAllUpdatesRequest(String partitionDN, String toServerDN, String fromServerDN) {
        this.partitionDN = partitionDN;
        this.toServerDN = toServerDN;
        this.fromServerDN = fromServerDN;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.22")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.partitionDN, true);
            ber.encodeString(this.toServerDN, true);
            ber.encodeString(this.fromServerDN, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getFromServerDN() {
        return this.fromServerDN;
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.21";
    }

    public String getPartitionDN() {
        return this.partitionDN;
    }

    public String getToServerDN() {
        return this.toServerDN;
    }

    public void setFromServerDN(String fromServerDN) {
        this.fromServerDN = fromServerDN;
    }

    public void setPartitionDN(String partitionDN) {
        this.partitionDN = partitionDN;
    }

    public void setToServerDN(String toServerDN) {
        this.toServerDN = toServerDN;
    }
}

