/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class RemoveOrphanNamingContextRequest
implements ExtendedRequest {
    private String serverDN;
    private String partitionDN;

    public RemoveOrphanNamingContextRequest() {
    }

    public RemoveOrphanNamingContextRequest(String serverDN, String partitionDN) {
        this.serverDN = serverDN;
        this.partitionDN = partitionDN;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.42")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.serverDN, true);
            ber.encodeString(this.partitionDN, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.41";
    }

    public String getPartitionDN() {
        return this.partitionDN;
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public void setPartitionDN(String partitionDN) {
        this.partitionDN = partitionDN;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }
}

