/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class RemoveReplicaRequest
implements ExtendedRequest {
    private int flag;
    private String serverDN;
    private String replicaDN;

    public RemoveReplicaRequest() {
    }

    public RemoveReplicaRequest(String replicaDN, String serverDN, int flag) {
        this.flag = flag;
        this.serverDN = serverDN;
        this.replicaDN = replicaDN;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.12")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeInt(this.flag);
            ber.encodeString(this.serverDN, true);
            ber.encodeString(this.replicaDN, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public int getFlag() {
        return this.flag;
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.11";
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public String getreplicaDN() {
        return this.replicaDN;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setReplicaDN(String replicaDN) {
        this.replicaDN = replicaDN;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }
}

