/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class SchemaSyncRequest
implements ExtendedRequest {
    private int delay;
    private String serverDN;

    public SchemaSyncRequest() {
    }

    public SchemaSyncRequest(String serverDN, int delay) {
        this.serverDN = serverDN;
        this.delay = delay;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.28")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public int getDelay() {
        return this.delay;
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.serverDN, true);
            ber.encodeInt(this.delay);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.27";
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }
}

