/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class SetReplicationFilterRequest
implements ExtendedRequest {
    private String serverDN;
    private String[][] replicationFilter;

    public SetReplicationFilterRequest() {
    }

    public SetReplicationFilterRequest(String serverDN, String[][] replicationFilter) {
        this.serverDN = serverDN;
        this.replicationFilter = replicationFilter;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.36")) {
            throw new NamingException("SetReplicationFilter request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.serverDN, true);
            ber.beginSeq(48);
            int i = 0;
            while (i < this.replicationFilter.length && this.replicationFilter[i] != null) {
                ber.beginSeq(48);
                ber.encodeString(this.replicationFilter[i][0], true);
                ber.beginSeq(48);
                int j = 1;
                while (j < this.replicationFilter[i].length && this.replicationFilter[i][j] != null) {
                    ber.encodeString(this.replicationFilter[i][j], true);
                    ++j;
                }
                ber.endSeq();
                ber.endSeq();
                ++i;
            }
            ber.endSeq();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.35";
    }

    public String[][] getReplicationFilter() {
        return this.replicationFilter;
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public void setReplicationFilter(String[][] replicationFilter) {
        this.replicationFilter = replicationFilter;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }
}

