/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ssl;

import com.novell.service.security.net.SecureSocket;
import com.novell.service.security.net.SecureSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class LdapSecureSocket
extends SSLSocket
implements SSLSession {
    public static final String CIPHERSUITE_NAME = "UNKNOWN_CIPHERSUITE";
    public static final String[] CIPHERSUITES = new String[]{"UNKNOWN_CIPHERSUITE"};
    private SecureSocket Socket;
    private boolean IsServer;
    private long CreateTime = System.currentTimeMillis();
    private Hashtable Bindings = new Hashtable();

    LdapSecureSocket(SecureSocket s) {
        this.Socket = s;
        this.IsServer = true;
    }

    LdapSecureSocket(String Host, int Port) throws IOException {
        this.Socket = SecureSocketFactory.getDefault().createSocket(Host, Port);
    }

    LdapSecureSocket(String Host, int Port, InetAddress lAddress, int lPort) throws IOException {
        this.Socket = SecureSocketFactory.getDefault().createSocket(Host, Port, lAddress, lPort);
    }

    LdapSecureSocket(InetAddress Address, int Port) throws IOException {
        this.Socket = SecureSocketFactory.getDefault().createSocket(Address, Port);
    }

    LdapSecureSocket(InetAddress Address, int Port, InetAddress lAddress, int lPort) throws IOException {
        this.Socket = SecureSocketFactory.getDefault().createSocket(Address, Port, lAddress, lPort);
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener l) {
        l.handshakeCompleted(new HandshakeCompletedEvent(this, this));
    }

    public void close() throws IOException {
        this.Socket.close();
    }

    public String getCipherSuite() {
        return CIPHERSUITE_NAME;
    }

    public long getCreationTime() {
        return this.CreateTime;
    }

    public boolean getEnableSessionCreation() {
        return true;
    }

    public String[] getEnabledCipherSuites() {
        return CIPHERSUITES;
    }

    public byte[] getId() {
        return new byte[0];
    }

    public InetAddress getInetAddress() {
        return this.Socket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.Socket.getInputStream();
    }

    public long getLastAccessedTime() {
        return this.CreateTime;
    }

    public InetAddress getLocalAddress() {
        return this.Socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.Socket.getLocalPort();
    }

    public boolean getNeedClientAuth() {
        return false;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.Socket.getOutputStream();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        throw new SSLPeerUnverifiedException(null);
    }

    public String getPeerHost() {
        return this.getInetAddress().getHostName();
    }

    public int getPort() {
        return this.Socket.getPort();
    }

    public SSLSession getSession() {
        return this;
    }

    public SSLSessionContext getSessionContext() {
        return null;
    }

    public int getSoLinger() throws SocketException {
        return this.Socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.Socket.getSoTimeout();
    }

    public String[] getSupportedCipherSuites() {
        return CIPHERSUITES;
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.Socket.getTcpNoDelay();
    }

    public boolean getUseClientMode() {
        return this.IsServer ^ true;
    }

    public Object getValue(String Name2) {
        return this.Bindings.get(Name2);
    }

    public String[] getValueNames() {
        Hashtable hashtable = this.Bindings;
        synchronized (hashtable) {
            Enumeration Iterator2 = this.Bindings.keys();
            String[] Names = new String[this.Bindings.size()];
            int i = 0;
            while (i < Names.length) {
                Names[i] = (String)Iterator2.nextElement();
                ++i;
            }
            String[] stringArray = Names;
            Object var3_6 = null;
            return stringArray;
        }
    }

    public void invalidate() {
    }

    public void putValue(String Name2, Object Value) {
        Hashtable hashtable = this.Bindings;
        synchronized (hashtable) {
            this.removeValue(Name2);
            this.Bindings.put(Name2, Value);
            if (Value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)Value).valueBound(new SSLSessionBindingEvent(this, Name2));
            }
        }
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener l) {
    }

    public void removeValue(String Name2) {
        Object Obj = this.Bindings.remove(Name2);
        if (Obj != null && Obj instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)Obj).valueUnbound(new SSLSessionBindingEvent(this, Name2));
        }
    }

    public void setEnableSessionCreation(boolean b) {
        throw new IllegalArgumentException("setEnableSessionCreation");
    }

    public void setEnabledCipherSuites(String[] Ciphers) {
        int i = 0;
        while (i < Ciphers.length) {
            if (!Ciphers[i].equals(CIPHERSUITE_NAME)) {
                throw new IllegalArgumentException(String.valueOf(Ciphers[i]) + " not supported");
            }
            ++i;
        }
    }

    public void setNeedClientAuth(boolean b) {
        throw new IllegalArgumentException("setNeedClientAuth");
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.Socket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.Socket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.Socket.setTcpNoDelay(on);
    }

    public void setUseClientMode(boolean b) {
        throw new IllegalArgumentException("setUseClientMode");
    }

    public void startHandshake() {
    }
}

