/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

public class ByteArraySearch {
    private static final int TABLE_SIZE = 256;
    private int[] m_jumpTable = new int[256];
    private byte[] m_byPattern = null;
    private byte[] m_bySearchIn = null;
    private int m_iStartAt = 0;
    private int m_iCount = 0;

    public void setPatternToFind(byte[] byArray) {
        int n = byArray.length;
        this.m_byPattern = byArray;
        int n2 = 0;
        while (n2 < 256) {
            this.m_jumpTable[n2] = n;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            this.m_jumpTable[n3] = n - 1 - n2;
            ++n2;
        }
    }

    public void setBufferToSearch(byte[] byArray, int n, int n2) {
        this.m_bySearchIn = new byte[n2];
        System.arraycopy(byArray, n, this.m_bySearchIn, 0, n2);
        this.m_iStartAt = n;
        this.m_iCount = n2;
    }

    public int doSearch() {
        int n = this.m_byPattern.length;
        int n2 = this.m_iCount;
        int n3 = n;
        int n4 = n3 - 1;
        while (n4 < n2 && n3 != 0) {
            if (this.m_bySearchIn[n4] == this.m_byPattern[n3 - 1]) {
                --n3;
                --n4;
                continue;
            }
            int n5 = n - n3 + 1;
            int n6 = this.m_bySearchIn[n4] & 0xFF;
            int n7 = this.m_jumpTable[n6];
            n7 = n5 > n7 ? n5 : n7;
            n4 += n7;
            n3 = n;
        }
        if (n3 == 0) {
            return n4 + 1 + this.m_iStartAt;
        }
        return -1;
    }
}

