/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import java.util.NoSuchElementException;

public class ByteArrayTokenizer {
    protected byte[] m_buf = null;
    protected int m_iCurIdx = 0;
    protected byte[] m_delims = new byte[]{32, 9, 13, 10};
    protected boolean m_bReturnTokens = false;

    public ByteArrayTokenizer(byte[] byArray) {
        this.m_buf = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_buf, 0, byArray.length);
        this.readyNextToken();
    }

    public ByteArrayTokenizer(byte[] byArray, byte[] byArray2) {
        this.m_buf = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_buf, 0, byArray.length);
        this.m_delims = byArray2;
        this.readyNextToken();
    }

    public ByteArrayTokenizer(byte[] byArray, byte[] byArray2, boolean bl) {
        this.m_buf = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_buf, 0, byArray.length);
        this.m_delims = byArray2;
        this.m_bReturnTokens = bl;
        this.readyNextToken();
    }

    protected void readyNextToken() {
        if (this.m_bReturnTokens) {
            return;
        }
        int n = this.m_buf.length;
        if (this.m_iCurIdx >= n) {
            return;
        }
        byte by = this.m_buf[this.m_iCurIdx];
        while (this.isDelimiter(by) && this.m_iCurIdx + 1 < n) {
            by = this.m_buf[++this.m_iCurIdx];
        }
    }

    public boolean isDelimiter(byte by) {
        int n = this.m_delims.length;
        int n2 = 0;
        while (n2 < n) {
            if (by == this.m_delims[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasMoreElements() {
        return this.m_iCurIdx < this.m_buf.length;
    }

    public byte[] nextElement() throws NoSuchElementException {
        if (this.m_iCurIdx >= this.m_buf.length) {
            throw new NoSuchElementException();
        }
        int n = this.m_iCurIdx;
        int n2 = this.m_iCurIdx;
        byte[] byArray = null;
        byte by = this.m_buf[this.m_iCurIdx++];
        while (!this.isDelimiter(by)) {
            ++n2;
            by = this.m_buf[this.m_iCurIdx++];
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            ++n3;
        }
        byArray = new byte[n3];
        System.arraycopy(this.m_buf, n, byArray, 0, n3);
        this.readyNextToken();
        return byArray;
    }

    public byte[] nextToken() {
        return this.nextElement();
    }

    public byte[] nextToken(byte[] byArray) {
        this.m_delims = byArray;
        return this.nextElement();
    }

    public static int intValue(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if (by < 48 || by > 57) {
                return n;
            }
            n = n * 10 + (by - 48);
            ++n3;
        }
        return n;
    }

    public static long longValue(byte[] byArray) {
        long l = 0L;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by < 48 || by > 57) {
                return l;
            }
            l = l * 10L + (long)(by - 48);
            ++n2;
        }
        return l;
    }
}

