/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.ByteArraySearch;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.njFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class I18NMultipartParser
extends I18NServletRequest {
    static final int INPUT_BUF_SIZE = 24000;
    boolean m_bMultipart = false;
    HttpServletRequest m_request = null;
    Hashtable m_ht = null;
    byte m_pendingByte;
    boolean m_bBytePending = false;
    private InputStream m_is;
    private long m_iTotalRead = 0L;
    private byte[] m_inputBuffer = null;
    private int m_inputBufferPos = 0;
    private int m_inputBufferSize = 0;
    private int m_iNest = 0;
    private String m_strUploadDir = null;
    private Log m_log = null;
    private boolean m_bReadError = false;
    private long m_lWaitCount = 0L;
    private long m_lTotalReadCount = 0L;
    private long m_lContentLength = 0L;
    private boolean m_bEndOfStream = false;

    public I18NMultipartParser(HttpServletRequest httpServletRequest, String string) {
        this(httpServletRequest, string, null);
    }

    public I18NMultipartParser(HttpServletRequest httpServletRequest, String string, Log log) {
        super(httpServletRequest);
        this.m_log = log;
        this.m_request = httpServletRequest;
        Object var4_4 = null;
        this.m_strUploadDir = string;
    }

    protected Hashtable getContentData(Hashtable hashtable) {
        String string = this.m_request.getContentType();
        if (string == null || !string.toLowerCase().startsWith("multipart/form-data")) {
            super.getContentData(hashtable);
            return hashtable;
        }
        try {
            this.m_is = this.m_request.getInputStream();
        }
        catch (IOException iOException) {
            return hashtable;
        }
        this.m_inputBuffer = new byte[24000];
        this.m_ht = hashtable;
        String string2 = this.getBoundary(string);
        this.parseMultiPart(string2);
        if (this.m_bReadError) {
            this.put("MultiPart.Upload.error", "1");
        }
        return hashtable;
    }

    private void put(String string, String string2) {
        String[] stringArray = null;
        if (this.m_ht.containsKey(string)) {
            String[] stringArray2 = (String[])this.m_ht.get(string);
            stringArray = new String[stringArray2.length + 1];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray[n] = stringArray2[n];
                ++n;
            }
            stringArray[stringArray2.length] = string2;
        } else {
            stringArray = new String[]{string2};
        }
        this.m_ht.put(string, stringArray);
    }

    private void parseMultiPart(String string) {
        try {
            try {
                this.getLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = this.m_iNest++;
            while (this.m_iNest > n && !this.m_bReadError) {
                this.parsePart(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parsePart(String string) {
        String string2 = null;
        String string3 = null;
        String[] stringArray = new String[]{null, null};
        this.parseHeaders(stringArray);
        string2 = stringArray[0];
        string3 = stringArray[1];
        if (string2 == null) {
            return;
        }
        if (string3 == null) {
            this.parseNameValuePairs(string2, string);
        } else {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            FilterOutputStream filterOutputStream = null;
            if (string3.length() > 0) {
                this.put(string2 + ".name", string3);
                String string4 = this.getTempFile();
                if (string4 != null) {
                    this.put(string2 + ".tempFile", string4);
                    try {
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string4)), 24576);
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
            try {
                long l = this.saveFile(string, (BufferedOutputStream)filterOutputStream);
                this.put(string2 + ".size", String.valueOf(l));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseHeaders(String[] var1_1) {
        var2_2 = null;
        try {
            var2_2 = this.getLine();
            if (true) ** GOTO lbl37
        }
        catch (IOException var3_3) {
            --this.m_iNest;
            return;
        }
        do {
            var3_4 = new StringTokenizer(var2_2, " =;", true);
            while (var3_4.hasMoreTokens()) {
                var4_5 = var3_4.nextToken(" =;");
                if (var4_5.equalsIgnoreCase("Content-Type:")) {
                    var4_5 = var3_4.nextToken();
                    if (!var4_5.equalsIgnoreCase("multipart/mixed")) continue;
                    var5_7 = var3_4.nextToken();
                    if (!var4_5.equalsIgnoreCase("boundary")) continue;
                    var6_8 = var3_4.nextToken();
                    this.parseMultiPart(var6_8);
                    return;
                }
                if (var4_5.equalsIgnoreCase("name")) {
                    if (!var3_4.hasMoreTokens() || !(var4_5 = var3_4.nextToken()).equals("=") || !var3_4.hasMoreTokens()) continue;
                    var1_1[0] = var3_4.nextToken();
                    continue;
                }
                if (!var4_5.equalsIgnoreCase("filename") || !var3_4.hasMoreTokens() || !(var4_5 = var3_4.nextToken()).equals("=") || !var3_4.hasMoreTokens()) continue;
                var4_5 = var3_4.nextToken("\"");
                if (!var3_4.hasMoreTokens() || (var4_5 = var3_4.nextToken()).equals("\"")) continue;
                var1_1[1] = var4_5;
                if (!var3_4.hasMoreTokens()) continue;
                var4_5 = var3_4.nextToken();
            }
            try {
                var2_2 = this.getLine();
            }
            catch (IOException var4_6) {
                --this.m_iNest;
                return;
            }
lbl37:
            // 2 sources

        } while (var2_2 != null && var2_2.length() > 0 && !this.m_bReadError);
    }

    /*
     * Unable to fully structure code
     */
    private void parseNameValuePairs(String var1_1, String var2_2) {
        var3_3 = "";
        var4_4 = null;
        try {
            var4_4 = this.getLine();
            if (true) ** GOTO lbl17
        }
        catch (IOException var5_5) {
            --this.m_iNest;
            return;
        }
        do {
            var3_3 = var3_3.length() > 0 ? var3_3 + "\r\n" + var4_4 : var3_3 + var4_4;
            try {
                var4_4 = this.getLine();
            }
            catch (IOException var5_6) {
                --this.m_iNest;
                return;
            }
lbl17:
            // 2 sources

        } while (!var4_4.startsWith("--" + var2_2));
        if (var1_1.startsWith("\"") && var1_1.endsWith("\"")) {
            var1_1 = var1_1.substring(1, var1_1.length() - 1);
        }
        if (var3_3.startsWith("\"") && var3_3.endsWith("\"")) {
            var3_3 = var3_3.substring(1, var3_3.length() - 1);
        }
        this.put(var1_1, var3_3);
        var5_7 = "--" + var2_2 + "--";
        if (var4_4.equals(var5_7)) {
            --this.m_iNest;
        }
    }

    private long parseFileContents(String string, BufferedOutputStream bufferedOutputStream) throws IOException {
        int n = string.length() + 4;
        int n2 = 24576;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        long l = 0L;
        int n4 = this.read();
        byArray[n3++] = (byte)n4;
        ++l;
        boolean bl = false;
        while (!bl && n4 != -1) {
            if (n4 == 13) {
                if (n3 - 1 < n || n3 - 1 > n + 2) {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.write(byArray, 0, n3 - 1);
                    }
                    byArray[0] = 13;
                    n3 = 1;
                } else {
                    String string2 = new String(byArray, 0, n3 - 1);
                    if (string2.equals("\r\n--" + string)) {
                        bl = true;
                        n4 = this.read();
                        if (n4 == -1) break;
                        l -= (long)(string.length() + 5);
                    } else if (string2.equals("\r\n--" + string + "--")) {
                        bl = true;
                        --this.m_iNest;
                        l -= (long)(string.length() + 7);
                        n4 = this.read();
                        if (n4 == -1) break;
                    }
                }
            }
            if (!bl && n3 + 2 == n2) {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.write(byArray, 0, n3);
                }
                n3 = 0;
            }
            if (bl) continue;
            n4 = this.read();
            if (n4 == -1) break;
            byArray[n3++] = (byte)n4;
            ++l;
        }
        return l;
    }

    private String getLine() throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = this.read();
        char c = (char)n2;
        while (n2 != -1 && c != '\r' && c != '\n' && n < 1023) {
            byArray[n++] = (byte)n2;
            n2 = this.read();
            c = (char)n2;
        }
        if (c == '\r') {
            n2 = this.read();
            c = (char)n2;
        }
        if (n2 == -1) {
            this.m_bReadError = true;
        }
        return new String(byArray, 0, n, this.getCharacterEncoding());
    }

    private String getBoundary(String string) {
        int n = string.indexOf("boundary=");
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(n += 9);
        int n2 = string2.indexOf(",");
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    private synchronized String getTempFile() {
        if (!this.fixupUploadDir()) {
            return null;
        }
        int n = 97;
        Date date = new Date();
        long l = date.getTime();
        String string = new String(this.m_strUploadDir + Long.toHexString(l) + (char)n + ".mpf");
        File file = new File(string);
        while (file.exists()) {
            n = (char)(n + '\u0001');
            string = new String(this.m_strUploadDir + Long.toHexString(l) + (char)n + ".mpf");
            file = new File(string);
            if (n != 122) continue;
            date = new Date();
            l = date.getTime();
            n = 65;
        }
        return string;
    }

    private boolean fixupUploadDir() {
        if (this.m_strUploadDir == null || this.m_strUploadDir.length() == 0) {
            this.error("Error.Upload.badPath", "", null, null, null, null, null, 2);
            return false;
        }
        njFile njFile2 = new njFile(this.m_strUploadDir);
        try {
            this.m_strUploadDir = njFile2.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!this.m_strUploadDir.endsWith("/") && !this.m_strUploadDir.endsWith("\\")) {
            this.m_strUploadDir = this.m_strUploadDir + njFile.separator;
        }
        if (!njFile2.isDirectory() && !njFile2.mkdirs()) {
            this.error("Error.Upload.badPath", njFile2.getAbsolutePath(), null, null, null, null, null, 2);
            return false;
        }
        return true;
    }

    private int refillBuffer() {
        if (this.m_lTotalReadCount == 0L) {
            this.m_lContentLength = this.m_request.getContentLength();
        }
        if (this.m_lTotalReadCount >= this.m_lContentLength) {
            return -1;
        }
        boolean bl = false;
        int n = this.m_inputBufferSize - this.m_inputBufferPos;
        System.arraycopy(this.m_inputBuffer, this.m_inputBufferPos, this.m_inputBuffer, 0, n);
        int n2 = 24000 - n;
        int n3 = -1;
        try {
            n3 = this.m_is.read(this.m_inputBuffer, n, n2);
            this.m_lTotalReadCount += (long)n3;
        }
        catch (SocketException socketException) {
            System.out.println(socketException.getMessage());
            socketException.printStackTrace();
            this.error("Error.Upload.readData", null, null, null, null, null, null, 0);
            this.m_bReadError = true;
            return -1;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            this.error("Error.Upload.readData", null, null, null, null, null, null, 0);
            this.m_bReadError = true;
            return -1;
        }
        if (n3 != -1) {
            this.m_iTotalRead += (long)n3;
            this.m_inputBufferSize = n + n3;
        } else {
            this.m_inputBufferSize = n;
        }
        this.m_inputBufferPos = 0;
        return n3;
    }

    private long saveFile(String string, BufferedOutputStream bufferedOutputStream) throws IOException {
        int n;
        int n2;
        int n3;
        long l = 0L;
        String string2 = "\r\n--" + string;
        byte[] byArray = string2.getBytes();
        int n4 = byArray.length;
        ByteArraySearch byteArraySearch = new ByteArraySearch();
        byteArraySearch.setPatternToFind(byArray);
        do {
            n2 = this.m_inputBufferSize - this.m_inputBufferPos - n4 - 2;
            byteArraySearch.setBufferToSearch(this.m_inputBuffer, this.m_inputBufferPos, n2);
            n3 = byteArraySearch.doSearch();
            if (n3 == -1) {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.write(this.m_inputBuffer, this.m_inputBufferPos, n2);
                }
                l += (long)n2;
                this.m_inputBufferPos += n2;
                if (this.refillBuffer() != -1) continue;
                this.m_bReadError = true;
                return l;
            }
            n = n3 - this.m_inputBufferPos;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.write(this.m_inputBuffer, this.m_inputBufferPos, n);
            }
            this.m_inputBufferPos += n;
            l += (long)n;
        } while (n3 == -1 && this.m_inputBufferSize > 0);
        if (n3 == -1) {
            n2 = this.m_inputBufferSize - this.m_inputBufferPos;
            byteArraySearch.setBufferToSearch(this.m_inputBuffer, this.m_inputBufferPos, n2);
            n3 = byteArraySearch.doSearch();
            if (n3 != -1) {
                n = n3 - this.m_inputBufferPos;
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.write(this.m_inputBuffer, this.m_inputBufferPos, n);
                }
                this.m_inputBufferPos += n;
                l += (long)n;
            }
        }
        return l;
    }

    private int read() {
        if (this.m_inputBufferPos >= this.m_inputBufferSize && this.refillBuffer() == -1 && this.m_inputBufferSize == 0) {
            return -1;
        }
        return this.m_inputBuffer[this.m_inputBufferPos++] & 0xFF;
    }

    private int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                return n4;
            }
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    private void error(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) {
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NLocale i18NLocale = null;
        i18NLocale = this.m_log != null ? this.m_log.getI18NLocale() : new I18NLocale();
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.I18NMultipartParser", i18NLocale);
        String string8 = i18NPropertyBundle.getProperty(string);
        string8 = MessageFormat.format(string8, objectArray);
        if (this.m_log != null) {
            int n2 = 3;
            if (n == 2) {
                n2 = 1;
            }
            this.m_log.logMessage(string8, "MPF", null, null, n, n2);
        } else {
            System.out.println(string8);
        }
    }
}

