/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.Provider;
import com.novell.webaccess.common.ProviderClassContext;
import com.novell.webaccess.common.ProviderContext;
import com.novell.webaccess.common.Session;
import com.novell.webaccess.common.UserInfo;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public class ProviderLoader
extends ClassLoader {
    private static Object sm_syncObject = new Object();
    protected static boolean sm_bCheckedSetAttr = false;
    protected static boolean sm_bCallSetAttr = true;
    private static Hashtable sm_providerContexts = null;
    private Log m_log = null;
    private String m_sDefaultProvider = null;
    private Properties m_propsConfig = null;
    private Hashtable m_providerData = null;
    private ServletContext m_servletContext = null;
    private HttpServlet m_servlet = null;

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = null;
        clazz = classLoader == null ? this.findSystemClass(string) : classLoader.loadClass(string);
        return clazz;
    }

    public void init(Properties properties, Log log, ServletContext servletContext, HttpServlet httpServlet) {
        if (servletContext != null) {
            this.m_servletContext = servletContext;
        }
        if (httpServlet != null) {
            this.m_servlet = httpServlet;
        }
        if (this.m_providerData == null) {
            this.m_providerData = new Hashtable();
        }
        if (sm_providerContexts == null) {
            sm_providerContexts = new Hashtable();
        }
        this.m_providerData.put("_ClassCache_", new Hashtable());
        if (log != null) {
            this.m_log = log;
        }
        this.m_propsConfig = properties;
        this.m_sDefaultProvider = (String)((Hashtable)this.m_propsConfig).get("Provider.default");
        if (this.m_sDefaultProvider == null) {
            this.m_sDefaultProvider = "GWAP";
        }
        ProviderClassContext providerClassContext = null;
        String string = null;
        Enumeration enumeration = this.m_providerData.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.startsWith("_Provider_") || (providerClassContext = (ProviderClassContext)this.m_providerData.get(string)) == null) continue;
            string = string.substring(10);
            this.initializeProviderData(string, providerClassContext, this.m_propsConfig);
        }
    }

    public String getDefaultProviderName() {
        return this.m_sDefaultProvider;
    }

    public static ProviderContext getProviderContext(Provider provider) {
        return (ProviderContext)sm_providerContexts.get(provider);
    }

    public static ProviderContext removeProviderContext(Provider provider) {
        return (ProviderContext)sm_providerContexts.remove(provider);
    }

    public Provider loadProvider(String string, Session session, HttpServletRequest httpServletRequest) {
        Provider provider;
        block18: {
            provider = null;
            ProviderClassContext providerClassContext = null;
            try {
                if (string == null || string.length() == 0) {
                    string = this.m_sDefaultProvider;
                }
                if ((provider = (Provider)session.getValue(string)) != null) break block18;
                String string2 = this.m_propsConfig.getProperty("Provider." + string + ".class");
                if (string2 == null) {
                    this.logError("Loader.missingCfgEntry", string, null, null, null, null, null);
                    break block18;
                }
                Object object = sm_syncObject;
                synchronized (object) {
                    Hashtable hashtable = (Hashtable)this.m_providerData.get("_ClassCache_");
                    Class clazz = (Class)hashtable.get(string);
                    if (clazz == null) {
                        try {
                            clazz = this.loadClass(string2, true);
                            hashtable.put(string, clazz);
                            providerClassContext = new ProviderClassContext(string, this.m_servletContext, this.m_servlet);
                            this.initializeProviderData(string, providerClassContext, this.m_propsConfig);
                            this.m_providerData.put("_Provider_" + string, providerClassContext);
                            this.logVerbose("Loader.providerLoaded", string2, null, null, null, null, null);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.logError("Loader.classNotFound", string2, null, null, null, null, null);
                            classNotFoundException.printStackTrace();
                        }
                        catch (Exception exception) {
                            this.logError("Loader.failure", string2, null, null, null, null, null);
                            exception.printStackTrace();
                        }
                    }
                    if (clazz != null) {
                        Constructor constructor = null;
                        try {
                            constructor = clazz.getConstructor(new Class[0]);
                            provider = (Provider)constructor.newInstance(new Class[0]);
                            this.initProvider(string, provider, session, httpServletRequest, this.m_log);
                            session.putValue(string, provider);
                            session.addProvider(string, provider);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            this.logError("Loader.missingMethod", string2, null, null, null, null, null);
                            noSuchMethodException.printStackTrace();
                        }
                        catch (InstantiationException instantiationException) {
                            this.logError("Loader.noInstantiation", string2, null, null, null, null, null);
                            instantiationException.printStackTrace();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            this.logError("Loader.noConstructorAccess", string2, null, null, null, null, null);
                            illegalAccessException.printStackTrace();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.logError("Loader.badConstructorArg", string2, null, null, null, null, null);
                            illegalArgumentException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            this.logError("Loader.constructorException", string2, null, null, null, null, null);
                            Exception exception = (Exception)invocationTargetException.getTargetException();
                            exception.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return provider;
    }

    void initProvider(String string, Provider provider, Session session, HttpServletRequest httpServletRequest, Log log) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        ProviderClassContext providerClassContext = null;
        ProviderContext providerContext = null;
        try {
            object3 = ((I18NServletRequest)httpServletRequest).getWebAppSession();
            if (!sm_bCheckedSetAttr) {
                try {
                    serializable = object3.getClass();
                    object2 = new Class[2];
                    Class.forName("java.lang.String");
                    Class.forName("java.lang.Object");
                    object = ((Class)serializable).getMethod("setAttribute", (Class<?>)object2);
                    sm_bCallSetAttr = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    sm_bCallSetAttr = false;
                }
                sm_bCheckedSetAttr = true;
            }
            if (sm_bCallSetAttr) {
                object3.setAttribute("WebAccessSession", (Object)session);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = (UserInfo)session.getValue("USER");
        serializable = ((UserInfo)object3).getProperties();
        object2 = (String)((Hashtable)serializable).get("Browser.os");
        object = null;
        I18NLocale i18NLocale = null;
        object = (I18NLocale)session.getValue("UILocale");
        i18NLocale = (I18NLocale)session.getValue("BrowserLocale");
        providerClassContext = (ProviderClassContext)this.m_providerData.get("_Provider_" + string);
        providerContext = new ProviderContext(providerClassContext, session, (I18NLocale)object, i18NLocale, (String)object2, this.m_propsConfig, log);
        sm_providerContexts.put(provider, providerContext);
        provider.init(providerContext);
    }

    private void initializeProviderData(String string, ProviderClassContext providerClassContext, Properties properties) {
        String string2 = "Provider." + string + ".";
        Enumeration enumeration = ((Hashtable)properties).keys();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            providerClassContext.put(string3, ((Hashtable)properties).get(string3));
        }
    }

    private void logError(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (this.m_log == null) {
            return;
        }
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.ProviderResources", this.m_log.getI18NLocale());
        String string8 = i18NPropertyBundle.getProperty(string);
        string8 = MessageFormat.format(string8, objectArray);
        this.m_log.logMessage(string8, "PROVIDER", null, null, 2, 1);
    }

    private void logVerbose(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (this.m_log == null) {
            return;
        }
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.ProviderResources", this.m_log.getI18NLocale());
        String string8 = i18NPropertyBundle.getProperty(string);
        string8 = MessageFormat.format(string8, objectArray);
        this.m_log.logMessage(string8, "PROVIDER", null, null, 0, 2);
    }
}

