/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.Authenticator;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.Provider;
import com.novell.webaccess.common.ProviderContext;
import com.novell.webaccess.common.ProviderLoader;
import com.novell.webaccess.common.SessionManager;
import com.novell.webaccess.common.UserInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class Session
implements Serializable,
HttpSession {
    public static final int TIMED_OUT = 1;
    public static final int AUTHENTICATION_REQUIRED = 2;
    public static final int ALREADY_LOGGED_IN = 4;
    public static final int INVALID_HASH = 8;
    public static final int INVALID_COOKIE = 16;
    public static final String USE_SESSION_COOKIE_KEY = "Security.Session.UseClientCookie.enable";
    private String m_sId = null;
    private String m_sSessionCookie = null;
    private String m_sCharEncoding = null;
    private boolean m_bUseCookie = false;
    private long m_lHash = 0L;
    private long m_lCreationTime = 0L;
    private long m_lLastAccessTime = 0L;
    private int m_maxInactiveInterval = 0;
    private boolean m_bNew = true;
    private boolean m_bIsLoggedIn = false;
    private int m_iFlags = 0;
    private Properties m_properties = null;
    private Hashtable m_authenticators = new Hashtable();
    private Hashtable m_providers = new Hashtable();
    private boolean m_bInService = false;
    private transient Object m_syncInService = new Object();
    private transient SessionManager m_sessionManager = null;

    public Session(String string, long l, String string2) {
        this.setCreationTime();
        this.m_properties = new Properties();
        this.m_sId = string;
        this.m_lHash = l;
        this.m_sSessionCookie = string2;
    }

    public ServletContext getServletContext() {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_syncInService = new Object();
    }

    public void setFlags(int n) {
        this.m_iFlags = n;
    }

    public int getFlags() {
        return this.m_iFlags;
    }

    public void startInService() {
        while (true) {
            if (this.m_syncInService == null) {
                this.m_syncInService = new Object();
            }
            Object object = this.m_syncInService;
            synchronized (object) {
                if (!this.m_bInService) {
                    this.m_bInService = true;
                    break;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stopInService() {
        Object object = this.m_syncInService;
        synchronized (object) {
            this.m_bInService = false;
        }
    }

    public synchronized boolean isInService() {
        return this.m_bInService;
    }

    public String getCharacterEncoding() {
        return this.m_sCharEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.m_sCharEncoding = string;
    }

    private void setCreationTime() {
        this.m_lLastAccessTime = this.m_lCreationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.m_lCreationTime;
    }

    public void setLastAccessedTime() {
        this.m_lLastAccessTime = System.currentTimeMillis();
    }

    public long getLastAccessedTime() {
        return this.m_lLastAccessTime;
    }

    public void setMaxInactiveInterval(int n) {
        this.m_maxInactiveInterval = n;
    }

    public int getMaxInactiveInterval() {
        return this.m_maxInactiveInterval;
    }

    public boolean isNew() {
        return this.m_bNew;
    }

    public void setNew(boolean bl) {
        this.m_bNew = bl;
    }

    public void setLoggedIn(boolean bl) {
        this.m_bIsLoggedIn = bl;
    }

    public boolean getLoggedIn() {
        return this.m_bIsLoggedIn;
    }

    void setSessionManager(SessionManager sessionManager) {
        this.m_sessionManager = sessionManager;
    }

    public void invalidate() {
        if (this.m_sessionManager != null) {
            this.m_sessionManager.invalidate(this);
        }
    }

    public void destroy(int n) {
        Enumeration enumeration = this.getProviders();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            provider.destroy(n);
        }
    }

    public void setAttribute(String string, Object object) {
        ((Hashtable)this.m_properties).put(string, object);
    }

    public void putValue(String string, Object object) {
        ((Hashtable)this.m_properties).put(string, object);
        if (string.equals("UILocale")) {
            Enumeration enumeration = this.m_providers.elements();
            while (enumeration.hasMoreElements()) {
                Provider provider = (Provider)enumeration.nextElement();
                ProviderContext providerContext = ProviderLoader.getProviderContext(provider);
                if (providerContext == null) continue;
                I18NLocale i18NLocale = providerContext.getUILocale();
                i18NLocale.update((I18NLocale)object);
            }
        }
    }

    public Object getAttribute(String string) {
        return ((Hashtable)this.m_properties).get(string);
    }

    public Object getValue(String string) {
        return ((Hashtable)this.m_properties).get(string);
    }

    public void removeAttribute(String string) {
        ((Hashtable)this.m_properties).remove(string);
    }

    public void removeValue(String string) {
        ((Hashtable)this.m_properties).remove(string);
    }

    public Enumeration getAttributeNames() {
        return ((Hashtable)this.m_properties).keys();
    }

    public String[] getValueNames() {
        Enumeration enumeration = ((Hashtable)this.m_properties).keys();
        int n = 0;
        int n2 = ((Hashtable)this.m_properties).size();
        String[] stringArray = new String[n2];
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String getId() {
        return this.m_sId;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public long getHash() {
        return this.m_lHash;
    }

    public void setUseCookie(boolean bl) {
        this.m_bUseCookie = bl;
        UserInfo userInfo = (UserInfo)this.getValue("USER");
        if (userInfo != null) {
            String string = null;
            string = bl ? "true" : "false";
            userInfo.setProperty(USE_SESSION_COOKIE_KEY, string);
        }
    }

    public boolean useCookie() {
        return this.m_bUseCookie;
    }

    public String getSessionCookie() {
        return this.m_sSessionCookie;
    }

    public UserInfo getUserInfo() {
        return (UserInfo)this.getValue("USER");
    }

    public void addProvider(String string, Provider provider) {
        this.m_providers.put(string, provider);
    }

    public Provider getProvider(String string) {
        return (Provider)this.m_providers.get(string);
    }

    public Enumeration getProviders() {
        return this.m_providers.elements();
    }

    public Enumeration getProviderNames() {
        return this.m_providers.keys();
    }

    public void addAuthenticator(String string, Authenticator authenticator) {
        this.m_authenticators.put(string, authenticator);
    }

    public Authenticator getAuthenticator(String string) {
        return (Authenticator)this.m_authenticators.get(string);
    }

    public Enumeration getAuthenticators() {
        return this.m_authenticators.elements();
    }
}

