/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.ByteCodeOutputStream;
import com.novell.webaccess.common.CompileException;
import com.novell.webaccess.common.Condition;
import com.novell.webaccess.common.EOTemplateException;
import com.novell.webaccess.common.FixupEntry;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NPropertyBundle;
import com.novell.webaccess.common.Log;
import com.novell.webaccess.common.SBTokenizer;
import com.novell.webaccess.common.SymbolTableEntry;
import com.novell.webaccess.common.TemplateTextStream;
import com.novell.webaccess.common.njFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

class TemplateCompiler {
    static final byte[] OP_NOP = new byte[]{0, 0, 0, 0};
    static final int iOP_NOP = 0;
    static final byte[] OP_OUT = new byte[]{0, 0, 0, 1};
    static final int iOP_OUT = 1;
    static final byte[] OP_PUSH = new byte[]{0, 0, 0, 2};
    static final int iOP_PUSH = 2;
    static final byte[] OP_ADD = new byte[]{0, 0, 0, 3};
    static final int iOP_ADD = 3;
    static final byte[] OP_SUB = new byte[]{0, 0, 0, 4};
    static final int iOP_SUB = 4;
    static final byte[] OP_MULT = new byte[]{0, 0, 0, 5};
    static final int iOP_MULT = 5;
    static final byte[] OP_DIV = new byte[]{0, 0, 0, 6};
    static final int iOP_DIV = 6;
    static final byte[] OP_MOD = new byte[]{0, 0, 0, 7};
    static final int iOP_MOD = 7;
    static final byte[] OP_SET = new byte[]{0, 0, 0, 8};
    static final int iOP_SET = 8;
    static final byte[] OP_SETG = new byte[]{0, 0, 0, 9};
    static final int iOP_SETG = 9;
    static final byte[] OP_PRN = new byte[]{0, 0, 0, 10};
    static final int iOP_PRN = 10;
    static final byte[] OP_CAT = new byte[]{0, 0, 0, 11};
    static final int iOP_CAT = 11;
    static final byte[] OP_LINE = new byte[]{0, 0, 0, 12};
    static final int iOP_LINE = 12;
    static final byte[] OP_INCL = new byte[]{0, 0, 0, 13};
    static final int iOP_INCL = 13;
    static final byte[] OP_EOIN = new byte[]{0, 0, 0, 14};
    static final int iOP_EOIN = 14;
    static final byte[] OP_QUIT = new byte[]{0, 0, 0, 15};
    static final int iOP_QUIT = 15;
    static final byte[] OP_FLSH = new byte[]{0, 0, 0, 16};
    static final int iOP_FLSH = 16;
    static final byte[] OP_DUMP = new byte[]{0, 0, 0, 17};
    static final int iOP_DUMP = 17;
    static final byte[] OP_REPL = new byte[]{0, 0, 0, 18};
    static final int iOP_REPL = 18;
    static final byte[] OP_INC = new byte[]{0, 0, 0, 19};
    static final int iOP_INC = 19;
    static final byte[] OP_DEC = new byte[]{0, 0, 0, 20};
    static final int iOP_DEC = 20;
    static final byte[] OP_STAB = new byte[]{0, 0, 0, 21};
    static final int iOP_STAB = 21;
    static final byte[] OP_DEF = new byte[]{0, 0, 0, 22};
    static final int iOP_DEF = 22;
    static final byte[] OP_JZ = new byte[]{0, 0, 0, 23};
    static final int iOP_JZ = 23;
    static final byte[] OP_JNZ = new byte[]{0, 0, 0, 24};
    static final int iOP_JNZ = 24;
    static final byte[] OP_JMP = new byte[]{0, 0, 0, 25};
    static final int iOP_JMP = 25;
    static final byte[] OP_CMP = new byte[]{0, 0, 0, 26};
    static final int iOP_CMP = 26;
    static final byte[] OP_BAND = new byte[]{0, 0, 0, 27};
    static final int iOP_BAND = 27;
    static final byte[] OP_BOR = new byte[]{0, 0, 0, 28};
    static final int iOP_BOR = 28;
    static final byte[] OP_FNC = new byte[]{0, 0, 0, 29};
    static final int iOP_FNC = 29;
    static final byte[] OP_IDXV = new byte[]{0, 0, 0, 30};
    static final int iOP_IDXV = 30;
    static final byte[] OP_NOT = new byte[]{0, 0, 0, 31};
    static final int iOP_NOT = 31;
    static final byte[] OP_TST = new byte[]{0, 0, 0, 32};
    static final int iOP_TST = 32;
    static final byte[] OP_DREF = new byte[]{0, 0, 0, 33};
    static final int iOP_DREF = 33;
    static final byte[] OP_HDR = new byte[]{0, 0, 0, 34};
    static final int iOP_HDR = 34;
    static final byte[] OP_COOK = new byte[]{0, 0, 0, 35};
    static final int iOP_COOK = 35;
    static final byte[] BC_FALSE = new byte[]{0, 0, 0, 0};
    static final byte[] BC_TRUE = new byte[]{0, 0, 0, 1};
    static final byte[] BC_ZERO = new byte[]{0, 0, 0, 0};
    static final byte[] BC_EQUAL = new byte[]{0, 0, 0, 1};
    static final byte[] BC_GREATER = new byte[]{0, 0, 0, 2};
    static final byte[] BC_LESS = new byte[]{0, 0, 0, 3};
    static final int IDENT_BAD = 0;
    static final int IDENT_GOOD = 1;
    static final int IDENT_SUBSCRIPT = 2;
    private static final String[][] m_tblKeywords = new String[][]{{"!", "doCOMMENT", "doCOMMENT"}, {"OUTPUT", "doOUTPUT", "doOUTPUT"}, {"NOOUTPUT", "doNOOUTPUT", "doNOOUTPUT"}, {"IF", "doIF", "doIF"}, {"IFDEF", "doIFDEF", "doIFDEF"}, {"ELSE", "doELSE", "doELSE"}, {"ELSEIFDEF", "doELSEIFDEF", "doELSEIFDEF"}, {"ELSEIF", "doELSEIF", "doELSEIF"}, {"ENDIF", "doENDIF", "doENDIF"}, {"WHILE", "doWHILE", "doWHILE"}, {"BREAK", "doBREAK", "doNOOP"}, {"CONTINUE", "doCONTINUE", "doNOOP"}, {"ENDWHILE", "doENDWHILE", "doENDWHILE"}, {"SET", "doSETLOCAL", "doNOOP"}, {"SETGLOBAL", "doSETGLOBAL", "doNOOP"}, {"INC", "doINC", "doNOOP"}, {"DEC", "doDEC", "doNOOP"}, {"INCLUDE", "doINCLUDE", "doNOOP"}, {"STRINGTABLE", "doSTRINGTABLE", "doNOOP"}, {"STRING", "doSTRING", "doNOOP"}, {"VAR", "doVAR", "doNOOP"}, {"IGNOREWHITE", "doIGNOREWHITE", "doNOOP"}, {"NOIGNOREWHITE", "doNOIGNOREWHITE", "doNOOP"}, {"ABORT", "doABORT", "doNOOP"}, {"FLUSH", "doFLUSH", "doNOOP"}, {"DUMPALL", "doDUMPALL", "doNOOP"}, {"COOKIE", "doCOOKIE", "doNOOP"}, {"HEADER", "doHEADER", "doNOOP"}, {"HEADER", "doHEADER", "doNOOP"}, {"ALIAS", "doALIAS", "doALIAS"}, {"NOOP", "doNOOP", "doNOOP"}};
    private static final int TABLE_ENTRIES = 31;
    private static final String[][] m_tblFunctions = new String[][]{{"substring", "3"}, {"toLower", "1"}, {"toUpper", "1"}, {"length", "1"}, {"findLast", "2"}, {"find", "2"}, {"date", "2"}, {"createDate", "3"}, {"firstWeekDayOfMonth", "1"}, {"firstDayOfWeek", "2"}, {"daysInMonth", "1"}, {"today", "0"}, {"todayTZ", "0"}, {"addToDate", "3"}, {"escape", "1"}, {"replaceWith", "3"}, {"linkURLs", "5"}, {"linkEncodedURLs", "5"}, {"toHTML", "1"}, {"toScript", "1"}, {"urlEncode", "1"}, {"urlEncodePath", "1"}, {"listToArray", "3"}, {"trim", "1"}, {"startsWith", "2"}, {"endsWith", "2"}, {"toSpellerText", "2"}, {"getHeader", "1"}, {"toHTMLExt", "1"}, {"listToSortedArray", "4"}, {"toDisplay", "1"}, {"toXML", "1"}, {"xmlEncode", "1"}, {"xmlDecode", "1"}, {"formatMessage", "1+"}, {"toTag", "1"}, {"toWMLExt", "1"}, {"toQuote", "1"}};
    private static final int FUNCTION_COUNT = 38;
    static final char TEMPLATE_START_CHAR = '{';
    static final char TEMPLATE_END_CHAR = '}';
    static final char TEMPLATE_COMMENT_CHAR = '!';
    static final char TEMPLATE_ESCAPE_CHAR = '\\';
    private ByteCodeOutputStream m_bcOs = null;
    private Vector m_vSymEntries = null;
    private Vector m_vIfFixupEntries = null;
    private Vector m_vWhileFixupEntries = null;
    private Hashtable m_hAliases = new Hashtable();
    private Stack m_ifStack = new Stack();
    private Stack m_whileStack = new Stack();
    private int m_iFixup = 0;
    private String m_strTemplatePath;
    protected TemplateTextStream m_tStream = null;
    private int m_iIgnoreWhite = 0;
    private boolean m_bLastWhite = false;
    private byte[] m_rgNewLine = new byte[]{10};
    private Log m_log = null;
    private boolean m_bDebug = false;
    private OutputStream m_osErr = null;
    private String m_strCharSet = null;
    private I18NLocale m_uiLocale = null;
    private boolean m_bOutputOccured = false;
    private int m_iOutput = 0;
    private int m_iResursionDepth = 0;
    private static Properties m_inProcess = new Properties();

    public TemplateCompiler(InputStream inputStream, String string, String string2, OutputStream outputStream, I18NLocale i18NLocale, Log log) {
        if (!this.isValidPath(string, string2)) {
            string2 = "";
        }
        njFile njFile2 = new njFile(string2);
        try {
            string2 = njFile2.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.init(inputStream, string2, outputStream, i18NLocale, log);
    }

    void init(InputStream inputStream, String string, OutputStream outputStream, I18NLocale i18NLocale, Log log) {
        this.m_tStream = new TemplateTextStream(inputStream);
        this.m_log = log;
        this.m_strTemplatePath = string;
        this.m_osErr = outputStream == null ? System.out : outputStream;
        this.m_uiLocale = i18NLocale == null ? new I18NLocale() : i18NLocale;
        this.m_strCharSet = this.m_uiLocale.getCharset();
        this.m_vSymEntries = new Vector();
        this.m_vIfFixupEntries = new Vector();
        this.m_vWhileFixupEntries = new Vector();
        int n = TemplateCompiler.fourByteToInt(BC_ZERO);
        int n2 = TemplateCompiler.fourByteToInt(BC_EQUAL);
        int n3 = TemplateCompiler.fourByteToInt(BC_GREATER);
        int n4 = TemplateCompiler.fourByteToInt(BC_LESS);
        this.m_vSymEntries.addElement(new SymbolTableEntry("*_ZERO", 18, String.valueOf(n)));
        this.m_vSymEntries.addElement(new SymbolTableEntry("*_EQ", 18, String.valueOf(n2)));
        this.m_vSymEntries.addElement(new SymbolTableEntry("*_GT", 18, String.valueOf(n3)));
        this.m_vSymEntries.addElement(new SymbolTableEntry("*_LS", 18, String.valueOf(n4)));
        this.m_vSymEntries.addElement(new SymbolTableEntry("*_templateName", 26, string));
    }

    TemplateCompiler(String string, Vector vector, Vector vector2, Vector vector3, I18NLocale i18NLocale, Log log) {
        this.m_log = log;
        this.m_uiLocale = i18NLocale;
        this.m_strTemplatePath = string;
        this.m_vSymEntries = vector;
        this.m_vIfFixupEntries = vector2;
        this.m_vWhileFixupEntries = vector3;
        this.m_vSymEntries.addElement(new SymbolTableEntry("*_includeName", 26, string));
    }

    public static String getFunctionName(int n) {
        if (n > 38) {
            return "";
        }
        return m_tblFunctions[n][0];
    }

    public Vector getSymbolTable() {
        return this.m_vSymEntries;
    }

    static short TwoByteToShort(byte[] byArray) {
        return (short)((short)byArray[0] << 8 | byArray[1] & 0xFF);
    }

    static int fourByteToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    static int eightByteToLong(byte[] byArray) {
        return (int)((long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[0] & 0xFF) << 24 | (long)(byArray[1] & 0xFF) << 16 | (long)(byArray[2] & 0xFF) << 8 | (long)(byArray[3] & 0xFF));
    }

    boolean compile(ByteCodeOutputStream byteCodeOutputStream, boolean bl) throws CompileException {
        Object object;
        while (!TemplateCompiler.isFreeToCompile(this.m_strTemplatePath)) {
            try {
                this.wait(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File file = new File(this.m_strTemplatePath);
        if (!file.exists()) {
            object = file.getName();
            int n = ((String)object).lastIndexOf(47);
            if (n < 0) {
                n = ((String)object).lastIndexOf(92);
            }
            if (n > 0) {
                object = ((String)object).substring(n + 1);
            }
            TemplateCompiler.doneCompiling(this.m_strTemplatePath);
            this.compileError("Error.Compile.Template.noExist", (String)object, null, null, null, null, null);
        }
        object = null;
        try {
            object = new FileInputStream(file);
        }
        catch (IOException iOException) {
            object = null;
        }
        if (object == null) {
            String string = file.getName();
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            if (n > 0) {
                string = string.substring(n + 1);
            }
            TemplateCompiler.doneCompiling(this.m_strTemplatePath);
            this.compileError("Error.Compile.Template.noOpen", string, null, null, null, null, null);
        }
        this.m_tStream = new TemplateTextStream((InputStream)object);
        return this.compileStream(byteCodeOutputStream, bl);
    }

    boolean compileStream(ByteCodeOutputStream byteCodeOutputStream, boolean bl) throws CompileException {
        char c;
        this.m_bcOs = byteCodeOutputStream;
        this.m_bDebug = bl;
        try {
            c = this.m_tStream.read();
        }
        catch (EOTemplateException eOTemplateException) {
            try {
                this.m_tStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TemplateCompiler.doneCompiling(this.m_strTemplatePath);
            return true;
        }
        while (true) {
            if (this.m_bDebug) {
                int n = (int)this.m_tStream.getLineNumber();
                byte[] byArray = this.intToBytes(n);
                this.writeByteCode(OP_LINE);
                this.writeByteCode(byArray);
            }
            try {
                this.CompilePart(c);
                c = this.m_tStream.read();
            }
            catch (CompileException compileException) {
                try {
                    this.m_tStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TemplateCompiler.doneCompiling(this.m_strTemplatePath);
                throw compileException;
            }
            catch (EOTemplateException eOTemplateException) {
                try {
                    this.m_tStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TemplateCompiler.doneCompiling(this.m_strTemplatePath);
                if (this.m_ifStack.size() > 0) {
                    System.out.println();
                    String string = this.m_strTemplatePath + ": Missing {ENDIF}";
                    this.compileError("Error.Compile.ENDIF.missing", "IF", "ENDIF", null, null, null, null);
                    throw new CompileException(string);
                }
                if (this.m_whileStack.size() > 0) {
                    String string = this.m_strTemplatePath + ": Missing {ENDWHILE}";
                    this.compileError("Error.Compile.ENDWHILE.missing", "WHILE", "ENDWHILE", null, null, null, null);
                    throw new CompileException(string);
                }
                return true;
            }
        }
    }

    private boolean isValidPath(String string, String string2) {
        boolean bl = false;
        njFile njFile2 = new njFile(string);
        njFile njFile3 = new njFile(string2);
        try {
            String string3 = njFile2.getCanonicalPath();
            String string4 = njFile3.getCanonicalPath();
            if (njFile.separatorChar == '/') {
                string3 = string3.replace('\\', njFile.separatorChar);
                string4 = string4.replace('\\', njFile.separatorChar);
            } else {
                string3 = string3.replace('/', njFile.separatorChar);
                string4 = string4.replace('/', njFile.separatorChar);
            }
            if (string4.startsWith(string3)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static synchronized boolean isFreeToCompile(String string) {
        if (string != null) {
            String string2 = m_inProcess.getProperty(string);
            if (string2 == null) {
                ((Hashtable)m_inProcess).put(string, "1");
                return true;
            }
            return false;
        }
        return true;
    }

    private static synchronized void doneCompiling(String string) {
        if (string != null) {
            ((Hashtable)m_inProcess).remove(string);
        }
    }

    boolean CompilePart(char c) throws CompileException, EOTemplateException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(c);
        if (c != '{') {
            this.doTEXT(stringBuffer);
            return true;
        }
        String string = this.getPotentialKeyword(stringBuffer);
        String string2 = this.expandAliasKeyword(string, stringBuffer);
        if (string2 != null) {
            string = string2;
        }
        if ((n = this.isTemplateKeyword(string)) != -1) {
            this.compileKeyword(string, n, stringBuffer);
        } else {
            this.doTEXT(stringBuffer);
        }
        return true;
    }

    String expandAliasKeyword(String string, StringBuffer stringBuffer) throws EOTemplateException {
        StringBuffer stringBuffer2 = null;
        String string2 = null;
        stringBuffer2 = (StringBuffer)this.m_hAliases.get(string);
        if (stringBuffer2 != null) {
            while (this.m_tStream.read() != '}') {
            }
        }
        while (stringBuffer2 != null) {
            int n = stringBuffer2.length();
            char c = '\u0000';
            while (n > 0) {
                c = stringBuffer2.charAt(--n);
                if (n <= 0 && c == '{') continue;
                this.m_tStream.putBack(c);
            }
            stringBuffer.setLength(stringBuffer.length() - string.length());
            string = string2 = this.getPotentialKeyword(stringBuffer);
            if (this.isTemplateKeyword(string) == -1) {
                stringBuffer.setLength(0);
            }
            stringBuffer2 = (StringBuffer)this.m_hAliases.get(string);
        }
        return string2;
    }

    boolean expandAliasOperand(String string) throws EOTemplateException {
        boolean bl = false;
        StringBuffer stringBuffer = null;
        Object var4_4 = null;
        stringBuffer = (StringBuffer)this.m_hAliases.get(string);
        if (stringBuffer != null) {
            bl = true;
            int n = stringBuffer.length();
            char c = '\u0000';
            while (n > 0) {
                c = stringBuffer.charAt(--n);
                if (n <= 0 && c == '{') continue;
                this.m_tStream.putBack(c);
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    String getPotentialKeyword(StringBuffer var1_1) {
        var2_2 = null;
        try {
            var3_3 = this.m_tStream.read();
        }
        catch (EOTemplateException var4_4) {
            return "";
        }
        if (var3_3 != '!') ** GOTO lbl17
        var2_2 = "!";
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var1_1.append(var3_3);
            try {
                var3_3 = this.m_tStream.read();
                continue;
            }
            catch (EOTemplateException var4_5) {
                return "";
            }
lbl17:
            // 2 sources

            ** while (Character.isWhitespace((char)var3_3))
        }
lbl18:
        // 1 sources

        var4_6 = new StringBuffer();
        if (Character.isJavaIdentifierStart(var3_3)) ** GOTO lbl31
        this.m_tStream.putBack(var3_3);
        return "";
lbl-1000:
        // 1 sources

        {
            var1_1.append(var3_3);
            var4_6.append(var3_3);
            try {
                var3_3 = this.m_tStream.read();
                continue;
            }
            catch (EOTemplateException var5_7) {
                return "";
            }
lbl31:
            // 2 sources

            ** while (Character.isJavaIdentifierPart((char)var3_3))
        }
lbl32:
        // 1 sources

        this.m_tStream.putBack(var3_3);
        return var4_6.toString();
    }

    private int isTemplateKeyword(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = 0;
        n = 0;
        while (n < 31) {
            if (string.equals(m_tblKeywords[n][0])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean compileKeyword(String string, int n, StringBuffer stringBuffer) throws EOTemplateException, CompileException {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = stringBuffer.length();
        int n3 = 0;
        stringBuffer3.append(stringBuffer.charAt(n3++));
        if (n3 < n2) {
            char c = stringBuffer.charAt(n3);
            while (n3 < n2 && Character.isWhitespace(c)) {
                stringBuffer3.append(c);
                c = stringBuffer.charAt(n3++);
            }
        }
        n3 += string.length();
        int n4 = stringBuffer.length();
        while (n3 < n4) {
            stringBuffer2.append(stringBuffer.charAt(n3));
            ++n3;
        }
        if (string.equals(m_tblKeywords[0][0])) {
            this.getRestOfComment(stringBuffer2);
        } else {
            this.getRestOfKeyword(stringBuffer2);
        }
        if (this.m_bDebug) {
            byte[] byArray = stringBuffer3.toString().getBytes();
            byte[] byArray2 = string.getBytes();
            byte[] byArray3 = stringBuffer2.toString().getBytes();
            int n5 = byArray.length + byArray2.length + byArray3.length;
            byte[] byArray4 = this.intToBytes(n5);
            this.writeByteCode(byArray4);
            this.writeByteCode(byArray);
            this.writeByteCode(byArray2);
            this.writeByteCode(byArray3);
        }
        return this.processKeyword(stringBuffer2, n, false);
    }

    /*
     * Unable to fully structure code
     */
    void getRestOfComment(StringBuffer var1_1) {
        var2_2 = 1;
        var4_3 = false;
        try {
            var3_4 = this.m_tStream.read();
            if (true) ** GOTO lbl43
        }
        catch (EOTemplateException var5_5) {
            return;
        }
        do {
            if (!var4_3 && var3_4 == '\\') {
                var4_3 = true;
            } else {
                if (var4_3) {
                    switch (var3_4) {
                        case 'n': {
                            var3_4 = '\n';
                            break;
                        }
                        case 'r': {
                            var3_4 = '\r';
                            break;
                        }
                        case 't': {
                            var3_4 = '\t';
                            break;
                        }
                        case 'f': {
                            var3_4 = '\f';
                            break;
                        }
                        case 'b': {
                            var3_4 = '\b';
                        }
                    }
                } else if (var3_4 == '{') {
                    ++var2_2;
                } else if (var3_4 == '}') {
                    --var2_2;
                }
                var4_3 = false;
                var1_1.append(var3_4);
            }
            if (var2_2 <= 0) continue;
            try {
                var3_4 = this.m_tStream.read();
            }
            catch (EOTemplateException var5_6) {
                return;
            }
lbl43:
            // 3 sources

        } while (var2_2 > 0);
    }

    /*
     * Unable to fully structure code
     */
    void getRestOfKeyword(StringBuffer var1_1) throws CompileException, EOTemplateException {
        var2_2 = 1;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var7_6 = false;
        var8_7 = -1;
        var9_8 = -1;
        var10_9 = new StringBuffer();
        try {
            var6_10 = this.m_tStream.read();
            if (true) ** GOTO lbl99
        }
        catch (EOTemplateException var11_11) {
            return;
        }
        do {
            if (!var7_6 && var6_10 == '\\') {
                var7_6 = true;
            } else {
                if (var7_6) {
                    switch (var6_10) {
                        case 'n': {
                            var6_10 = '\n';
                            break;
                        }
                        case 'r': {
                            var6_10 = '\r';
                            break;
                        }
                        case 't': {
                            var6_10 = '\t';
                            break;
                        }
                        case 'f': {
                            var6_10 = '\f';
                            break;
                        }
                        case 'b': {
                            var6_10 = '\b';
                        }
                    }
                } else {
                    if (var6_10 == '\r' || var6_10 == '\n') {
                        if (var4_4 > 0) {
                            this.compileError("Error.Compile.noEndDQuote", null, null, null, null, null, null);
                        } else if (var5_5 > 0) {
                            this.compileError("Error.Compile.noEndSQuopte", null, null, null, null, null, null);
                        }
                    }
                    if (var4_4 == 0 && var5_5 == 0) {
                        if (var6_10 == '{') {
                            var8_7 = var1_1.length();
                            ++var2_2;
                        } else if (var6_10 == '}') {
                            --var2_2;
                        } else if (var6_10 == '(') {
                            ++var3_3;
                        } else if (var6_10 == ')') {
                            if (var3_3 > 0) {
                                --var3_3;
                            } else {
                                this.compileError("Error.Compile.parenNotBrace", null, null, null, null, null, null);
                            }
                        }
                    }
                    if (var8_7 >= 0) {
                        if (var6_10 == '}' || Character.isSpaceChar(var6_10)) {
                            var9_8 = var1_1.length();
                            var11_12 = var10_9.toString();
                            var10_9.setLength(0);
                            if (this.m_hAliases.get(var11_12) != null) {
                                if (var6_10 != '}') {
                                    --var2_2;
                                    try {
                                        while (this.m_tStream.read() != '}') {
                                        }
                                    }
                                    catch (EOTemplateException var12_14) {
                                        return;
                                    }
                                }
                                this.expandAliasOperand(var11_12);
                                var1_1.setLength(var8_7);
                                try {
                                    var6_10 = this.m_tStream.read();
                                }
                                catch (EOTemplateException var12_15) {
                                    return;
                                }
                                var8_7 = -1;
                                continue;
                            }
                        } else if (var1_1.length() > var8_7) {
                            var10_9.append(var6_10);
                        }
                    }
                    if (var6_10 == '\'' && var4_4 == 0) {
                        var5_5 = var5_5 == 0 ? 1 : 0;
                    } else if (var6_10 == '\"' && var5_5 == 0) {
                        var4_4 = var4_4 == 0 ? 1 : 0;
                    }
                }
                var7_6 = false;
                var1_1.append(var6_10);
            }
            if (var2_2 <= 0) continue;
            try {
                var6_10 = this.m_tStream.read();
            }
            catch (EOTemplateException var11_13) {
                return;
            }
lbl99:
            // 4 sources

        } while (var2_2 > 0);
    }

    boolean processKeyword(StringBuffer stringBuffer, int n, boolean bl) throws CompileException {
        if (bl) {
            ++this.m_iResursionDepth;
        }
        Class<?> clazz = this.getClass();
        Method method = null;
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.StringBuffer")};
            method = clazz.getDeclaredMethod(m_tblKeywords[n][1], classArray);
            Object[] objectArray = new Object[]{stringBuffer};
            Boolean bl2 = (Boolean)method.invoke((Object)this, objectArray);
            if (!bl && bl2.booleanValue()) {
                this.m_bOutputOccured = true;
                this.writeByteCode(OP_PRN);
                this.m_bLastWhite = false;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Class<?> clazz2 = throwable.getClass();
            if (clazz2.getName().equals("com.novell.webaccess.common.CompileException")) {
                throw (CompileException)throwable;
            }
            throwable.printStackTrace();
            this.compileError("Error.exception", null, null, null, null, null, null);
            System.out.println(invocationTargetException.getTargetException().getMessage());
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Exception exception) {
            this.compileError("Error.Compile.unhandledKeyword", m_tblKeywords[n][0], null, null, null, null, null);
            System.out.println(exception.getMessage());
        }
        if (bl) {
            --this.m_iResursionDepth;
        }
        return true;
    }

    private StringBuffer getTemplatePath() {
        int n;
        Object var1_1 = null;
        File file = new File(this.m_strTemplatePath);
        Object var3_3 = null;
        String string = file.getAbsolutePath();
        int n2 = string.lastIndexOf(92);
        if (n2 < (n = string.lastIndexOf(47))) {
            n2 = n;
        }
        if (n2 >= 0) {
            if (n2 > 0) {
                ++n2;
            }
            string = string.substring(0, n2);
        } else {
            string = "";
        }
        return new StringBuffer(string);
    }

    int isValidIdentifier(StringBuffer stringBuffer, SBTokenizer sBTokenizer) throws CompileException {
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c == '[') {
                bl = true;
                while (c != ']' && n2 < n) {
                    if (++n2 == n) {
                        n = this.getRestOfSubscript(stringBuffer, sBTokenizer);
                    }
                    c = stringBuffer.charAt(n2);
                }
                if (n2 == n) {
                    return 0;
                }
            } else if (n2 == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c) && c != '.' && c != ':') {
                return 0;
            }
            ++n2;
        }
        if (bl) {
            return 2;
        }
        return 1;
    }

    private int getRestOfSubscript(StringBuffer stringBuffer, SBTokenizer sBTokenizer) throws CompileException {
        boolean bl = false;
        do {
            StringBuffer stringBuffer2;
            String string;
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Subscript.badFormat", null, null, null, null, null, null);
            }
            if ((string = (stringBuffer2 = sBTokenizer.nextToken()).toString()).indexOf(93) >= 0) {
                bl = true;
            }
            stringBuffer.append(string);
        } while (!bl);
        return stringBuffer.length();
    }

    static boolean isNumeric(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                case '-': {
                    if (n2 <= 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    int addStringSymbol(StringBuffer stringBuffer) {
        SymbolTableEntry symbolTableEntry;
        String string = stringBuffer.toString();
        int n = this.m_vSymEntries.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            symbolTableEntry = (SymbolTableEntry)this.m_vSymEntries.elementAt(n2);
            if ((symbolTableEntry.getFlags() & 8) != 0 && string.equals(string2 = symbolTableEntry.getValue())) {
                return n2;
            }
            ++n2;
        }
        symbolTableEntry = new SymbolTableEntry("*_", 8, stringBuffer.toString());
        this.m_vSymEntries.addElement(symbolTableEntry);
        return n;
    }

    int addVarSymbol(StringBuffer stringBuffer) {
        SymbolTableEntry symbolTableEntry;
        String string = stringBuffer.toString();
        int n = this.m_vSymEntries.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            symbolTableEntry = (SymbolTableEntry)this.m_vSymEntries.elementAt(n2);
            if ((symbolTableEntry.getFlags() & 1) != 0 && string.equals(string2 = symbolTableEntry.getValue())) {
                return n2;
            }
            ++n2;
        }
        symbolTableEntry = new SymbolTableEntry("*v_", 1, stringBuffer.toString());
        this.m_vSymEntries.addElement(symbolTableEntry);
        return n;
    }

    int addStringTableSymbol(StringBuffer stringBuffer) {
        SymbolTableEntry symbolTableEntry;
        String string = stringBuffer.toString();
        int n = this.m_vSymEntries.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            symbolTableEntry = (SymbolTableEntry)this.m_vSymEntries.elementAt(n2);
            if ((symbolTableEntry.getFlags() & 4) != 0 && string.equals(string2 = symbolTableEntry.getValue())) {
                return n2;
            }
            ++n2;
        }
        symbolTableEntry = new SymbolTableEntry("*s_", 4, stringBuffer.toString());
        this.m_vSymEntries.addElement(symbolTableEntry);
        return n;
    }

    void stripParens(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n < 2) {
            return;
        }
        char[] cArray = new char[n - 2];
        stringBuffer.getChars(1, n - 1, cArray, 0);
        stringBuffer.setLength(0);
        stringBuffer.append(cArray);
    }

    byte[] longToBytes(long l) {
        byte[] byArray = new byte[]{(byte)(0xFFL & l >> 56), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l)};
        return byArray;
    }

    byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n)};
        return byArray;
    }

    byte[] shortToBytes(short s) {
        byte[] byArray = new byte[]{(byte)(0xFF & s >> 8), (byte)(0xFF & s)};
        return byArray;
    }

    private void evaluateBooleanExpression(StringBuffer stringBuffer, Vector vector) throws CompileException {
        Vector vector2 = new Vector();
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/<>!&|");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{<>!&|");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Expression.Conditional.missingExpression", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        this.arithmeticExpression(stringBuffer6, sBTokenizer, false);
        int n = vector2.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            Integer n3 = (Integer)vector2.elementAt(n2);
            if (n3 == 1) {
                this.writeByteCode(OP_BAND);
            } else {
                this.writeByteCode(OP_BOR);
            }
            --n2;
        }
        this.writeByteCode(OP_JZ);
        int n4 = this.m_bcOs.getCount();
        FixupEntry fixupEntry = new FixupEntry(this.m_iFixup, n4);
        vector.addElement(fixupEntry);
        ++this.m_iFixup;
        byte[] byArray = this.intToBytes(this.m_iFixup);
        this.writeByteCode(byArray);
    }

    private void arithmeticExpression(StringBuffer stringBuffer, SBTokenizer sBTokenizer, boolean bl) throws CompileException {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        this.evaluateOperand(stringBuffer, sBTokenizer, bl);
        if (!sBTokenizer.hasMoreTokens()) {
            return;
        }
        do {
            StringBuffer stringBuffer2;
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Expression.invalid", null, null, null, null, null, null);
            }
            StringBuffer stringBuffer3 = sBTokenizer.nextToken();
            n = 0;
            char c = '\u0000';
            char c2 = stringBuffer3.charAt(0);
            if (stringBuffer3.length() > 1) {
                c = stringBuffer3.charAt(1);
            }
            if (stringBuffer3.length() == 1) {
                char c3;
                if (c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/' || c2 == '%') {
                    n = 1;
                } else if (c2 == '=' || c2 == '<' || c2 == '>' || c2 == '!') {
                    n = 1;
                    if (sBTokenizer.hasMoreTokens()) {
                        stringBuffer2 = sBTokenizer.nextToken();
                        c3 = stringBuffer2.charAt(0);
                        if (c3 == '=') {
                            c = '=';
                            stringBuffer3.append('=');
                        } else {
                            sBTokenizer.putBackToken();
                        }
                    }
                } else if ((c2 == '&' || c2 == '|') && sBTokenizer.hasMoreTokens() && (c3 = (stringBuffer2 = sBTokenizer.nextToken()).charAt(0)) == c2) {
                    stringBuffer3.append(c3);
                    n = 1;
                }
            } else if (stringBuffer3.length() == 2 && (c2 == '&' || c2 == '|') && c == c2) {
                n = 1;
            }
            if (n == 0) {
                this.compileError("Error.Compile.Expression.badOperator", null, null, null, null, null, null);
            }
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
            }
            if ((stringBuffer2 = sBTokenizer.nextToken()).length() == 1 && stringBuffer2.charAt(0) == '-' && sBTokenizer.hasMoreTokens()) {
                stringBuffer2.append((Object)sBTokenizer.nextToken());
            }
            this.evaluateOperand(stringBuffer2, sBTokenizer, bl);
            switch (c2) {
                case '+': {
                    this.writeByteCode(OP_ADD);
                    break;
                }
                case '-': {
                    this.writeByteCode(OP_SUB);
                    break;
                }
                case '*': {
                    this.writeByteCode(OP_MULT);
                    break;
                }
                case '/': {
                    this.writeByteCode(OP_DIV);
                    break;
                }
                case '%': {
                    this.writeByteCode(OP_MOD);
                    break;
                }
                case '&': {
                    vector.addElement(new Integer(1));
                    break;
                }
                case '|': {
                    vector.addElement(new Integer(0));
                    break;
                }
                case '!': {
                    this.writeByteCode(OP_CMP);
                    this.writeByteCode(OP_TST);
                    this.writeByteCode(BC_EQUAL);
                    this.writeByteCode(OP_NOT);
                    break;
                }
                case '=': {
                    this.writeByteCode(OP_CMP);
                    this.writeByteCode(OP_TST);
                    this.writeByteCode(BC_EQUAL);
                    break;
                }
                case '<': {
                    if (stringBuffer3.length() == 1) {
                        this.writeByteCode(OP_CMP);
                        this.writeByteCode(OP_TST);
                        this.writeByteCode(BC_LESS);
                        break;
                    }
                    this.writeByteCode(OP_CMP);
                    this.writeByteCode(OP_TST);
                    this.writeByteCode(BC_GREATER);
                    this.writeByteCode(OP_NOT);
                    break;
                }
                case '>': {
                    if (stringBuffer3.length() == 1) {
                        this.writeByteCode(OP_CMP);
                        this.writeByteCode(OP_TST);
                        this.writeByteCode(BC_GREATER);
                        break;
                    }
                    this.writeByteCode(OP_CMP);
                    this.writeByteCode(OP_TST);
                    this.writeByteCode(BC_LESS);
                    this.writeByteCode(OP_NOT);
                    break;
                }
            }
        } while (sBTokenizer.hasMoreTokens());
        int n2 = vector.size();
        n = n2 - 1;
        while (n >= 0) {
            Integer n3 = (Integer)vector.elementAt(n);
            if (n3 == 1) {
                this.writeByteCode(OP_BAND);
            } else {
                this.writeByteCode(OP_BOR);
            }
            --n;
        }
    }

    void arithmeticSubExpression(StringBuffer stringBuffer, boolean bl) throws CompileException {
        this.stripParens(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=<>!+-*%/&|");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{<>!&|");
        StringBuffer stringBuffer4 = new StringBuffer("{}()");
        StringBuffer stringBuffer5 = new StringBuffer("{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        this.arithmeticExpression(stringBuffer6, sBTokenizer, bl);
    }

    void evaluateOperand(StringBuffer stringBuffer, SBTokenizer sBTokenizer, boolean bl) throws CompileException {
        char c = stringBuffer.charAt(0);
        String string = stringBuffer.toString();
        if (string.equals("DEF")) {
            StringBuffer stringBuffer2;
            int n;
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.DEF.missingVariable", "DEF", null, null, null, null, null);
            }
            if ((n = this.isValidIdentifier(stringBuffer2 = sBTokenizer.nextToken(), sBTokenizer)) == 2) {
                this.doArrayName(stringBuffer2, bl);
                this.writeByteCode(OP_DEF);
                this.writeByteCode(OP_TST);
                this.writeByteCode(BC_TRUE);
                return;
            }
            int n2 = this.addVarSymbol(stringBuffer2);
            byte[] byArray = this.intToBytes(n2);
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
            this.writeByteCode(OP_DEF);
            this.writeByteCode(OP_TST);
            this.writeByteCode(BC_TRUE);
        } else if (string.equals("NOTDEF")) {
            StringBuffer stringBuffer3;
            int n;
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.DEF.missingVariable", "NOTDEF", null, null, null, null, null);
            }
            if ((n = this.isValidIdentifier(stringBuffer3 = sBTokenizer.nextToken(), sBTokenizer)) == 2) {
                this.doArrayName(stringBuffer3, bl);
                this.writeByteCode(OP_DEF);
                this.writeByteCode(OP_TST);
                this.writeByteCode(BC_TRUE);
                return;
            }
            int n3 = this.addVarSymbol(stringBuffer3);
            byte[] byArray = this.intToBytes(n3);
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
            this.writeByteCode(OP_DEF);
            this.writeByteCode(OP_TST);
            this.writeByteCode(BC_FALSE);
        } else if (c == '(') {
            this.arithmeticSubExpression(stringBuffer, bl);
        } else if (TemplateCompiler.isNumeric(stringBuffer)) {
            this.handleNumericConstant(stringBuffer);
        } else if (c == '\"' || c == '\'') {
            this.handleStringConstant(stringBuffer);
        } else if (c == '{') {
            this.handleLookup(stringBuffer);
        } else {
            int n = this.isFunction(stringBuffer);
            if (n >= 0) {
                if (!sBTokenizer.hasMoreTokens()) {
                    this.compileError("Error.Compile.Function.syntax", stringBuffer.toString(), null, null, null, null, null);
                }
                this.doFunction(n, sBTokenizer.nextToken(), bl);
                return;
            }
            this.doVariable(stringBuffer, bl);
        }
    }

    void handleNumericConstant(StringBuffer stringBuffer) throws CompileException {
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer("*_");
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        stringBuffer2.append(cArray);
        int n2 = this.addVarSymbol(stringBuffer2);
        SymbolTableEntry symbolTableEntry = (SymbolTableEntry)this.m_vSymEntries.elementAt(n2);
        symbolTableEntry.addFlags(50);
        symbolTableEntry.setValue(stringBuffer.toString());
        byte[] byArray = this.intToBytes(n2);
        this.writeByteCode(OP_PUSH);
        this.writeByteCode(byArray);
    }

    void handleStringConstant(StringBuffer stringBuffer) throws CompileException {
        this.stripParens(stringBuffer);
        int n = this.addStringSymbol(stringBuffer);
        byte[] byArray = this.intToBytes(n);
        this.writeByteCode(OP_PUSH);
        this.writeByteCode(byArray);
    }

    void handleLookup(StringBuffer stringBuffer) throws CompileException {
        boolean bl;
        StringBuffer stringBuffer2;
        int n;
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''");
        StringBuffer stringBuffer6 = new StringBuffer("\"'");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
        if ((n = this.isTemplateKeyword((stringBuffer2 = sBTokenizer.nextToken()).toString())) == -1) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
        if (!(bl = this.processKeyword(sBTokenizer.getRemaining(), n, true))) {
            this.compileError("Error.Compile.Expression.badExpression", null, null, null, null, null, null);
        }
    }

    private void stringExpression(SBTokenizer sBTokenizer, StringBuffer stringBuffer) {
    }

    void save(OutputStream outputStream) {
    }

    void writeByteCode(byte[] byArray) throws CompileException {
        try {
            this.m_bcOs.write(byArray);
        }
        catch (IOException iOException) {
            this.compileError("Error.Compile.ByteCode.write", null, null, null, null, null, null);
        }
    }

    void writeByteCode(byte[] byArray, ByteCodeOutputStream byteCodeOutputStream) throws CompileException {
        try {
            byteCodeOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            this.compileError("Error.Compile.ByteCode.write", null, null, null, null, null, null);
        }
    }

    private boolean doCOMMENT(StringBuffer stringBuffer) throws CompileException {
        return false;
    }

    private boolean doNOOUTPUT(StringBuffer stringBuffer) throws CompileException {
        ++this.m_iOutput;
        return false;
    }

    private boolean doOUTPUT(StringBuffer stringBuffer) throws CompileException {
        --this.m_iOutput;
        return false;
    }

    private boolean doTEXT(StringBuffer stringBuffer) throws CompileException {
        ByteCodeOutputStream byteCodeOutputStream = new ByteCodeOutputStream();
        char c = '\u0000';
        int n = 0;
        boolean bl = false;
        if (this.m_iOutput == 0) {
            int n2 = stringBuffer.length();
            int n3 = 0;
            while (n3 < n2) {
                c = stringBuffer.charAt(n3);
                if (this.m_iIgnoreWhite > 0 && this.m_bLastWhite && Character.isWhitespace(c)) {
                    int n4;
                    if (c == '\n' && (n4 = byteCodeOutputStream.getCount()) > 0) {
                        byteCodeOutputStream.setAt(n4 - 1, this.m_rgNewLine);
                    }
                } else {
                    byteCodeOutputStream.write(c);
                    ++n;
                    this.m_bLastWhite = Character.isWhitespace(c);
                }
                ++n3;
            }
        }
        try {
            c = this.m_tStream.read();
        }
        catch (EOTemplateException eOTemplateException) {
            if (n == 0) {
                return false;
            }
            bl = true;
        }
        while (!bl) {
            if (c == '{') {
                char c2;
                try {
                    c2 = this.m_tStream.read();
                }
                catch (EOTemplateException eOTemplateException) {
                    bl = true;
                    break;
                }
                if (c2 == '!') {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    this.getRestOfComment(stringBuffer2);
                    try {
                        c = this.m_tStream.read();
                        continue;
                    }
                    catch (EOTemplateException eOTemplateException) {
                        bl = true;
                        break;
                    }
                }
                this.m_tStream.putBack(c2);
                break;
            }
            if (this.m_iOutput == 0) {
                if (this.m_iIgnoreWhite > 0 && this.m_bLastWhite && Character.isWhitespace(c)) {
                    int n5;
                    if (c == '\n' && (n5 = byteCodeOutputStream.getCount()) > 0) {
                        byteCodeOutputStream.setAt(n5 - 1, this.m_rgNewLine);
                    }
                } else {
                    byteCodeOutputStream.write(c);
                    ++n;
                    this.m_bLastWhite = Character.isWhitespace(c);
                }
                if (n == 65530) {
                    byte[] byArray = this.intToBytes(n);
                    this.m_bOutputOccured = true;
                    this.writeByteCode(OP_OUT);
                    this.writeByteCode(byArray);
                    this.writeByteCode(byteCodeOutputStream.toByteArray());
                    byteCodeOutputStream.reset();
                    n = 0;
                }
            }
            try {
                c = this.m_tStream.read();
            }
            catch (EOTemplateException eOTemplateException) {
                bl = true;
            }
        }
        if (!bl) {
            this.m_tStream.putBack(c);
        }
        if (this.m_bDebug) {
            byte[] byArray = byteCodeOutputStream.toByteArray();
            byte[] byArray2 = this.intToBytes(n);
            this.writeByteCode(byArray2);
            this.writeByteCode(byArray);
        }
        if (n > 0) {
            byte[] byArray = this.intToBytes(n);
            this.m_bOutputOccured = true;
            this.writeByteCode(OP_OUT);
            this.writeByteCode(byArray);
            this.writeByteCode(byteCodeOutputStream.toByteArray());
        }
        return false;
    }

    void FixUp(Vector vector) {
        int n = vector.size() - 1;
        FixupEntry fixupEntry = (FixupEntry)vector.elementAt(n);
        int n2 = fixupEntry.getPosition();
        int n3 = this.m_bcOs.getCount();
        byte[] byArray = this.intToBytes(n3);
        this.m_bcOs.setAt(n2, byArray);
        vector.setSize(n);
    }

    private boolean doIFDEF(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = new StringBuffer("DEF ");
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        stringBuffer2.append(cArray);
        this.doIF(stringBuffer2);
        return false;
    }

    private boolean doIF(StringBuffer stringBuffer) throws CompileException {
        Condition condition = new Condition();
        ++condition.iFixupCount;
        this.m_ifStack.push(condition);
        this.evaluateBooleanExpression(stringBuffer, this.m_vIfFixupEntries);
        return false;
    }

    private boolean doENDIF(StringBuffer stringBuffer) throws CompileException {
        if (this.m_ifStack.empty()) {
            this.compileError("Error.Compile.Construct.End.extra", "ENDIF", "IF", null, null, null, null);
        }
        Condition condition = (Condition)this.m_ifStack.pop();
        int n = condition.iFixupCount;
        while (n > 0) {
            this.FixUp(this.m_vIfFixupEntries);
            --n;
        }
        return false;
    }

    private boolean doELSE(StringBuffer stringBuffer) throws CompileException {
        if (this.m_ifStack.empty()) {
            this.compileError("Error.Compile.Construct.End.extra", "ELSE", "IF", null, null, null, null);
        }
        this.writeByteCode(OP_JMP);
        int n = this.m_bcOs.getCount();
        FixupEntry fixupEntry = new FixupEntry(this.m_iFixup, n);
        byte[] byArray = this.intToBytes(this.m_iFixup);
        this.writeByteCode(byArray);
        this.FixUp(this.m_vIfFixupEntries);
        this.m_vIfFixupEntries.addElement(fixupEntry);
        ++this.m_iFixup;
        return false;
    }

    private boolean doELSEIF(StringBuffer stringBuffer) throws CompileException {
        this.doELSE(stringBuffer);
        Condition condition = (Condition)this.m_ifStack.peek();
        ++condition.iFixupCount;
        this.evaluateBooleanExpression(stringBuffer, this.m_vIfFixupEntries);
        return false;
    }

    private boolean doELSEIFDEF(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = new StringBuffer("DEF ");
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        stringBuffer2.append(cArray);
        this.doELSEIF(stringBuffer2);
        return false;
    }

    private boolean doWHILE(StringBuffer stringBuffer) throws CompileException {
        Condition condition = new Condition();
        ++condition.iFixupCount;
        condition.iStartPos = this.m_bcOs.getCount();
        this.m_whileStack.push(condition);
        this.evaluateBooleanExpression(stringBuffer, this.m_vWhileFixupEntries);
        return false;
    }

    private boolean doBREAK(StringBuffer stringBuffer) throws CompileException {
        if (this.m_whileStack.empty()) {
            this.compileError("Error.Compile.Construct.End.extra", "BREAK", "WHILE", null, null, null, null);
        }
        this.writeByteCode(OP_JMP);
        int n = this.m_bcOs.getCount();
        FixupEntry fixupEntry = new FixupEntry(this.m_iFixup, n);
        byte[] byArray = this.intToBytes(this.m_iFixup);
        this.writeByteCode(byArray);
        this.m_vWhileFixupEntries.addElement(fixupEntry);
        ++this.m_iFixup;
        Condition condition = (Condition)this.m_whileStack.peek();
        ++condition.iFixupCount;
        return false;
    }

    private boolean doCONTINUE(StringBuffer stringBuffer) throws CompileException {
        if (this.m_whileStack.empty()) {
            this.compileError("Error.Compile.Construct.End.extra", "CONTINUE", "WHILE", null, null, null, null);
        }
        this.writeByteCode(OP_JMP);
        Condition condition = (Condition)this.m_whileStack.peek();
        byte[] byArray = this.intToBytes(condition.iStartPos);
        this.writeByteCode(byArray);
        return false;
    }

    private boolean doENDWHILE(StringBuffer stringBuffer) throws CompileException {
        if (this.m_whileStack.empty()) {
            this.compileError("Error.Compile.Construct.End.extra", "ENDWHILE", "WHILE", null, null, null, null);
        }
        Condition condition = (Condition)this.m_whileStack.pop();
        int n = condition.iStartPos;
        this.writeByteCode(OP_JMP);
        this.writeByteCode(this.intToBytes(condition.iStartPos));
        int n2 = condition.iFixupCount;
        while (n2 > 0) {
            this.FixUp(this.m_vWhileFixupEntries);
            --n2;
        }
        return false;
    }

    private boolean doALIAS(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingName", "ALIAS", null, null, null, null, null);
            return false;
        }
        sBTokenizer.nextToken();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingName", "ALIAS", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingName", "ALIAS", null, null, null, null, null);
            return false;
        }
        sBTokenizer.nextToken();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Alias.missingValue", "ALIAS", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer7 = sBTokenizer.nextToken();
        while (sBTokenizer.hasMoreTokens()) {
            stringBuffer7.append((Object)sBTokenizer.nextToken());
        }
        this.m_hAliases.put(stringBuffer6.toString(), stringBuffer7);
        return false;
    }

    private boolean doHEADER(StringBuffer stringBuffer) throws CompileException {
        if (this.m_bOutputOccured) {
            this.compileError("Error.Compile.Header.tooLate", "HEADER", null, null, null, null, null);
        }
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Header.missingName", "HEADER", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer6 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer6, sBTokenizer, false);
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Header.missingValue", "HEADER", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer7 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer7, sBTokenizer, false);
        this.writeByteCode(OP_HDR);
        return false;
    }

    private boolean doCOOKIE(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2;
        if (this.m_bOutputOccured) {
            this.compileError("Error.Compile.Cookie.tooLate", "COOKIE", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer6 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        StringBuffer stringBuffer7 = new StringBuffer("");
        int n = this.addStringSymbol(stringBuffer7);
        byte[] byArray = this.intToBytes(n);
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Cookie.missingParameter", "COOKIE", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer8 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer8, sBTokenizer, false);
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Cookie.missingParameter", "COOKIE", null, null, null, null, null);
            return false;
        }
        StringBuffer stringBuffer9 = sBTokenizer.nextToken();
        this.evaluateOperand(stringBuffer9, sBTokenizer, false);
        if (!sBTokenizer.hasMoreTokens()) {
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
        } else {
            stringBuffer2 = sBTokenizer.nextToken();
            this.evaluateOperand(stringBuffer2, sBTokenizer, false);
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
        } else {
            stringBuffer2 = sBTokenizer.nextToken();
            this.evaluateOperand(stringBuffer2, sBTokenizer, false);
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
        } else {
            stringBuffer2 = sBTokenizer.nextToken();
            this.evaluateOperand(stringBuffer2, sBTokenizer, false);
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
        } else {
            stringBuffer2 = sBTokenizer.nextToken();
            this.evaluateOperand(stringBuffer2, sBTokenizer, false);
        }
        this.writeByteCode(OP_COOK);
        return false;
    }

    private void doSET(StringBuffer stringBuffer, boolean bl) throws CompileException {
        int n;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3;
        StringBuffer stringBuffer4;
        int n2;
        StringBuffer stringBuffer5 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer6 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer7 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer8 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer5, stringBuffer6);
        sBTokenizer.setQuotes(stringBuffer7, stringBuffer8, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.SET.missingLValue", "SET", null, null, null, null, null);
        }
        if ((n2 = this.isValidIdentifier(stringBuffer4 = sBTokenizer.nextToken(), sBTokenizer)) == 0) {
            this.compileError("Error.Compile.SET.invalidRValue", stringBuffer4.toString(), null, null, null, null, null);
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.SET.missingEq", "SET", null, null, null, null, null);
        }
        if ((stringBuffer3 = sBTokenizer.nextToken()).length() > 1 || stringBuffer3.charAt(0) != '=') {
            this.compileError("Error.Compile.SET.missingEq", "SET", null, null, null, null, null);
        }
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.SET.missingRValue", "SET", null, null, null, null, null);
        }
        if ((stringBuffer2 = sBTokenizer.nextToken()).length() == 1 && stringBuffer2.charAt(0) == '-' && sBTokenizer.hasMoreTokens()) {
            stringBuffer2.append((Object)sBTokenizer.nextToken());
        }
        boolean bl2 = false;
        if (sBTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer9 = sBTokenizer.nextToken();
            sBTokenizer.putBackToken();
            if (stringBuffer9.length() == 1 && ((n = stringBuffer9.charAt(0)) == 43 || n == 45 || n == 42 || n == 47 || n == 37)) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.arithmeticExpression(stringBuffer2, sBTokenizer, false);
        } else {
            int n3 = 1;
            this.evaluateOperand(stringBuffer2, sBTokenizer, false);
            while (sBTokenizer.hasMoreTokens()) {
                n = this.m_vSymEntries.size();
                stringBuffer2 = sBTokenizer.nextToken();
                this.evaluateOperand(stringBuffer2, sBTokenizer, false);
                ++n3;
            }
            while (n3 > 1) {
                this.writeByteCode(OP_CAT);
                --n3;
            }
        }
        if (n2 == 2) {
            this.doArrayName(stringBuffer4, false);
        } else {
            int n4 = this.addVarSymbol(stringBuffer4);
            byte[] byArray = this.intToBytes(n4);
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
        }
        if (bl) {
            this.writeByteCode(OP_SETG);
        } else {
            this.writeByteCode(OP_SET);
        }
    }

    private boolean doSETLOCAL(StringBuffer stringBuffer) throws CompileException {
        this.doSET(stringBuffer, false);
        return false;
    }

    private boolean doSETGLOBAL(StringBuffer stringBuffer) throws CompileException {
        this.doSET(stringBuffer, true);
        return false;
    }

    private boolean doINC(StringBuffer stringBuffer) throws CompileException {
        this.doVariable(stringBuffer, false);
        this.writeByteCode(OP_INC);
        return false;
    }

    private boolean doDEC(StringBuffer stringBuffer) throws CompileException {
        this.doVariable(stringBuffer, false);
        this.writeByteCode(OP_DEC);
        return false;
    }

    private boolean doINCLUDE(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = this.getParameterValue(stringBuffer);
        StringBuffer stringBuffer3 = this.getTemplatePath();
        stringBuffer3.append((Object)stringBuffer2);
        TemplateCompiler templateCompiler = new TemplateCompiler(stringBuffer3.toString(), this.m_vSymEntries, this.m_vIfFixupEntries, this.m_vWhileFixupEntries, this.m_uiLocale, this.m_log);
        if (this.m_bDebug) {
            byte[] byArray = stringBuffer3.toString().getBytes();
            int n = byArray.length;
            byte[] byArray2 = this.intToBytes(n);
            this.writeByteCode(OP_INCL);
            this.writeByteCode(byArray2);
            this.writeByteCode(byArray);
        }
        templateCompiler.compile(this.m_bcOs, this.m_bDebug);
        if (this.m_bDebug) {
            this.writeByteCode(OP_EOIN);
        }
        return false;
    }

    private boolean doSTRINGTABLE(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = this.getParameterValue(stringBuffer);
        int n = -1;
        n = this.addStringSymbol(stringBuffer2);
        byte[] byArray = this.intToBytes(n);
        this.writeByteCode(OP_PUSH);
        this.writeByteCode(byArray);
        this.writeByteCode(OP_STAB);
        return false;
    }

    StringBuffer getParameterValue(StringBuffer stringBuffer) throws CompileException {
        StringBuffer stringBuffer2 = new StringBuffer(" \r\n\t}");
        StringBuffer stringBuffer3 = new StringBuffer("x");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.missingValue", null, null, null, null, null, null);
        }
        StringBuffer stringBuffer4 = sBTokenizer.nextToken();
        return stringBuffer4;
    }

    private boolean doSTRING(StringBuffer stringBuffer) throws CompileException {
        if (this.m_iResursionDepth == 0 && this.m_iOutput > 0) {
            return false;
        }
        this.doVariable(stringBuffer, true);
        return true;
    }

    private boolean doVAR(StringBuffer stringBuffer) throws CompileException {
        if (this.m_iResursionDepth == 0 && this.m_iOutput > 0) {
            return false;
        }
        this.doVariable(stringBuffer, false);
        return true;
    }

    private void doVariable(StringBuffer stringBuffer, boolean bl) throws CompileException {
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
        StringBuffer stringBuffer4 = new StringBuffer("=+-*%/{");
        StringBuffer stringBuffer5 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer6 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer3, stringBuffer4);
        sBTokenizer.setQuotes(stringBuffer5, stringBuffer6, '\u0000');
        sBTokenizer.tokenize();
        if (!sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.missingName", null, null, null, null, null, null);
        }
        if ((stringBuffer2 = sBTokenizer.nextToken()).charAt(0) == '{') {
            this.evaluateOperand(stringBuffer2, sBTokenizer, bl);
            this.writeByteCode(OP_DREF);
            if (bl) {
                this.writeByteCode(BC_TRUE);
            } else {
                this.writeByteCode(BC_FALSE);
            }
            return;
        }
        int n = this.isFunction(stringBuffer2);
        if (n >= 0) {
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Function.syntax", stringBuffer2.toString(), null, null, null, null, null);
            }
            StringBuffer stringBuffer7 = sBTokenizer.nextToken();
            this.doFunction(n, stringBuffer7, bl);
            this.handleReplaceableParams(sBTokenizer, false);
            return;
        }
        int n2 = this.isValidIdentifier(stringBuffer2, sBTokenizer);
        if (n2 == 0) {
            this.compileError("Error.Compile.badName", stringBuffer2.toString(), null, null, null, null, null);
        }
        if (n2 == 2) {
            this.doArrayName(stringBuffer2, bl);
        } else {
            int n3 = -1;
            n3 = bl ? this.addStringTableSymbol(stringBuffer2) : this.addVarSymbol(stringBuffer2);
            byte[] byArray = this.intToBytes(n3);
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
        }
        this.handleReplaceableParams(sBTokenizer, false);
    }

    private void handleReplaceableParams(SBTokenizer sBTokenizer, boolean bl) throws CompileException {
        int n = 0;
        StringBuffer stringBuffer = null;
        while (sBTokenizer.hasMoreTokens()) {
            stringBuffer = sBTokenizer.nextToken();
            this.evaluateOperand(stringBuffer, sBTokenizer, bl);
            ++n;
        }
        if (n > 0) {
            if (n > 10) {
                this.compileError("Error.Compile.Replaceable.tooMany", null, null, null, null, null, null);
            }
            byte[] byArray = this.intToBytes(n);
            this.writeByteCode(OP_REPL);
            this.writeByteCode(byArray);
        }
    }

    private void doArrayName(StringBuffer stringBuffer, boolean bl) throws CompileException {
        Object object;
        Object object2;
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer2 = null;
        n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c == '[') {
                ++n3;
                int n4 = n2++;
                stringBuffer2 = new StringBuffer();
                c = stringBuffer.charAt(n2);
                while (c != ']') {
                    stringBuffer2.append(c);
                    c = stringBuffer.charAt(++n2);
                }
                StringBuffer stringBuffer3 = new StringBuffer(" \r\n\t{}=+-*%/");
                object2 = new StringBuffer("=+-*%/{");
                object = new StringBuffer("\"\"''{}()");
                StringBuffer stringBuffer4 = new StringBuffer("\"'{(");
                SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer2);
                sBTokenizer.setDelims(stringBuffer3, (StringBuffer)object2);
                sBTokenizer.setQuotes((StringBuffer)object, stringBuffer4, '\u0000');
                sBTokenizer.tokenize();
                this.arithmeticExpression(sBTokenizer.nextToken(), sBTokenizer, false);
                this.m_vSymEntries.addElement(new SymbolTableEntry("*_ssOffset", 2, String.valueOf(n4)));
                int n5 = this.m_vSymEntries.size() - 1;
                byte[] byArray = this.intToBytes(n5);
                this.writeByteCode(OP_PUSH);
                this.writeByteCode(byArray);
                char[] cArray = new char[n4];
                stringBuffer.getChars(0, n4, cArray, 0);
                char[] cArray2 = null;
                if (n2 + 1 < n) {
                    cArray2 = new char[n - n2 - 1];
                    stringBuffer.getChars(n2 + 1, n, cArray2, 0);
                }
                stringBuffer.setLength(0);
                stringBuffer.append(cArray);
                if (n2 + 1 < n) {
                    stringBuffer.append(cArray2);
                }
                n2 = n4 - 1;
                n = stringBuffer.length();
            }
            ++n2;
        }
        if (n3 > 0) {
            byte[] byArray = this.intToBytes(n3);
            this.m_vSymEntries.addElement(new SymbolTableEntry("*_ssOffset", 2, String.valueOf(byArray)));
            int n6 = this.m_vSymEntries.size() - 1;
            object2 = this.intToBytes(n6);
            this.writeByteCode(OP_PUSH);
            this.writeByteCode(byArray);
            this.m_vSymEntries.addElement(new SymbolTableEntry("*_ssVar", 2, stringBuffer.toString()));
            n6 = this.m_vSymEntries.size() - 1;
            if (bl) {
                object = (SymbolTableEntry)this.m_vSymEntries.elementAt(n6);
                ((SymbolTableEntry)object).addFlags(4);
            }
            object2 = this.intToBytes(n6);
            this.writeByteCode(OP_IDXV);
            this.writeByteCode((byte[])object2);
        }
    }

    private int isFunction(StringBuffer stringBuffer) throws CompileException {
        String string = stringBuffer.toString();
        int n = 0;
        n = 0;
        while (n < 38) {
            if (string.equals(m_tblFunctions[n][0])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void doFunction(int n, StringBuffer stringBuffer, boolean bl) throws CompileException {
        Object object;
        boolean bl2 = true;
        this.stripParens(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer(", \r\n\t{}=+-*%/<>!&|");
        StringBuffer stringBuffer3 = new StringBuffer("=+-*%/{<>!&|");
        StringBuffer stringBuffer4 = new StringBuffer("\"\"''{}()");
        StringBuffer stringBuffer5 = new StringBuffer("\"'{(");
        SBTokenizer sBTokenizer = new SBTokenizer(stringBuffer);
        sBTokenizer.setDelims(stringBuffer2, stringBuffer3);
        sBTokenizer.setQuotes(stringBuffer4, stringBuffer5, '\u0000');
        sBTokenizer.tokenize();
        String string = m_tblFunctions[n][1];
        if (string.endsWith("+")) {
            bl2 = false;
            string = string.substring(0, string.length() - 1);
        }
        int n2 = Integer.parseInt(string);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (!sBTokenizer.hasMoreTokens()) {
                this.compileError("Error.Compile.Function.badParamCount", m_tblFunctions[n][0], string, null, null, null, null);
            }
            ++n3;
            object = sBTokenizer.nextToken();
            StringBuffer stringBuffer6 = new StringBuffer(", \r\n\t{}=+-*%/<>!&|");
            StringBuffer stringBuffer7 = new StringBuffer("=+-*%/{<>!&|");
            StringBuffer stringBuffer8 = new StringBuffer("\"\"''{}()");
            StringBuffer stringBuffer9 = new StringBuffer("\"'{(");
            SBTokenizer sBTokenizer2 = new SBTokenizer((StringBuffer)object);
            sBTokenizer2.setDelims(stringBuffer6, stringBuffer7);
            sBTokenizer2.setQuotes(stringBuffer8, stringBuffer9, '\u0000');
            sBTokenizer2.tokenize();
            object = sBTokenizer2.nextToken();
            if (this.isFunction((StringBuffer)object) >= 0) {
                this.evaluateOperand((StringBuffer)object, sBTokenizer, bl);
            } else {
                this.evaluateOperand((StringBuffer)object, sBTokenizer2, bl);
            }
            if (n4 + 1 == n2 && !bl2 && sBTokenizer.hasMoreTokens()) {
                --n4;
            }
            ++n4;
        }
        if (sBTokenizer.hasMoreTokens()) {
            this.compileError("Error.Compile.Function.badParamCount", m_tblFunctions[n][0], string, null, null, null, null);
        }
        if (!bl2) {
            this.writeByteCode(OP_PUSH);
            object = this.intToBytes(n3);
            this.writeByteCode((byte[])object);
        }
        object = this.intToBytes(n);
        this.writeByteCode(OP_FNC);
        this.writeByteCode((byte[])object);
    }

    private boolean doIGNOREWHITE(StringBuffer stringBuffer) throws CompileException {
        if (this.m_bDebug) {
            return false;
        }
        ++this.m_iIgnoreWhite;
        return false;
    }

    private boolean doNOIGNOREWHITE(StringBuffer stringBuffer) throws CompileException {
        if (this.m_bDebug) {
            return false;
        }
        --this.m_iIgnoreWhite;
        return false;
    }

    private boolean doABORT(StringBuffer stringBuffer) throws CompileException {
        this.writeByteCode(OP_QUIT);
        return false;
    }

    private boolean doFLUSH(StringBuffer stringBuffer) throws CompileException {
        this.writeByteCode(OP_FLSH);
        return false;
    }

    private boolean doDUMPALL(StringBuffer stringBuffer) throws CompileException {
        if (this.m_iResursionDepth == 0 && this.m_iOutput > 0) {
            return false;
        }
        this.m_bOutputOccured = true;
        this.writeByteCode(OP_DUMP);
        return false;
    }

    private void compileError(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws CompileException {
        Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7};
        I18NPropertyBundle i18NPropertyBundle = I18NPropertyBundle.getI18NPropertyBundle("com.novell.webaccess.common.TemplateResources", this.m_uiLocale);
        String string8 = i18NPropertyBundle.getProperty(string);
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = new String(this.m_strTemplatePath);
        int n = string9.lastIndexOf(47);
        if (n < 0) {
            n = string9.lastIndexOf(92);
        }
        if (n > 0) {
            string9 = string9.substring(n + 1);
        }
        stringBuffer.append(i18NPropertyBundle.getProperty("Error.Compile.Error"));
        stringBuffer.append(": ");
        stringBuffer.append(string9);
        stringBuffer.append(": ");
        stringBuffer.append(i18NPropertyBundle.getProperty("Error.Compile.Line"));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(this.m_tStream.getLineNumber()));
        stringBuffer.append(": ");
        stringBuffer.append(string8);
        stringBuffer.append(".    ");
        string8 = MessageFormat.format(stringBuffer.toString(), objectArray);
        if (this.m_log != null) {
            this.m_log.logMessage(string8, "TPLTCOMPILE", null);
        } else {
            System.out.println(string8);
        }
        throw new CompileException(string8);
    }

    void info(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_strTemplatePath);
        stringBuffer.append(": Line ");
        stringBuffer.append(String.valueOf(this.m_tStream.getLineNumber()));
        stringBuffer.append(": ");
        stringBuffer.append(string);
        stringBuffer.append("\n");
        String string2 = stringBuffer.toString();
        System.out.println(this.m_strTemplatePath + ": Line " + this.m_tStream.getLineNumber() + ": " + string);
    }
}

