/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

import com.novell.webaccess.common.URLCoder;
import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Utils {
    static final byte[] s_hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final String EMPTY_STRING = new String("");

    public static String toScript(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            int n = stringBuffer.length();
            int n2 = 0;
            do {
                char c = stringBuffer.charAt(n2);
                switch (c) {
                    case '\n': {
                        stringBuffer.insert(n2++, '\\');
                        stringBuffer.setCharAt(n2, 'n');
                        ++n;
                        break;
                    }
                    case '\r': {
                        stringBuffer.insert(n2++, '\\');
                        stringBuffer.setCharAt(n2, 'r');
                        ++n;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stringBuffer.insert(n2, '\\');
                        ++n2;
                        ++n;
                    }
                }
            } while (++n2 < n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static String urlEncode(String string, String string2) {
        byte[] byArray;
        if (string == null) {
            return EMPTY_STRING;
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = string.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray = string.getBytes();
            }
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122) {
                byArray2[n3++] = by;
            } else if (by == 32) {
                byArray2[n3++] = 43;
            } else {
                byArray2[n3++] = 37;
                int n4 = by >> 4 & 0xF;
                byArray2[n3++] = s_hexTable[n4];
                n4 = by & 0xF;
                byArray2[n3++] = s_hexTable[n4];
            }
            ++n2;
        }
        try {
            return new String(byArray2, 0, n3, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return new String(byArray2, 0, n3, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException3) {
                return new String(byArray2, 0, n3);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(byArray2, 0, n3);
        }
    }

    public static String urlEncodePath(String string, String string2) {
        byte[] byArray;
        if (string == null) {
            return EMPTY_STRING;
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = string.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray = string.getBytes();
            }
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by >= 48 && by <= 57 || by >= 65 && by <= 90 || by >= 97 && by <= 122 || by == 47 || by == 46 || by == 95 || by == 45) {
                byArray2[n3++] = by;
            } else if (by == 32) {
                byArray2[n3++] = 43;
            } else {
                byArray2[n3++] = 37;
                int n4 = by >> 4 & 0xF;
                byArray2[n3++] = s_hexTable[n4];
                n4 = by & 0xF;
                byArray2[n3++] = s_hexTable[n4];
            }
            ++n2;
        }
        try {
            return new String(byArray2, 0, n3, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return new String(byArray2, 0, n3, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException3) {
                return new String(byArray2, 0, n3);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(byArray2, 0, n3);
        }
    }

    public static String formatMessage(String string, Object[] objectArray) {
        if (string == null) {
            return EMPTY_STRING;
        }
        string = Utils.replaceSubString(string, "'", "''");
        return MessageFormat.format(string, objectArray);
    }

    public static String substring(String string, String string2, String string3) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return Utils.substring(string, Integer.parseInt(string2), Integer.parseInt(string3));
    }

    public static String substring(String string, int n, int n2) {
        if (string == null) {
            return EMPTY_STRING;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(n, n + n2);
    }

    public static String toLower(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string.toLowerCase();
    }

    public static String toUpper(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string.toUpperCase();
    }

    public static String length(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return String.valueOf(string.length());
    }

    public static String find(String string, String string2) {
        return Utils.find(string, string2, true);
    }

    public static String findLast(String string, String string2) {
        return Utils.find(string, string2, true);
    }

    public static String find(String string, String string2, boolean bl) {
        int n = -1;
        n = bl ? string.indexOf(string2) : string.lastIndexOf(string2);
        return String.valueOf(n);
    }

    public static String date(String string, String string2, Locale locale) {
        Date date = null;
        try {
            date = new Date(Long.parseLong(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            StringBuffer stringBuffer2 = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            stringBuffer = simpleDateFormat.format(date, stringBuffer2, fieldPosition);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EMPTY_STRING;
        }
        return stringBuffer.toString();
    }

    public static String createDate(String string, String string2, String string3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        if (string != null && string.length() > 0) {
            calendar.set(2, Integer.parseInt(string) - 1);
        }
        if (string2 != null && string2.length() > 0) {
            calendar.set(5, Integer.parseInt(string2));
        }
        if (string3 != null && string3.length() > 0) {
            calendar.set(1, Integer.parseInt(string3));
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    public static String firstWeekDayOfMonth(String string) {
        Date date = new Date(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        calendar.set(5, 1);
        return String.valueOf(calendar.get(7));
    }

    public static String firstDayOfWeek(String string, String string2) {
        Date date = new Date(Long.parseLong(string));
        long l = Long.parseLong(string2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        int n = calendar.get(7);
        int n2 = (int)((long)(n * -1) + l);
        calendar.add(5, n2);
        long l2 = calendar.getTime().getTime();
        return String.valueOf(l2);
    }

    public static String daysInMonth(String string) {
        Date date = new Date(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return String.valueOf(calendar.get(5));
    }

    public static String today() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    public static String todayTZ() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    public static String addToDate(String string, String string2, String string3) {
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Date date = new Date(Long.parseLong(string));
        int n2 = string2.equals("DAYS") ? 5 : (string2.equals("WEEKS") ? 3 : (string2.equals("MONTHS") ? 2 : (string2.equals("YEARS") ? 1 : (string2.equals("HOURS") ? 10 : (string2.equals("MINUTES") ? 12 : (string2.equals("SECONDS") ? 13 : 5))))));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(calendar.getTime());
        calendar.setTime(date);
        calendar.add(n2, n);
        long l = calendar.getTime().getTime();
        return String.valueOf(l);
    }

    public static String escape(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return URLCoder.encode(string);
    }

    public static String replaceWith(String string, String string2, String string3) {
        StringBuffer stringBuffer = Utils.replaceSubstrings(string, string2, string3);
        return stringBuffer.toString();
    }

    public static String startsWith(String string, String string2) {
        if (string.startsWith(string2)) {
            return "1";
        }
        return "0";
    }

    public static String endsWith(String string, String string2) {
        if (string.endsWith(string2)) {
            return "1";
        }
        return "0";
    }

    public static String linkURLs(String string, String string2, String string3, String string4, String string5) {
        int n;
        boolean bl = false;
        if (string4.equalsIgnoreCase("true")) {
            bl = true;
        }
        String string6 = string.toUpperCase();
        Object var7_7 = null;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        int n2 = 0;
        int n3 = 0;
        do {
            int n4 = string6.indexOf("HTTP://", n3);
            int n5 = string6.indexOf("HTTPS://", n3);
            int n6 = string6.indexOf("FTP://", n3);
            int n7 = string6.indexOf("WWW.", n3);
            n = n4;
            if (n5 != -1 && n > n5 || n == -1) {
                n = n5;
            }
            if (n6 != -1 && n > n6 || n == -1) {
                n = n6;
            }
            if (n7 != -1 && n > n7 || n == -1) {
                n = n7;
            }
            if (n == -1) continue;
            n3 = n;
            int n8 = string.length() - 1;
            boolean bl2 = false;
            char c = string.charAt(n3 + 1);
            while (n3 < n8 && !Character.isWhitespace(c) && c != ')' && c != '<' && c != '{' && c != '[') {
                if (c == '&' && n3 + 5 < n8 && string.charAt(n3 + 2) == 'a' && string.charAt(n3 + 3) == 'm' && string.charAt(n3 + 4) == 'p' && string.charAt(n3 + 5) == ';') {
                    n3 += 4;
                    bl2 = true;
                }
                if (++n3 >= n8) continue;
                c = string.charAt(n3 + 1);
            }
            while (!Character.isLetterOrDigit(string.charAt(n3)) && string.charAt(n3) != '/' && n3 > n) {
                --n3;
            }
            String string7 = string.substring(n, n3 + 1);
            Object[] objectArray = new String[3];
            objectArray[1] = string7;
            if (n == n7) {
                string7 = "http://" + string7;
            }
            int n9 = string7.indexOf("&amp;");
            while (n9 != -1) {
                string7 = string7.substring(0, n9 + 1) + string7.substring(n9 + 5);
                n9 = string7.indexOf("&amp;");
            }
            objectArray[0] = string7;
            String string8 = MessageFormat.format(string3, objectArray);
            if (!bl) {
                stringBuffer.append(string.substring(n2, n));
                if (n2 > 0 && string5 != null) {
                    stringBuffer.append(string5);
                }
            }
            stringBuffer.append(string8);
            n2 = n3 + 1;
        } while (n != -1);
        if (!bl) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String toHTML(String string) {
        return Utils.stringToHTML(string, true);
    }

    public static String toHTMLExt(String string) {
        return Utils.stringToHTMLExt(string);
    }

    public static String toDisplay(String string) {
        return Utils.stringToHTMLExt(string);
    }

    public static String toWMLExt(String string) {
        return Utils.stringToWMLExt(string);
    }

    public static String trim(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string.trim();
    }

    public static String toSpellerText(String string, String string2) {
        return Utils.stringToSpellerText(string, string2);
    }

    private static StringBuffer replaceSubstrings(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 != -1) {
            stringBuffer.append(string.substring(n2, n3));
            if (string3.length() > 0) {
                stringBuffer.append(string3);
            }
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer;
    }

    static String replaceSubString(String string, String string2, String string3) {
        if (string.indexOf(string2) == -1) {
            return string;
        }
        String string4 = new String(string.trim());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (-1 != string4.indexOf(string2, n2)) {
            ++n;
            n2 = string4.indexOf(string2, n2) + string2.length();
        }
        if (0 == n) {
            return string4;
        }
        int n4 = string4.length() + n * (string3.length() - string2.length());
        char[] cArray = new char[n4];
        int n5 = 0;
        while (n5 < n4) {
            cArray[n5] = 32;
            ++n5;
        }
        boolean bl = false;
        int n6 = 0;
        n2 = 0;
        n3 = 0;
        while (!bl) {
            n3 = string4.indexOf(string2, n2);
            if (-1 == n3) {
                bl = true;
                n3 = string4.length();
            }
            int n7 = n2;
            while (n7 < n3) {
                cArray[n6] = string4.charAt(n7);
                ++n6;
                ++n7;
            }
            if (!bl) {
                int n8 = 0;
                while (n8 < string3.length()) {
                    cArray[n6] = string3.charAt(n8);
                    ++n6;
                    ++n8;
                }
            }
            n2 = n3 + string2.length();
        }
        String string5 = new String(cArray);
        string5 = string5.trim();
        return string5;
    }

    public static String toQuote(String string) {
        return Utils.stringToQuoted(string);
    }

    static String stringToQuoted(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '\'': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#39;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#34;");
                    n2 += 3;
                    ++n;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String stringToHTML(String string, boolean bl) {
        if (string == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '\n': 
                case '\r': {
                    if (bl) {
                        if (n2 < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.setCharAt(n2++, 'B');
                            stringBuffer.insert(n2, "R>");
                            ++n2;
                        } else {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.insert(n2, "BR>");
                            n2 += 2;
                        }
                    } else {
                        stringBuffer.insert(n2, "<BR>");
                        if ((n2 += 4) < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            ++n2;
                        }
                    }
                    n = 0;
                    bl2 = false;
                    break;
                }
                case '<': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "lt;");
                    n2 += 2;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '>': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "gt;");
                    n2 += 2;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '$': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#36;");
                    n2 += 3;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '\u001b': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#27;");
                    n2 += 3;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '&': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "amp;");
                    n2 += 3;
                    ++n;
                    bl2 = false;
                    break;
                }
                case '\t': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "nbsp;");
                    n2 += 5;
                    ++n;
                    while (n == 0 || n % 4 != 0) {
                        stringBuffer.insert(n2, "&nbsp;");
                        n2 += 6;
                        ++n;
                    }
                    --n2;
                    bl2 = true;
                    break;
                }
                case ' ': {
                    if (bl2) {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "nbsp;");
                        n2 += 4;
                    }
                    ++n;
                    bl2 = true;
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "quot;");
                    n2 += 4;
                    ++n;
                    break;
                }
                default: {
                    bl2 = false;
                    ++n;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String stringToHTMLExt(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        while (n2 < stringBuffer.length()) {
            c = stringBuffer.charAt(n2);
            if (c >= '\u0080') {
                String string2 = Integer.toString(stringBuffer.charAt(n2));
                int n3 = string2.length();
                stringBuffer.setCharAt(n2++, '&');
                stringBuffer.insert(n2, "#" + string2 + ";");
                n2 += n3 + 1;
                ++n;
                bl = false;
            } else {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (n2 < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.setCharAt(n2++, 'B');
                            stringBuffer.insert(n2, "R>");
                            ++n2;
                        } else {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.insert(n2, "BR>");
                            n2 += 2;
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case '<': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "lt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '>': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "gt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '$': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "#36;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\u001b': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "#27;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '&': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "amp;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\t': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "nbsp;");
                        n2 += 5;
                        ++n;
                        while (n == 0 || n % 4 != 0) {
                            stringBuffer.insert(n2, "&nbsp;");
                            n2 += 6;
                            ++n;
                        }
                        --n2;
                        bl = true;
                        break;
                    }
                    case ' ': {
                        if (bl) {
                            stringBuffer.setCharAt(n2++, '&');
                            stringBuffer.insert(n2, "nbsp;");
                            n2 += 4;
                        }
                        ++n;
                        bl = true;
                        break;
                    }
                    case '\"': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "quot;");
                        n2 += 4;
                        ++n;
                        break;
                    }
                    default: {
                        bl = false;
                        ++n;
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String stringToWMLExt(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        while (n2 < stringBuffer.length()) {
            c = stringBuffer.charAt(n2);
            if (c >= '\u0080') {
                String string2 = Integer.toString(stringBuffer.charAt(n2));
                int n3 = string2.length();
                stringBuffer.setCharAt(n2++, '&');
                stringBuffer.insert(n2, "#" + string2 + ";");
                n2 += n3 + 1;
                ++n;
                bl = false;
            } else {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (n2 < stringBuffer.length() - 1 && (stringBuffer.charAt(n2) == '\n' && stringBuffer.charAt(n2 + 1) == '\r' || stringBuffer.charAt(n2) == '\r' && stringBuffer.charAt(n2 + 1) == '\n')) {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.setCharAt(n2++, 'B');
                            stringBuffer.insert(n2, "R>");
                            ++n2;
                        } else {
                            stringBuffer.setCharAt(n2++, '<');
                            stringBuffer.insert(n2, "BR>");
                            n2 += 2;
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case '<': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "lt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '>': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "gt;");
                        n2 += 2;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '$': {
                        stringBuffer.insert(++n2, '$');
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\u001b': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "#27;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '&': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "amp;");
                        n2 += 3;
                        ++n;
                        bl = false;
                        break;
                    }
                    case '\t': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "nbsp;");
                        n2 += 5;
                        ++n;
                        while (n == 0 || n % 4 != 0) {
                            stringBuffer.insert(n2, "&nbsp;");
                            n2 += 6;
                            ++n;
                        }
                        --n2;
                        bl = true;
                        break;
                    }
                    case ' ': {
                        if (bl) {
                            stringBuffer.setCharAt(n2++, '&');
                            stringBuffer.insert(n2, "nbsp;");
                            n2 += 4;
                        }
                        ++n;
                        bl = true;
                        break;
                    }
                    case '\"': {
                        stringBuffer.setCharAt(n2++, '&');
                        stringBuffer.insert(n2, "quot;");
                        n2 += 4;
                        ++n;
                        break;
                    }
                    default: {
                        bl = false;
                        ++n;
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String toXML(String string) {
        return Utils.stringToXML(string);
    }

    public static String xmlEncode(String string) {
        return Utils.stringToXML(string);
    }

    public static String toTag(String string) {
        return Utils.stringToXML(string);
    }

    static String stringToXML(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n2)) {
                case '<': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#60;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '>': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#62;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '&': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#38;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\'': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#39;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#34;");
                    n2 += 3;
                    ++n;
                    break;
                }
                case '\u001b': {
                    stringBuffer.setCharAt(n2++, '&');
                    stringBuffer.insert(n2, "#27;");
                    n2 += 3;
                    ++n;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    String xmlDecode(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return Utils.stringFromXML(string);
    }

    static String stringFromXML(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n2 = string.length();
        StringBuffer stringBuffer3 = new StringBuffer(n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            char c;
            if ((c = stringBuffer2.charAt(n3++)) == '#') {
                n5 = 0;
                c = stringBuffer2.charAt(n3++);
                while (c != ';' && n5 < n) {
                    stringBuffer.append(c);
                    ++n5;
                    c = stringBuffer2.charAt(n3++);
                }
                c = (char)Integer.parseInt(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            stringBuffer3.insert(n4++, c);
        }
        return stringBuffer2.toString();
    }

    static String stringToSpellerText(String string, String string2) {
        if (string == null) {
            return EMPTY_STRING;
        }
        String string3 = '<' + string2 + '>';
        int n = string3.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            switch (stringBuffer.charAt(n3)) {
                case '\n': 
                case '\r': {
                    stringBuffer.insert(n3, string3);
                    if ((n3 += n) < stringBuffer.length() - 1 && (stringBuffer.charAt(n3) == '\n' && stringBuffer.charAt(n3 + 1) == '\r' || stringBuffer.charAt(n3) == '\r' && stringBuffer.charAt(n3 + 1) == '\n')) {
                        ++n3;
                    }
                    n2 = 0;
                    break;
                }
                case '<': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "lt;");
                    n3 += 2;
                    ++n2;
                    break;
                }
                case '>': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "gt;");
                    n3 += 2;
                    ++n2;
                    break;
                }
                case '&': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "amp;");
                    n3 += 3;
                    ++n2;
                    break;
                }
                case '\t': {
                    boolean bl = true;
                    while (n2 == 0 || n2 % 4 != 0) {
                        if (bl) {
                            stringBuffer.setCharAt(n3, ' ');
                            bl = false;
                        } else {
                            stringBuffer.insert(++n3, " ");
                        }
                        ++n2;
                    }
                    break;
                }
                case '\"': {
                    stringBuffer.setCharAt(n3++, '&');
                    stringBuffer.insert(n3, "quot;");
                    n3 += 4;
                    ++n2;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

