/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.wbem.client.ClientProperties;

public class CIMNameSpace
implements Serializable {
    static final long serialVersionUID = 200L;
    private static final String DEFAULT_HOST = "localhost";
    static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private String host = "localhost";
    private String nameSpace = "/root/cimv2";
    private URI hostURI = null;
    private static String localIP = null;

    protected static String validateNameSpace(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        s = s.replace('\\', '/');
        s = s.toLowerCase();
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c != '/') continue;
            int nextChar = i + 1;
            while (nextChar < len && s.charAt(nextChar) == '/') {
                i = nextChar++;
            }
        }
        int lastChar = sb.length() - 1;
        if (lastChar > 0 && sb.charAt(lastChar) == '/') {
            sb.deleteCharAt(lastChar);
        }
        return sb.toString();
    }

    public CIMNameSpace() {
        this(null);
    }

    public CIMNameSpace(String uri) {
        if (uri == null) {
            try {
                this.host = this.getLocalIPAddress();
            }
            catch (Exception e) {
                this.host = DEFAULT_HOST;
            }
        } else {
            try {
                this.hostURI = new URI(uri);
                this.host = this.hostURI.getHost() != null ? this.hostURI.getHost() : uri;
                try {
                    this.host = this.host.equalsIgnoreCase(DEFAULT_HOST) ? this.getLocalIPAddress() : InetAddress.getByName(this.host).getHostAddress();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String path = this.hostURI.getPath();
                if (path != null && !path.equals("")) {
                    this.nameSpace = CIMNameSpace.validateNameSpace(path);
                }
            }
            catch (URISyntaxException e) {
                if (uri.indexOf(47) != -1 || uri.indexOf(92) != -1) {
                    throw new IllegalArgumentException(e.getClass().getName() + ": " + e.getMessage());
                }
                this.host = uri;
            }
        }
    }

    public CIMNameSpace(String host, String ns) {
        this(host);
        this.nameSpace = CIMNameSpace.validateNameSpace(ns);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        if (this.hostURI != null) {
            return this.hostURI.getScheme();
        }
        return null;
    }

    public String getPort() {
        if (this.hostURI != null) {
            return this.hostURI.getPort() != -1 ? new Integer(this.hostURI.getPort()).toString() : null;
        }
        return null;
    }

    public URI getURI() {
        return this.hostURI;
    }

    public void parse(String p) {
        String s = p.replace('\\', '/');
        if (s.startsWith("//")) {
            int index = s.indexOf("/", 3);
            this.host = s.substring(2, index);
        }
        this.nameSpace = s;
    }

    public void setNameSpace(String ns) {
        this.nameSpace = CIMNameSpace.validateNameSpace(ns);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String toString() {
        boolean haveNameSpace;
        StringBuffer buffer = new StringBuffer(this.host.length() + this.nameSpace.length() + 3);
        boolean haveHost = this.host != null && this.host.length() > 0;
        boolean bl = haveNameSpace = this.nameSpace != null && this.nameSpace.length() > 0;
        if (haveHost) {
            String scheme;
            if (this.hostURI != null && (scheme = this.hostURI.getScheme()) != null) {
                buffer.append(scheme);
                buffer.append(":");
            }
            buffer.append("//");
            buffer.append(this.host);
            if (this.getPort() != null) {
                buffer.append(":" + this.getPort());
            }
            if (haveNameSpace && this.nameSpace.charAt(0) != '/') {
                buffer.append('/');
            }
        }
        if (haveNameSpace) {
            buffer.append(this.nameSpace);
        }
        return buffer.toString();
    }

    private String getLocalIPAddress() {
        if (localIP != null) {
            return localIP;
        }
        try {
            if (System.getProperty("java.net.preferIPv4Stack") == null) {
                String preferIPv4 = ClientProperties.getProperty("java.net.preferIPv4Stack") == null ? "true" : ClientProperties.getProperty("java.net.preferIPv4Stack");
                System.setProperty("java.net.preferIPv4Stack", preferIPv4);
            }
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> e1 = ni.getInetAddresses();
                while (e1.hasMoreElements()) {
                    InetAddress inetAddress = e1.nextElement();
                    String address = inetAddress.getHostAddress();
                    if (address == null || address.trim().length() == 0 || address.equalsIgnoreCase(LOOPBACK_ADDRESS)) continue;
                    localIP = address;
                    return address;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        localIP = LOOPBACK_ADDRESS;
        return localIP;
    }
}

