/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.util.Random;

public class PasswordCredential {
    public static final int MAX_PASSWORD_SIZE = 256;
    public static final byte[] NULL_PASSWORD = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] junk;
    private byte[] userpswd;
    private String hostname;

    public PasswordCredential() {
        this.setup();
        this.userpswd = new byte[256];
        this.zap(this.userpswd);
        this.hostname = null;
    }

    public PasswordCredential(String userPassword) {
        this.setup();
        this.userpswd = new byte[256];
        if (userPassword != null && userPassword.trim().length() > 0) {
            this.encode(this.userpswd, userPassword);
        } else {
            this.zap(this.userpswd);
        }
        this.hostname = null;
    }

    public String getUserPassword() {
        String str = this.userpswd[0] == 0 && this.userpswd[1] == 0 ? "" : this.decode(this.userpswd);
        return str;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setUserPassword(String userPassword) {
        if (userPassword != null && userPassword.trim().length() > 0) {
            this.encode(this.userpswd, userPassword);
        } else {
            this.zap(this.userpswd);
        }
    }

    public void clearUserPassword() {
        this.zap(this.userpswd);
        this.hostname = null;
    }

    public void setHostName(String hostName) {
        this.hostname = hostName;
    }

    protected void encode(byte[] pswd, String password) {
        if (password != null) {
            int i;
            byte[] kb = new byte[256];
            System.arraycopy(this.junk, 0, kb, 0, 256);
            byte[] data = password.getBytes();
            int len = data.length;
            if (len > 256) {
                len = 256;
            }
            for (i = 0; i < len; ++i) {
                int n = i;
                kb[n] = (byte)(kb[n] ^ data[i]);
            }
            if (i < 256) {
                int n = i;
                kb[n] = (byte)(kb[n] ^ 0);
            }
            System.arraycopy(kb, 0, pswd, 0, 256);
        } else {
            this.zap(pswd);
        }
    }

    protected String decode(byte[] pswd) {
        String str = "";
        byte[] kb = new byte[256];
        System.arraycopy(this.junk, 0, kb, 0, 256);
        int len = 256;
        boolean sw = true;
        int j = len;
        for (int i = 0; i < len; ++i) {
            int n = i;
            kb[n] = (byte)(kb[n] ^ pswd[i]);
            if (!sw || kb[i] != 0) continue;
            sw = false;
            j = i;
        }
        if (j > 0) {
            str = new String(kb, 0, j);
        }
        return str;
    }

    protected void zap(byte[] pswd) {
        System.arraycopy(NULL_PASSWORD, 0, pswd, 0, 256);
        pswd[0] = this.junk[0];
    }

    private void setup() {
        byte[] kb1 = new byte[256];
        byte[] kb2 = new byte[256];
        this.junk = new byte[256];
        long time = System.currentTimeMillis();
        Random seeder = new Random(time);
        seeder.nextBytes(kb1);
        seeder.nextBytes(kb2);
        time = System.currentTimeMillis();
        long mask = 1L;
        long test = 0L;
        for (int i = 0; i < 256; ++i) {
            test = time & mask;
            this.junk[i] = test > 0L ? kb1[i] : kb2[i];
            mask <<= 1;
        }
    }
}

