/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascent;
    int descent;
    int[] segments;
    int[] tabs;
    StyleItem[] styles;
    int layout;
    int context;
    int attrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.context = OS.gdk_pango_context_get();
        if (this.context == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        OS.gdk_pango_context_set_colormap(this.context, OS.gdk_colormap_get_system());
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0) {
            SWT.error(2);
        }
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.pango_layout_set_auto_dir(this.layout, false);
        }
        this.text = "";
        this.descent = -1;
        this.ascent = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.attrList != 0) {
            return;
        }
        String string = this.getSegmentsText();
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        OS.pango_layout_set_text(this.layout, byArray, byArray.length);
        if (this.styles.length == 2 && this.styles[0].style == null && this.ascent == -1 && this.descent == -1 && this.segments == null) {
            return;
        }
        int n7 = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        PangoAttribute pangoAttribute = new PangoAttribute();
        char[] cArray = null;
        int n8 = string.length();
        if ((this.ascent != -1 || this.descent != -1) && n8 > 0) {
            n6 = OS.pango_layout_get_iter(this.layout);
            if (n6 == 0) {
                SWT.error(2);
            }
            PangoRectangle pangoRectangle = new PangoRectangle();
            if (this.ascent != -1) {
                pangoRectangle.y = -(this.ascent * 1024);
            }
            pangoRectangle.height = (Math.max(0, this.ascent) + Math.max(0, this.descent)) * 1024;
            n5 = OS.pango_layout_get_line_count(this.layout);
            cArray = new char[n8 + n5 * 2];
            int n9 = 0;
            int n10 = 0;
            do {
                n4 = OS.pango_layout_iter_get_index(n6);
                n3 = n10 * 6;
                n2 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n2, PangoAttribute.sizeof);
                pangoAttribute.start_index = n4 + n3;
                pangoAttribute.end_index = n4 + n3 + 3;
                OS.memmove(n2, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n2);
                n2 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n2, PangoAttribute.sizeof);
                pangoAttribute.start_index = n4 + n3 + 3;
                pangoAttribute.end_index = n4 + n3 + 6;
                OS.memmove(n2, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n2);
                n = OS.g_utf8_pointer_to_offset(n7, n7 + n4);
                cArray[n + n10 * 2] = 8203;
                cArray[n + n10 * 2 + 1] = 65279;
                string.getChars(n9, n, cArray, n9 + n10 * 2);
                n9 = n;
                ++n10;
            } while (OS.pango_layout_iter_next_line(n6));
            OS.pango_layout_iter_free(n6);
            string.getChars(n9, n8, cArray, n9 + n10 * 2);
            byArray = Converter.wcsToMbcs(null, cArray, false);
            OS.pango_layout_set_text(this.layout, byArray, byArray.length);
            n7 = OS.pango_layout_get_text(this.layout);
        } else {
            cArray = new char[n8];
            string.getChars(0, n8, cArray, 0);
        }
        n6 = 0;
        int n11 = 0;
        while (n11 < cArray.length) {
            n5 = cArray[n11];
            if (n5 == 8206 || n5 == 8207 || n5 == 65279 || n5 == 8203) {
                ++n6;
            }
            ++n11;
        }
        this.invalidOffsets = new int[n6];
        n6 = 0;
        n11 = 0;
        while (n11 < cArray.length) {
            n5 = cArray[n11];
            if (n5 == 8206 || n5 == 8207 || n5 == 65279 || n5 == 8203) {
                this.invalidOffsets[n6++] = n11;
            }
            ++n11;
        }
        n11 = OS.strlen(n7);
        n5 = 0;
        while (n5 < this.styles.length - 1) {
            StyleItem styleItem = this.styles[n5];
            TextStyle textStyle = styleItem.style;
            if (textStyle != null) {
                int n12;
                GlyphMetrics glyphMetrics;
                int n13;
                Object object;
                Color color;
                int n14;
                n4 = this.translateOffset(styleItem.start);
                n3 = this.translateOffset(this.styles[n5 + 1].start - 1);
                n2 = OS.g_utf8_offset_to_pointer(n7, n4) - n7;
                n = OS.g_utf8_offset_to_pointer(n7, n3 + 1) - n7;
                n2 = Math.min(n2, n11);
                n = Math.min(n, n11);
                Font font = textStyle.font;
                if (font != null && !font.isDisposed()) {
                    n14 = OS.pango_attr_font_desc_new(font.handle);
                    OS.memmove(pangoAttribute, n14, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n14, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n14);
                }
                if (textStyle.underline) {
                    n14 = OS.pango_attr_underline_new(1);
                    OS.memmove(pangoAttribute, n14, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n14, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n14);
                }
                if (textStyle.strikeout) {
                    n14 = OS.pango_attr_strikethrough_new(true);
                    OS.memmove(pangoAttribute, n14, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n14, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n14);
                }
                if ((color = textStyle.foreground) != null && !color.isDisposed()) {
                    object = color.handle;
                    int n15 = OS.pango_attr_foreground_new(((GdkColor)object).red, ((GdkColor)object).green, ((GdkColor)object).blue);
                    OS.memmove(pangoAttribute, n15, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n15, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n15);
                }
                if ((object = textStyle.background) != null && !((Color)object).isDisposed()) {
                    GdkColor gdkColor = ((Color)object).handle;
                    n13 = OS.pango_attr_background_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                    OS.memmove(pangoAttribute, n13, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n13, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n13);
                }
                if ((glyphMetrics = textStyle.metrics) != null) {
                    PangoRectangle pangoRectangle = new PangoRectangle();
                    pangoRectangle.y = -(glyphMetrics.ascent * 1024);
                    pangoRectangle.height = (glyphMetrics.ascent + glyphMetrics.descent) * 1024;
                    pangoRectangle.width = glyphMetrics.width * 1024;
                    n12 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                    OS.memmove(pangoAttribute, n12, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n12, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n12);
                }
                if ((n13 = textStyle.rise) != 0) {
                    n12 = OS.pango_attr_rise_new(n13 * 1024);
                    OS.memmove(pangoAttribute, n12, PangoAttribute.sizeof);
                    pangoAttribute.start_index = n2;
                    pangoAttribute.end_index = n;
                    OS.memmove(n12, pangoAttribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, n12);
                }
            }
            ++n5;
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    public void dispose() {
        if (this.layout == 0) {
            return;
        }
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        if (this.layout != 0) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0;
        if (this.context != 0) {
            OS.g_object_unref(this.context);
        }
        this.context = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(1);
        int n8 = this.text.length();
        boolean bl = n3 <= n4 && n3 != -1 && n4 != -1;
        GCData gCData = gC.data;
        int n9 = gCData.cairo;
        if (n5 != 0 && (bl || (n5 & 0x100000) != 0)) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            PangoLogAttr pangoLogAttr = new PangoLogAttr();
            PangoRectangle pangoRectangle = new PangoRectangle();
            n7 = OS.pango_layout_get_line_count(this.layout);
            int n10 = OS.pango_layout_get_text(this.layout);
            int n11 = OS.pango_layout_get_iter(this.layout);
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_save(n9);
                GdkColor gdkColor = color2.handle;
                Cairo.cairo_set_source_rgba(n9, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, color2.handle);
            }
            n6 = 0;
            do {
                int n12;
                int n13;
                int n14;
                OS.pango_layout_iter_get_line_extents(n11, null, pangoRectangle);
                if (OS.pango_layout_iter_next_line(n11)) {
                    n14 = OS.pango_layout_iter_get_index(n11);
                    n13 = OS.g_utf8_pointer_to_offset(n10, n10 + n14);
                } else {
                    n13 = OS.g_utf8_strlen(n10, -1);
                }
                n14 = 0;
                if (n6 == n7 - 1 && (n5 & 0x100000) != 0) {
                    n14 = 1;
                } else {
                    if (nArray[0] == 0) {
                        OS.pango_layout_get_log_attrs(this.layout, nArray, nArray2);
                    }
                    OS.memmove(pangoLogAttr, nArray[0] + n13 * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
                    if (!pangoLogAttr.is_line_break) {
                        if (n3 <= n13 && n13 <= n4) {
                            n14 = 1;
                        }
                    } else if (n3 <= n13 && n13 < n4 && (n5 & 0x10000) != 0) {
                        n14 = 1;
                    }
                }
                if (n14 == 0) continue;
                int n15 = n + OS.PANGO_PIXELS(pangoRectangle.x) + OS.PANGO_PIXELS(pangoRectangle.width);
                int n16 = n2 + OS.PANGO_PIXELS(pangoRectangle.y);
                int n17 = OS.PANGO_PIXELS(pangoRectangle.height);
                if (this.ascent != -1 && this.descent != -1) {
                    n17 = Math.max(n17, this.ascent + this.descent);
                }
                int n18 = n12 = (n5 & 0x10000) != 0 ? Integer.MAX_VALUE : n17 / 3;
                if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    Cairo.cairo_rectangle(n9, n15, n16, n12, n17);
                    Cairo.cairo_fill(n9);
                    continue;
                }
                OS.gdk_draw_rectangle(gCData.drawable, gC.handle, 1, n15, n16, n12, n17);
            } while (++n6 < n7);
            OS.pango_layout_iter_free(n11);
            if (nArray[0] != 0) {
                OS.g_free(nArray[0]);
            }
            if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_restore(n9);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, gCData.foreground);
            }
        }
        if (n8 == 0) {
            return;
        }
        if (!bl) {
            if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_move_to(n9, n, n2);
                OS.pango_cairo_show_layout(n9, this.layout);
            } else {
                OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
            }
        } else {
            boolean bl2;
            n3 = Math.min(Math.max(0, n3), n8 - 1);
            n4 = Math.min(Math.max(0, n4), n8 - 1);
            n8 = OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1);
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            boolean bl3 = bl2 = n3 == 0 && n4 == n8 - 1;
            if (bl2) {
                if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    int n19 = OS.pango_layout_get_text(this.layout);
                    this.drawWithCairo(n9, n, n2, 0, OS.strlen(n19), bl2, color2.handle, color.handle);
                } else {
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                }
            } else {
                int n20 = OS.pango_layout_get_text(this.layout);
                int n21 = OS.g_utf8_offset_to_pointer(n20, n3) - n20;
                int n22 = OS.g_utf8_offset_to_pointer(n20, n4 + 1) - n20;
                n7 = OS.strlen(n20);
                n21 = Math.min(n21, n7);
                n22 = Math.min(n22, n7);
                if (n9 != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    this.drawWithCairo(n9, n, n2, n21, n22, bl2, color2.handle, color.handle);
                } else {
                    Region region = new Region();
                    gC.getClipping(region);
                    OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                    int[] nArray = new int[]{n21, n22};
                    n6 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (n6 != 0) {
                        OS.gdk_gc_set_clip_region(gC.handle, n6);
                        OS.gdk_region_destroy(n6);
                    }
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    gC.setClipping(region);
                    region.dispose();
                }
            }
        }
    }

    void drawWithCairo(int n, int n2, int n3, int n4, int n5, boolean bl, GdkColor gdkColor, GdkColor gdkColor2) {
        int[] nArray;
        int n6;
        Cairo.cairo_save(n);
        if (!bl) {
            Cairo.cairo_move_to(n, n2, n3);
            OS.pango_cairo_show_layout(n, this.layout);
        }
        if ((n6 = OS.gdk_pango_layout_get_clip_region(this.layout, n2, n3, nArray = new int[]{n4, n5}, nArray.length / 2)) != 0) {
            OS.gdk_cairo_region(n, n6);
            Cairo.cairo_clip(n);
            OS.gdk_cairo_set_source_color(n, gdkColor);
            Cairo.cairo_paint(n);
            OS.gdk_region_destroy(n6);
        }
        OS.gdk_cairo_set_source_color(n, gdkColor2);
        Cairo.cairo_move_to(n, n2, n3);
        OS.pango_cairo_show_layout(n, this.layout);
        Cairo.cairo_restore(n);
    }

    void freeRuns() {
        if (this.attrList == 0) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int n = OS.pango_layout_get_alignment(this.layout);
        switch (n) {
            case 1: {
                return 0x1000000;
            }
            case 2: {
                return 131072;
            }
        }
        return 16384;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(this.layout, nArray, nArray2);
        int n = OS.pango_layout_get_width(this.layout);
        int n2 = OS.PANGO_PIXELS(n != -1 ? n : nArray[0]);
        int n3 = OS.PANGO_PIXELS(nArray2[0]);
        if (this.ascent != -1 && this.descent != -1) {
            n3 = Math.max(n3, this.ascent + this.descent);
        }
        return new Rectangle(0, 0, n2, n3);
    }

    public Rectangle getBounds(int n, int n2) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n4 - 1);
        n2 = Math.min(Math.max(0, n2), n4 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        int n5 = OS.pango_layout_get_text(this.layout);
        int n6 = OS.g_utf8_offset_to_pointer(n5, n) - n5;
        int n7 = OS.g_utf8_offset_to_pointer(n5, n2 + 1) - n5;
        int n8 = OS.strlen(n5);
        int[] nArray = new int[]{n6 = Math.min(n6, n8), n7 = Math.min(n7, n8)};
        int n9 = OS.gdk_pango_layout_get_clip_region(this.layout, 0, 0, nArray, 1);
        if (n9 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        PangoRectangle pangoRectangle = new PangoRectangle();
        int n10 = OS.pango_layout_get_iter(this.layout);
        if (n10 == 0) {
            SWT.error(2);
        }
        if ((n3 = OS.gdk_region_new()) == 0) {
            SWT.error(2);
        }
        int n11 = 0;
        do {
            OS.pango_layout_iter_get_line_extents(n10, null, pangoRectangle);
            n11 = OS.pango_layout_iter_next_line(n10) ? OS.pango_layout_iter_get_index(n10) - 1 : n8;
            if (n6 > n11) continue;
            gdkRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            gdkRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            gdkRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            gdkRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            OS.gdk_region_union_with_rect(n3, gdkRectangle);
        } while (n11 + 1 <= n7);
        OS.gdk_region_intersect(n9, n3);
        OS.gdk_region_destroy(n3);
        OS.pango_layout_iter_free(n10);
        OS.gdk_region_get_clipbox(n9, gdkRectangle);
        OS.gdk_region_destroy(n9);
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_indent(this.layout));
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = OS.pango_layout_get_iter(this.layout);
        if (n3 == 0) {
            SWT.error(2);
        }
        int n4 = 0;
        PangoItem pangoItem = new PangoItem();
        PangoLayoutRun pangoLayoutRun = new PangoLayoutRun();
        int n5 = OS.pango_layout_get_text(this.layout);
        int n6 = OS.g_utf8_offset_to_pointer(n5, n) - n5;
        int n7 = OS.strlen(n5);
        n6 = Math.min(n6, n7);
        do {
            int n8;
            if ((n8 = OS.pango_layout_iter_get_run(n3)) == 0) continue;
            OS.memmove(pangoLayoutRun, n8, PangoLayoutRun.sizeof);
            OS.memmove(pangoItem, pangoLayoutRun.item, PangoItem.sizeof);
            if (pangoItem.offset > n6 || n6 >= pangoItem.offset + pangoItem.length) continue;
            n4 = pangoItem.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(n3));
        OS.pango_layout_iter_free(n3);
        return n4;
    }

    public Rectangle getLineBounds(int n) {
        int n2;
        this.checkLayout();
        this.computeRuns();
        int n3 = OS.pango_layout_get_line_count(this.layout);
        if (n < 0 || n >= n3) {
            SWT.error(6);
        }
        if ((n2 = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        int n4 = 0;
        while (n4 < n) {
            OS.pango_layout_iter_next_line(n2);
            ++n4;
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(n2, null, pangoRectangle);
        OS.pango_layout_iter_free(n2);
        int n5 = OS.PANGO_PIXELS(pangoRectangle.x);
        int n6 = OS.PANGO_PIXELS(pangoRectangle.y);
        int n7 = OS.PANGO_PIXELS(pangoRectangle.width);
        int n8 = OS.PANGO_PIXELS(pangoRectangle.height);
        if (this.ascent != -1 && this.descent != -1) {
            n8 = Math.max(n8, this.ascent + this.descent);
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(5);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        int n4 = OS.pango_layout_get_text(this.layout);
        int n5 = OS.g_utf8_offset_to_pointer(n4, n) - n4;
        int n6 = OS.strlen(n4);
        n5 = Math.min(n5, n6);
        int n7 = OS.pango_layout_get_iter(this.layout);
        if (n7 == 0) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(n7)) {
            if (OS.pango_layout_iter_get_index(n7) > n5) break;
            ++n3;
        }
        OS.pango_layout_iter_free(n7);
        return n3;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = OS.pango_layout_get_line_count(this.layout);
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 0;
        int n4 = 0;
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        OS.memmove(pangoLayoutLine, OS.pango_layout_get_line(this.layout, n), PangoLayoutLine.sizeof);
        if (pangoLayoutLine.runs == 0) {
            int n5 = this.font != null ? this.font.handle : this.device.systemFont.handle;
            int n6 = OS.pango_context_get_language(this.context);
            int n7 = OS.pango_context_get_metrics(this.context, n5, n6);
            n3 = OS.pango_font_metrics_get_ascent(n7);
            n4 = OS.pango_font_metrics_get_descent(n7);
            OS.pango_font_metrics_unref(n7);
        } else {
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, n), null, pangoRectangle);
            n3 = -pangoRectangle.y;
            n4 = pangoRectangle.height - n3;
        }
        n3 = Math.max(this.ascent, OS.PANGO_PIXELS(n3));
        n4 = Math.max(this.descent, OS.PANGO_PIXELS(n4));
        return FontMetrics.gtk_new(n3, n4, 0, 0, n3 + n4);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int n = OS.pango_layout_get_line_count(this.layout);
        int[] nArray = new int[n + 1];
        int n2 = OS.pango_layout_get_text(this.layout);
        int n3 = OS.pango_layout_get_iter(this.layout);
        if (n3 == 0) {
            SWT.error(2);
        }
        int n4 = 0;
        do {
            int n5 = OS.pango_layout_iter_get_index(n3);
            int n6 = OS.g_utf8_pointer_to_offset(n2, n2 + n5);
            nArray[n4++] = this.untranslateOffset(n6);
        } while (OS.pango_layout_iter_next_line(n3));
        OS.pango_layout_iter_free(n3);
        nArray[n] = this.text.length();
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = OS.pango_layout_get_text(this.layout);
        int n4 = OS.g_utf8_offset_to_pointer(n3, n) - n3;
        int n5 = OS.strlen(n3);
        n4 = Math.min(n4, n5);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, n4, pangoRectangle);
        int n6 = bl ? pangoRectangle.x + pangoRectangle.width : pangoRectangle.x;
        int n7 = pangoRectangle.y;
        return new Point(OS.PANGO_PIXELS(n6), OS.PANGO_PIXELS(n7));
    }

    public int getNextOffset(int n, int n2) {
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl) {
            if (n == n4) {
                return n4;
            }
        } else if (n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, nArray, nArray2);
        if (nArray[0] == 0) {
            return n + n3;
        }
        n4 = OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1);
        n = this.translateOffset(n);
        PangoLogAttr pangoLogAttr = new PangoLogAttr();
        n = this.validateOffset(n, n3);
        while (n > 0 && n < n4) {
            OS.memmove(pangoLogAttr, nArray[0] + n * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
            if ((n2 & 2) != 0 && pangoLogAttr.is_cursor_position || (n2 & 4) != 0 && (!bl ? pangoLogAttr.is_word_start : pangoLogAttr.is_word_end)) break;
            if ((n2 & 0x10) != 0 && pangoLogAttr.is_word_start || (n2 & 8) != 0 && pangoLogAttr.is_word_end) break;
            n = this.validateOffset(n, n3);
        }
        OS.g_free(nArray[0]);
        return Math.min(Math.max(0, this.untranslateOffset(n)), this.text.length());
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        if ((n3 = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(n3, null, pangoRectangle);
            pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            if (pangoRectangle.y > n2 || n2 >= pangoRectangle.y + pangoRectangle.height) continue;
            pangoRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            if (n >= pangoRectangle.x + pangoRectangle.width) {
                n = pangoRectangle.x + pangoRectangle.width - 1;
            }
            if (n >= pangoRectangle.x) break;
            n = pangoRectangle.x;
            break;
        } while (OS.pango_layout_iter_next_line(n3));
        OS.pango_layout_iter_free(n3);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.pango_layout_xy_to_index(this.layout, n * 1024, n2 * 1024, nArray2, nArray3);
        int n4 = OS.pango_layout_get_text(this.layout);
        int n5 = OS.g_utf8_pointer_to_offset(n4, n4 + nArray2[0]);
        if (nArray != null) {
            nArray[0] = nArray3[0];
        }
        return this.untranslateOffset(n5);
    }

    public int getOrientation() {
        this.checkLayout();
        int n = OS.pango_context_get_base_dir(this.context);
        return n == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int n, int n2) {
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int n = OS.pango_layout_get_width(this.layout);
        return n != -1 ? OS.PANGO_PIXELS(n) : -1;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        int n3 = 0;
        switch (n) {
            case 0x1000000: {
                n3 = 1;
                break;
            }
            case 131072: {
                n3 = 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, n3);
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : 0);
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        OS.pango_layout_set_indent(this.layout, n * 1024);
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, bl);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n &= n3) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        int n4 = n2 = n == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == n2) {
            return;
        }
        OS.pango_context_set_base_dir(this.context, n2);
        OS.pango_layout_context_changed(this.layout);
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_spacing(this.layout, n * 1024);
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        this.checkLayout();
        int n5 = this.text.length();
        if (n5 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n5 - 1);
        n2 = Math.min(Math.max(0, n2), n5 - 1);
        if (n > 0 && TextLayout.isAlef(this.text.charAt(n)) && TextLayout.isLam(this.text.charAt(n - 1))) {
            --n;
        }
        if (n2 < n5 - 1 && TextLayout.isLam(this.text.charAt(n2)) && TextLayout.isAlef(this.text.charAt(n2 + 1))) {
            ++n2;
        }
        int n6 = -1;
        int n7 = this.styles.length;
        while (n7 - n6 > 1) {
            n4 = (n7 + n6) / 2;
            if (this.styles[n4 + 1].start > n) {
                n7 = n4;
                continue;
            }
            n6 = n4;
        }
        if (n7 >= 0 && n7 < this.styles.length) {
            StyleItem styleItem = this.styles[n7];
            if (styleItem.start == n && this.styles[n7 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n8 = n4 = n7;
        while (n8 < this.styles.length) {
            if (this.styles[n8 + 1].start > n2) break;
            ++n8;
        }
        if (n4 == n8) {
            n3 = this.styles[n4].start;
            int n9 = this.styles[n8 + 1].start - 1;
            if (n3 == n && n9 == n2) {
                this.styles[n4].style = textStyle;
                return;
            }
            if (n3 != n && n9 != n2) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                styleItemArray[n4 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n4].style;
                styleItemArray[n4 + 2] = styleItem;
                System.arraycopy(this.styles, n8 + 1, styleItemArray, n8 + 3, this.styles.length - n8 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n == this.styles[n4].start) {
            --n4;
        }
        if (n2 == this.styles[n8 + 1].start - 1) {
            ++n8;
        }
        n3 = this.styles.length + 1 - (n8 - n4 - 1);
        StyleItem[] styleItemArray = new StyleItem[n3];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        styleItemArray[n4 + 1] = styleItem;
        this.styles[n8].start = n2 + 1;
        System.arraycopy(this.styles, n8, styleItemArray, n4 + 2, this.styles.length - n8);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        int n;
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.tabs = nArray;
        if (nArray == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            n = OS.pango_tab_array_new(nArray.length, true);
            if (n != 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    OS.pango_tab_array_set_tab(n, n2, 0, nArray[n2]);
                    ++n2;
                }
                OS.pango_layout_set_tabs(this.layout, n);
                OS.pango_tab_array_free(n);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = string.length();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        this.freeRuns();
        OS.pango_layout_set_width(this.layout, n == -1 ? -1 : n * 1024);
    }

    static final boolean isLam(int n) {
        return n == 1604;
    }

    static final boolean isAlef(int n) {
        switch (n) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n < this.invalidOffsets[n3]) break;
            ++n;
            ++n3;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n == this.invalidOffsets[n3]) {
                ++n;
            } else if (n < this.invalidOffsets[n3]) {
                return n - n3;
            }
            ++n3;
        }
        return n - this.invalidOffsets.length;
    }

    int validateOffset(int n, int n2) {
        if (this.invalidOffsets == null) {
            return n + n2;
        }
        int n3 = n2 > 0 ? 0 : this.invalidOffsets.length - 1;
        block0: do {
            n += n2;
            while (n3 >= 0 && n3 < this.invalidOffsets.length) {
                if (this.invalidOffsets[n3] == n) continue block0;
                n3 += n2;
            }
        } while (n3 >= 0 && n3 < this.invalidOffsets.length);
        return n;
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

