/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 32768);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        int n;
        this.fullPath = null;
        if ((this.style & 0x2002) == 2) {
            n = OS.gtk_file_chooser_get_filenames(this.handle);
            int n2 = OS.g_slist_length(n);
            this.fileNames = new String[n2];
            int n3 = n;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = OS.g_slist_data(n3);
                int n7 = OS.g_filename_to_utf8(n6, -1, null, null, null);
                OS.g_free(n6);
                if (n7 != 0) {
                    int[] nArray = new int[1];
                    int n8 = OS.g_utf8_to_utf16(n7, -1, null, nArray, null);
                    OS.g_free(n7);
                    if (n8 != 0) {
                        int n9 = nArray[0];
                        char[] cArray = new char[n9];
                        OS.memmove(cArray, n8, n9 * 2);
                        OS.g_free(n8);
                        this.fullPath = new String(cArray);
                        this.fileNames[n4++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                n3 = OS.g_slist_next(n3);
                ++n5;
            }
            if (n4 != 0 && n4 != n2) {
                String[] stringArray = new String[n4];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n4);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(n);
        } else {
            n = OS.gtk_file_chooser_get_filename(this.handle);
            if (n != 0) {
                int n10 = OS.g_filename_to_utf8(n, -1, null, null, null);
                OS.g_free(n);
                if (n10 != 0) {
                    int[] nArray = new int[1];
                    int n11 = OS.g_utf8_to_utf16(n10, -1, null, nArray, null);
                    OS.g_free(n10);
                    if (n11 != 0) {
                        int n12 = nArray[0];
                        char[] cArray = new char[n12];
                        OS.memmove(cArray, n11, n12 * 2);
                        OS.g_free(n11);
                        this.fullPath = new String(cArray);
                        this.fileNames = new String[1];
                        this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
            }
        }
        if (this.fullPath != null) {
            n = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n + 1);
            this.filterPath = this.fullPath.substring(0, n);
        }
        return this.fullPath;
    }

    String computeResultClassicDialog() {
        int n;
        int n2;
        int[] nArray;
        int n3;
        int n4;
        GtkFileSelection gtkFileSelection = new GtkFileSelection();
        OS.memmove(gtkFileSelection, this.handle);
        int n5 = gtkFileSelection.selection_entry;
        int n6 = OS.gtk_entry_get_text(n5);
        int n7 = OS.strlen(n6);
        if (n7 == 0) {
            n4 = gtkFileSelection.file_list;
            n3 = OS.gtk_tree_view_get_selection(n4);
            n2 = OS.gtk_tree_selection_get_selected_rows(n3, nArray = new int[1]);
            if (n2 == 0) {
                return null;
            }
            int n8 = OS.g_list_length(n2);
            if (n8 == 0) {
                OS.g_list_free(n2);
                return null;
            }
            int n9 = OS.g_list_nth_data(n2, 0);
            int[] nArray2 = new int[1];
            int n10 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(nArray[0], n10, n9)) {
                OS.gtk_tree_model_get(nArray[0], n10, 0, nArray2, -1);
            }
            OS.g_free(n10);
            n = 0;
            while (n < n8) {
                OS.gtk_tree_path_free(OS.g_list_nth_data(n2, n));
                ++n;
            }
            OS.g_list_free(n2);
            if (nArray2[0] == 0) {
                return null;
            }
            n = OS.strlen(nArray2[0]);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, nArray2[0], n);
            OS.g_free(nArray2[0]);
            OS.gtk_entry_set_text(n5, byArray);
        }
        n4 = OS.gtk_file_selection_get_filename(this.handle);
        n3 = OS.g_filename_to_utf8(n4, -1, null, null, null);
        nArray = new int[1];
        n2 = OS.g_utf8_to_utf16(n3, -1, null, nArray, null);
        n7 = nArray[0];
        char[] cArray = new char[n7];
        OS.memmove(cArray, n2, n7 * 2);
        String string = new String(cArray);
        OS.g_free(n2);
        OS.g_free(n3);
        if (string == null) {
            return null;
        }
        int n11 = string.lastIndexOf(SEPARATOR);
        if (n11 + 1 == string.length()) {
            return null;
        }
        String string2 = this.fullPath = string;
        this.fileName = this.fullPath.substring(n11 + 1);
        this.filterPath = this.fullPath.substring(0, n11);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            int n12 = n = OS.gtk_file_selection_get_selections(this.handle);
            int[] nArray3 = new int[1];
            OS.memmove(nArray3, n12, OS.PTR_SIZEOF);
            int n13 = 0;
            while (nArray3[0] != 0) {
                ++n13;
                OS.memmove(nArray3, n12 += OS.PTR_SIZEOF, OS.PTR_SIZEOF);
            }
            this.fileNames = new String[n13];
            nArray3 = new int[n13];
            OS.memmove(nArray3, n, n13 * OS.PTR_SIZEOF);
            int n14 = 0;
            while (n14 < n13) {
                n3 = OS.g_filename_to_utf8(nArray3[n14], -1, null, null, null);
                nArray = new int[1];
                n2 = OS.g_utf8_to_utf16(n3, -1, null, nArray, null);
                cArray = new char[nArray[0]];
                OS.memmove(cArray, n2, nArray[0] * 2);
                String string3 = new String(cArray);
                this.fileNames[n14] = string3.substring(string3.lastIndexOf(SEPARATOR) + 1);
                OS.g_free(n2);
                OS.g_free(n3);
                ++n14;
            }
            OS.g_strfreev(n);
        }
        return string2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        boolean bl;
        boolean bl2 = bl = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (bl) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        int n2 = this.parent.topHandle();
        this.handle = OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0);
        int n3 = OS.gtk_window_get_icon_list(n2);
        if (n3 != 0) {
            OS.gtk_window_set_icon_list(this.handle, n3);
            OS.g_list_free(n3);
        }
        this.presetChooserDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String string = null;
        if (OS.gtk_dialog_run(this.handle) == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    String openClassicDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new(byArray);
        if (this.parent != null) {
            int n = this.parent.topHandle();
            OS.gtk_window_set_transient_for(this.handle, n);
            int n2 = OS.gtk_window_get_icon_list(n);
            if (n2 != 0) {
                OS.gtk_window_set_icon_list(this.handle, n2);
                OS.g_list_free(n2);
            }
        }
        this.presetClassicDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String string = null;
        if (OS.gtk_dialog_run(this.handle) == -5) {
            string = this.computeResultClassicDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        int n;
        int n2;
        Object object;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if (this.filterPath.length() > 0) {
            object = new StringBuffer();
            if (this.filterPath.charAt(0) != SEPARATOR) {
                ((StringBuffer)object).append(SEPARATOR);
            }
            ((StringBuffer)object).append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                ((StringBuffer)object).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuffer)object).append(this.fileName);
            } else {
                ((StringBuffer)object).append('.');
            }
            byte[] byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
            n2 = OS.realpath(byArray, null);
            if (n2 != 0) {
                OS.gtk_file_chooser_set_filename(this.handle, n2);
                OS.g_free(n2);
            }
        } else if (this.fileName.length() > 0 && this.fileName.charAt(0) == SEPARATOR && (n = OS.realpath((byte[])(object = (Object)Converter.wcsToMbcs(null, this.fileName, true)), null)) != 0) {
            OS.gtk_file_chooser_set_filename(this.handle, n);
            OS.g_free(n);
        }
        if ((this.style & 0x2000) != 0 && this.fileName.length() > 0) {
            object = Converter.wcsToMbcs(null, this.fileName, true);
            OS.gtk_file_chooser_set_current_name(this.handle, (byte[])object);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int n3 = 0;
        while (n3 < this.filterExtensions.length) {
            if (this.filterExtensions[n3] != null) {
                byte[] byArray;
                String string;
                byte[] byArray2;
                int n4 = OS.gtk_file_filter_new();
                if (this.filterNames.length > n3 && this.filterNames[n3] != null) {
                    byArray2 = Converter.wcsToMbcs(null, this.filterNames[n3], true);
                    OS.gtk_file_filter_set_name(n4, byArray2);
                } else {
                    byArray2 = Converter.wcsToMbcs(null, this.filterExtensions[n3], true);
                    OS.gtk_file_filter_set_name(n4, byArray2);
                }
                n2 = 0;
                int n5 = this.filterExtensions[n3].indexOf(59);
                while (n5 != -1) {
                    string = this.filterExtensions[n3].substring(n2, n5);
                    byArray = Converter.wcsToMbcs(null, string, true);
                    OS.gtk_file_filter_add_pattern(n4, byArray);
                    n2 = n5 + 1;
                    n5 = this.filterExtensions[n3].indexOf(59, n2);
                }
                string = this.filterExtensions[n3].substring(n2);
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_file_filter_add_pattern(n4, byArray);
                OS.gtk_file_chooser_add_filter(this.handle, n4);
            }
            ++n3;
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    void presetClassicDialog() {
        OS.gtk_file_selection_set_select_multiple(this.handle, (this.style & 2) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int n = this.fullPath.length();
        char[] cArray = new char[n + 1];
        this.fullPath.getChars(0, n, cArray, 0);
        int n2 = OS.g_utf16_to_utf8(cArray, -1, null, null, null);
        int n3 = OS.g_filename_from_utf8(n2, -1, null, null, null);
        OS.gtk_file_selection_set_filename(this.handle, n3);
        OS.g_free(n2);
        OS.g_free(n3);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

