/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.authDev;

import com.novell.emframe.dev.eMFrameUtils;
import java.util.HashMap;
import java.util.Locale;

public class ConnectionProfile {
    public static final String ROOTNAME = "RootName";
    public static final String HOSTURI = "HostURI";
    public static final String UNIQUE_HOST_ID = "UniqueHostName";
    protected HashMap m_hmSettingsByName = new HashMap();
    protected String m_sResourceFile = null;
    protected Locale m_locale = null;
    protected String m_sResourceIdPrefix = "ConnectionProfile.";
    protected String m_sDecriptionIdPostFix = ".Desc";

    public ConnectionProfile(String resourceFile, Locale locale) {
        this.m_sResourceFile = resourceFile;
        this.m_locale = locale;
    }

    public String[] getSettingIds() {
        return this.m_hmSettingsByName.keySet().toArray(new String[this.m_hmSettingsByName.size()]);
    }

    public Object getSetting(String settingId) {
        return this.m_hmSettingsByName.get(settingId);
    }

    public Object setSetting(String Id, Object value) {
        return this.m_hmSettingsByName.put(Id, value);
    }

    public String getSettingLable(String Id) {
        return eMFrameUtils.getLocalizedString(this.m_sResourceFile, this.m_sResourceIdPrefix + Id, this.m_locale);
    }

    public String getSettingDescription(String Id) {
        return eMFrameUtils.getLocalizedString(this.m_sResourceFile, this.m_sResourceIdPrefix + Id + this.m_sDecriptionIdPostFix, this.m_locale);
    }

    public String getUniqueHostId() {
        return (String)this.getSetting(UNIQUE_HOST_ID);
    }

    public String getUniqueHostIdLabel() {
        return this.getSettingLable(UNIQUE_HOST_ID);
    }

    public String getUniqueHostIdDecription() {
        return this.getSettingDescription(UNIQUE_HOST_ID);
    }

    public String getHostURI() {
        return (String)this.getSetting(HOSTURI);
    }

    public String getHostURILabel() {
        return this.getSettingLable(UNIQUE_HOST_ID);
    }

    public String getHostURIDecription() {
        return this.getSettingDescription(UNIQUE_HOST_ID);
    }

    public String getRootName() {
        return (String)this.getSetting(ROOTNAME);
    }

    public String getRootNameLabel() {
        return this.getSettingLable(UNIQUE_HOST_ID);
    }

    public String getRootNameDecription() {
        return this.getSettingDescription(UNIQUE_HOST_ID);
    }
}

