/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.authDev;

import com.novell.emframe.dev.authenticator.InvalidAuthMethodException;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.HashMap;
import java.util.Locale;

public class MCredentials {
    public static final String PASSWORD = "password";
    public static final String DISPLAYNAME = "DisplayName";
    public static final String ID = "Id";
    public static final String FULLID = "FullId";
    protected HashMap m_hmSettingsByName = new HashMap();
    protected String m_sResourceFile = null;
    protected String m_sResourceIdPrefix = "ConnectionProfile.";
    protected String m_sDecriptionIdSuffix = ".Desc";
    protected Locale m_locale = null;

    public MCredentials(String resourceFile, Locale locale) {
        this.m_sResourceFile = resourceFile;
        this.m_locale = locale;
    }

    public String[] getSettingIds() {
        return this.m_hmSettingsByName.keySet().toArray(new String[this.m_hmSettingsByName.size()]);
    }

    public Object getSetting(String settingId) {
        return this.m_hmSettingsByName.get(settingId);
    }

    public Object setSetting(String settingId, Object value) {
        return this.m_hmSettingsByName.put(settingId, value);
    }

    public String getSettingLabel(String settingId) {
        return eMFrameUtils.getLocalizedString(this.m_sResourceFile, this.m_sResourceIdPrefix + settingId, this.m_locale);
    }

    public String getSettingDescription(String settingId) {
        return eMFrameUtils.getLocalizedString(this.m_sResourceFile, this.m_sResourceIdPrefix + settingId + this.m_sDecriptionIdSuffix, this.m_locale);
    }

    public String getFullId() {
        return (String)this.getSetting(FULLID);
    }

    public String getFullIdLabel() {
        return this.getSettingLabel(FULLID);
    }

    public String getFullIdDescription() {
        return this.getSettingDescription(FULLID);
    }

    public String getId() {
        return (String)this.getSetting(ID);
    }

    public String getIdLabel() {
        return this.getSettingLabel(ID);
    }

    public String getIdDescription() {
        return this.getSettingDescription(ID);
    }

    public String getDisplayName() {
        return (String)this.getSetting(DISPLAYNAME);
    }

    public String getDisplayNameLabel() {
        return this.getSettingLabel(DISPLAYNAME);
    }

    public String getDisplayNameDescription() {
        return this.getSettingDescription(DISPLAYNAME);
    }

    public String getAuthMethodId() {
        return PASSWORD;
    }

    public String getPassword() throws InvalidAuthMethodException {
        if (this.getAuthMethodId() != PASSWORD) {
            throw new InvalidAuthMethodException(eMFrameUtils.getLocalizedString("FwResources", "INVALID_AUTH_METHOD", this.m_locale), eMFrameUtils.getLocalizedString("FwResouces", "INVALID_AUTH_METHOD__PASSWORD_NOT_SUPPORTED", this.m_locale));
        }
        return (String)this.getSetting(PASSWORD);
    }
}

