/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.debug;

import com.novell.emframe.dev.AsyncContext;
import com.novell.emframe.dev.AsyncWorker;
import com.novell.emframe.dev.D;

public class AsyncWorkerTest
extends AsyncWorker {
    int items;
    boolean makeErrors;
    int errorRate;
    int currentItemNumber;
    private boolean interrupted;

    public AsyncWorkerTest(int items, int errorRate) {
        this.items = items;
        this.errorRate = errorRate;
    }

    public void run(AsyncContext context) {
        this.currentItemNumber = 0;
        while (!this.interrupted && this.currentItemNumber < this.items) {
            context.addStatusMsg("added item: " + this.currentItemNumber);
            this.generateError(context);
            try {
                D.log("processing item: " + this.currentItemNumber);
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                D.log(e);
                context.addErrorMsg("Interupted by user");
            }
            ++this.currentItemNumber;
        }
        if (this.interrupted) {
            context.addStatusMsg("Stopped");
        }
    }

    public void onInterrupt(AsyncContext context) {
        context.addStatusMsg("Stopping....");
        this.interrupted = true;
    }

    private void generateError(AsyncContext context) {
        if (Math.random() * 100.0 < (double)this.errorRate) {
            context.addErrorMsg("Error adding item: " + this.currentItemNumber);
        }
    }
}

