/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.AsyncContext;
import com.novell.emframe.dev.AsyncWorker;
import com.novell.emframe.dev.Countable;
import com.novell.emframe.fw.AsyncProgressFormat;
import com.novell.emframe.fw.util.FwAsyncUtils;
import java.util.Collection;
import java.util.Iterator;

public abstract class BasicCollectionAsyncWorker
extends AsyncWorker
implements Countable {
    Collection collection;
    boolean interrupted;
    int currentElementIndex;

    public BasicCollectionAsyncWorker(Collection collection) {
        this.collection = collection;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public int getCurrentElementIndex() {
        return this.currentElementIndex;
    }

    public void run(AsyncContext context) {
        this.currentElementIndex = 0;
        Iterator iter = this.collection.iterator();
        while (!this.interrupted && iter.hasNext()) {
            Object element = iter.next();
            this.process(element, context);
            ++this.currentElementIndex;
        }
        if (this.interrupted) {
            AsyncProgressFormat format = FwAsyncUtils.getProgressFormat(context);
            context.addStatusMsg("<B>" + format.getInterruptedMsg() + "</B>");
        }
    }

    protected abstract void process(Object var1, AsyncContext var2);

    public int getTotalCount(AsyncContext context) {
        return this.collection.size();
    }

    public int getCompletedCount(AsyncContext context) {
        return this.getCurrentElementIndex();
    }

    public void onInterrupt(AsyncContext context) {
        this.setInterrupted(true);
    }
}

