/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Hashtable;

public class Chapter {
    protected String m_id = null;
    protected String m_resourceBundle = null;
    protected String m_displayNameResourceKey = null;
    protected String m_displayName = null;
    protected String m_name = null;
    protected static Hashtable m_chapters = new Hashtable();

    public String getName(TaskContext context) {
        String name = eMFrameUtils.getLocalizedString(this.m_resourceBundle, this.m_displayNameResourceKey, context);
        if (name == null || name.length() == 0) {
            this.m_name = this.m_displayNameResourceKey == null || this.m_displayNameResourceKey.length() == 0 ? (name = eMFrameUtils.getLocalizedString("FwResources", "UnNamedChapterDisplayName", context)) : (name = this.m_displayNameResourceKey);
        }
        this.m_name = name;
        return name;
    }

    public String getName() {
        return this.m_name;
    }

    public static String getName(String strChapterId, TaskContext context) {
        Chapter c = (Chapter)m_chapters.get(strChapterId);
        return c.getName(context);
    }

    public String getId() {
        return this.m_id;
    }

    public String getResourcePropertiesFile() {
        return this.m_resourceBundle;
    }

    public String getDisplayNameKey() {
        return this.m_displayNameResourceKey;
    }

    public static Chapter createChapter(String id, String resourceBundleFile, String displayNameResourceKey) {
        Chapter chapter = (Chapter)m_chapters.get(id);
        if (chapter == null) {
            chapter = new Chapter(id, resourceBundleFile, displayNameResourceKey);
            Chapter.addToRegistry(chapter);
        }
        return chapter;
    }

    private static void addToRegistry(Chapter c) {
        m_chapters.put(c.getId(), c);
    }

    private Chapter(String id, String resourceBundleFile, String displayNameResourceKey) {
        this.m_id = id;
        this.m_resourceBundle = resourceBundleFile;
        this.m_displayNameResourceKey = displayNameResourceKey;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Chapter) {
            return this.m_id.equals(((Chapter)obj).m_id);
        }
        return false;
    }
}

