/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DebugLogging;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.debug.DebugLogEvent;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventManager;
import org.jdom.Document;

public class D {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;

    public static final void assrt(boolean conditional, String message) {
        if (FwUtils.showDeveloperWarnings() && D.isDebugEnabled(1) && !conditional) {
            D.log("################ Assertion Failure #################", 1);
            D.log("################ Message: " + message + " #################", 1);
            D.log(new Exception("Assertion Failure"));
        }
    }

    public static boolean isDebugEnabled(int iLevel) {
        return DebugLogging.isLoggable(iLevel);
    }

    public static boolean isDebugEnabled() {
        return D.isDebugEnabled(3);
    }

    public static void log(String sString) {
        D.log(sString, 3);
    }

    public static void log(String sString, int iLevel) {
        if (D.isDebugEnabled(iLevel)) {
            PortalEventManager.postEvent((PortalEvent)new DebugLogEvent(iLevel, D.getPrefix(0), sString, null));
        }
    }

    public static void log(String sString, int iLevel, int callSiteRewindCount) {
        if (D.isDebugEnabled(iLevel)) {
            PortalEventManager.postEvent((PortalEvent)new DebugLogEvent(iLevel, D.getPrefix(callSiteRewindCount), sString, null));
        }
    }

    public static void log(Throwable e) {
        D.log(e, 1, 3);
    }

    public static void log(Throwable e, int msgLevel, int stackTraceLevel) {
        if (D.isDebugEnabled(msgLevel) || D.isDebugEnabled(stackTraceLevel)) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
            e = eMFrameUtils.discoverRootException(e);
            while (e.getCause() != null) {
                e = e.getCause();
            }
            String pref = D.getPrefix(0);
            PortalEventManager.postEvent((PortalEvent)new DebugLogEvent(msgLevel, pref, msg, null));
            PortalEventManager.postEvent((PortalEvent)new DebugLogEvent(stackTraceLevel, pref, null, e));
        }
    }

    public static final void log(Document doc) {
        D.log(doc, 3);
    }

    public static final void log(Document doc, int level) {
        if (doc != null && D.isDebugEnabled(level)) {
            D.log(FwUtils.getDocStr(doc));
        }
    }

    public static final void log(org.w3c.dom.Document doc) {
        D.log(doc, 3);
    }

    public static final void log(org.w3c.dom.Document doc, int level) {
        if (doc != null && D.isDebugEnabled(level)) {
            D.log(FwUtils.getDocStr(doc));
        }
    }

    private static String getPrefix(int callSiteRewindCount) {
        StackTraceElement stack = D.findCallSite(callSiteRewindCount);
        String className = stack.getClassName();
        String prefix = className.substring(className.lastIndexOf(".") + 1);
        prefix = prefix + ".......................";
        prefix = prefix.substring(0, 18);
        int lineNumber = stack.getLineNumber();
        if (lineNumber < 10) {
            prefix = prefix + "...";
        } else if (lineNumber < 100) {
            prefix = prefix + "..";
        } else if (lineNumber < 1000) {
            prefix = prefix + ".";
        }
        return prefix + "." + lineNumber + " ";
    }

    private static StackTraceElement findCallSite(int callSiteRewindCount) {
        Exception e = new Exception();
        StackTraceElement[] stacks = e.getStackTrace();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i].getClassName().equals("com.novell.emframe.dev.D")) continue;
            if (callSiteRewindCount > 0) {
                i = Math.min(i + callSiteRewindCount, stacks.length - 1);
            }
            return stacks[i];
        }
        return null;
    }

    public static boolean getLoggingToFile() {
        return DebugLogging.getLoggingToFile();
    }

    public static void setLoggingToFile(boolean bSet) {
        DebugLogging.setLoggingToFile(bSet);
    }

    public static boolean getLoggingToErr() {
        return DebugLogging.getLoggingToErr();
    }

    public static void setLoggingToErr(boolean bSet) {
        DebugLogging.setLoggingToErr(bSet);
    }

    public static boolean getLoggingToOut() {
        return DebugLogging.getLoggingToOut();
    }

    public static void setLoggingToOut(boolean bSet) {
        DebugLogging.setLoggingToOut(bSet);
    }

    public static int getLoggingLevel() {
        return DebugLogging.getLoggingLevel();
    }

    public static void setLoggingLevel(int iLevel) {
        DebugLogging.setLoggingLevel(iLevel);
    }

    public static String getLogFileName() {
        return DebugLogging.getLogFileName();
    }

    public static long getLogFileSize() {
        return DebugLogging.getLogFileSize();
    }
}

