/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.PartitionService;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.CountableObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandler;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.authenticator.AuthNotAuthenticatedException;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AttributeNamer;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Target;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.util.Loader;
import com.novell.security.nmas.mgmt.NMASLoginDataException;
import com.novell.security.nmas.mgmt.NMASSimplePwdMgr;
import java.beans.PropertyVetoException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.jdom.Document;
import org.jdom.Element;

public class DirUtils {
    final char REPLACE_CHAR = (char)95;
    protected DirAuthenticator m_dirAuth;
    protected AdminNamespace m_ns;
    protected ObjectEntry treeOE;
    SchemaDefinition m_schemaDef;
    String[] sortedClassArray = null;
    String[] sortedAttrArray = null;
    String[] classArray = null;
    String[] attrArray = null;
    Map realNamesMap;
    Map superClassMap;
    Map subClassMap;
    MappingObject ldapMappingObject;
    String[] containerTypes;
    String[] m_saOSSelectableContainerTypes;
    HashSet m_hsOSSelectableContainerTypes;
    String[] m_saOSSelectableLeafTypes;
    HashSet m_hsOSSelectableLeafTypes;
    String[] m_saOSSelectableTypes;
    HashSet m_hsOSSelectableTypes;
    Hashtable containerTypesHash;
    HashSet m_hsAuxClassSet;
    String[] sortedAttrDisplayNamesArray = null;
    Hashtable okTypeNames = new Hashtable();
    private static final int UP_FLAG_ON = 256;

    public static AdminNamespace getAdminNamespace(MContext context) {
        return context.getDirUtils().m_ns;
    }

    void populateContainerTypes() {
        Vector<String> v = new Vector<String>();
        ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].isContainer() || !classes[i].isEffective()) continue;
            String className = classes[i].getName();
            v.addElement(className);
            this.containerTypesHash.put(className.toLowerCase(), className);
        }
        this.containerTypes = new String[v.size()];
        v.copyInto(this.containerTypes);
    }

    public String[] getContainerTypes() {
        if (this.containerTypes == null) {
            this.populateContainerTypes();
        }
        return this.containerTypes;
    }

    public String[] getSelectableContainerTypes() {
        return this.getSelectableContainerTypes(null);
    }

    public String[] getSelectableContainerTypes(HashSet excludeTypes) {
        if (this.m_saOSSelectableContainerTypes == null) {
            Vector<String> v = new Vector<String>();
            ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
            for (int i = 0; i < classes.length; ++i) {
                String className;
                if (!classes[i].isContainer() || !classes[i].isEffective() || (className = classes[i].getName()).equalsIgnoreCase("Top")) continue;
                v.addElement(className);
            }
            Collections.sort(v);
            this.m_saOSSelectableContainerTypes = new String[v.size()];
            v.copyInto(this.m_saOSSelectableContainerTypes);
            this.m_hsOSSelectableContainerTypes = new HashSet(v);
        }
        return this.removeDups(this.m_hsOSSelectableContainerTypes, excludeTypes, this.m_saOSSelectableContainerTypes);
    }

    public String[] getSelectableLeafTypes() {
        return this.getSelectableLeafTypes(null);
    }

    public String[] getSelectableLeafTypes(HashSet excludeTypes) {
        if (this.m_saOSSelectableLeafTypes == null) {
            Vector<String> v = new Vector<String>();
            ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
            for (int i = 0; i < classes.length; ++i) {
                String className;
                if (classes[i].isContainer() || !classes[i].isEffective() || (className = classes[i].getName()).equalsIgnoreCase("Top")) continue;
                v.addElement(className);
            }
            Collections.sort(v);
            this.m_saOSSelectableLeafTypes = new String[v.size()];
            v.copyInto(this.m_saOSSelectableLeafTypes);
            this.m_hsOSSelectableLeafTypes = new HashSet(v);
        }
        return this.removeDups(this.m_hsOSSelectableLeafTypes, excludeTypes, this.m_saOSSelectableLeafTypes);
    }

    public String[] getSelectableTypes() {
        return this.getSelectableTypes(null);
    }

    public String[] getSelectableTypes(HashSet excludeTypes) {
        if (this.m_saOSSelectableTypes == null) {
            Vector<String> v = new Vector<String>();
            ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
            for (int i = 0; i < classes.length; ++i) {
                String className;
                if (!classes[i].isEffective() || (className = classes[i].getName()).equalsIgnoreCase("Top")) continue;
                v.addElement(className);
            }
            Collections.sort(v);
            this.m_saOSSelectableTypes = new String[v.size()];
            v.copyInto(this.m_saOSSelectableTypes);
            this.m_hsOSSelectableTypes = new HashSet(v);
        }
        return this.removeDups(this.m_hsOSSelectableTypes, excludeTypes, this.m_saOSSelectableTypes);
    }

    private String[] removeDups(HashSet hsTypes, HashSet hsDups, String[] origTypes) {
        HashSet tmp;
        boolean changed;
        Object[] noDups = origTypes;
        if (hsTypes != null && hsDups != null && !hsDups.isEmpty() && (changed = (tmp = (HashSet)hsTypes.clone()).removeAll(hsDups))) {
            Vector v = new Vector(tmp);
            Collections.sort(v);
            noDups = new String[v.size()];
            v.copyInto(noDups);
        }
        return noDups;
    }

    public boolean isContainer(String objectType) {
        if (this.containerTypes == null) {
            this.populateContainerTypes();
        }
        return this.containerTypesHash.get(objectType.toLowerCase()) != null;
    }

    public String getObjectTypeDisplayName(String objectTypeName, MContext context) {
        String resourceFile = FwDirUtils.getObjectTypeResourceFile(objectTypeName);
        String okName = this.getSafeName(objectTypeName);
        String otn = "ObjectType." + okName;
        String translatedString = AttributeNamer.getCustomResourcesValue(otn, context);
        if (translatedString != null) {
            return translatedString;
        }
        if (resourceFile == null) {
            resourceFile = "FwResources";
        }
        translatedString = eMFrameUtils.getLocalizedString(resourceFile, otn, objectTypeName, context);
        return translatedString;
    }

    public String getAttributeDisplayName(String attributeName, MContext context) {
        String key = "Attribute." + this.getSafeName(attributeName);
        String translatedString = AttributeNamer.getCustomResourcesValue(key, context);
        if (translatedString != null) {
            return translatedString;
        }
        return FwUtils.getAttributeDisplayName(attributeName, context.getLocale(), attributeName);
    }

    public String getObjectEntryImageName(ObjectEntry oe) {
        String typeName = oe.getObjectType().getName();
        return this.getObjectTypeImageName(typeName);
    }

    public String getObjectTypeImageName(String typeName) {
        String imageName = this.getSafeName(typeName);
        imageName = imageName + ".gif";
        if ((imageName = FwDirUtils.getAvailableImagePath(imageName.toLowerCase())) == null) {
            try {
                String parentImage;
                String parentObjectClass;
                ObjectType[] parentTypes;
                ObjectEntry treeOE = (ObjectEntry)this.m_dirAuth.getAuthenticationBroker().getProtocolObject("AdminNamespace");
                ObjectType objectType = this.m_ns.getObjectType(treeOE, typeName);
                if (objectType != null && (parentTypes = objectType.getParentTypes()) != null && parentTypes.length > 0 && (parentObjectClass = parentTypes[0].getName()) != null && !parentObjectClass.equalsIgnoreCase("Top") && (parentImage = this.getObjectTypeImageName(parentObjectClass)) != null) {
                    return parentImage;
                }
            }
            catch (Exception e) {
                D.log(e);
            }
            imageName = "UnknownDSObject.gif";
        }
        return imageName;
    }

    public String getSafeName(String typeName) {
        D.assrt(typeName != null, "typeName==null");
        if (typeName == null) {
            return null;
        }
        String okName = (String)this.okTypeNames.get(typeName);
        if (okName != null) {
            return okName;
        }
        okName = FwUtils.getSafeName(typeName);
        this.okTypeNames.put(typeName, okName);
        return okName;
    }

    public static final String readAttributeXML(MContext context, Object theObj, String attrName) throws eDirAccessServiceException {
        boolean isRefreshing = false;
        if (context.getRequest().getAttribute("isRefresh") != null) {
            isRefreshing = context.getRequest().getAttribute("isRefresh").equals("true");
        }
        if (!(theObj instanceof MOOManager)) {
            ObjectAttribute oa = null;
            if (!isRefreshing) {
                oa = ((NSObject)theObj).getAttribute(attrName);
            } else {
                ObjectEntry treeOE = null;
                try {
                    treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
                }
                catch (AuthBrokerException e) {
                    e.printStackTrace();
                }
                AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
                try {
                    TargetObjects targetObjects = (TargetObjects)context.getRequest().getAttribute("targetObjects");
                    oa = ns.getAttribute(targetObjects.getObjectEntry(), attrName);
                }
                catch (SPIException e) {
                    e.printStackTrace();
                }
            }
            if (oa == null) {
                return "";
            }
        }
        DataHandler theHandler = Loader.getAttributeHandler(attrName, true);
        if (theHandler == null) {
            String syntaxName = null;
            if (theObj instanceof MOOManager) {
                ObjectOperation oo = ((MOOManager)theObj).getObjectOperation(attrName);
                if (oo == null || isRefreshing) {
                    TargetObjects targetObjs = (TargetObjects)context.getRequest().getAttribute("targetObjects");
                    oo = DirUtils.createObjectOperationforMOO(context, theObj, targetObjs, attrName);
                    if (oo != null) {
                        ((MOOManager)theObj).addObjectOperation(oo);
                    } else {
                        return "";
                    }
                }
                syntaxName = oo.getAttributeDefinition().getSyntax().getName();
            } else {
                ObjectAttribute oa = null;
                if (!isRefreshing) {
                    oa = ((NSObject)theObj).getAttribute(attrName);
                    syntaxName = oa.getAttributeDefinition().getSyntax().getName();
                } else {
                    ObjectEntry treeOE = null;
                    try {
                        treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
                    }
                    catch (AuthBrokerException e) {
                        e.printStackTrace();
                    }
                    AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
                    try {
                        TargetObjects targetObjects = (TargetObjects)context.getRequest().getAttribute("targetObjects");
                        oa = ns.getAttribute(targetObjects.getObjectEntry(), attrName);
                        syntaxName = oa.getAttributeDefinition().getSyntax().getName();
                    }
                    catch (SPIException e) {
                        e.printStackTrace();
                    }
                }
            }
            theHandler = Loader.getSyntaxHandler(syntaxName, true);
        }
        if (theHandler == null) {
            D.log("DataHandler for " + attrName + " not found.");
            throw new eDirAccessServiceException("DefaultSyntaxHandler Missing", "DataHandler is not available");
        }
        return theHandler.getString(theObj, attrName, context);
    }

    private static ObjectOperation createObjectOperationforMOO(MContext context, Object theObj, TargetObjects targetObjs, String attrName) {
        ObjectEntry oe = null;
        ObjectAttribute objAttr = null;
        ObjectOperation objOp = null;
        try {
            if (theObj instanceof MOOManager) {
                oe = ((MOOManager)theObj).getTreeObjectEntry();
            }
            AdminNamespace ns = oe.getAdminNamespace();
            AttributeDefinition ad = ns.getAttributeDefinition(oe, attrName);
            objAttr = new ObjectAttribute(ad);
            ArrayList finalValues = DirUtils.getCommonValues(context, theObj, targetObjs, attrName);
            if (finalValues == null) {
                return null;
            }
            Object[] obj = finalValues.toArray();
            Arrays.sort(obj, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return arg0.toString().compareToIgnoreCase(arg1.toString());
                }
            });
            for (int i = 0; i < obj.length; ++i) {
                objAttr.addComponent((ValueComponent)obj[i]);
            }
            objOp = new ObjectOperation(objAttr, 5);
            return objOp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList getCommonValues(MContext context, Object theObj, TargetObjects targetObjs, String attrName) {
        ObjectEntry oe = null;
        ArrayList<ValueComponent> targetValues = new ArrayList<ValueComponent>();
        ArrayList<ValueComponent> finalValues = new ArrayList<ValueComponent>();
        if (targetObjs == null || targetObjs.getCount() == 0) {
            return null;
        }
        if (theObj instanceof MOOManager) {
            oe = ((MOOManager)theObj).getTreeObjectEntry();
        }
        try {
            AdminNamespace ns = oe.getAdminNamespace();
            AttributeDefinition ad = ns.getAttributeDefinition(oe, attrName);
            ObjectEntry[] targets = targetObjs.getOEArray();
            ObjectAttribute attrib = null;
            for (int i = 0; i < targets.length; ++i) {
                targetValues.clear();
                ObjectEntry objOe = targets[i];
                attrib = ns.getAttribute(objOe, attrName);
                if (attrib != null) {
                    Enumeration myenum = attrib.getValueComponents();
                    while (myenum.hasMoreElements()) {
                        ValueComponent vc = (ValueComponent)myenum.nextElement();
                        targetValues.add(vc);
                    }
                    if (i == 0) {
                        finalValues.addAll(targetValues);
                        continue;
                    }
                    finalValues.retainAll(targetValues);
                    continue;
                }
                finalValues.clear();
                return null;
            }
            return finalValues;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList getAllValues(MContext context, Object theObj, TargetObjects targetObjs, String attrName) {
        ObjectEntry oe = null;
        ArrayList<ValueComponent> finalValues = new ArrayList<ValueComponent>();
        if (targetObjs == null || targetObjs.getCount() == 0) {
            return null;
        }
        if (theObj instanceof MOOManager) {
            oe = ((MOOManager)theObj).getTreeObjectEntry();
        }
        try {
            AdminNamespace ns = oe.getAdminNamespace();
            ObjectEntry[] targets = targetObjs.getOEArray();
            ObjectAttribute attrib = null;
            for (int i = 0; i < targets.length; ++i) {
                ObjectEntry objOe = targets[i];
                attrib = ns.getAttribute(objOe, attrName);
                if (attrib == null) continue;
                Enumeration myenum = attrib.getValueComponents();
                while (myenum.hasMoreElements()) {
                    ValueComponent vc = (ValueComponent)myenum.nextElement();
                    if (finalValues.contains(vc)) continue;
                    finalValues.add(vc);
                }
            }
            return finalValues;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeAttributeXML(MContext context, Object theObj, String attrName, String value) throws eDirAccessServiceException {
        String syntaxName = null;
        ObjectEntry oe = null;
        oe = theObj instanceof MOOManager ? ((MOOManager)theObj).getTreeObjectEntry() : ((NSObject)theObj).getObjectEntry();
        try {
            AdminNamespace ns = oe.getAdminNamespace();
            AttributeDefinition ad = ns.getAttributeDefinition(oe, attrName);
            syntaxName = ad.getSyntax().getName();
        }
        catch (SPIException e) {
            throw new eDirAccessServiceException("eDir Access Service Error", "Attribute " + attrName + " not found in the schema.");
        }
        catch (NamespaceException e) {
            throw new eDirAccessServiceException("eDir Access Service Error", "Attribute " + attrName + " not found in the schema.");
        }
        catch (Exception e) {
            throw new eDirAccessServiceException("eDir Access Service Error", "Attribute " + attrName + " not found in the schema.");
        }
        DataHandler theHandler = DirUtils.getHandler(attrName, syntaxName, true);
        if (theHandler == null) {
            throw new eDirAccessServiceException("eDir Access Service Error", "Couldn't find a Attribute or Syntax handler for " + attrName);
        }
        theHandler.setString(theObj, attrName, value, context);
    }

    private static DataHandler getHandler(String attrName, String syntaxName, boolean cache) {
        DataHandler theHandler = Loader.getAttributeHandler(attrName, cache);
        if (theHandler == null) {
            theHandler = Loader.getSyntaxHandler(syntaxName, true);
        }
        return theHandler;
    }

    public void reReadSchema(ObjectEntry treeOE) {
        try {
            ((NDSSchemaDefinition)this.m_ns.getSchemaDefinition(treeOE)).refreshSchema();
        }
        catch (SPIException e) {
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public void reinitialize() {
        this.resetInternalSchemaCache();
    }

    public void resetInternalSchemaCache() {
        this.m_schemaDef = null;
        this.classArray = null;
        this.sortedClassArray = null;
        this.attrArray = null;
        this.sortedAttrArray = null;
        this.sortedAttrDisplayNamesArray = null;
        this.realNamesMap = new HashMap();
        this.superClassMap = new HashMap();
        this.subClassMap = new HashMap();
        this.ldapMappingObject = null;
        this.containerTypes = null;
        this.containerTypesHash = new Hashtable();
        this.m_hsAuxClassSet = new HashSet();
        try {
            this.m_schemaDef = this.m_ns.getSchemaDefinition(this.treeOE);
            ClassDefinition[] classes = this.m_schemaDef.getClassDefinitions();
            ArrayList<String> classList = new ArrayList<String>();
            for (int j = 0; j < classes.length; ++j) {
                String cname = classes[j].getName();
                if (cname.equals("[Anything]") || cname.equals("[Nothing]")) continue;
                classList.add(cname);
                if (!classes[j].isAuxiliary()) continue;
                this.m_hsAuxClassSet.add(cname);
            }
            this.classArray = classList.toArray(new String[classList.size()]);
            AttributeDefinition[] attrs = this.m_schemaDef.getAttributeDefinitions();
            ArrayList<String> attrList = new ArrayList<String>();
            for (int i = 0; i < attrs.length; ++i) {
                String aname = attrs[i].getName();
                if (aname.equals("[Anything]") || aname.equals("[Nothing]")) continue;
                attrList.add(aname);
            }
            this.attrArray = attrList.toArray(new String[0]);
        }
        catch (SPIException e) {
            D.log(e);
        }
        this.buildAttrNameTable();
        if (this.m_ns instanceof NDSNamespace) {
            this.createMappingObject((NDSNamespace)this.m_ns, this.treeOE);
        }
    }

    private String[] sortNames(String[] nameArray) {
        ArrayList<String> list = new ArrayList<String>(nameArray.length);
        for (int i = 0; i < nameArray.length; ++i) {
            list.add(nameArray[i]);
        }
        Locale locale = this.m_dirAuth.getLocale();
        Collator collator = Collator.getInstance(locale);
        Collections.sort(list, collator);
        return list.toArray(new String[list.size()]);
    }

    public String[] getSortedClasses() {
        if (this.sortedClassArray == null) {
            this.sortedClassArray = this.sortNames(this.classArray);
        }
        return this.sortedClassArray;
    }

    public String[] getSortedAttrs() {
        if (this.sortedAttrArray == null) {
            this.sortedAttrArray = this.sortNames(this.attrArray);
        }
        return this.sortedAttrArray;
    }

    public String[] getSortedAttributeDisplayNames(MContext context) {
        if (this.sortedAttrDisplayNamesArray == null) {
            String[] names = this.getSortedAttrs();
            this.sortedAttrDisplayNamesArray = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                this.sortedAttrDisplayNamesArray[i] = this.getAttributeDisplayName(names[i], context);
            }
        }
        return this.sortedAttrDisplayNamesArray;
    }

    public String[] getSuperClasses(String strName) throws NamespaceException {
        if (this.superClassMap.containsKey(strName)) {
            List list = (List)this.superClassMap.get(strName);
            return list.toArray(new String[0]);
        }
        Object[] superClasses = this.m_schemaDef.getSuperClasses(strName);
        if (superClasses.length > 0) {
            List cleanClasses = this.FindDup(superClasses);
            this.superClassMap.put(strName, cleanClasses);
            return cleanClasses.toArray(new String[0]);
        }
        return null;
    }

    public ArrayList getAllSubClasses(String[] superTypes) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < superTypes.length; ++i) {
            String[] directSubClasses;
            String superType = superTypes[i];
            if (!list.contains(superType)) {
                list.add(superType);
            }
            if ((directSubClasses = this.getSubClasses(superType)) == null) continue;
            for (int j = 0; j < directSubClasses.length; ++j) {
                String directSubClass = directSubClasses[j];
                ArrayList allSubTypes = this.getAllSubClasses(new String[]{directSubClass});
                list.addAll(allSubTypes);
            }
        }
        return list;
    }

    public String[] getSubClasses(String strName) {
        if (this.subClassMap.containsKey(strName)) {
            List l = (List)this.subClassMap.get(strName);
            return l.toArray(new String[0]);
        }
        Object[] subClasses = this.m_schemaDef.getSubClasses(strName);
        if (subClasses.length > 0) {
            List cleanClasses = this.FindDup(subClasses);
            this.subClassMap.put(strName, cleanClasses);
            return cleanClasses.toArray(new String[0]);
        }
        return null;
    }

    public String getRealName(String strSafeName) {
        return (String)this.realNamesMap.get(strSafeName);
    }

    public MappingObject getMappingObject() {
        return this.ldapMappingObject;
    }

    private void buildAttrNameTable() {
        for (int x = 0; x < this.attrArray.length; ++x) {
            String safeAttrName = this.getSafeName(this.attrArray[x]);
            this.realNamesMap.put(safeAttrName, this.attrArray[x]);
        }
        for (int z = 0; z < this.classArray.length; ++z) {
            String safeClassName = this.getSafeName(this.classArray[z]);
            this.realNamesMap.put(safeClassName, this.classArray[z]);
        }
    }

    private List FindDup(Object[] array) {
        LinkedList<String> tempList = new LinkedList<String>();
        tempList.add(array[0].toString());
        for (int i = 1; i < array.length; ++i) {
            tempList.remove(array[i].toString());
            tempList.add(array[i].toString());
        }
        return tempList;
    }

    public void addASXMLFilterInfoToRM(FilterResultModifier rm, String filterXML, MContext context) {
        String TYPES = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.types", context);
        String ID = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.id", context);
        try {
            StringReader r = new StringReader(filterXML);
            Document document = iManager.getSaxBuilder().build((Reader)r);
            Element root = document.getRootElement();
            Element type = root.getChild(TYPES);
            List typeNames = type.getChildren(ID);
            for (int i = 0; i < typeNames.size(); ++i) {
                String typeName = ((Element)typeNames.get(i)).getTextTrim();
                this.addASXMLFilterInfoToRM(rm, typeName, filterXML, context);
            }
        }
        catch (Exception e) {
            D.log(e);
            return;
        }
    }

    public void addASXMLFilterInfoToRM(FilterResultModifier rm, String[] typeNames, String filterXML, MContext context) {
        if (typeNames == null || typeNames.length < 1) {
            this.addASXMLFilterInfoToRM(rm, filterXML, context);
        } else {
            for (int i = 0; i < typeNames.length; ++i) {
                this.addASXMLFilterInfoToRM(rm, typeNames[i], filterXML, context);
            }
        }
    }

    public void addASXMLFilterInfoToRM(FilterResultModifier rm, String typeName, String filterXML, MContext context) {
        String AUXTYPES = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.auxTypes", context);
        String ID = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.id", context);
        String GROUP = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.group", context);
        String GROUP_OP = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.grpLop", context);
        String ROW = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.row", context);
        String ROW_OP = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.rowLop", context);
        String ATTRIB = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.attrib", context);
        String OP = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.op", context);
        String VALUE = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.value", context);
        try {
            StringReader r = new StringReader(filterXML);
            Document document = iManager.getSaxBuilder().build((Reader)r);
            if (rm == null) {
                return;
            }
            if (this.isAuxClass(typeName)) {
                rm.setIncludeAuxClasses(true);
            }
            Element root = document.getRootElement();
            FilterResultModifier.Filter filter = new FilterResultModifier.Filter(typeName);
            List rootChildren = root.getChildren(GROUP);
            Iterator rootIterator = rootChildren.iterator();
            SelectionCriterion selectionCriterion = new SelectionCriterion();
            List auxClassList = root.getChildren(AUXTYPES);
            Iterator auxIterator = auxClassList.iterator();
            while (rootIterator.hasNext()) {
                Element groupElement = (Element)rootIterator.next();
                Group group = new Group(groupElement.getChildTextTrim(GROUP_OP));
                List groupChildrenRows = groupElement.getChildren(ROW);
                Iterator groupIteratorRows = groupChildrenRows.iterator();
                while (groupIteratorRows.hasNext()) {
                    Element rowElement = (Element)groupIteratorRows.next();
                    Row row = new Row(rowElement.getChildTextTrim(ATTRIB), rowElement.getChildTextTrim(OP), rowElement.getChildTextTrim(VALUE), rowElement.getChildTextTrim(ROW_OP));
                    group.addRow(row);
                }
                selectionCriterion.addGroup(group);
            }
            FilterResultModifier.FilterItemGroup filterItem = null;
            for (int i = 0; i < selectionCriterion.getGroups().size(); ++i) {
                Group group = (Group)selectionCriterion.getGroups().elementAt(i);
                filterItem = new FilterResultModifier.FilterItemGroup();
                for (int j = 0; j < group.getRows().size(); ++j) {
                    Row row = (Row)group.getRows().elementAt(j);
                    filterItem.addFilterItem(row.getAttribute(), DirUtils.translateOp(row.getOperation()), row.getValue(), DirUtils.translateOp(row.getRowOp()));
                }
                filter.addFilterItemGroupPair(filterItem, "&");
            }
            while (auxIterator.hasNext()) {
                Element auxElement = (Element)auxIterator.next();
                List auxL = auxElement.getChildren(ID);
                Iterator auxClassIterator = auxL.iterator();
                while (auxClassIterator.hasNext()) {
                    Element auxClassEl = (Element)auxClassIterator.next();
                    String aux = auxClassEl.getText();
                    filterItem = new FilterResultModifier.FilterItemGroup();
                    if (auxClassIterator.hasNext()) {
                        filterItem.addFilterItem("Object Class", "=", aux.trim(), "&");
                    } else {
                        filterItem.addFilterItem("Object Class", "=", aux.trim(), null);
                    }
                    filter.addFilterItemGroupPair(filterItem, "&");
                }
            }
            rm.addFilter(filter);
        }
        catch (Exception e) {
            D.log(e);
            return;
        }
    }

    private static String translateOp(String op) {
        if (op.equals("AS.Op.isEqual") || op.equals("AS.Op.is")) {
            return "=";
        }
        if (op.equals("AS.Op.isNotEqual") || op.equals("AS.Op.isNot")) {
            return "!";
        }
        if (op.equals("AS.Op.isBefore") || op.equals("AS.Op.isLessEqual")) {
            return "<=";
        }
        if (op.equals("AS.Op.isAfter") || op.equals("AS.Op.isGreaterEqual")) {
            return ">=";
        }
        if (op.equals("AS.Op.isNear")) {
            return "~=";
        }
        if (op.equals("and")) {
            return "&";
        }
        if (op.equals("or")) {
            return "|";
        }
        if (op.equals("AS.Op.isPresent")) {
            return "=*";
        }
        if (op.equals("AS.Op.isNotPresent")) {
            return "!*";
        }
        return "";
    }

    public static NSObject createUser(String className, ObjectEntry parentEntry, String userStr, String surname) throws NamespaceException, SPIException, SnapinVetoException {
        AdminNamespace ns = parentEntry.getObjectType().getAdminNamespace();
        SchemaDefinition schema = ns.getSchemaDefinition(parentEntry);
        StringValue surNameVal = new StringValue((Syntax)NDSSyntax.SYN_CI_STRING, surname);
        StringValue objClassVal = new StringValue((Syntax)NDSSyntax.SYN_CLASS_NAME, className);
        StringValue cnVal = new StringValue((Syntax)NDSSyntax.SYN_CI_STRING, userStr);
        ValueComponent[] surNameVals = new ValueComponent[1];
        ValueComponent[] objClassVals = new ValueComponent[1];
        ValueComponent[] cnVals = new ValueComponent[1];
        surNameVals[0] = surNameVal;
        objClassVals[0] = objClassVal;
        cnVals[0] = cnVal;
        ObjectAttribute surNameAttr = new ObjectAttribute(schema.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"Surname")), surNameVals);
        ObjectAttribute objClassAttr = new ObjectAttribute(schema.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"Object Class")), objClassVals);
        ObjectAttribute cnAttr = new ObjectAttribute(schema.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"CN")), cnVals);
        Vector<ObjectAttribute> attrVec = new Vector<ObjectAttribute>();
        attrVec.addElement(surNameAttr);
        attrVec.addElement(objClassAttr);
        attrVec.addElement(cnAttr);
        ObjectEntry newObjEntry = null;
        newObjEntry = ns.createObjectEntry(parentEntry, userStr, className);
        NSObject nsObject = ns.createNSObject(newObjEntry, attrVec);
        ns.create(nsObject);
        AdminNamespace nsAuth = ns;
        nsAuth.setPassword(newObjEntry, "");
        return nsObject;
    }

    public static NSObject createObject(ObjectEntry parentEntry, String objectName, String className, String namingAttr) throws NamespaceException, SPIException, SnapinVetoException {
        AdminNamespace ns = parentEntry.getObjectType().getAdminNamespace();
        SchemaDefinition schema = ns.getSchemaDefinition(parentEntry);
        StringValue objClassVal = new StringValue((Syntax)NDSSyntax.SYN_CLASS_NAME, className);
        StringValue cnVal = new StringValue((Syntax)NDSSyntax.SYN_CI_STRING, objectName);
        ValueComponent[] objClassVals = new ValueComponent[1];
        ValueComponent[] cnVals = new ValueComponent[1];
        objClassVals[0] = objClassVal;
        cnVals[0] = cnVal;
        ObjectAttribute objClassAttr = new ObjectAttribute(schema.getAttributeDefinition(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"Object Class")), objClassVals);
        ObjectAttribute cnAttr = new ObjectAttribute(schema.getAttributeDefinition(namingAttr), cnVals);
        Vector<ObjectAttribute> attrVec = new Vector<ObjectAttribute>();
        attrVec.addElement(objClassAttr);
        attrVec.addElement(cnAttr);
        ObjectEntry newObjEntry = null;
        newObjEntry = ns.createObjectEntry(parentEntry, objectName, className);
        NSObject nsObject = ns.createNSObject(newObjEntry, attrVec);
        ns.create(nsObject);
        return nsObject;
    }

    public static void attributeWriter(ObjectEntry oe, String[] attr, String[] attrVal) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        if (attr.length == attrVal.length) {
            AdminNamespace namespace = oe.getObjectType().getAdminNamespace();
            NSObject nsObj = namespace.getDetails(oe);
            int numAttrs = attr.length;
            for (int i = 0; i < numAttrs; ++i) {
                ObjectAttribute objAttr = nsObj.getAttribute(attr[i]);
                if (objAttr == null && !attrVal[i].equals("")) {
                    AttributeDefinition attrDef = namespace.getAttributeDefinition(oe, attr[i]);
                    Syntax syntax = attrDef.getSyntax();
                    ValueComponent val = syntax.createValueComponent((Object)attrVal[i]);
                    objAttr = new ObjectAttribute(attrDef);
                    objAttr.addComponent(val);
                    nsObj.addAttribute(objAttr);
                    continue;
                }
                if (objAttr != null && !attrVal[i].equals("")) {
                    Syntax syntax = objAttr.getAttributeDefinition().getSyntax();
                    ValueComponent val = syntax.createValueComponent((Object)attrVal[i]);
                    ValueComponent oldValue = (ValueComponent)objAttr.getValueComponents().nextElement();
                    objAttr.replaceComponent(oldValue, val);
                    continue;
                }
                if (objAttr == null || !attrVal[i].equals("")) continue;
                nsObj.deleteAttribute(attr[i]);
            }
            namespace.update(nsObj);
        }
    }

    public static String[] attributeReader(ObjectEntry oe, String[] attr) throws SPIException {
        String[] attrStr = new String[attr.length];
        AdminNamespace namespace = oe.getObjectType().getAdminNamespace();
        NSObject nsObj = namespace.getDetails(oe);
        int numAttrs = attr.length;
        for (int i = 0; i < numAttrs; ++i) {
            ObjectAttribute objAttr = nsObj.getAttribute(attr[i]);
            attrStr[i] = objAttr != null ? objAttr.getValueComponents().nextElement().toString() : new String("");
        }
        return attrStr;
    }

    public static boolean MoveObject(ObjectEntry objectEntry, ObjectEntry destObjectEntry, boolean createAliasFlag) throws NamespaceException, SPIException, SnapinVetoException {
        ClassDefinition cd = null;
        long objFlags = 0L;
        AdminNamespace adminns = destObjectEntry.getObjectType().getAdminNamespace();
        objFlags = objectEntry.getObjectFlags();
        cd = adminns.getClassDefinition(objectEntry, objectEntry.getObjectType().getName());
        if (cd.canBeContainedBy(destObjectEntry.getObjectType().getName())) {
            if (objectEntry.getObjectType().isContainer() && !ObjectFlags.isAlias((long)objFlags) && !ObjectFlags.isPartition((long)objFlags)) {
                return false;
            }
            adminns.move(objectEntry, destObjectEntry);
            if (createAliasFlag) {
                // empty if block
            }
        }
        return true;
    }

    public static boolean isObjectInThisTree(ObjectEntry oeTree, String objectFullName) {
        String strEncodedObject = eMFrameUtils.replaceSubString(objectFullName, "\\.", "\\#");
        D.log("Checking:" + strEncodedObject);
        D.log("tree = " + oeTree.getName());
        int iLastDotIndex = strEncodedObject.lastIndexOf(".");
        if (strEncodedObject.endsWith(".")) {
            iLastDotIndex = strEncodedObject.lastIndexOf(".", iLastDotIndex - 1);
        }
        if (-1 != iLastDotIndex) {
            String strLastName = strEncodedObject.substring(iLastDotIndex);
            String strEncodedLastName = eMFrameUtils.replaceSubString(strLastName, "\\#", "\\.");
            if (oeTree.getName().equalsIgnoreCase(strEncodedLastName)) {
                D.log("found");
                return true;
            }
        }
        D.log("lost");
        return false;
    }

    public static String removeTreeFromFullName(ObjectEntry oeTree, String objectFullName) {
        if (DirUtils.isObjectInThisTree(oeTree, objectFullName)) {
            return DirUtils.removeRightMostName(objectFullName);
        }
        return objectFullName;
    }

    public static String removeRightMostName(String objectName) {
        int iLastDotIndex;
        String strEncodedObject = eMFrameUtils.replaceSubString(objectName, "\\.", "\\#");
        if (strEncodedObject.endsWith(".")) {
            strEncodedObject = strEncodedObject.substring(0, strEncodedObject.length() - 1);
        }
        if (-1 != (iLastDotIndex = strEncodedObject.lastIndexOf("."))) {
            String strEncodedLastName = strEncodedObject.substring(0, iLastDotIndex);
            strEncodedLastName = eMFrameUtils.replaceSubString(strEncodedLastName, "\\#", "\\.");
            return strEncodedLastName;
        }
        return "";
    }

    public static String getLeftMostName(String objectName) {
        return DirUtils.getLeftMostName(null, objectName);
    }

    public static String getLeftMostName(AdminNamespace ns, String objectName) {
        String strEncodedObject;
        int iDotIndex;
        String sSep = ".";
        if (ns != null && ns instanceof LDAPNamespace) {
            sSep = ",";
        }
        if (-1 != (iDotIndex = (strEncodedObject = eMFrameUtils.replaceSubString(objectName, "\\" + sSep, "\\#")).indexOf(sSep))) {
            String strEncodedLastName = strEncodedObject.substring(0, iDotIndex);
            strEncodedLastName = eMFrameUtils.replaceSubString(strEncodedLastName, "\\#", "\\" + sSep);
            return strEncodedLastName;
        }
        return objectName;
    }

    public static boolean isOfType(ObjectType type, String strKnownType, boolean bDerivedOK) {
        if (type != null) {
            String typeName = type.getName();
            if (typeName != null && typeName.equalsIgnoreCase(strKnownType)) {
                return true;
            }
            if (bDerivedOK && !strKnownType.equalsIgnoreCase("Top")) {
                return DirUtils.checkParentType(type, strKnownType);
            }
        }
        return false;
    }

    public boolean isAuxClass(String typeName) {
        if (typeName == null || typeName.length() < 1) {
            return false;
        }
        return this.m_hsAuxClassSet.contains(typeName);
    }

    public boolean isOfAuxClass(ObjectEntry oe, String auxClass) {
        try {
            AdminNamespace ns = oe.getObjectType().getAdminNamespace();
            ObjectAttribute oa = ns.getAttribute(oe, "Object Class");
            if (oa != null) {
                Enumeration valenum = oa.getValueComponents();
                while (valenum.hasMoreElements()) {
                    if (!((StringValue)valenum.nextElement()).getValue().equalsIgnoreCase(auxClass)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            D.log(e);
            return false;
        }
    }

    private static boolean checkParentType(ObjectType type, String strKnownType) {
        ObjectType[] parents = type.getParentTypes();
        if (parents != null) {
            for (int i = 0; i < parents.length; ++i) {
                if (parents[i] == null) continue;
                String parentTypeName = parents[i].getName();
                if (parentTypeName != null && parentTypeName.equalsIgnoreCase(strKnownType)) {
                    return true;
                }
                if (!DirUtils.checkParentType(parents[i], strKnownType)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCount(ObjectEntryEnumeration oee) {
        if (oee instanceof CountableObjectEntryEnumeration) {
            try {
                return ((CountableObjectEntryEnumeration)oee).getCount();
            }
            catch (SnapinException snapinException) {
                // empty catch block
            }
        }
        return -1;
    }

    private void createMappingObject(NDSNamespace ndsns, ObjectEntry treeOE) {
        try {
            String defaultServerIp;
            String serverDN = ndsns.getDefaultServerDN(treeOE);
            try {
                defaultServerIp = ndsns.getDefaultIpAddress(treeOE);
            }
            catch (SPIException ee) {
                defaultServerIp = null;
                D.log(ee);
            }
            ObjectEntry serverOE = ndsns.getObjectEntry(treeOE, serverDN);
            this.ldapMappingObject = new MappingObject(serverOE, defaultServerIp, this.classArray, this.attrArray);
        }
        catch (SPIException se) {
            D.log(se);
        }
        catch (NamespaceException ne) {
            D.log(ne);
        }
    }

    public void createSortedTypeArrays(ArrayList types, ArrayList localizedTypes, MContext context) {
        if (types == null || localizedTypes == null) {
            D.assrt(false, "createSortedTypeArrays: types or localizedTypes is null");
            return;
        }
        localizedTypes.clear();
        for (int i = 0; i < types.size(); ++i) {
            String type = (String)types.get(i);
            if (type == null || type.length() <= 0) continue;
            if (type.equals("*")) {
                localizedTypes.add(eMFrameUtils.getLocalizedString("FwResources", "OS.All", context));
                continue;
            }
            localizedTypes.add(context.getDirUtils().getObjectTypeDisplayName(type, context));
        }
        eMFrameUtils.sortKeyValues(localizedTypes, types, context);
    }

    public static final String[] getRights(ObjectEntry targetOE, ObjectEntry trusteeOE, String[] attrib) throws PageException {
        AdminNamespace ns = targetOE.getAdminNamespace();
        String[] arRights = new String[attrib.length];
        try {
            SchemaDefinition schema = ns.getSchemaDefinition(targetOE);
            for (int index = 0; index < attrib.length; ++index) {
                Rights rights;
                AttributeDefinition attrDef = schema.getAttributeDefinition(attrib[index]);
                arRights[index] = attrDef.isReadOnly() ? "R" : ((rights = ns.getPropertyEffectiveRights(targetOE, trusteeOE, new String[]{attrib[index]})[0]).hasReadRights() && rights.hasWriteRights() ? "RW" : (rights.hasReadRights() || attrDef.isReadOnly() ? "R" : "NONE"));
            }
        }
        catch (SPIException e) {
            D.log(e);
            throw new PageException((Exception)((Object)e));
        }
        catch (NamespaceException ne) {
            D.log(ne);
            throw new PageException((Exception)((Object)ne));
        }
        return arRights;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSimplePassword(String treeName, String userName, String newPassword, boolean doDelay) throws PluginException {
        AuthenticationBroker broker = this.m_dirAuth.getAuthenticationBroker();
        boolean ssl = broker.getAuthUseLdapSSL();
        if (!ssl) {
            String errTitle = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.ErrorTitle", this.m_dirAuth.getLocale());
            String errMess = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.SSLNotConfigured", this.m_dirAuth.getLocale());
            throw new PluginException(errTitle, errMess, broker.getIdentity()[2]);
        }
        LdapContext ldapCtx = null;
        try {
            ldapCtx = (LdapContext)broker.getAPIObject("JndiLdap", null);
        }
        catch (AuthBrokerException abe) {
            String errTitle = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.ErrorTitle", this.m_dirAuth.getLocale());
            String errMess = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.GetLDAPContextFailed", this.m_dirAuth.getLocale()) + "\n" + abe.getLocalizedMessage();
            throw new PluginException(errTitle, errMess, broker.getIdentity()[2]);
        }
        try {
            NMASSimplePwdMgr simplePassMgr = new NMASSimplePwdMgr(ldapCtx);
            boolean simplePasswordSet = false;
            int delayCnt = 0;
            while (!simplePasswordSet) {
                try {
                    simplePassMgr.setSimplePwd(treeName, userName, newPassword);
                    simplePasswordSet = true;
                }
                catch (NMASLoginDataException tmplde) {
                    if (doDelay && tmplde.getNmasRetCode() == -601 && delayCnt++ < 60) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception ex) {}
                        continue;
                    }
                    simplePasswordSet = true;
                    throw tmplde;
                    return;
                }
            }
        }
        catch (NMASLoginDataException lde) {
            AdminNamespace adminns = this.treeOE.getAdminNamespace();
            SPIException spie = adminns.createSPIException(lde.getNmasRetCode());
            D.log("setSimplePassword::" + lde.getNmasRetCode());
            throw new PluginException((Exception)((Object)spie));
        }
        catch (Throwable te) {
            String errMess = null;
            String tmpStr = te.getLocalizedMessage();
            String errTitle = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.ErrorTitle", this.m_dirAuth.getLocale());
            errMess = null != tmpStr ? eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.SetPassFailed", this.m_dirAuth.getLocale()) + "\n" + tmpStr : eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.SetPassFailed", this.m_dirAuth.getLocale());
            throw new PluginException(errTitle, errMess);
        }
        finally {
            try {
                ldapCtx.close();
            }
            catch (NamingException e) {}
            ldapCtx = null;
        }
    }

    public boolean getUniversalPwdState(String containerStr) throws PluginException {
        ObjectEntry containerOE;
        AdminNamespace ndsns = this.treeOE.getAdminNamespace();
        try {
            containerOE = ndsns.getObjectEntry(containerStr);
        }
        catch (SPIException e) {
            String errTitle = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.ErrorTitle", this.m_dirAuth.getLocale());
            String errMess = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.ObjectNotFound", this.m_dirAuth.getLocale()) + "  " + e.getLocalizedMessage();
            throw new PluginException(errTitle, errMess, containerStr);
        }
        int tmpFlags = 0;
        try {
            if (ndsns instanceof NDSNamespace) {
                tmpFlags = this.queryUPFlag((NDSNamespace)ndsns, containerOE);
            }
        }
        catch (SPIException spe) {
            D.log(spe);
            String errTitle = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.ErrorTitle", this.m_dirAuth.getLocale());
            String errMess = null;
            errMess = spe instanceof UniqueSPIException && spe.getErrorCode() == -601 ? eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.NMASInstallFailure", this.m_dirAuth.getLocale()) + "\n" + spe.getLocalizedMessage() : eMFrameUtils.getLocalizedString("BaseResources", "SimplePassErr.UPStatusFailure", this.m_dirAuth.getLocale()) + "\n" + spe.getLocalizedMessage();
            throw new PluginException(errTitle, errMess);
        }
        return (tmpFlags & 0x100) == 256;
    }

    private int queryUPFlag(NDSNamespace ndsns, ObjectEntry targetOE) throws SPIException {
        int rVal = 0;
        if (null == targetOE) {
            return rVal;
        }
        try {
            String treeName = this.treeOE.getName();
            rVal = targetOE.getName().equals(treeName) ? this.queryTreeRoot() : this.queryContainer(ndsns, targetOE);
        }
        catch (SPIException spe) {
            D.log("queryUPFlag:: " + (Object)((Object)spe));
            throw spe;
        }
        return rVal;
    }

    private int queryTreeRoot() throws SPIException {
        int rVal = 0;
        try {
            String tmpName;
            ObjectEntry policyOE;
            ObjectAttribute flagAttr;
            AdminNamespace ndsns = this.treeOE.getAdminNamespace();
            ObjectEntry passwordPolicyOE = ndsns.getObjectEntry(this.treeOE, "Login Policy.Security");
            ObjectAttribute dnAttr = ndsns.getAttribute(passwordPolicyOE, "nspmPasswordPolicyDN");
            if (null != dnAttr && null != (flagAttr = ndsns.getAttribute(policyOE = ndsns.getObjectEntry(this.treeOE, tmpName = ((StringValue)dnAttr.getValueComponents().nextElement()).getValue()), "nspmConfigurationOptions"))) {
                Long flags = ((LongValue)flagAttr.getValueComponents().nextElement()).getLongValue();
                rVal = flags.intValue();
            }
        }
        catch (SPIException spe) {
            D.log("queryTreeRoot:: " + (Object)((Object)spe));
            throw spe;
        }
        return rVal;
    }

    private int queryContainer(NDSNamespace ndsns, ObjectEntry targetOE) throws SPIException {
        int rVal = 0;
        try {
            ObjectAttribute dnAttr = ndsns.getAttribute(targetOE, "nspmPasswordPolicyDN");
            if (null != dnAttr) {
                String tmpName = ((StringValue)dnAttr.getValueComponents().nextElement()).getValue();
                ObjectEntry policyOE = ndsns.getObjectEntry(this.treeOE, tmpName);
                ObjectAttribute flagAttr = ndsns.getAttribute(policyOE, "nspmConfigurationOptions");
                if (null != flagAttr) {
                    rVal = ((LongValue)flagAttr.getValueComponents().nextElement()).getLongValue().intValue();
                }
            } else {
                rVal = this.queryPartition(ndsns, targetOE);
            }
        }
        catch (SPIException spe) {
            D.log("queryContainer:: " + (Object)((Object)spe));
            throw spe;
        }
        return rVal;
    }

    private int queryPartition(NDSNamespace ndsns, ObjectEntry targetOE) throws SPIException {
        int rVal = 0;
        try {
            PartitionService partitionService = ndsns.getPartitionService(targetOE);
            String partitionRootDN = partitionService.getPartitionRoot(targetOE);
            ObjectEntry partitionOE = ndsns.getObjectEntry(this.treeOE, partitionRootDN);
            ObjectAttribute dnAttr = ndsns.getAttribute(partitionOE, "nspmPasswordPolicyDN");
            if (null != dnAttr) {
                String tmpName = ((StringValue)dnAttr.getValueComponents().nextElement()).getValue();
                ObjectEntry policyOE = ndsns.getObjectEntry(this.treeOE, tmpName);
                ObjectAttribute flagAttr = ndsns.getAttribute(policyOE, "nspmConfigurationOptions");
                if (null != flagAttr) {
                    rVal = ((LongValue)flagAttr.getValueComponents().nextElement()).getLongValue().intValue();
                }
            } else {
                rVal = this.queryTreeRoot();
            }
        }
        catch (SPIException spe) {
            D.log("queryPartition:: " + (Object)((Object)spe));
            throw spe;
        }
        return rVal;
    }

    public static void updateAndSyncBackLinks(NSObject nsobj) throws PluginException {
        Target.singleSyncBackLinks(nsobj);
    }

    public static boolean isNVDS(MContext context) {
        return "NVDS".equals(DirAuthenticator.getDirAuth(context).getSystem());
    }

    public static String getUserCN(MContext context) throws AuthNotAuthenticatedException {
        return (String)DirAuthenticator.getDirAuth(context).getCredentials(context.getRequest()).getSetting("Id");
    }

    public static String getTree(MContext context) {
        return (String)DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getSetting("UniqueHostName");
    }

    private class Row {
        private String attribute;
        private String operation;
        private String value;
        private String row_op;

        Row(String attribute, String operation, String value, String row_op) {
            this.attribute = attribute;
            this.operation = operation;
            this.value = value;
            this.row_op = row_op;
        }

        String getAttribute() {
            return this.attribute;
        }

        String getOperation() {
            return this.operation;
        }

        String getValue() {
            return this.value;
        }

        String getRowOp() {
            return this.row_op;
        }
    }

    private class Group {
        private Vector rows;
        private String group_op;

        Group(String group_op) {
            this.group_op = group_op;
            this.rows = new Vector();
        }

        void addRow(Row row) {
            this.rows.addElement(row);
        }

        Vector getRows() {
            return this.rows;
        }

        String getOperator() {
            return this.group_op;
        }
    }

    private class SelectionCriterion {
        private Vector groups = new Vector();

        private SelectionCriterion() {
        }

        void addGroup(Group group) {
            this.groups.addElement(group);
        }

        Vector getGroups() {
            return this.groups;
        }
    }
}

