/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.application.console.snapin.ObjectEntry;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MappingObject {
    private static final String MAPKEY_NDS_NAME = "NDSName";
    private static final String MAPKEY_LDAP_NAMES = "LDAPNames";
    private static final String MAPKEY_DELIMITER = "$";
    private static int DEFAULT_CLEAR_PORT = 389;
    private static int DEFAULT_SSL_PORT = 636;
    private HashMap LDAPClassToNDSTable = new HashMap();
    private HashMap LDAPAttributeToNDSTable = new HashMap();
    private HashMap NDSClassToLDAPTable = new HashMap();
    private HashMap NDSAttributeToLDAPTable = new HashMap();
    private String cachedIpAddress = null;
    private int cachedLDAPClearPort = -1;
    private int cachedLDAPSSLPort = -1;
    private String treeNameNoDots = null;
    private NDSNamespace ndsns;
    static final int B4TYPE = 0;
    static final int INTYPE = 1;
    static final int B4EQUAL = 2;
    static final int B4VALUE = 3;
    static final int INVALUE = 4;
    static final int INQUOTEDVALUE = 5;
    static final int B4LDAPSEPARATOR = 6;
    static final int INHEXSTRING = 7;
    static final int INHEXPAIR = 8;
    static final int MAX_DN_CHARS = 256;
    static char DELIM_VALUE = (char)61;
    static char DELIM_DV = (char)43;
    static char DELIM_DF_RDN = (char)46;
    static char DELIM_DF_ESCAPE = (char)92;
    static char NDS_SEPARATOR = DELIM_DF_RDN;
    static int ERR_DN_TOO_LONG = -353;
    static int ERR_ILLEGAL_DS_NAME = -610;
    static int LDAP_INVALID_DN_SYNTAX = 34;

    public MappingObject(ObjectEntry ncpServerOE, String inipAddress, String[] allNDSClassNames, String[] allNDSAttrNames) throws NamespaceException, SPIException {
        this.ndsns = (NDSNamespace)ncpServerOE.getNamespace();
        this.readMappingTableFromNDS(ncpServerOE);
        this.completeAutoMapping(allNDSClassNames, this.NDSClassToLDAPTable, this.LDAPClassToNDSTable);
        this.completeAutoMapping(allNDSAttrNames, this.NDSAttributeToLDAPTable, this.LDAPAttributeToNDSTable);
        this.cachedIpAddress = inipAddress;
        StringBuffer sb = new StringBuffer(ncpServerOE.getRoot().getName());
        int slen = sb.length();
        if (slen > 1 && sb.charAt(0) == '.') {
            sb.deleteCharAt(0);
            --slen;
        }
        if (slen >= 2 && sb.charAt(slen - 1) == '.' && sb.charAt(slen - 2) != '\\') {
            sb.deleteCharAt(slen - 1);
        }
        this.treeNameNoDots = sb.toString();
    }

    public String getLDAPIpAddress() {
        return this.cachedIpAddress;
    }

    public int getLDAPClearPort() {
        return this.cachedLDAPClearPort;
    }

    public int getLDAPSSLPort() {
        return this.cachedLDAPSSLPort;
    }

    public String LDAPClassToNDS(String LDAPClassName) {
        String retStr = (String)this.LDAPClassToNDSTable.get(LDAPClassName.toLowerCase());
        return retStr;
    }

    public String LDAPAttributeToNDS(String LDAPAttributeName) {
        String retStr = (String)this.LDAPAttributeToNDSTable.get(LDAPAttributeName.toLowerCase());
        return retStr;
    }

    public String[] NDSClassToLDAP(String NDSClassName) {
        String[] retStrArr = (String[])this.NDSClassToLDAPTable.get(NDSClassName.toLowerCase());
        return retStrArr;
    }

    public String[] NDSAttributeToLDAP(String NDSAttributeName) {
        String[] retStrArr = (String[])this.NDSAttributeToLDAPTable.get(NDSAttributeName.toLowerCase());
        return retStrArr;
    }

    private void completeAutoMapping(String[] ndsCasedNames, HashMap ndsToLDAPMap, HashMap ldapToNDSMap) {
        for (int jj = 0; jj < ndsCasedNames.length; ++jj) {
            String ndsLowerName = ndsCasedNames[jj].toLowerCase();
            if (ndsToLDAPMap.containsKey(ndsLowerName)) continue;
            String ldapCasedName = this.autoMapToLDAPName(ndsCasedNames[jj]);
            String ldapLowerName = ldapCasedName.toLowerCase();
            String[] oneArray = new String[]{ldapCasedName};
            ndsToLDAPMap.put(ndsLowerName, oneArray);
            if (ldapToNDSMap.containsKey(ldapLowerName)) continue;
            ldapToNDSMap.put(ldapLowerName, ndsCasedNames[jj]);
        }
    }

    private String autoMapToLDAPName(String ndsName) {
        char[] inNDSArr = ndsName.toCharArray();
        char[] newLDAPArr = new char[inNDSArr.length];
        int newcc = 0;
        for (int cc = 0; cc < inNDSArr.length; ++cc) {
            if (inNDSArr[cc] == ' ' || inNDSArr[cc] == ':') continue;
            newLDAPArr[newcc++] = inNDSArr[cc];
        }
        if (newcc != inNDSArr.length) {
            newLDAPArr[0] = Character.toLowerCase(newLDAPArr[0]);
        }
        return String.valueOf(newLDAPArr, 0, newcc);
    }

    private void readMappingTableFromNDS(ObjectEntry ncpServerOE) throws SPIException {
        NDSObjectAttribute attrMap;
        Enumeration ldnValues;
        NDSObjectAttribute ldapGroupAttr;
        Enumeration ldnValues2;
        NDSObjectAttribute ldapSSLAttr;
        Enumeration ldnValues3;
        Enumeration ldnValues4;
        if (ncpServerOE == null) {
            return;
        }
        boolean isOldStyleMapping = false;
        ObjectEntry ldapServerOE = null;
        NSObject ncpServerNSObject = this.ndsns.getDetails(ncpServerOE);
        NDSObjectAttribute ldapServerAttr = (NDSObjectAttribute)ncpServerNSObject.getAttribute("LDAP Server");
        if (ldapServerAttr != null && (ldnValues4 = ldapServerAttr.getValueComponents()).hasMoreElements()) {
            String ldapServerDN = ((StringValue)ldnValues4.nextElement()).getValue();
            ldapServerOE = this.ndsns.getObjectEntry(ncpServerOE.getRoot(), ldapServerDN);
        }
        if (ldapServerOE == null) {
            return;
        }
        ObjectEntry ldapGroupOE = null;
        NSObject ldapServerNSObject = this.ndsns.getDetails(ldapServerOE);
        NDSObjectAttribute ldapClearAttr = (NDSObjectAttribute)ldapServerNSObject.getAttribute("LDAP TCP Port");
        if (ldapClearAttr != null && (ldnValues3 = ldapClearAttr.getValueComponents()).hasMoreElements()) {
            this.cachedLDAPClearPort = (int)((LongValue)ldnValues3.nextElement()).getValue();
        }
        if (this.cachedLDAPClearPort == -1) {
            this.cachedLDAPClearPort = DEFAULT_CLEAR_PORT;
        }
        if ((ldapSSLAttr = (NDSObjectAttribute)ldapServerNSObject.getAttribute("LDAP SSL Port")) != null && (ldnValues2 = ldapSSLAttr.getValueComponents()).hasMoreElements()) {
            this.cachedLDAPSSLPort = (int)((LongValue)ldnValues2.nextElement()).getValue();
        }
        if (this.cachedLDAPSSLPort == -1) {
            this.cachedLDAPSSLPort = DEFAULT_SSL_PORT;
        }
        if ((ldapGroupAttr = (NDSObjectAttribute)ldapServerNSObject.getAttribute("LDAP Group")) != null && (ldnValues = ldapGroupAttr.getValueComponents()).hasMoreElements()) {
            String ldapGroupDN = ((StringValue)ldnValues.nextElement()).getValue();
            ldapGroupOE = this.ndsns.getObjectEntry(ncpServerOE.getRoot(), ldapGroupDN);
        }
        if (ldapGroupOE == null) {
            return;
        }
        NSObject ldapGroupNSObject = this.ndsns.getDetails(ldapGroupOE);
        NDSObjectAttribute classMap = (NDSObjectAttribute)ldapGroupNSObject.getAttribute("ldapClassList");
        if (classMap == null) {
            classMap = (NDSObjectAttribute)ldapGroupNSObject.getAttribute("LDAP Class Map v11");
            isOldStyleMapping = true;
            if (classMap == null) {
                return;
            }
        }
        if ((attrMap = (NDSObjectAttribute)ldapGroupNSObject.getAttribute("ldapAttributeList")) == null) {
            attrMap = (NDSObjectAttribute)ldapGroupNSObject.getAttribute("LDAP Attribute Map v11");
            isOldStyleMapping = true;
            if (attrMap == null) {
                return;
            }
        }
        if (isOldStyleMapping) {
            this.initializeOldStyleMappingTables(classMap, attrMap);
        } else {
            this.initializeNewStyleMappingTables(classMap, attrMap);
        }
    }

    private void initializeNewStyleMappingTables(NDSObjectAttribute classMapAttr, NDSObjectAttribute attrMapAttr) {
        if (classMapAttr == null || attrMapAttr == null) {
            return;
        }
        NDSObjectAttribute[] mapAttrs = new NDSObjectAttribute[]{classMapAttr, attrMapAttr};
        for (int mapType = 0; mapType < mapAttrs.length; ++mapType) {
            Enumeration valueSet = mapAttrs[mapType].getValueComponents();
            while (valueSet.hasMoreElements()) {
                String[] ciStrings;
                ValueList valueList = (ValueList)valueSet.nextElement();
                CaseIgnoreListFacade cilFacade = (CaseIgnoreListFacade)valueList.createFacade();
                if (cilFacade == null || (ciStrings = cilFacade.getStrings()) == null) continue;
                String ndsName = "";
                String[] ldapNameArray = null;
                block10: for (int j = 0; j < ciStrings.length; ++j) {
                    switch (j) {
                        case 0: {
                            ndsName = this.getValueString(MAPKEY_NDS_NAME, ciStrings[j]);
                            continue block10;
                        }
                        case 1: {
                            ldapNameArray = this.getValueStrings(MAPKEY_LDAP_NAMES, ciStrings[j]);
                        }
                    }
                }
                if (ndsName == "" || ldapNameArray == null) continue;
                switch (mapType) {
                    case 0: {
                        int x;
                        for (x = 0; x < ldapNameArray.length; ++x) {
                            this.LDAPClassToNDSTable.put(ldapNameArray[x].toLowerCase(), ndsName);
                        }
                        this.NDSClassToLDAPTable.put(ndsName.toLowerCase(), ldapNameArray);
                        break;
                    }
                    case 1: {
                        int x;
                        for (x = 0; x < ldapNameArray.length; ++x) {
                            this.LDAPAttributeToNDSTable.put(ldapNameArray[x].toLowerCase(), ndsName);
                        }
                        this.NDSAttributeToLDAPTable.put(ndsName.toLowerCase(), ldapNameArray);
                    }
                }
            }
        }
    }

    private String getValueString(String key, String nameValuePair) {
        String keyEquals = key + "=";
        int valueIndex = nameValuePair.indexOf(keyEquals);
        if (valueIndex > -1) {
            return nameValuePair.substring(valueIndex + keyEquals.length());
        }
        return "";
    }

    private String[] getValueStrings(String key, String nameValuePair) {
        String keyEquals = key + "=";
        int valueIndex = nameValuePair.indexOf(keyEquals);
        String value = "";
        String[] list = null;
        if (valueIndex > -1 && nameValuePair.length() > valueIndex + keyEquals.length()) {
            value = nameValuePair.substring(valueIndex + keyEquals.length());
            StringTokenizer st = new StringTokenizer(value, MAPKEY_DELIMITER);
            list = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                list[i++] = st.nextToken().trim();
            }
        }
        return list;
    }

    private void initializeOldStyleMappingTables(NDSObjectAttribute classMapAttr, NDSObjectAttribute attrMapAttr) {
        if (classMapAttr == null || attrMapAttr == null) {
            return;
        }
        NDSObjectAttribute[] mapAttrs = new NDSObjectAttribute[]{classMapAttr, attrMapAttr};
        block4: for (int mapType = 0; mapType < mapAttrs.length; ++mapType) {
            Character tmpCh;
            char tmpChar;
            int tmpInt;
            int tmpInt2;
            int tmpInt1;
            int j;
            char[] charArray;
            int stringLength;
            int i;
            Enumeration valueSet = mapAttrs[mapType].getValueComponents();
            if (!valueSet.hasMoreElements()) continue;
            byte[] mappings = ((HexValue)valueSet.nextElement()).getValue();
            String[][] mapArray = new String[2][];
            int index = 0;
            if (mappings == null) {
                return;
            }
            int attrCounts = 0;
            attrCounts = mappings[index += 4] >= 0 ? (attrCounts += mappings[index]) : (attrCounts += 256 + mappings[index]);
            attrCounts = mappings[index + 1] >= 0 ? (attrCounts += mappings[index + 1] * 256) : (attrCounts += (256 + mappings[index + 1]) * 256);
            mapArray[0] = new String[attrCounts];
            index += 2;
            for (i = 0; i < attrCounts; ++i) {
                stringLength = mappings[index += 3];
                charArray = new char[stringLength];
                ++index;
                for (j = 0; j < stringLength; ++j) {
                    tmpInt1 = mappings[index];
                    tmpInt2 = mappings[index + 1];
                    tmpInt = (tmpInt2 &= 0xFF) << 8 | (tmpInt1 &= 0xFF);
                    tmpChar = (char)tmpInt;
                    tmpCh = new Character(tmpChar);
                    charArray[j] = tmpCh.charValue();
                    index += 2;
                }
                mapArray[0][i] = new String(charArray);
            }
            attrCounts = 0;
            attrCounts = mappings[index] >= 0 ? (attrCounts += mappings[index]) : (attrCounts += 256 + mappings[index]);
            attrCounts = mappings[index + 1] >= 0 ? (attrCounts += mappings[index + 1] * 256) : (attrCounts += (256 + mappings[index + 1]) * 256);
            mapArray[1] = new String[attrCounts];
            index += 2;
            for (i = 0; i < attrCounts; ++i) {
                stringLength = mappings[index += 3];
                charArray = new char[stringLength];
                ++index;
                for (j = 0; j < stringLength; ++j) {
                    tmpInt1 = mappings[index];
                    tmpInt2 = mappings[index + 1];
                    tmpInt = (tmpInt2 &= 0xFF) << 8 | (tmpInt1 &= 0xFF);
                    tmpChar = (char)tmpInt;
                    tmpCh = new Character(tmpChar);
                    charArray[j] = tmpCh.charValue();
                    index += 2;
                }
                mapArray[1][i] = new String(charArray);
            }
            switch (mapType) {
                case 0: {
                    String[] oneArray;
                    String[] ldapNames;
                    int x;
                    for (x = 0; x < mapArray[0].length; ++x) {
                        this.LDAPClassToNDSTable.put(mapArray[0][x].toLowerCase(), mapArray[1][x]);
                        ldapNames = (String[])this.NDSClassToLDAPTable.get(mapArray[1][x].toLowerCase());
                        if (ldapNames != null) {
                            this.NDSClassToLDAPTable.put(mapArray[1][x].toLowerCase(), this.appendStrToArray(ldapNames, mapArray[0][x]));
                            continue;
                        }
                        oneArray = new String[]{mapArray[0][x]};
                        this.NDSClassToLDAPTable.put(mapArray[1][x].toLowerCase(), oneArray);
                    }
                    continue block4;
                }
                case 1: {
                    String[] oneArray;
                    String[] ldapNames;
                    int x;
                    for (x = 0; x < mapArray[0].length; ++x) {
                        this.LDAPAttributeToNDSTable.put(mapArray[0][x].toLowerCase(), mapArray[1][x]);
                        ldapNames = (String[])this.NDSAttributeToLDAPTable.get(mapArray[1][x].toLowerCase());
                        if (ldapNames != null) {
                            this.NDSAttributeToLDAPTable.put(mapArray[1][x].toLowerCase(), this.appendStrToArray(ldapNames, mapArray[0][x]));
                            continue;
                        }
                        oneArray = new String[]{mapArray[0][x]};
                        this.NDSAttributeToLDAPTable.put(mapArray[1][x].toLowerCase(), oneArray);
                    }
                    continue block4;
                }
            }
        }
    }

    private String[] appendStrToArray(String[] origArray, String add) {
        if (origArray == null || add == null) {
            return null;
        }
        String[] newArray = new String[origArray.length + 1];
        for (int i = 0; i < origArray.length; ++i) {
            newArray[i] = origArray[i];
        }
        newArray[newArray.length - 1] = add;
        return newArray;
    }

    static boolean LDAPSEPARATOR(char c) {
        return c == ',' || c == ';' || c == '+';
    }

    static boolean SPACE(char c) {
        return c == ' ' || c == '\n';
    }

    static boolean LDAPNEEDSESCAPE(char c) {
        return c == '\"' || c == ',' || c == '+' || c == '<' || c == '>' || c == ';' || c == '\\';
    }

    static boolean NDAPNEEDSESCAPE(char c) {
        return c == '.' || c == '+' || c == '=' || c == '\\';
    }

    static boolean LDAPMAYESCAPE(char c) {
        return c == '#' || c == '=' || c == ' ';
    }

    static boolean LDAPHEXPAIR(char c1, char c2) {
        return (MappingObject.LDAPDIGIT(c1) || c1 >= 'a' && c1 <= 'f') && (MappingObject.LDAPDIGIT(c2) || c2 >= 'a' && c2 <= 'f');
    }

    static boolean LDAPATTRTYPECHAR(char c) {
        return MappingObject.LDAPALPHA(c) || MappingObject.LDAPDIGIT(c) || c == '-' || c == '.';
    }

    static boolean LDAPALPHA(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    static boolean LDAPDIGIT(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean NDSDELIMITER(char c) {
        return c == DELIM_VALUE || c == DELIM_DV || c == DELIM_DF_RDN;
    }

    static boolean NDSSEPARATOR(char c) {
        return c == DELIM_DF_RDN;
    }

    static boolean NDSESCAPE(char c) {
        return c == DELIM_DF_ESCAPE;
    }

    static void hexCharsToChar(char c1, char c2, char cOut) {
        cOut = c1 >= '0' && c1 <= '9' ? (char)(c1 - 48) : (char)(10 + c1 - 97);
        cOut = (char)(cOut << 4);
        cOut = c2 >= '0' && c2 <= '9' ? (char)(cOut + (char)(c2 - 48)) : (char)(cOut + (char)(10 + c2 - 97));
    }

    public String LDAPNameToNDSName(String ldapDN_s, boolean typed, boolean addTreeName) {
        return MappingObject.LDAPNameToNDSName(ldapDN_s, typed, addTreeName, this, this.treeNameNoDots);
    }

    public static String LDAPNameToNDSName(String ldapDN_s) {
        return MappingObject.LDAPNameToNDSName(ldapDN_s, false, false, null, null);
    }

    /*
     * Unable to fully structure code
     */
    private static String LDAPNameToNDSName(String ldapDN_s, boolean do_typed, boolean do_addTreeName, MappingObject mapObj, String treeNameNoDots) {
        ldapDN = new StringBuffer(ldapDN_s);
        ndsDN = new StringBuffer();
        retStr = new String();
        curldapDNPos = 0;
        state = 0;
        c = '\u0000';
        c1 = '\u0000';
        c2 = '\u0000';
        if (ldapDN.length() == 0 || ldapDN.charAt(0) == '\u0000') {
            return retStr;
        }
        if (do_addTreeName && treeNameNoDots != null && treeNameNoDots.length() != 0) {
            if (do_typed && mapObj != null) {
                ndsDN.append("T=");
            }
            ndsDN.append(treeNameNoDots);
            ndsDN.append(MappingObject.NDS_SEPARATOR);
        }
        tmp = new StringBuffer();
        state = 0;
        block9: for (curldapDNPos = 0; curldapDNPos < ldapDN.length(); ++curldapDNPos) {
            if (ndsDN.length() >= 256) {
                return retStr;
            }
            switch (state) {
                case 0: {
                    if (MappingObject.SPACE(ldapDN.charAt(curldapDNPos))) continue block9;
                    tmpcurldapDNPos = curldapDNPos;
                    while (ldapDN.charAt(tmpcurldapDNPos) != '=' && !MappingObject.SPACE(ldapDN.charAt(tmpcurldapDNPos))) {
                        if (!MappingObject.LDAPATTRTYPECHAR(ldapDN.charAt(tmpcurldapDNPos))) {
                            return retStr;
                        }
                        ++tmpcurldapDNPos;
                    }
                    if (tmpcurldapDNPos == curldapDNPos) {
                        return retStr;
                    }
                    if (do_typed && mapObj != null) {
                        tmpBuf = new char[tmpcurldapDNPos - curldapDNPos];
                        ldapDN.getChars(curldapDNPos, tmpcurldapDNPos, tmpBuf, 0);
                        ldapAttrName = new String(tmpBuf);
                        if (ldapAttrName == null) {
                            return retStr;
                        }
                        ndsAttrName = mapObj.LDAPAttributeToNDS(ldapAttrName);
                        if (ndsAttrName.length() == 0) {
                            return retStr;
                        }
                        ndsDN.append(ndsAttrName);
                        ndsDN.append('=');
                    }
                    curldapDNPos = tmpcurldapDNPos;
                    while (ldapDN.charAt(tmpcurldapDNPos) != '=' && !MappingObject.SPACE(ldapDN.charAt(tmpcurldapDNPos))) {
                        ++curldapDNPos;
                    }
                    state = 3;
                    continue block9;
                }
                case 3: {
                    if (ldapDN.charAt(curldapDNPos) == '\"') {
                        state = 5;
                        continue block9;
                    }
                    if (ldapDN.charAt(curldapDNPos) == '#') {
                        state = 7;
                        continue block9;
                    }
                    if (MappingObject.SPACE(ldapDN.charAt(curldapDNPos))) continue block9;
                    state = 4;
                    --curldapDNPos;
                    continue block9;
                }
                case 4: {
                    if (MappingObject.LDAPSEPARATOR(ldapDN.charAt(curldapDNPos))) {
                        ndsDN.append(tmp);
                        tmp = new StringBuffer();
                        state = 0;
                        if (ldapDN.charAt(curldapDNPos) == '+') {
                            ndsDN.append(MappingObject.DELIM_DV);
                            continue block9;
                        }
                        ndsDN.append(MappingObject.NDS_SEPARATOR);
                        continue block9;
                    }
                    if (MappingObject.SPACE(ldapDN.charAt(curldapDNPos))) {
                        i = 1;
                        while (MappingObject.SPACE(ldapDN.charAt(curldapDNPos + i))) {
                            ++i;
                        }
                        if (MappingObject.LDAPSEPARATOR(ldapDN.charAt(curldapDNPos + i))) {
                            curldapDNPos += i - 1;
                            continue block9;
                        }
                    }
                    if (ldapDN.charAt(curldapDNPos) != MappingObject.DELIM_DF_ESCAPE) ** GOTO lbl95
                    if (MappingObject.LDAPNEEDSESCAPE(ldapDN.charAt(curldapDNPos + 1)) || MappingObject.LDAPMAYESCAPE(ldapDN.charAt(curldapDNPos + 1))) {
                        ++curldapDNPos;
                    } else {
                        c1 = Character.toLowerCase(ldapDN.charAt(curldapDNPos + 1));
                        if (MappingObject.LDAPHEXPAIR(c1, c2 = Character.toLowerCase(ldapDN.charAt(curldapDNPos + 2)))) {
                            state = 8;
                            continue block9;
                        }
                        return retStr;
lbl95:
                        // 1 sources

                        if (MappingObject.LDAPNEEDSESCAPE(ldapDN.charAt(curldapDNPos))) {
                            return retStr;
                        }
                    }
                    if (MappingObject.NDAPNEEDSESCAPE(ldapDN.charAt(curldapDNPos))) {
                        tmp.append(MappingObject.DELIM_DF_ESCAPE);
                    }
                    tmp.append(ldapDN.charAt(curldapDNPos));
                    continue block9;
                }
                case 5: {
                    if (ldapDN.charAt(curldapDNPos) == '\"') {
                        if (ldapDN.charAt(curldapDNPos + 1) == '\u0000') {
                            ndsDN.append('\u0000');
                        }
                        state = 6;
                        continue block9;
                    }
                    if (ldapDN.charAt(curldapDNPos) == MappingObject.DELIM_DF_ESCAPE) {
                        ++curldapDNPos;
                    }
                    if (MappingObject.NDSDELIMITER(ldapDN.charAt(curldapDNPos)) || MappingObject.NDSESCAPE(ldapDN.charAt(curldapDNPos))) {
                        ndsDN.append(MappingObject.DELIM_DF_ESCAPE);
                        ndsDN.append(ldapDN.charAt(curldapDNPos));
                        continue block9;
                    }
                    ndsDN.append(ldapDN.charAt(curldapDNPos));
                    continue block9;
                }
                case 6: {
                    if (!MappingObject.LDAPSEPARATOR(ldapDN.charAt(curldapDNPos))) continue block9;
                    if (ldapDN.charAt(curldapDNPos) == '+') {
                        ndsDN.append(MappingObject.DELIM_DV);
                    } else {
                        ndsDN.append(MappingObject.NDS_SEPARATOR);
                    }
                    state = 0;
                    continue block9;
                }
                case 8: {
                    MappingObject.hexCharsToChar(c1, c2, c);
                    tmp.append(c);
                    ++curldapDNPos;
                    state = 4;
                    continue block9;
                }
                case 7: {
                    c1 = Character.toLowerCase(ldapDN.charAt(curldapDNPos));
                    c2 = Character.toLowerCase(ldapDN.charAt(curldapDNPos + 1));
                    if (MappingObject.LDAPHEXPAIR(c1, c2)) {
                        MappingObject.hexCharsToChar(c1, c2, c);
                        tmp.append(c);
                        ++curldapDNPos;
                        continue block9;
                    }
                    ndsDN.append(tmp);
                    tmp = new StringBuffer();
                    if (MappingObject.LDAPSEPARATOR(ldapDN.charAt(curldapDNPos))) {
                        state = 0;
                        if (ldapDN.charAt(curldapDNPos) == '+') {
                            ndsDN.append(MappingObject.DELIM_DV);
                            continue block9;
                        }
                        ndsDN.append(MappingObject.NDS_SEPARATOR);
                        continue block9;
                    }
                    state = 6;
                    continue block9;
                }
            }
        }
        if (tmp.length() > 0) {
            ndsDN.append(tmp);
        }
        retStr = new String(ndsDN);
        return retStr;
    }

    public String NDSNameToLDAPName(ObjectEntry ndsOE) {
        String ndsNameString = this.ndsns.getFullyTypedName(ndsOE);
        return this.NDSNameToLDAPName(ndsNameString);
    }

    public String NDSNameToLDAPName(String NDSName_s) {
        int tmpDNLen;
        StringBuffer ldapDN = new StringBuffer();
        StringBuffer ndsDN = new StringBuffer(NDSName_s);
        String retStr = new String();
        int curndsDNPos = 0;
        int state = 0;
        if (ndsDN.charAt(curndsDNPos) == '.') {
            ++curndsDNPos;
        }
        if ((tmpDNLen = ndsDN.length()) >= 2 && ndsDN.charAt(tmpDNLen - 1) == '.' && ndsDN.charAt(tmpDNLen - 2) != '\\') {
            ndsDN.deleteCharAt(tmpDNLen - 1);
        }
        while (curndsDNPos < ndsDN.length()) {
            if (ldapDN.length() >= 256) {
                return retStr;
            }
            switch (state) {
                case 0: {
                    int tmpcurndsDNPos = curndsDNPos;
                    while (ndsDN.charAt(tmpcurndsDNPos) != '=') {
                        ++tmpcurndsDNPos;
                    }
                    if (tmpcurndsDNPos == curndsDNPos) {
                        return retStr;
                    }
                    char[] tmpBuf = new char[tmpcurndsDNPos - curndsDNPos];
                    ndsDN.getChars(curndsDNPos, tmpcurndsDNPos, tmpBuf, 0);
                    String ndsAttrName = new String(tmpBuf);
                    if (ndsAttrName == null) {
                        return retStr;
                    }
                    String[] ldapAttrNameArr = this.NDSAttributeToLDAP(ndsAttrName);
                    if (ldapAttrNameArr[0].length() == 0) {
                        return retStr;
                    }
                    ldapDN.append(ldapAttrNameArr[0]);
                    ldapDN.append('=');
                    curndsDNPos = tmpcurndsDNPos;
                    while (ndsDN.charAt(tmpcurndsDNPos) != '=' && !MappingObject.SPACE(ndsDN.charAt(tmpcurndsDNPos))) {
                        ++curndsDNPos;
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    if (ndsDN.charAt(curndsDNPos) == ' ' || ndsDN.charAt(curndsDNPos) == '#') {
                        ldapDN.append(DELIM_DF_ESCAPE);
                        ldapDN.append(ndsDN.charAt(curndsDNPos));
                        state = 4;
                        break;
                    }
                    state = 4;
                }
                case 4: {
                    if (MappingObject.NDSESCAPE(ndsDN.charAt(curndsDNPos))) {
                        ++curndsDNPos;
                    }
                    if ((ndsDN.charAt(curndsDNPos) == NDS_SEPARATOR || ndsDN.charAt(curndsDNPos) == DELIM_DV) && ndsDN.charAt(curndsDNPos - 1) != DELIM_DF_ESCAPE) {
                        if (MappingObject.SPACE(ldapDN.charAt(ldapDN.length() - 1))) {
                            char c = ldapDN.charAt(ldapDN.length() - 1);
                            ldapDN.insert(ldapDN.length() - 1, DELIM_DF_ESCAPE);
                            ldapDN.append(c);
                        }
                        state = 0;
                        if (ndsDN.charAt(curndsDNPos) == NDS_SEPARATOR) {
                            ldapDN.append(',');
                            break;
                        }
                        ldapDN.append('+');
                        break;
                    }
                    if (MappingObject.LDAPNEEDSESCAPE(ndsDN.charAt(curndsDNPos))) {
                        ldapDN.append(DELIM_DF_ESCAPE);
                    }
                    ldapDN.append(ndsDN.charAt(curndsDNPos));
                    break;
                }
                default: {
                    return retStr;
                }
            }
            ++curndsDNPos;
        }
        retStr = new String(ldapDN);
        return retStr;
    }
}

