/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.emframe.dev.BookException;
import com.novell.emframe.dev.Chapter;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PageOrderedComparator;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.PropertyBookPage;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwPropertyPageContext;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.HiddenPluginsInfo;
import com.novell.emframe.fw.legacySupport.LegacyTaskContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public abstract class PropertyBook
extends Task
implements Runnable {
    private static final String KEY_PAGE_ASSIGNMENT = "page-assignment";
    private static final String KEY_ICON_NAME = "Book.Icon.name";
    private static final String KEY_ICON_ALT = "Book.Icon.alt";
    private static final String KEY_DISPLAY_NAME = "Task.displayName";
    private static final String PAGE_HELP_FILE = "Help.file";
    private static final String KEY_COMMAND = "nextState";
    private static final String KEY_CURRENTPAGE = "activePage";
    private static final String KEY_NEXTPAGE = "nextPage";
    private static final String KEY_NEXTPAGE_BY_PAGEID = "nextPageByPageId";
    private static final String TEMPLATE_ERROR_PAGE = "fw.ErrorPage";
    private static final String TEMPLATE_FRAME_HEADER = "fw.BookFrameHeader";
    private static final String TEMPLATE_FRAMESET = "fw.BookFrameSet";
    protected TaskContext m_context = null;
    protected HttpServletRequest m_req = null;
    protected Vector m_allPages = new Vector();
    protected Vector m_pages = new Vector();
    protected String m_command = null;
    public String m_displayName = null;
    public String m_iconUrl = null;
    public String m_iconAlt = null;
    protected Document[] m_pageDocs = null;
    protected HashMap m_initialParams = null;
    protected Hashtable m_cache = null;
    protected int m_currentPageId = -1;
    protected String[] m_handledAttributeNames = null;
    private String m_merge = null;
    protected String m_id = null;
    protected String[] m_delayedAttributes = null;
    protected String m_pageOrders = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        block14: {
            this.m_context = new PropertyBookContext((LegacyTaskContext)context, ((LegacyTaskContext)context).getResultStrings());
            this.m_req = this.m_context.getRequest();
            this.m_command = context.getRequest().getParameter(KEY_COMMAND);
            try {
                if (this.m_command == null || this.m_command.equals("initialState") || this.m_command.equals("selectTarget")) {
                    this.initialState();
                    break block14;
                }
                if (this.m_command.equals("search")) {
                    this.doSearch();
                    this.outputMisc();
                    break block14;
                }
                if (this.m_command.equals("show")) {
                    this.doShow();
                    this.outputMisc();
                    break block14;
                }
                if (this.m_command.equals("apply") || this.m_command.equals("ok")) {
                    this.doApply();
                    this.outputMisc();
                    break block14;
                }
                if (this.m_command.equals("refreshAllValues")) {
                    this.doRefresh();
                    this.outputMisc();
                    break block14;
                }
                if (this.m_command.equals("menubar")) {
                    this.outputMenubar(false);
                    this.outputMisc();
                    this.setMerge(TEMPLATE_FRAME_HEADER);
                    break block14;
                }
                if (this.m_command.equals("showPageOrder")) {
                    this.outputMenubar(true);
                    this.outputMisc();
                    ArrayList disabledPages = FwUtils.difference(this.m_allPages, this.m_pages);
                    String[] disabledIds = new String[disabledPages.size()];
                    int i = 0;
                    Iterator iter = disabledPages.iterator();
                    while (iter.hasNext()) {
                        PropertyBookPage page = (PropertyBookPage)iter.next();
                        disabledIds[i++] = "" + this.getPageIndexById(page.getId(), this.m_allPages);
                    }
                    this.m_req.setAttribute("disabledIds", (Object)disabledIds);
                    this.setMerge("fw.PageOrder");
                    break block14;
                }
                if (this.m_command.equals("savePageOrder")) {
                    this.savePageOrder();
                    this.outputData("GeneralMsg.Url", "javascript: window.close()");
                    this.setMerge("dev.GenConf");
                    break block14;
                }
                if (this.m_command.equals("progress")) {
                    this.updateMooProgressDialog();
                    break block14;
                }
                if (this.m_command.equals("progress.cancel")) {
                    this.abortMooUpdate();
                    break block14;
                }
                if (this.m_command.equals("refresh")) {
                    this.refresh();
                    this.doShow();
                    this.outputMisc();
                    break block14;
                }
                throw new Exception("Invalid value for nextstate: " + this.m_command);
            }
            catch (Throwable e) {
                PropertyBook.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                this.outputData("GeneralMsg.Mode", "fatal");
                this.setUIPage("dev/GenErr.jsp");
                return true;
            }
        }
        this.setUIPage(this.m_merge.replace('.', '/') + ".jsp");
        return true;
    }

    private void doRefresh() throws BookException {
        D.log("Refreshing . . . ");
        this.m_req.setAttribute("isRefresh", (Object)"true");
        String nextPage = PropertyBook.getParameter(this.m_req, KEY_NEXTPAGE_BY_PAGEID);
        int nextPageId = nextPage != null ? this.getPageIndexById(nextPage) : PropertyBook.getParameterAsInt(this.m_req, KEY_NEXTPAGE);
        if (nextPageId < 0) {
            D.assrt(false, "PropertyBook: No page to show");
            String header = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgTitleDefault", this.m_context);
            String body = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgBodyDefault", this.m_context);
            throw new BookException(header, body);
        }
        this.showPage(nextPageId);
    }

    private void savePageOrder() {
        String[] pageIndices = eMFrameUtils.unpack(this.m_req.getParameter("pageOrder"), this.m_context);
        String pack = eMFrameUtils.pack(this.convertToRealIds(pageIndices), this.m_context);
        this.m_context.setPersistentData("fwPrefs", this.getPrefrencesKey() + ".pageOrder", pack);
        pageIndices = eMFrameUtils.unpack(this.m_req.getParameter("disabledPages"), this.m_context);
        pack = eMFrameUtils.pack(this.convertToRealIds(pageIndices), this.m_context);
        this.m_context.setPersistentData("fwPrefs", this.getPrefrencesKey() + ".disabledPages", pack);
        this.setLocalizedSuccessMessage("FwResources", "Success", "Book.PageOrderSave");
    }

    private String[] convertToRealIds(String[] pageIndices) {
        String[] ids = new String[pageIndices.length];
        for (int i = 0; i < pageIndices.length; ++i) {
            int index = Integer.parseInt(pageIndices[i]);
            PropertyBookPage page = (PropertyBookPage)this.m_allPages.elementAt(index);
            ids[i] = page.getId();
        }
        return ids;
    }

    private void initialState() throws BookException {
        String initialPageId;
        String pack;
        String[] pageOrder;
        ArrayList<String> allDelayedAttributes = new ArrayList<String>();
        Iterator iter = this.m_pages.iterator();
        while (iter.hasNext()) {
            PropertyBookPage page = (PropertyBookPage)iter.next();
            String[] delayedAttributes = page.getDelayedAttributes();
            if (delayedAttributes == null) continue;
            for (int i = 0; i < delayedAttributes.length; ++i) {
                allDelayedAttributes.add(delayedAttributes[i]);
            }
        }
        this.m_delayedAttributes = allDelayedAttributes.toArray(new String[allDelayedAttributes.size()]);
        boolean valid = this.readData();
        if (!valid) {
            if (this.m_iconUrl != null) {
                this.outputData("Task.Icon.name", this.m_iconUrl);
            }
            if (this.m_iconAlt != null) {
                this.outputData("Task.Icon.alt", this.m_iconAlt);
            }
            this.doSearch();
            this.outputMisc();
            return;
        }
        this.instantiatePages();
        if (this.m_pageOrders != null && (pageOrder = this.m_pageOrders.split(",")) != null) {
            Collections.sort(this.m_pages, new PageOrderedComparator(pageOrder));
        }
        if ((pack = this.m_context.getPersistentData("fwPrefs", this.getPrefrencesKey() + ".pageOrder")) != null) {
            String[] order = eMFrameUtils.unpack(pack, this.m_context);
            Collections.sort(this.m_pages, new PageOrderedComparator(order));
        }
        this.m_allPages.addAll(this.m_pages);
        pack = this.m_context.getPersistentData("fwPrefs", this.getPrefrencesKey() + ".disabledPages");
        if (pack != null) {
            String[] disabledPageIds = eMFrameUtils.unpack(pack, this.m_context);
            Iterator iter2 = this.m_pages.iterator();
            block4: while (iter2.hasNext()) {
                PropertyBookPage propertyBookPage = (PropertyBookPage)iter2.next();
                for (int i = 0; i < disabledPageIds.length; ++i) {
                    if (!propertyBookPage.getId().equals(disabledPageIds[i])) continue;
                    iter2.remove();
                    continue block4;
                }
            }
        }
        if (this.m_pages == null || this.m_pages.size() < 1) {
            String strError = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "Book.NoPagesMessage", this.m_context);
            throw new BookException(strError, strBody);
        }
        Vector<String> unsupportedPages = new Vector<String>();
        Vector<String> supportedAttr = new Vector<String>();
        Vector<String> goodAttrs = new Vector<String>();
        boolean pageDirty = false;
        AdminNamespace ns = DirUtils.getAdminNamespace(this.m_context);
        if (ns instanceof LDAPNamespace) {
            try {
                Iterator iterator = this.m_pages.iterator();
                while (iterator.hasNext()) {
                    PropertyBookPage propertyBookPage = (PropertyBookPage)iterator.next();
                    pageDirty = false;
                    supportedAttr = new Vector();
                    String[] attributesFromPage = propertyBookPage.getHandledAttributeNames();
                    if (attributesFromPage == null) continue;
                    for (int i = 0; i < attributesFromPage.length; ++i) {
                        if (!ns.isSupported("attr", (Object)attributesFromPage[i])) {
                            if (unsupportedPages.contains(propertyBookPage.getId())) continue;
                            unsupportedPages.add(propertyBookPage.getId());
                            iterator.remove();
                            pageDirty = true;
                            continue;
                        }
                        supportedAttr.add(attributesFromPage[i]);
                    }
                    if (!pageDirty) continue;
                    goodAttrs.addAll(supportedAttr);
                }
            }
            catch (Exception e) {
                PropertyBook.log(e);
            }
        }
        ArrayList<String> allHandledAtts = new ArrayList<String>();
        Iterator iterator = this.m_pages.iterator();
        while (iterator.hasNext()) {
            PropertyBookPage propertyBookPage = (PropertyBookPage)iterator.next();
            String[] attributesFromPage = propertyBookPage.getHandledAttributeNames();
            if (attributesFromPage == null) continue;
            for (int i = 0; i < attributesFromPage.length; ++i) {
                allHandledAtts.add(attributesFromPage[i]);
            }
        }
        this.m_handledAttributeNames = allHandledAtts.toArray(new String[allHandledAtts.size()]);
        if (goodAttrs.size() > 0) {
            Vector<String> tempAttrs = new Vector<String>();
            for (int i = 0; i < this.m_handledAttributeNames.length; ++i) {
                if (goodAttrs.contains(this.m_handledAttributeNames[i])) continue;
                tempAttrs.add(this.m_handledAttributeNames[i]);
            }
            this.m_handledAttributeNames = tempAttrs.toArray(new String[tempAttrs.size()]);
        }
        if ((initialPageId = (String)this.m_initialParams.get("initialPageId")) == null) {
            this.outputData(KEY_CURRENTPAGE, "0");
        } else {
            int pageIndex = this.getPageIndexById(initialPageId);
            if (pageIndex < 0) {
                PropertyBook.printErrorMessage("Could not find page: " + initialPageId);
                this.outputData(KEY_CURRENTPAGE, "0");
            } else {
                this.outputData(KEY_CURRENTPAGE, "" + pageIndex);
            }
        }
        this.setMerge(TEMPLATE_FRAMESET);
    }

    protected String getPrefrencesKey() {
        return "fw.PropertyBook." + this.m_id;
    }

    public void init(TaskContext context, Document doc) {
        this.m_displayName = eMFrameUtils.getDisplayName(doc, (MContext)context);
        this.m_id = doc.getRootElement().getChildTextTrim("id");
        Properties params = eMFrameUtils.getUrlParams(doc);
        this.m_iconUrl = params.getProperty(KEY_ICON_NAME);
        this.m_iconAlt = params.getProperty(KEY_ICON_ALT);
        ListIterator iter = doc.getRootElement().getChildren(KEY_PAGE_ASSIGNMENT).listIterator();
        Document pagedoc = null;
        ArrayList<Document> temp = new ArrayList<Document>();
        while (iter.hasNext()) {
            Element currentPage = (Element)iter.next();
            String strId = currentPage.getTextTrim();
            pagedoc = GlobalRegistry.getPluginDocument(strId);
            if (pagedoc != null) {
                temp.add(pagedoc);
                continue;
            }
            PropertyBook.printErrorMessage("Could not find XML description of page: " + strId);
        }
        this.m_pageDocs = new Document[temp.size()];
        this.m_pageDocs = temp.toArray(this.m_pageDocs);
        Element pageOrdersElement = doc.getRootElement().getChild("pageOrders");
        if (pageOrdersElement != null) {
            this.m_pageOrders = pageOrdersElement.getTextTrim();
        }
        this.m_initialParams = new HashMap();
        HttpServletRequest req = context.getRequest();
        Enumeration myenum = req.getParameterNames();
        String key = null;
        while (myenum.hasMoreElements()) {
            key = (String)myenum.nextElement();
            this.m_initialParams.put(key, req.getParameter(key));
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        TaskContext context = eMFrameFactory.getTaskContext(req);
        Document doc = FwUtils.getTaskDocument(context, sServiceName);
        Element root = doc.getRootElement();
        List children = doc.getRootElement().getChildren("supported-device-type");
        if (children != null && children.size() > 0) {
            ArrayList<String> supportedDevices = new ArrayList<String>();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                supportedDevices.add(element.getTextTrim());
            }
            String device = (String)req.getSession().getAttribute("DeviceType");
            if (!supportedDevices.contains(device)) {
                throw new Exception("Device not supported");
            }
        } else {
            List list = root.getChildren(KEY_PAGE_ASSIGNMENT);
            Iterator iter = list.iterator();
            ArrayList hiddenTasks = (ArrayList)context.getAuthAttribute("fw.HiddenTasks");
            boolean hasPage = false;
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String pageId = element.getTextTrim();
                Document pageDoc = GlobalRegistry.getPluginDocument(pageId);
                if (pageDoc == null) continue;
                Throwable error = FwUtils.callVerifyForDeviceMethod(context, pageDoc);
                if (error == null) {
                    hasPage = true;
                    continue;
                }
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "Book.pageUnavailable", context);
                hiddenTasks.add(new HiddenPluginsInfo(error, pageDoc, roleName));
            }
            if (!hasPage) {
                throw new PluginException(null, eMFrameUtils.getLocalizedString("FwResources", "Book.noPagesSuceededIsPluginAvailable", context));
            }
        }
    }

    protected void addPage(PropertyBookPage page) {
        page.m_propertyBook = this;
        if (page.getChapter() == null) {
            page.setChapter(Chapter.createChapter("base.other", "com.novell.emframe.base.resources.BaseResourceBundle", "OtherChapterName"));
        }
        this.m_pages.addElement(page);
    }

    protected PropertyBookPage getPage(int index) {
        return (PropertyBookPage)this.m_pages.elementAt(index);
    }

    protected void instantiatePages() throws BookException {
        if (this.m_pageDocs == null || this.m_pageDocs.length < 1) {
            String strHeader = eMFrameUtils.getLocalizedString("FwResources", "Book.noPages", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "Book.noPagesDetails", this.m_context);
            throw new BookException(strHeader, strBody);
        }
        for (int pageIndex = 0; pageIndex < this.m_pageDocs.length; ++pageIndex) {
            PropertyBookPage p = this.getInstance(this.m_pageDocs[pageIndex]);
            if (p == null) continue;
            try {
                this.addPage(p);
                continue;
            }
            catch (Throwable e) {
                D.log("Unabled to add page: id=" + this.m_pageDocs[pageIndex].getRootElement().getChildTextTrim("id"));
                D.log(e);
            }
        }
    }

    protected PropertyBookPage getInstance(Document doc) {
        return this.getInstance(doc, true);
    }

    protected PropertyBookPage getInstance(Document doc, boolean verifyDevice) {
        String strPageClassName = null;
        String strPageId = null;
        PropertyBookPage p = null;
        try {
            strPageId = doc.getRootElement().getChildTextTrim("id");
            if (strPageId == null || strPageId.length() < 1) {
                PropertyBook.printErrorMessage("Skipping page because it has no id.");
                return null;
            }
            strPageClassName = eMFrameUtils.getClassName(doc);
            if (strPageClassName == null || strPageClassName.length() < 1) {
                PropertyBook.printErrorMessage("skippin page (" + strPageId + ") because it is missing a class-name");
                return null;
            }
            if (verifyDevice && FwUtils.callVerifyForDeviceMethod(this.m_context, doc) != null) {
                PropertyBook.printErrorMessage("skipping page (" + strPageId + ") because it does not run in the current environment or support the current device");
                return null;
            }
            Class<?> commandClass = Class.forName(strPageClassName);
            p = (PropertyBookPage)commandClass.newInstance();
            p.init(this.m_context, doc);
        }
        catch (Throwable e) {
            PropertyBook.printErrorMessage("PropertyBook: Could not instanciate page class: " + strPageClassName + " Skipping page: " + strPageId);
            PropertyBook.log(e);
            return null;
        }
        return p;
    }

    private final void outputMenubar(boolean all) {
        Integer chapterIndex;
        Hashtable<String, Integer> hChapterIndex = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hPageIndex = new Hashtable<String, Integer>();
        int chapterCounter = 0;
        Vector pages = all ? this.m_allPages : this.m_pages;
        this.m_context.getRequest().setAttribute("pages", (Object)pages);
        int size = pages.size();
        for (int index = 0; index < size; ++index) {
            Integer pageIndex;
            PropertyBookPage currentPage = (PropertyBookPage)pages.get(index);
            Chapter currentChapter = currentPage.getChapter();
            chapterIndex = (Integer)hChapterIndex.get(currentChapter.getId());
            if (chapterIndex == null) {
                chapterIndex = new Integer(chapterCounter);
                ++chapterCounter;
                hChapterIndex.put(currentChapter.getId(), chapterIndex);
            }
            if ((pageIndex = (Integer)hPageIndex.get(currentChapter.getId())) == null) {
                pageIndex = new Integer(0);
                hPageIndex.put(currentChapter.getId(), pageIndex);
            }
            this.outputData("chapter." + chapterIndex + "." + pageIndex + ".name", currentPage.getName(this.m_context));
            this.outputData("chapter." + chapterIndex + "." + pageIndex + ".id", "" + index);
            hPageIndex.put(currentChapter.getId(), new Integer(pageIndex + 1));
        }
        Enumeration eChapters = hPageIndex.keys();
        Integer numberOfPages = null;
        String strChapterId = null;
        while (eChapters.hasMoreElements()) {
            strChapterId = (String)eChapters.nextElement();
            numberOfPages = (Integer)hPageIndex.get(strChapterId);
            chapterIndex = (Integer)hChapterIndex.get(strChapterId);
            this.outputData("chapter." + chapterIndex + ".count", "" + numberOfPages);
            this.outputData("chapter." + chapterIndex + ".name", "" + Chapter.getName(strChapterId, this.m_context));
        }
        this.outputData("chapter.count", "" + chapterCounter);
    }

    protected void outputMisc() throws BookException {
        this.outputData(KEY_DISPLAY_NAME, this.getDisplayName());
    }

    protected void doShow() throws BookException {
        int currentPageId = PropertyBook.getParameterAsInt(this.m_req, KEY_CURRENTPAGE);
        String nextPage = PropertyBook.getParameter(this.m_req, KEY_NEXTPAGE_BY_PAGEID);
        int nextPageId = nextPage != null ? this.getPageIndexById(nextPage) : PropertyBook.getParameterAsInt(this.m_req, KEY_NEXTPAGE);
        if (currentPageId >= 0) {
            PropertyBookPage p = this.getPage(currentPageId);
            try {
                FwPropertyPageContext pageContext = new FwPropertyPageContext(p, (FwTaskContext)((Object)this.m_context));
                p.cache(pageContext);
            }
            catch (PageException e) {
                PropertyBook.log(e);
                this.outputData("Page.error", "true");
                eMFrameUtils.setErrorMessage(e, this.m_context);
                nextPageId = currentPageId;
            }
            catch (Throwable e) {
                PropertyBook.log(e);
                this.setLocalizedErrorMessage("FwResources", "InternalError", "Book.illegalPageAction");
                this.setMerge(TEMPLATE_ERROR_PAGE);
                return;
            }
        }
        if (nextPageId < 0) {
            D.assrt(false, "PropertyBook: No page to show");
            String header = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgTitleDefault", this.m_context);
            String body = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgBodyDefault", this.m_context);
            throw new BookException(header, body);
        }
        this.showPage(nextPageId);
    }

    protected void canCommit() throws PluginException {
    }

    protected void doApply() throws PluginException {
        int currentPageId = PropertyBook.getParameterAsInt(this.m_req, KEY_CURRENTPAGE);
        if (currentPageId == -1) {
            currentPageId = 0;
        } else {
            PropertyBookPage p = this.getPage(currentPageId);
            try {
                FwPropertyPageContext pageContext = new FwPropertyPageContext(p, (FwTaskContext)((Object)this.m_context));
                p.cache(pageContext);
            }
            catch (PageException e) {
                PropertyBook.log(e);
                this.outputData("Page.error", "true");
                eMFrameUtils.setErrorMessage(e, this.m_context);
                this.showPage(currentPageId);
                return;
            }
            catch (Throwable e) {
                PropertyBook.log(e);
                this.setLocalizedErrorMessage("FwResources", "InternalError", "Book.illegalPageAction");
                this.setMerge(TEMPLATE_ERROR_PAGE);
                return;
            }
        }
        try {
            this.canCommit();
        }
        catch (PluginException e) {
            if (this.m_command.equals("ok")) {
                this.outputData("GeneralMsg.Url", "javascript: opener.parent.location = 'webacc?taskId=" + ((FwTaskContext)((Object)this.m_context)).getTaskId() + "&taskComplete=true';window.close()");
            }
            eMFrameUtils.setErrorMessage(e, this.m_context);
            this.setMerge("dev.GenErr");
            return;
        }
        if (this.shouldThreadUpdate()) {
            Thread updateThread = new Thread(this);
            updateThread.start();
            this.setMerge("fw.Progress");
            if (this.m_command.equals("apply")) {
                this.outputData("Progress.onComplete", "refreshPropertyBook");
            } else {
                this.outputData("Progress.onComplete", "closeCallingTask");
            }
        } else {
            boolean success = this.writeDataAndApplyPages(currentPageId);
            if (success) {
                if (this.m_command.equals("apply")) {
                    this.showPage(currentPageId);
                    this.setLocalizedSuccessMessage("FwResources", "Success", "ChangesSaved");
                } else {
                    this.taskCompleteFlag = true;
                    this.m_req.setAttribute("Task.frameLevel", (Object)"1");
                }
            }
        }
    }

    public void run() {
        try {
            this.writeData();
        }
        catch (Throwable e) {
            D.assrt(false, "TargetCollection.update should not have throw in Moo mode!");
            PropertyBook.log(e);
            this.setLocalizedErrorMessage("FwResources", "Book.updateFailed", "Book.internalError");
            this.setMerge(TEMPLATE_ERROR_PAGE);
        }
    }

    private boolean writeDataAndApplyPages(int currentPageId) {
        PropertyBookPage currentPage = null;
        Enumeration ePage = this.m_pages.elements();
        while (ePage.hasMoreElements()) {
            currentPage = (PropertyBookPage)ePage.nextElement();
            try {
                currentPage.canCommit(new FwPropertyPageContext(currentPage, (FwTaskContext)((Object)this.m_context)));
            }
            catch (PageException e) {
                PropertyBook.log(e);
                int pageindex = this.getPageIndexById(currentPage.getId());
                this.showPage(pageindex);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                this.outputData("Page.error", "true");
                return false;
            }
            catch (Throwable e) {
                PropertyBook.log(e);
                this.setLocalizedErrorMessage("FwResources", "Book.updateFailed", "Book.internalError");
                this.setMerge(TEMPLATE_ERROR_PAGE);
                return false;
            }
        }
        try {
            this.writeData();
        }
        catch (BookException e) {
            PropertyBook.log(e);
            this.showPage(currentPageId);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        catch (Throwable e) {
            PropertyBook.log(e);
            this.setLocalizedErrorMessage("FwResources", "Book.updateFailed", "Book.internalError");
            this.setMerge(TEMPLATE_ERROR_PAGE);
            return false;
        }
        ePage = this.m_pages.elements();
        while (ePage.hasMoreElements()) {
            currentPage = (PropertyBookPage)ePage.nextElement();
            if (!currentPage.m_IsDirty) continue;
            try {
                FwPropertyPageContext pageContext = new FwPropertyPageContext(currentPage, (FwTaskContext)((Object)this.m_context));
                currentPage.commit(pageContext);
                currentPage.m_IsDirty = false;
            }
            catch (PageException e) {
                PropertyBook.log(e);
                int pageindex = this.getPageIndexById(currentPage.getId());
                this.showPage(pageindex);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                this.outputData("Page.error", "true");
                return false;
            }
            catch (Throwable e) {
                PropertyBook.log(e);
                this.setLocalizedErrorMessage("FwResources", "Book.updateFailed", "Book.internalError");
                this.setMerge(TEMPLATE_ERROR_PAGE);
                return false;
            }
        }
        return true;
    }

    private void showPage(int pageIndex) {
        PropertyBookPage page = this.getPage(pageIndex);
        D.assrt(this.getJSPDataObjectOrNull() == null, "PropetyBook m_JSPDataObject should never be used.");
        try {
            Properties resultStrings;
            FwPropertyPageContext pageContext = new FwPropertyPageContext(page, (FwTaskContext)((Object)this.m_context));
            page.show(pageContext);
            page.m_IsDirty = true;
            String helpfile = page.getHelpFilename();
            if (page.m_JSPDataObject != null) {
                pageContext.getResultStrings().putAll((Map<?, ?>)page.m_JSPDataObject);
                page.m_JSPDataObject = null;
            }
            if ((resultStrings = pageContext.getResultStrings()) != null) {
                Enumeration<?> myenum = resultStrings.propertyNames();
                while (myenum.hasMoreElements()) {
                    String key = (String)myenum.nextElement();
                    this.m_req.setAttribute(key, (Object)resultStrings.getProperty(key));
                }
            }
            this.outputData(KEY_CURRENTPAGE, "" + pageIndex);
            this.outputData(PAGE_HELP_FILE, helpfile);
            String template = page.getTemplate();
            if (template == null && template.length() < 1) {
                PropertyBook.log("Merge template is missing");
                throw new Exception();
            }
            this.setMerge(template);
        }
        catch (PageException e) {
            PropertyBook.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            this.setMerge(TEMPLATE_ERROR_PAGE);
            this.outputData(KEY_CURRENTPAGE, "" + pageIndex);
            this.outputData("Page.error", "true");
            return;
        }
        catch (Throwable e) {
            PropertyBook.log(e);
            this.setLocalizedErrorMessage("FwResources", "InternalError", "Book.illegalPageAction");
            this.setMerge(TEMPLATE_ERROR_PAGE);
            this.outputData(KEY_CURRENTPAGE, "" + pageIndex);
            return;
        }
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    private static int getParameterAsInt(HttpServletRequest req, String key) {
        try {
            String strInteger = req.getParameter(key);
            return Integer.parseInt(strInteger);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected static void printErrorMessage(String message) {
        PropertyBook.log("======================================================================");
        PropertyBook.log("PropertyBook: " + message);
        PropertyBook.log("======================================================================");
    }

    public PropertyBookPage getPageById(String pageId) {
        int size = this.m_pages.size();
        for (int index = 0; index < size; ++index) {
            PropertyBookPage page = (PropertyBookPage)this.m_pages.get(index);
            if (!page.getId().equals(pageId)) continue;
            return page;
        }
        return null;
    }

    int getPageIndexById(String pageId) {
        return this.getPageIndexById(pageId, this.m_pages);
    }

    int getPageIndexById(String pageId, Vector pages) {
        Iterator iter = pages.iterator();
        int index = 0;
        while (iter.hasNext()) {
            PropertyBookPage page = (PropertyBookPage)iter.next();
            if (page.getId().equals(pageId)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getInitialParameter(String key) {
        return (String)this.m_initialParams.get(key);
    }

    public Hashtable getCache() {
        if (this.m_cache == null) {
            this.m_cache = new Hashtable();
        }
        return this.m_cache;
    }

    protected abstract boolean readData() throws BookException;

    protected abstract void writeData() throws BookException;

    protected abstract void doSearch();

    protected void updateMooProgressDialog() throws BookException {
    }

    protected void abortMooUpdate() throws BookException {
    }

    protected void refresh() throws BookException {
    }

    protected boolean shouldThreadUpdate() {
        return false;
    }

    protected final void setMerge(String merge) {
        this.m_merge = merge;
    }

    private void setLocalizedErrorMessage(String resourceFile, String headerKey, String bodyKey) {
        String strHeader = eMFrameUtils.getLocalizedString(resourceFile, headerKey, this.m_context);
        String strBody = eMFrameUtils.getLocalizedString(resourceFile, bodyKey, this.m_context);
        eMFrameUtils.setMessage("error", strHeader, strBody, this.m_context);
    }

    private void setLocalizedSuccessMessage(String resourceFile, String headerKey, String bodyKey) {
        String uiPage = this.getUIPage();
        String strHeader = eMFrameUtils.getLocalizedString(resourceFile, headerKey, this.m_context);
        String strBody = eMFrameUtils.getLocalizedString(resourceFile, bodyKey, this.m_context);
        eMFrameUtils.setMessage("success", strHeader, strBody, this.m_context);
        this.setUIPage(uiPage);
    }

    protected final void outputData(String key, String value) {
        if (key != null) {
            if (value == null) {
                value = "";
            }
            this.m_req.setAttribute(key, (Object)value);
        }
    }

    public String[] getHandledAttributeNames() {
        return this.m_handledAttributeNames;
    }

    public void release() {
        super.release();
        Iterator iterator = this.m_pages.iterator();
        while (iterator.hasNext()) {
            PropertyBookPage propertyBookPage = (PropertyBookPage)iterator.next();
            try {
                propertyBookPage.release();
            }
            catch (Throwable e) {
                D.log(e);
            }
        }
    }

    protected static void log(String message) {
        D.log(message);
    }

    protected static void log(Throwable e) {
        D.log(e);
    }

    public boolean isAttributeSupported(String attributeName) throws BookException {
        AdminNamespace ns = DirUtils.getAdminNamespace(this.m_context);
        try {
            if (ns.isSupported("attr", (Object)attributeName)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BookException(e);
        }
        return false;
    }

    class PropertyBookContext
    extends LegacyTaskContext {
        private Properties m_data;

        PropertyBookContext(LegacyTaskContext context, Properties data) {
            super((FwTaskContext)FwUtils.getMContext(context.getRequest()));
            this.m_data = data;
            this.makeLike(context);
        }

        public Properties getResultStrings() {
            return this.m_data;
        }
    }
}

