/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.Chapter;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.Plugin;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.PropertyBook;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public abstract class PropertyBookPage
extends Plugin {
    public PropertyBook m_propertyBook = null;
    public boolean m_IsDirty = false;
    protected Chapter m_chapter = null;
    protected Properties m_parameters = null;
    protected String m_helpfile = null;
    protected Document m_pageDoc = null;
    protected String m_displayName = null;
    protected String m_template = null;
    protected String m_id = null;
    public boolean m_isXML = false;
    protected String[] m_handledAttributeNames = null;
    protected String[] m_delayedAttributes = null;
    protected Properties m_JSPDataObject = null;

    public void init(PluginContext context, Document doc) {
        Element root = doc.getRootElement();
        this.m_helpfile = root.getChildTextTrim("help-file");
        Element chapter = root.getChild("chapter");
        if (chapter != null) {
            String chapterId = chapter.getChildTextTrim("id");
            String resourceKey = chapter.getChildTextTrim("display-name-key");
            String resourceBundle = chapter.getChildTextTrim("resource-properties-file");
            if (chapterId != null && chapterId.length() > 0) {
                this.m_chapter = Chapter.createChapter(chapterId, resourceBundle, resourceKey);
            }
        }
        List list = root.getChildren("handled-attribute-name");
        ArrayList<String> attributeNames = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            attributeNames.add(element.getTextTrim());
        }
        ArrayList<String> delayedAttributes = new ArrayList<String>();
        List delayedElements = root.getChildren("delayed-attributes");
        Iterator iter = delayedElements.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            delayedAttributes.add(element.getTextTrim());
        }
        this.m_delayedAttributes = delayedAttributes.toArray(new String[delayedAttributes.size()]);
        this.m_handledAttributeNames = attributeNames.toArray(new String[attributeNames.size()]);
        this.m_pageDoc = doc;
        this.m_displayName = eMFrameUtils.getDisplayName(root, (MContext)context);
        this.m_template = root.getChildTextTrim("merge-template");
        this.m_id = root.getChildTextTrim("id");
        this.m_isXML = root.getChild("xml") != null;
    }

    public Chapter getChapter() {
        return this.m_chapter;
    }

    public void setChapter(Chapter chapter) {
        this.m_chapter = chapter;
    }

    public String getHelpFilename() {
        return this.m_helpfile;
    }

    public String getName(TaskContext context) {
        return this.m_displayName;
    }

    public String getTemplate() {
        return this.m_template;
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id;
        }
        return this.getClass().getName();
    }

    public void show(PropertyPageContext context) throws PageException {
        this.show(context, context.getResultStrings());
    }

    public void show(TaskContext context, Properties resultStrings) throws PageException {
    }

    public void cache(PropertyPageContext context) throws PageException {
        this.save(context, context.getResultStrings());
    }

    public void save(TaskContext context, Properties resultStrings) throws PageException {
    }

    public void commit(PropertyPageContext context) throws PageException {
        this.apply(context, context.getResultStrings());
    }

    public void apply(TaskContext context, Properties resultStrings) throws PageException {
    }

    public void canCommit(TaskContext context, Properties resultStrings) throws PageException {
    }

    public void canCommit(PropertyPageContext context) throws PageException {
        this.canCommit(context, context.getResultStrings());
    }

    public void release() {
    }

    public String[] getHandledAttributeNames() {
        return this.m_handledAttributeNames;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Document doc = GlobalRegistry.getPluginDocument(sServiceName);
        List children = doc.getRootElement().getChildren("supported-device-type");
        ArrayList<String> supportedDevices = new ArrayList<String>();
        if (children == null || children.size() == 0) {
            supportedDevices.add("browser");
            supportedDevices.add("mozilla");
            supportedDevices.add("default");
        } else {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                supportedDevices.add(element.getTextTrim());
            }
        }
        String device = (String)req.getSession().getAttribute("DeviceType");
        if (!supportedDevices.contains(device)) {
            throw new Exception("Device not supported");
        }
    }

    public String[] getDelayedAttributes() {
        return this.m_delayedAttributes;
    }
}

