/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.legacySupport.LegacyTaskContext;
import com.novell.emframe.fw.legacySupport.LegacyTaskImpl;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;

public abstract class Task
extends LegacyTaskImpl {
    public static final String NOT_CHANGED = "notChanged";
    boolean inInitialState = false;
    public HttpServletResponse res = null;
    public String onCompleteString = null;
    public String onCancelString = null;
    public Hashtable nextTaskExtraParameters = null;
    public Hashtable repeatParams = null;
    protected boolean initialized = false;
    public boolean taskCompleteFlag = false;

    public abstract boolean execute(TaskContext var1, Properties var2);

    public void init(PluginContext context, Document doc) {
        D.log("---- called init(PluginContext, Document) ---");
        if (Boolean.TRUE != (Boolean)FwAttr.getFwRequestAttribute("CalledInitWithPluginContextFromInitWithTaskContext", context.getRequest())) {
            FwAttr.setFwRequestAttribute("CalledInitWithTaskContextFromInitWithPluginContext", Boolean.TRUE, context.getRequest());
            this.init((TaskContext)context, doc);
        }
    }

    public void init(TaskContext context, Document doc) {
        D.log("---- called init(TaskContext, Document) ---");
        if (Boolean.TRUE != (Boolean)FwAttr.getFwRequestAttribute("CalledInitWithTaskContextFromInitWithPluginContext", context.getRequest())) {
            FwAttr.setFwRequestAttribute("CalledInitWithPluginContextFromInitWithTaskContext", Boolean.TRUE, context.getRequest());
            this.init((PluginContext)context, doc);
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public static void isPluginAvailable(PluginContext context, Document doc) throws PluginException {
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) {
        this.getManagementServiceSet().getSessionCache().put("dev.HttpServletResponse", resp);
        this.res = resp;
        this.execute(req);
        if (req != null && req.getHeader("User-Agent").indexOf("Novell Wireless iManager") != -1) {
            this.handleMidpDevice(req, resp);
        }
    }

    private void handleMidpDevice(HttpServletRequest req, HttpServletResponse resp) {
        String taskId = req.getParameter("taskId");
        TaskContext context = eMFrameFactory.getTaskContext(req);
        Properties resultStrings = ((FwTaskContext)((Object)context)).getResultStrings();
        if (taskId != null && taskId.equals("fw.SilentAuthenticate")) {
            resultStrings.put("fw.Session", req.getSession().getId());
        }
        Set<Object> keyset = resultStrings.keySet();
        String[] keys = keyset.toArray(new String[keyset.size()]);
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = resultStrings.getProperty(keys[i]);
        }
        String keyPack = eMFrameUtils.pack(keys, context);
        String valPack = eMFrameUtils.pack(values, context);
        String[] array = new String[]{keyPack, valPack};
        String data = eMFrameUtils.pack(array, context);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream()));
            D.log("Response: " + data.toString());
            writer.write(data.toString());
            ((Writer)writer).close();
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    public void execute(HttpServletRequest origReq) {
        String taskIdParam;
        if (origReq == null) {
            this.inInitialState = true;
            return;
        }
        this.m_JSPDataObject = null;
        FwUtils.setBGI(origReq, (LegacyTask)((Object)this));
        String nextState = Task.getParameter(origReq, "nextState");
        if (this.inInitialState && nextState == null) {
            this.inInitialState = false;
            ((FwRequest)origReq).setParameter("nextState", "initialState");
        }
        if ((taskIdParam = Task.getParameter(origReq, "taskId")) == null) {
            taskIdParam = this.getTaskId();
            ((FwRequest)origReq).setParameter("taskId", taskIdParam);
        }
        if (!this.getTaskId().equalsIgnoreCase(taskIdParam)) {
            D.log("Starting task '" + this.getTaskId() + "' taskId on the request is '" + taskIdParam + "':");
        } else {
            D.log("Starting task '" + taskIdParam + "':");
        }
        I18NServletRequest req = (I18NServletRequest)origReq;
        LegacyTaskContext context = (LegacyTaskContext)eMFrameFactory.getTaskContext((HttpServletRequest)req);
        try {
            Properties resultStrings = context.getResultStrings();
            this.setUIPage(NOT_CHANGED);
            String taskId = this.getGadgetInstanceID();
            Document doc = FwUtils.getTaskDocument(context, taskId);
            nextState = Task.getParameter((HttpServletRequest)req, "nextState");
            if (nextState != null && nextState.equalsIgnoreCase("initialState")) {
                Task.addAllUrlParams(doc, req);
            }
            if (!this.isInitialized()) {
                try {
                    FwAttr.removeFwRequestAttribute("CalledInitWithPluginContextFromInitWithTaskContext", (HttpServletRequest)req);
                    FwAttr.removeFwRequestAttribute("CalledInitWithTaskContextFromInitWithPluginContext", (HttpServletRequest)req);
                    this.init(context, doc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setInitialized(true);
            }
            boolean executeReturn = false;
            try {
                String paramTaskId = Task.getParameter((HttpServletRequest)req, "taskId");
                String firstTime = Task.getParameter((HttpServletRequest)req, "firstTime");
                if (!(paramTaskId == null || !paramTaskId.equals("fw.HomePage") || firstTime != null && firstTime.equals("true") || this.getGadgetInstanceID().equalsIgnoreCase("fw.HomePage"))) {
                    this.processTaskComplete((HttpServletRequest)req);
                    executeReturn = true;
                } else if (paramTaskId.startsWith(this.getGadgetInstanceID()) && Task.getParameter((HttpServletRequest)req, "taskComplete") != null && Task.getParameter((HttpServletRequest)req, "taskComplete").equals("true")) {
                    this.processTaskComplete((HttpServletRequest)req);
                    executeReturn = true;
                } else {
                    executeReturn = this.execute(context, resultStrings);
                    if (this.taskCompleteFlag) {
                        this.processTaskComplete((HttpServletRequest)req);
                    }
                }
            }
            catch (Throwable e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, context);
            }
            this.finishCleanup(req, executeReturn, context);
        }
        catch (Throwable e) {
            D.log("Task terminated with error:");
            D.log(e);
            eMFrameUtils.setErrorMessage(e, context);
            D.log("<<<-----------------------------------------------");
        }
    }

    public static final String getParameter(HttpServletRequest req, String paramName) {
        return req.getParameter(paramName);
    }

    private static final void addUrlParamToRequest(Document doc, I18NServletRequest req, String paramName, String urlParamName) {
        if (doc != null) {
            Element el;
            Element root = doc.getRootElement();
            if ((Task.getParameter((HttpServletRequest)req, paramName) == null || paramName.equals("nextState") && req.getParameter(paramName) != null && req.getParameter(paramName).equals("initialState")) && (el = root.getChild(urlParamName)) != null) {
                String merge = el.getTextTrim();
                req.setParameter(paramName, merge);
            }
        }
    }

    public static final void addAllUrlParams(Document doc, I18NServletRequest req) {
        Task.addUrlParamToRequest(doc, req, "merge", "merge-template");
        Task.addUrlParamToRequest(doc, req, "error", "error-template");
        Task.addUrlParamToRequest(doc, req, "nextState", "initial-state");
        Properties params = eMFrameUtils.getUrlParams(doc);
        Enumeration<Object> keys = params.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("")) continue;
            String value = params.getProperty(key);
            if (req.getParameter(key) != null) continue;
            req.setParameter(key, value);
            req.setAttribute(key, value);
        }
    }

    private void processTaskComplete(HttpServletRequest req) throws GadgetInstanceException {
        this.returnToPrimary(req, null);
    }

    private void finishCleanup(I18NServletRequest req, boolean executeReturn, FwTaskContext context) {
        String template = null;
        if (this.getUIPage().equalsIgnoreCase(NOT_CHANGED) && (template = executeReturn ? Task.getParameter((HttpServletRequest)req, "merge") : Task.getParameter((HttpServletRequest)req, "error")) == null) {
            template = "fw.HomePage";
        }
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String key = (String)params.nextElement();
            String value = Task.getParameter((HttpServletRequest)req, key);
            if (key.equals("merge") || key.equals("error") || ((FwRequest)((Object)req)).getAttribute(key, true, false) != null) continue;
            req.setAttribute(key, value);
        }
        Properties legacyJSPDataObject = this.getJSPDataObjectOrNull();
        if (legacyJSPDataObject != null) {
            context.getResultStrings().putAll((Map<?, ?>)legacyJSPDataObject);
            this.m_JSPDataObject = null;
        }
        req.setAttribute("jspData", context.getResultStrings());
        if (template != null) {
            template = template.replace('.', '/');
            template = template + ".jsp";
            this.setUIPage(template);
        }
        D.log(this.getDocument());
    }

    public static String buildQueryString(HttpServletRequest req, boolean removeSearchParams) {
        StringBuffer buf = new StringBuffer();
        buf.append(req.getRequestURI());
        if (req != null) {
            Enumeration names = req.getParameterNames();
            ArrayList<String> tmp = new ArrayList<String>();
            String name = null;
            String[] values = null;
            while (names != null && names.hasMoreElements()) {
                name = (String)names.nextElement();
                if (name == null || name.length() == 0 || removeSearchParams && (name.equalsIgnoreCase("OS.AnchorDocState") || name.equalsIgnoreCase("OS.AdvancedSelection") || name.equalsIgnoreCase("OS.CallBack") || name.equalsIgnoreCase("OS.Container") || name.equalsIgnoreCase("OS.Control") || name.equalsIgnoreCase("OS.IconName") || name.equalsIgnoreCase("OS.InitialContext") || name.equalsIgnoreCase("OS.InitialCriterion") || name.equalsIgnoreCase("OS.IsOSAllowed") || name.equalsIgnoreCase("OS.Mode") || name.equalsIgnoreCase("OS.MultiSelect") || name.equalsIgnoreCase("OS.NameFilter") || name.equalsIgnoreCase("OS.Results") || name.equalsIgnoreCase("OS.ResultsPerPage") || name.equalsIgnoreCase("OS.ReturningToAnchor") || name.equalsIgnoreCase("OS.SearchSubContainers") || name.equalsIgnoreCase("OS.SearchOnStartup") || name.equalsIgnoreCase("OS.ShowSubClasses") || name.equalsIgnoreCase("OS.TypeFilter"))) continue;
                if (name.equalsIgnoreCase("AuthenticatePassword") || name.toLowerCase().indexOf("password") != -1) {
                    tmp.add(name + "=?");
                    continue;
                }
                values = req.getParameterValues(name);
                if (values.length <= 0 || values[0] == null) continue;
                tmp.add(name + "=" + values[0]);
            }
            Collections.sort(tmp);
            boolean first = true;
            String param = null;
            for (int i = 0; i < tmp.size(); ++i) {
                param = (String)tmp.get(i);
                if (param == null || param.length() == 0) continue;
                if (!removeSearchParams) {
                    buf.append("\n    ");
                }
                if (first) {
                    buf.append("?");
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(param);
            }
        }
        return buf.toString();
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.taskShouldRunImpl(req, sServiceName);
    }

    public void release() {
    }

    public void setUIPage(String moduleStylesheet) {
        super.setUIPage(moduleStylesheet);
    }

    public String getUIPage() {
        return super.getUIPage();
    }
}

