/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.D;

public class Version {
    private int major;
    private int minor;
    private int rev;
    private String build;

    public Version() {
        this.major = 0;
        this.minor = 0;
        this.rev = 0;
        this.build = "";
    }

    public Version(String versionString) {
        this.setVersionFromVersionString(versionString);
    }

    public Version(int major, int minor, int rev) {
        this.major = major;
        this.minor = minor;
        this.rev = rev;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setRev(int rev) {
        this.rev = rev;
    }

    public int getRev() {
        return this.rev;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void incrementVersion(int major, int minor, int rev) {
        this.rev += rev;
        this.minor += minor;
        this.major += major;
        if (this.rev > 99) {
            this.rev -= 100;
            ++this.minor;
        }
        if (this.minor > 99) {
            this.minor -= 100;
            ++this.major;
        }
    }

    public int compareTo(Version version) {
        int value = this.major - version.getMajor();
        if (value == 0 && (value = this.minor - version.getMinor()) == 0) {
            value = this.rev - version.getRev();
        }
        return value;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.rev;
    }

    private void setVersionFromVersionString(String versionString) {
        String majorStr = "0";
        String minorStr = "0";
        String revStr = "0";
        if (versionString != null) {
            majorStr = versionString;
            if (versionString.indexOf(".") != -1) {
                majorStr = versionString.substring(0, versionString.indexOf("."));
                minorStr = versionString = versionString.substring(versionString.indexOf(".") + 1, versionString.length());
                if (versionString.indexOf(".") != -1) {
                    minorStr = versionString.substring(0, versionString.indexOf("."));
                    revStr = versionString = versionString.substring(versionString.indexOf(".") + 1, versionString.length());
                    if (versionString.indexOf(".") != -1) {
                        revStr = versionString.substring(0, versionString.indexOf("."));
                        if (versionString.indexOf(".") != -1) {
                            this.build = versionString.substring(0, versionString.indexOf("."));
                        }
                    }
                }
            }
        }
        try {
            this.major = Integer.parseInt(majorStr);
            this.minor = Integer.parseInt(minorStr);
            this.rev = Integer.parseInt(revStr);
        }
        catch (NumberFormatException e) {
            D.log(e);
        }
    }
}

