/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Deletor;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;

public class VetoServerDelete
extends Deletor {
    protected String m_objectName = null;
    protected String m_msg = null;
    protected String m_header = null;

    public void doDelete(ObjectEntry oe, TaskContext context) throws PluginException {
        this.m_objectName = oe.getFullName();
        this.m_msg = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.CannotDeleteServer", context);
        this.m_header = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.CannotDeleteServerHdr", context);
        D.log("--------- doDelete is called from VetoServerDelete class for object: " + this.m_objectName);
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ndsns = (NDSNamespace)treeOE.getNamespace();
        if (!ndsns.isServerUp(oe)) {
            try {
                ndsns.delete(oe);
            }
            catch (SPIException spie) {
                D.log(spie);
                String strError = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), context);
                throw new PluginException(this.m_header, strError);
            }
            catch (SnapinVetoException sve) {
                D.log(sve);
                String strError = eMFrameUtils.getExceptionMessage((Exception)((Object)sve), context);
                throw new PluginException(this.m_header, strError);
            }
        } else {
            throw new PluginException(this.m_header, this.m_msg);
        }
    }
}

