/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.D;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XmlUtils {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String EMPTY_STRING = new String("");

    public static void writeTag(String tagName, String tagValue, BufferedWriter bout) throws IOException {
        XmlUtils.writeTag(tagName, null, tagValue, bout);
    }

    public static void writeCDataTag(String tagName, String tagValue, BufferedWriter bout) throws IOException {
        XmlUtils.writeTag(tagName, null, tagValue, bout, true);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, BufferedWriter bout) throws IOException {
        XmlUtils.writeTag(tagName, tagAttributes, tagValue, bout, false);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, BufferedWriter bout, boolean bCData) throws IOException {
        if (tagName != null && bout != null) {
            XmlUtils.writeStartTag(tagName, tagAttributes, bout);
            if (tagValue != null) {
                if (bCData) {
                    tagValue = XmlUtils.encodeCDataString(tagValue);
                    bout.write(CDATA_START);
                }
                bout.write(XmlUtils.xmlEncode(tagValue));
                if (bCData) {
                    bout.write(CDATA_END);
                }
            }
            XmlUtils.writeEndTag(tagName, bout);
        }
    }

    public static void writeStartTag(String tagName, BufferedWriter bout) throws IOException {
        XmlUtils.writeStartTag(tagName, null, bout);
    }

    public static void writeStartTag(String tagName, Properties tagAttributes, BufferedWriter bout) throws IOException {
        if (tagName != null && bout != null) {
            bout.write("<");
            bout.write(tagName);
            if (tagAttributes != null) {
                Enumeration<?> myenum = tagAttributes.propertyNames();
                while (myenum.hasMoreElements()) {
                    String attrName = (String)myenum.nextElement();
                    String attrValue = tagAttributes.getProperty(attrName);
                    if (attrValue == null) continue;
                    bout.write(" ");
                    bout.write(attrName);
                    bout.write("=\"");
                    bout.write(XmlUtils.xmlEncode(attrValue));
                    bout.write("\"");
                }
            }
            bout.write(">");
        }
    }

    public static void writeEndTag(String tagName, BufferedWriter bout) throws IOException {
        bout.write("</");
        bout.write(tagName);
        bout.write(">");
    }

    public static void writeTag(String tagName, String tagValue, StringBuffer bout) {
        XmlUtils.writeTag(tagName, null, tagValue, bout);
    }

    public static void writeCDataTag(String tagName, String tagValue, StringBuffer bout) {
        XmlUtils.writeTag(tagName, null, tagValue, bout, true);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, StringBuffer bout) {
        XmlUtils.writeTag(tagName, tagAttributes, tagValue, bout, false);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, StringBuffer bout, boolean bCData) {
        if (tagName != null && bout != null) {
            XmlUtils.writeStartTag(tagName, tagAttributes, bout);
            if (tagValue != null) {
                if (bCData) {
                    tagValue = XmlUtils.encodeCDataString(tagValue);
                    bout.append(CDATA_START);
                }
                bout.append(tagValue);
                if (bCData) {
                    bout.append(CDATA_END);
                }
            }
            XmlUtils.writeEndTag(tagName, bout);
        }
    }

    public static void writeStartTag(String tagName, StringBuffer bout) {
        XmlUtils.writeStartTag(tagName, null, bout);
    }

    public static void writeStartTag(String tagName, Properties tagAttributes, StringBuffer bout) {
        if (tagName != null && bout != null) {
            bout.append("<");
            bout.append(tagName);
            if (tagAttributes != null) {
                Enumeration<?> myenum = tagAttributes.propertyNames();
                while (myenum.hasMoreElements()) {
                    String attrName = (String)myenum.nextElement();
                    String attrValue = tagAttributes.getProperty(attrName);
                    if (attrValue == null) continue;
                    bout.append(" ");
                    bout.append(attrName);
                    bout.append("=\"");
                    bout.append(XmlUtils.xmlEncode(attrValue));
                    bout.append("\"");
                }
            }
            bout.append(">");
        }
    }

    public static void writeEndTag(String tagName, StringBuffer bout) {
        bout.append("</");
        bout.append(tagName);
        bout.append(">");
    }

    private static String encodeCDataString(String sStr) {
        int iStart = 0;
        int iFind = 0;
        int iFudge = CDATA_END.length() - 1;
        while ((iFind = sStr.indexOf(CDATA_END, iStart)) != -1) {
            String sOne = sStr.substring(0, iFind + iFudge);
            String sTwo = sStr.substring(iFind + iFudge);
            sStr = sOne + CDATA_END + CDATA_START + sTwo;
            iStart = iFind + CDATA_END.length() + CDATA_START.length();
        }
        return sStr;
    }

    public static String xmlDocumentToString(Document doc) {
        ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter("   ", true);
        try {
            outputter.output(doc, (OutputStream)targetStream);
            return targetStream.toString();
        }
        catch (IOException e) {
            D.log(e);
            return "";
        }
    }

    public static String xmlDocumentToString(org.w3c.dom.Document doc) {
        try {
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(targetStream);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            return targetStream.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String xmlElementToString(org.w3c.dom.Element element) {
        try {
            DOMSource source = new DOMSource(element);
            ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(targetStream);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            return targetStream.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String xmlElementToString(Element element) {
        ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter("   ", true);
        try {
            outputter.output(element, (OutputStream)targetStream);
            return targetStream.toString();
        }
        catch (IOException e) {
            D.log(e);
            return "";
        }
    }

    public static String xmlDecode(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int charCodeLength = 10;
        int sourceLength = str.length();
        StringBuffer charCode = new StringBuffer(charCodeLength);
        StringBuffer src = new StringBuffer(str);
        StringBuffer dst = new StringBuffer(sourceLength);
        int srcIndex = 0;
        int dstIndex = 0;
        int iTmp = 0;
        while (srcIndex < sourceLength) {
            int semiColon;
            int ch;
            if ((ch = src.charAt(srcIndex++)) == 38 && srcIndex < sourceLength && src.charAt(srcIndex) == '#') {
                int n = ++srcIndex;
                ++srcIndex;
                ch = src.charAt(n);
                for (iTmp = 0; ch != 59 && iTmp < charCodeLength; ++iTmp) {
                    charCode.append((char)ch);
                    ch = src.charAt(srcIndex++);
                }
                ch = (char)Integer.parseInt(charCode.toString());
                charCode.setLength(0);
            } else if (ch == 38 && srcIndex < sourceLength && (semiColon = str.indexOf(";", srcIndex)) != -1) {
                String escape = str.substring(srcIndex, semiColon);
                srcIndex = semiColon + 1;
                if (escape.equals("amp")) {
                    ch = 38;
                } else if (escape.equals("quot")) {
                    ch = 34;
                } else if (escape.equals("gt")) {
                    ch = 62;
                } else if (escape.equals("lt")) {
                    ch = 60;
                } else if (escape.equals("apos")) {
                    ch = 39;
                } else {
                    dst.insert(dstIndex++, "&");
                    dst.insert(dstIndex, escape);
                    dstIndex += escape.length();
                    ch = 59;
                }
            }
            dst.insert(dstIndex++, (char)ch);
        }
        return dst.toString();
    }

    public static String xmlEncode(String strText) {
        return XmlUtils.stringToXML(strText);
    }

    public static String stringToXML(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        block8: for (int idx = 0; idx < len; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                case '\u001b': {
                    sb.append("&#27;");
                    continue block8;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

