/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev.config;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.GeneralConfig;
import com.novell.emframe.fw.config.ConfigManager;
import com.novell.emframe.fw.config.UserConfigManager;
import com.novell.nps.configManager.GUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class UserConfig {
    private GeneralConfig m_gc = null;
    private UserConfigManager m_ucm = null;
    private String m_sUserConfigID = null;
    private int m_iMode = 1;

    public UserConfig(String sUserConfigID, MContext ctx) {
        this.init(sUserConfigID, null, ctx);
    }

    public UserConfig(String sUserConfigID, String sObjectDN, MContext ctx) {
        this.init(sUserConfigID, sObjectDN, ctx);
    }

    public static UserConfig getUserConfig(String sUserConfigID, MContext ctx) {
        Object obj;
        UserConfig ucRet = null;
        String sKey = "dev.config.UserConfig::";
        if (sUserConfigID != null && sUserConfigID.length() > 0) {
            sKey = sKey + sUserConfigID;
        }
        if ((obj = ctx.getAuthAttribute(sKey)) == null) {
            ucRet = new UserConfig(sUserConfigID, ctx);
            ctx.setAuthAttribute(sKey, ucRet);
        } else {
            ucRet = (UserConfig)obj;
        }
        return ucRet;
    }

    public static UserConfig getUserConfig(String sUserConfigID, String sObjectDN, MContext ctx) {
        UserConfig ucRet = null;
        if (sObjectDN == null) {
            Object obj;
            String sKey = "dev.config.UserConfig::";
            if (sUserConfigID != null && sUserConfigID.length() > 0) {
                sKey = sKey + sUserConfigID;
            }
            if ((obj = ctx.getAuthAttribute(sKey)) == null) {
                ucRet = new UserConfig(sUserConfigID, ctx);
                ctx.setAuthAttribute(sKey, ucRet);
            } else {
                ucRet = (UserConfig)obj;
            }
        } else {
            ucRet = new UserConfig(sUserConfigID, sObjectDN, ctx);
        }
        return ucRet;
    }

    private void init(String sUserConfigID, String sObjectDN, MContext ctx) {
        this.m_sUserConfigID = sUserConfigID;
        this.m_iMode = ConfigManager.getMode();
        if (this.m_iMode == 1) {
            this.m_gc = new GeneralConfig(this.m_sUserConfigID);
        } else if (this.m_iMode == 2) {
            if (sObjectDN == null) {
                String sKey = "SessionUserConfigManagerMode2:" + sUserConfigID;
                Object obj = ctx.getAuthAttribute(sKey);
                if (obj == null) {
                    String sUserDN = ((iMgrAuthenticatorImpl)ctx.getAuthenticator()).getUserId(ctx);
                    this.m_ucm = new UserConfigManager(ctx, sUserDN, this.m_iMode);
                    ctx.setAuthAttribute(sKey, this.m_ucm);
                } else {
                    this.m_ucm = (UserConfigManager)obj;
                }
            } else {
                this.m_ucm = new UserConfigManager(ctx, sObjectDN, this.m_iMode);
            }
        } else if (this.m_iMode == 3) {
            if (sObjectDN == null) {
                String sKey = "SessionUserConfigManagerMode3:" + sUserConfigID;
                Object obj = ctx.getAuthAttribute(sKey);
                if (obj == null) {
                    AuthenticationBroker ab = ctx.getAuthenticationBroker();
                    String sUserDN = null;
                    try {
                        sUserDN = ab.getAuthNdapName();
                    }
                    catch (AuthBrokerException e) {
                        D.log(e);
                    }
                    this.m_ucm = new UserConfigManager(ctx, sUserDN);
                    ctx.setAuthAttribute(sKey, this.m_ucm);
                } else {
                    this.m_ucm = (UserConfigManager)obj;
                }
            } else {
                this.m_ucm = new UserConfigManager(ctx, sObjectDN, this.m_iMode);
            }
        }
    }

    public String[] getSettingNames() {
        if (this.m_ucm != null) {
            return this.m_ucm.getSettingNames(this.m_sUserConfigID);
        }
        if (this.m_gc != null) {
            return this.m_gc.getSettingNames();
        }
        return null;
    }

    public String getSetting(String sName) {
        if (this.m_ucm != null) {
            return this.m_ucm.getSingleSetting(this.m_sUserConfigID, sName);
        }
        if (this.m_gc != null) {
            return this.m_gc.getSetting(sName);
        }
        return null;
    }

    public String getSetting(String sName, String sDefaultValue) {
        if (this.m_ucm != null) {
            return this.m_ucm.getSingleSetting(this.m_sUserConfigID, sName, sDefaultValue);
        }
        if (this.m_gc != null) {
            return this.m_gc.getSetting(sName, sDefaultValue);
        }
        return sDefaultValue;
    }

    public Object getObjectSetting(String sName) {
        if (this.m_ucm != null) {
            byte[] ba;
            Object oRet = null;
            String sRet = this.getSetting(sName);
            if (sRet != null && (ba = GUID.HexStringAsByte((String)sRet)) != null && ba.length != 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(ba);
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    oRet = ois.readObject();
                }
                catch (IOException ioe) {
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            return oRet;
        }
        if (this.m_gc != null) {
            return this.m_gc.getObjectSetting(sName);
        }
        return null;
    }

    public String[] getSettings(String sName) {
        if (this.m_ucm != null) {
            return this.m_ucm.getSetting(this.m_sUserConfigID, sName);
        }
        if (this.m_gc != null) {
            return this.m_gc.getSettings(sName);
        }
        return null;
    }

    public Object[] getObjectSettings(String sName) {
        if (this.m_ucm != null) {
            Object[] oaRet = null;
            String[] saRet = this.getSettings(sName);
            if (saRet != null) {
                oaRet = new Object[saRet.length];
                for (int i = 0; i < saRet.length; ++i) {
                    byte[] ba = GUID.HexStringAsByte((String)saRet[i]);
                    if (ba == null || ba.length == 0) continue;
                    ByteArrayInputStream bais = new ByteArrayInputStream(ba);
                    try {
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        oaRet[i] = ois.readObject();
                        continue;
                    }
                    catch (IOException ioe) {
                        oaRet[i] = null;
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        oaRet[i] = null;
                    }
                }
            }
            return oaRet;
        }
        if (this.m_gc != null) {
            return this.m_gc.getObjectSettings(sName);
        }
        return null;
    }

    public void setSetting(String sName, String sValue) throws ConfigException {
        if (this.m_ucm != null) {
            this.m_ucm.setSetting(this.m_sUserConfigID, sName, sValue);
        } else if (this.m_gc != null) {
            this.m_gc.setSetting(sName, sValue);
        }
    }

    public void setObjectSetting(String sName, Object oValue) throws ConfigException {
        if (this.m_ucm != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(oValue);
                oos.flush();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            byte[] ba = baos.toByteArray();
            StringBuffer sb = new StringBuffer(ba.length * 2 + 1);
            for (int i = 0; i < ba.length; ++i) {
                sb.append(GUID.byteAsHexString((int)ba[i]));
            }
            this.m_ucm.setSetting(this.m_sUserConfigID, sName, sb.toString());
        } else if (this.m_gc != null) {
            this.m_gc.setObjectSetting(sName, oValue);
        }
    }

    public void setSetting(String sName, String[] saValues) throws ConfigException {
        if (this.m_ucm != null) {
            this.m_ucm.setSetting(this.m_sUserConfigID, sName, saValues);
        } else if (this.m_gc != null) {
            this.m_gc.setSetting(sName, saValues);
        }
    }

    public void setObjectSetting(String sName, Object[] oaValues) throws ConfigException {
        if (this.m_ucm != null) {
            String[] saValues = new String[oaValues.length];
            for (int count = 0; count < oaValues.length; ++count) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(oaValues[count]);
                    oos.flush();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                byte[] ba = baos.toByteArray();
                StringBuffer sb = new StringBuffer(ba.length * 2 + 1);
                for (int i = 0; i < ba.length; ++i) {
                    sb.append(GUID.byteAsHexString((int)ba[i]));
                }
                saValues[count] = sb.toString();
            }
            this.m_ucm.setSetting(this.m_sUserConfigID, sName, saValues);
        } else if (this.m_gc != null) {
            this.m_gc.setObjectSetting(sName, oaValues);
        }
    }

    public void addSettingValue(String sName, String sValue) throws ConfigException {
        if (this.m_ucm != null) {
            this.m_ucm.addSettingValue(this.m_sUserConfigID, sName, sValue);
        } else if (this.m_gc != null) {
            this.m_gc.addSettingValue(sName, sValue);
        }
    }

    public void removeSettingValue(String sName, String sValue) throws ConfigException {
        if (this.m_ucm != null) {
            this.m_ucm.removeSettingValue(this.m_sUserConfigID, sName, sValue);
        } else if (this.m_gc != null) {
            this.m_gc.removeSettingValue(sName, sValue);
        }
    }

    public void removeSetting(String sName) throws ConfigException {
        if (this.m_ucm != null) {
            this.m_ucm.removeSetting(this.m_sUserConfigID, sName);
        } else if (this.m_gc != null) {
            this.m_gc.removeSetting(sName);
        }
    }

    public void writeSettings() throws ConfigException {
        if (this.m_ucm != null) {
            this.m_ucm.writeSettings(this.m_sUserConfigID);
        } else if (this.m_gc != null) {
            this.m_gc.writeSettings();
        }
    }

    public String getUserConfigFileName() {
        return this.m_ucm.getUserConfigFileName(this.m_sUserConfigID);
    }
}

