/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSFileRights;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.CustomTargetChooser;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.EdasUpdateThread;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CreateObjectUtils;
import com.novell.emframe.fw.DefaultTargetChooser;
import com.novell.emframe.fw.EdasRightsData;
import com.novell.emframe.fw.FakeRightsCache;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RightsBean;
import com.novell.emframe.fw.RightsCache;
import com.novell.emframe.fw.Target;
import com.novell.emframe.fw.TargetCollection;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.studio.CreateCustomPlugin;
import com.novell.emframe.fw.util.InfoFactory;
import com.novell.emframe.fw.util.StudioUtils;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSTask;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class eDirAccessService
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String EDIR_CONNECTOR = "$";
    public static final String EDIR_KEY = "eDir$";
    public static final String EDIR_COMMAND = "eDirCommand";
    public static final String EDIR_SEARCH = "eDirSearch";
    public static final String EDIR_READ = "read";
    public static final String EDIR_WRITE = "write";
    public static final String EDIR_CREATE = "create";
    public static final String EDIR_AUX_KEY = "auxillaryClassExtension";
    public static final String MODE_ADD = "add";
    public static final String MODE_REM = "remove";
    public static final String MODE_SET = "set";
    public static final String MODE_IGN = "ignore";
    private String[] m_attributesToRead = new String[0];
    private boolean m_bigXmlOnly = false;
    private TargetCollection m_targetCollection = null;
    private Properties m_customHandlers = new Properties();
    private String m_nextMerge = null;
    private String m_modifyTask = null;
    private Document m_doc = null;
    private boolean m_isInitialized = false;

    protected void initialize(TaskContext context, Document doc) {
        if (doc != null) {
            RBSTask task;
            Properties params = eMFrameUtils.getUrlParams(doc);
            String bigXmlOnly = params.getProperty("bigXmlOnly");
            this.m_bigXmlOnly = bigXmlOnly != null && bigXmlOnly.equals("true");
            Element root = doc.getRootElement();
            Element rbsXmlInfo = root.getChild("rbs-xml-info");
            Element pluginParams = null;
            if (rbsXmlInfo != null) {
                pluginParams = rbsXmlInfo.getChild("plugin-params-compressed");
                if (pluginParams != null) {
                    try {
                        pluginParams = StudioUtils.unCompressPluginParams(pluginParams);
                    }
                    catch (Exception e) {
                        D.log(e);
                    }
                } else {
                    pluginParams = rbsXmlInfo.getChild("plugin-params");
                }
                if (pluginParams != null) {
                    this.m_modifyTask = pluginParams.getChildTextTrim("modify-task");
                }
            }
            if ((task = (RBSTask)InfoFactory.rbsTasksMap.get(doc)) != null) {
                try {
                    RBSRights[] rights = task.getRights();
                    if (rights != null) {
                        ArrayList<String> list = new ArrayList<String>(rights.length);
                        for (int i = 0; i < rights.length; ++i) {
                            String attrName = rights[i].getProtectedAttrName();
                            if (attrName.charAt(0) == '[' || attrName.equals("Password Management")) continue;
                            list.add(attrName);
                        }
                        this.m_attributesToRead = list.toArray(new String[list.size()]);
                    }
                }
                catch (SPIException e) {
                    D.log(e);
                }
            } else {
                this.m_attributesToRead = FwUtils.extractAttributesForEDAS(root);
            }
            if (this.m_nextMerge == null) {
                this.m_nextMerge = doc.getRootElement().getChildTextTrim("merge-template");
            }
            FwUtils.extractCustomDataHandlers(this.m_customHandlers, doc);
        }
        if (this.m_attributesToRead == null || this.m_attributesToRead.length == 0) {
            this.m_attributesToRead = context.getDirUtils().getSortedAttrs();
        }
    }

    public void init(TaskContext context, Document doc) {
        this.m_doc = doc;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        TaskContext context = eMFrameFactory.getTaskContext(req);
        Document doc = FwUtils.getTaskDocument(context, sServiceName);
        String fullmerge = null;
        File defaultFile = null;
        File file = null;
        try {
            fullmerge = doc.getRootElement().getChildTextTrim("merge-template");
            if (fullmerge == null || fullmerge.length() <= 0) {
                String tempTaskName = doc.getRootElement().getChildTextTrim("id");
                if (tempTaskName != null) {
                    throw new Exception("Task (" + tempTaskName + ") not installed.  Missing merge-template tag in install xml file.");
                }
                throw new Exception("Task could not be installed.  Missing merge-template tag in install xml file.");
            }
            fullmerge = fullmerge.replace('.', '/');
            String module = eMFrameUtils.getModuleFromFullName(fullmerge);
            String merge = eMFrameUtils.getPageFromFullName(fullmerge);
            String device = (String)req.getSession().getAttribute("DeviceType");
            String modulesPath = iManager.sm_sWebappRootPath + "/portal/modules";
            defaultFile = new File(modulesPath + "/" + module + "/skins/default/devices/default/" + merge + ".jsp");
            file = new File(modulesPath + "/" + module + "/skins/default/devices/" + device + "/" + merge + ".jsp");
        }
        catch (Throwable e) {
            D.log(e);
        }
        if (!file.exists() && !defaultFile.exists()) {
            throw new Exception("Task not installed.  Missing JSP file: " + fullmerge);
        }
        Task.shouldRun(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        block37: {
            TargetCollection updatingTargetCollection;
            String nextState;
            String eDirCommand;
            HttpServletRequest req = context.getRequest();
            String eDirSearch = req.getParameter(EDIR_SEARCH);
            if (eDirSearch == null) {
                eDirSearch = (String)req.getAttribute(EDIR_SEARCH);
            }
            if ((eDirCommand = req.getParameter(EDIR_COMMAND)) == null) {
                eDirCommand = (String)req.getAttribute(EDIR_COMMAND);
            }
            if (!this.m_isInitialized) {
                Task task;
                Document configDoc = this.m_doc;
                String id = req.getParameter("parentId");
                if (id != null && (task = ((FwTaskContext)((Object)context)).getLiveTask(id)) instanceof CreateCustomPlugin) {
                    Element taskElement = (Element)((CreateCustomPlugin)task).m_document.getRootElement().clone();
                    configDoc = new Document(taskElement);
                    this.m_nextMerge = req.getParameter("merge");
                }
                this.initialize(context, configDoc);
                this.m_isInitialized = true;
            }
            if ((nextState = req.getParameter("nextState")) != null && nextState.equals("progress")) {
                updatingTargetCollection = (TargetCollection)context.getAuthAttribute("updatetarget.collection");
                updatingTargetCollection.outputProgressInformation(context);
                return true;
            }
            if (nextState != null && nextState.equals("progress.cancel")) {
                updatingTargetCollection = (TargetCollection)context.getAuthAttribute("updatetarget.collection");
                try {
                    updatingTargetCollection.abortUpdate(context);
                }
                catch (Exception e) {
                    eMFrameUtils.setErrorMessage(e, context);
                    return false;
                }
                String title = eMFrameUtils.getLocalizedString("FwResources", "ProgressCanceledHeader", context);
                String body = eMFrameUtils.getLocalizedString("FwResources", "ProgressCanceledBody", context);
                eMFrameUtils.setMessage("success", title, body, context);
                return true;
            }
            try {
                String merge;
                if (eDirCommand == null) {
                    String eDirTarget = req.getParameter("eDir$target");
                    if (eDirTarget == null) {
                        eDirTarget = (String)req.getAttribute("eDir$target");
                    }
                    String targetObjects = req.getParameter("targetNames");
                    if (eDirTarget != null) {
                        eDirCommand = EDIR_READ;
                    } else if (targetObjects != null && targetObjects.length() > 0) {
                        eDirCommand = EDIR_READ;
                        ((I18NServletRequest)req).setParameter("eDir$target", targetObjects);
                    }
                }
                if (eDirCommand == null) {
                    if (eDirSearch == null || eDirSearch.length() < 0) {
                        String title = eMFrameUtils.getLocalizedString("FwResources", "EDASError", context);
                        String body = eMFrameUtils.getLocalizedString("FwResources", "EDASTemplateMissingCommand", context);
                        throw new eDirAccessServiceException(title, body);
                    }
                    if (this.m_nextMerge != null) {
                        resultStrings.put("nextMerge", this.m_nextMerge);
                    } else {
                        resultStrings.put("nextMerge", req.getParameter("merge"));
                    }
                    resultStrings.put(EDIR_SEARCH, eDirSearch);
                    this.setUIPage("dev.TC");
                    merge = null;
                    CustomTargetChooser tc = new DefaultTargetChooser();
                    try {
                        Element xmlInfo = this.m_doc.getRootElement().getChild("rbs-xml-info");
                        if (xmlInfo != null) {
                            Element customTc;
                            Element pluginParams = null;
                            pluginParams = xmlInfo.getChild("plugin-params-compressed");
                            if (pluginParams != null) {
                                try {
                                    pluginParams = StudioUtils.unCompressPluginParams(pluginParams);
                                }
                                catch (Exception e) {
                                    D.log(e);
                                }
                            } else {
                                pluginParams = xmlInfo.getChild("plugin-params");
                            }
                            if (pluginParams != null && (customTc = pluginParams.getChild("custom-target-chooser")) != null) {
                                String className = customTc.getChildTextTrim("class-name");
                                Class<?> theClass = Class.forName(className);
                                tc = (CustomTargetChooser)theClass.newInstance();
                            }
                        }
                    }
                    catch (Throwable e) {
                        D.log(e);
                    }
                    merge = ((CustomTargetChooser)tc).showTargetChooser(context, this.m_doc);
                    this.setUIPage(merge);
                    return true;
                }
                if (eDirCommand.equalsIgnoreCase(EDIR_READ)) {
                    merge = context.getRequest().getParameter("merge");
                    resultStrings.put("jspFile", merge);
                    return this.doRead(context, resultStrings);
                }
                if (eDirCommand.equals("preCreate")) {
                    String objectTypeName = context.getDirUtils().getRealName(eDirSearch);
                    if (objectTypeName == null) {
                        FwUtils.setLocalizedMessage("error", "FwResources", "Error", "EDAS.schemaGone", context);
                        this.setUIPage("dev/GenErr.jsp");
                        return true;
                    }
                    this.preCreateState(context, resultStrings, objectTypeName);
                    break block37;
                }
                if (eDirCommand.equalsIgnoreCase(EDIR_CREATE)) {
                    return this.create(context, resultStrings);
                }
                if (eDirCommand.equalsIgnoreCase(EDIR_WRITE)) {
                    return this.doWrite(context, resultStrings, req);
                }
                if (eDirCommand.equalsIgnoreCase("Apply")) {
                    merge = context.getRequest().getParameter("jspFile");
                    resultStrings.put("jspFile", merge);
                    boolean success = this.doWrite(context, resultStrings, req);
                    if (!success) {
                        return false;
                    }
                    success = this.doRead(context, resultStrings);
                    if (success) {
                        String jspFile = req.getParameter("jspFile");
                        jspFile = jspFile.replace('.', '/') + ".jsp";
                        this.setUIPage(jspFile);
                    }
                    break block37;
                }
                String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "EDASUnsupportedCommand", context);
                eMFrameUtils.formatMessage(errorMsg, new String[]{eDirCommand});
                throw new eDirAccessServiceException(eMFrameUtils.getLocalizedString("FwResources", "EDASError", context), errorMsg);
            }
            catch (Exception e) {
                D.log(e);
                try {
                    this.doRead(context, resultStrings);
                }
                catch (Exception e1) {
                    D.log(e1);
                    return false;
                }
                String jspFile = req.getParameter("jspFile");
                jspFile = jspFile.replace('.', '/') + ".jsp";
                this.setUIPage(jspFile);
                eMFrameUtils.setErrorMessage(e, context);
                return false;
            }
        }
        return true;
    }

    private boolean doWrite(TaskContext context, Properties resultStrings, HttpServletRequest req) throws eDirAccessServiceException {
        boolean success = this.preWrite(context, resultStrings);
        if (!success) {
            return false;
        }
        TargetCollection targetCollection = new TargetCollection();
        targetCollection.write(this.m_customHandlers, context);
        if (targetCollection.getTarget("target").isMOO()) {
            context.setAuthAttribute("updatetarget.collection", targetCollection);
            EdasUpdateThread updateThread = new EdasUpdateThread(targetCollection, context);
            updateThread.start();
            resultStrings.put("Progress.secondsToRefresh", "0");
            this.setUIPage("fw.Progress");
        } else {
            targetCollection.update(context);
            String title = eMFrameUtils.getLocalizedString("FwResources", "Success", context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "ChangesSaved", context);
            resultStrings.put("GeneralMsg.MsgTitle", title);
            resultStrings.put("GeneralMsg.MsgBody", body);
        }
        return this.postWrite(resultStrings, context);
    }

    private boolean doRead(TaskContext context, Properties resultStrings) throws eDirAccessServiceException {
        boolean success = this.preRead(context, resultStrings);
        if (!success) {
            return false;
        }
        this.m_targetCollection = new TargetCollection();
        this.m_targetCollection.read(context, this.m_attributesToRead, this.m_customHandlers, this.m_bigXmlOnly);
        ObjectEntry oe = this.m_targetCollection.getTarget("target").getOE();
        if (oe != null) {
            resultStrings.put("TaskHeader.iconUrl", context.getDirUtils().getObjectEntryImageName(oe));
            resultStrings.put("TaskHeader.iconAlt", oe.getObjectType().getName());
        } else {
            String alt = eMFrameUtils.getLocalizedString("DevResources", "General.object", context);
            resultStrings.put("TaskHeader.iconUrl", "object16.gif");
            resultStrings.put("TaskHeader.iconAlt", alt);
        }
        return this.postRead(context, resultStrings);
    }

    protected boolean preRead(TaskContext context, Properties resultStrings) {
        return true;
    }

    protected boolean postRead(TaskContext context, Properties resultStrings) {
        return true;
    }

    protected boolean preWrite(TaskContext context, Properties resultStrings) {
        return true;
    }

    protected boolean postWrite(Properties resultStrings, TaskContext context) {
        return true;
    }

    public final TargetCollection getEdasTargetCollection() {
        return this.m_targetCollection;
    }

    protected boolean preCreate(String username, TaskContext context) {
        return true;
    }

    protected boolean postCreate(TaskContext context, String username) {
        return true;
    }

    private void preCreateState(TaskContext context, Properties resultStrings, String objectTypeName) {
        DirUtils dirUtils = context.getDirUtils();
        String[] attributesNames = dirUtils.getSortedAttrs();
        for (int cntr = 0; cntr < attributesNames.length; ++cntr) {
            String key = dirUtils.getSafeName(attributesNames[cntr]) + "DisplayName";
            resultStrings.put(key, dirUtils.getAttributeDisplayName(attributesNames[cntr], context));
        }
        resultStrings.put("GifName", dirUtils.getObjectTypeImageName(objectTypeName));
        resultStrings.put("CreatorSearchFilter", CreateObjectUtils.buildSearchFilter(objectTypeName, context));
        String strBody = eMFrameUtils.getLocalizedString("FwResources", "Creator.Create", context);
        String strDisplayTask = eMFrameUtils.formatMessage(strBody, new String[]{dirUtils.getObjectTypeDisplayName(objectTypeName, context)});
        resultStrings.put("Task.displayName", strDisplayTask);
        resultStrings.put("createClassName", objectTypeName);
        context.getRequest().setAttribute("edasRights", (Object)new EdasRightsData(new FakeRightsCache()));
        try {
            ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            String namingAttribute = CreateCustomPlugin.findBestNamingAttribute(ns.getSchemaDefinition(treeOE), objectTypeName);
            resultStrings.put("createNamingAttribute", namingAttribute);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private boolean create(TaskContext context, Properties resultStrings) throws PluginException {
        HttpServletRequest req = context.getRequest();
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        AdminNamespace ns = treeOE.getAdminNamespace();
        String objectClass = req.getParameter("eDir$target$createClassName");
        objectClass = context.getDirUtils().getRealName(objectClass);
        if (objectClass == null) {
            objectClass = req.getParameter("eDir$target$createClassName");
        }
        String name = null;
        try {
            SchemaDefinition schema = ns.getSchemaDefinition(treeOE);
            String namingAttribute = CreateCustomPlugin.findBestNamingAttribute(schema, objectClass);
            name = req.getParameter("eDir$target$" + namingAttribute);
            if (name == null) {
                AttributeDefinition[] naming = schema.getNamingAttributes(objectClass);
                for (int i = 0; i < naming.length; ++i) {
                    namingAttribute = naming[i].getName();
                    name = req.getParameter("eDir$target$" + namingAttribute);
                    if (name != null) break;
                }
            }
            if (name != null) {
                Document doc = iManager.getSaxBuilder().build((Reader)new StringReader(name));
                name = doc.getRootElement().getChildTextTrim("value");
                if (ns instanceof LDAPNamespace && !name.startsWith(namingAttribute + "=")) {
                    name = namingAttribute + "=" + name;
                }
            }
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
        boolean success = this.preCreate(name, context);
        if (!success) {
            return false;
        }
        TargetCollection targetCollection = new TargetCollection();
        String containerName = req.getParameter("eDir$target$createContext");
        String source = req.getParameter("eDir$target$createSourceObjectForClone");
        String password = req.getParameter("eDir$target$createPassword");
        targetCollection.createTargetDefinition(containerName, name, objectClass, context);
        targetCollection.write(this.m_customHandlers, context);
        try {
            CreateObjectUtils.validateContainment(objectClass, containerName, context);
            if (containerName.equalsIgnoreCase("[root]") || containerName.equals("")) {
                containerName = treeOE.getName();
            }
            ObjectEntry parentEntry = null;
            parentEntry = treeOE.getName().equalsIgnoreCase(containerName) ? ns.getObjectEntry(containerName) : ns.getObjectEntry(treeOE, containerName);
            ObjectEntry targetOE = ns.createObjectEntry(parentEntry, name, objectClass);
            if (objectClass != null && objectClass.equalsIgnoreCase("User")) {
                NDSObjectAttribute UniqueObjectAttribute;
                String strUniqueID = targetOE.getName();
                strUniqueID = eMFrameUtils.replaceWith(strUniqueID, "\\.", ".");
                strUniqueID = eMFrameUtils.replaceWith(strUniqueID, "\\=", "=");
                NSObject nsUniqueIDObj = (NSObject)targetCollection.getTarget("target").getObject();
                if (nsUniqueIDObj.getAttribute((UniqueObjectAttribute = new NDSObjectAttribute(ns.getAttributeDefinition(targetOE, "uniqueID"), new ValueComponent[]{NDSSyntax.SYN_CI_STRING.createValueComponent((Object)strUniqueID)})).getName()) == null) {
                    nsUniqueIDObj.addAttribute((ObjectAttribute)UniqueObjectAttribute);
                }
            }
            if (source != null && source.length() > 0) {
                Vector initalAttributes = new Vector();
                Vector<String> nonCloneAttrs = new Vector<String>();
                nonCloneAttrs.addElement(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"CN"));
                nonCloneAttrs.addElement(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"Common Name"));
                nonCloneAttrs.addElement("commonName");
                nonCloneAttrs.addElement(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"ACL"));
                nonCloneAttrs.addElement(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"Home Directory"));
                nonCloneAttrs.addElement(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"uniqueID"));
                nonCloneAttrs.addElement(SchemaUtil.translateNDAPAttr((ObjectEntry)parentEntry, (String)"Object Class"));
                CreateObjectUtils.doPreCreateClone(source, targetOE, nonCloneAttrs, initalAttributes, context);
                NSObject nsobj = (NSObject)targetCollection.getTarget("target").getObject();
                Iterator iter = initalAttributes.iterator();
                while (iter.hasNext()) {
                    ObjectAttribute objectAttribute = (ObjectAttribute)iter.next();
                    boolean readOnly = objectAttribute.getAttributeDefinition().isReadOnly();
                    if (nsobj.getAttribute(objectAttribute.getName()) != null || readOnly) continue;
                    try {
                        nsobj.addAttribute(objectAttribute);
                    }
                    catch (NamespaceException e) {
                        D.log(e);
                        D.log(objectAttribute.getName());
                    }
                }
            }
            targetCollection.getTarget("target").create(context);
            if (targetCollection.getTarget("target").getObject() instanceof NSObject) {
                Target.syncBackLinks((NSObject)targetCollection.getTarget("target").getObject());
            }
            String userHomePath = req.getParameter("_Home_DirectoryPath");
            String userHomeVolume = req.getParameter("_Home_DirectoryVolume");
            boolean homeDirCreated = false;
            if (userHomeVolume != null && userHomeVolume.length() > 0 && userHomePath != null && userHomePath.length() > 0) {
                NSFileRights homeDirectoryRights = CreateObjectUtils.getHomeDirectoryRightsAttribute(ns, null);
                CreateObjectUtils.createHomeDirectoryAndSetRights(userHomeVolume, userHomePath, targetOE, homeDirectoryRights, context);
                homeDirCreated = true;
            }
            if (source != null && source.length() > 0) {
                Enumeration valueSet;
                ObjectAttribute[] homeDirAttr;
                ObjectEntry sourceOE = ns.getObjectEntry(source);
                NSObject sourceNSObj = ns.getDetails(sourceOE);
                CreateObjectUtils.doPostCreateClone(containerName, name, sourceNSObj, ns, context);
                if (!homeDirCreated && (homeDirAttr = ns.getAttributes(sourceOE, new String[]{"Home Directory"}))[0] != null && (valueSet = homeDirAttr[0].getValueComponents()).hasMoreElements()) {
                    PathFacade pathFacade = (PathFacade)((ValueList)valueSet.nextElement()).createFacade();
                    String ndsVolName = pathFacade.getVolume();
                    String pathName = pathFacade.getPath() + "\\" + name;
                    String pathStr = CreateObjectUtils.fixPath(pathName);
                    if (ndsVolName != null && ndsVolName.length() > 0) {
                        NSFileRights homeDirectoryRights = CreateObjectUtils.getHomeDirectoryRightsAttribute(ns, sourceNSObj);
                        CreateObjectUtils.createHomeDirectoryAndSetRights(ndsVolName, pathStr, targetOE, homeDirectoryRights, context);
                    }
                    NDSObjectAttribute pathAttrib = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(targetOE, "Home Directory"));
                    pathAttrib.addComponent((ValueComponent)PathFacade.createValueList((long)0L, (String)ndsVolName, (String)pathStr));
                    ns.setAttribute(targetOE, (ObjectAttribute)pathAttrib);
                }
                CreateObjectUtils.setNewObjectFSRights(targetOE, sourceNSObj);
                CreateObjectUtils.setVolumeSpaceRestrictions(targetOE, sourceNSObj);
            }
            if (password != null) {
                CreateObjectUtils.setPassword(targetOE, password, context);
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, context);
            return false;
        }
        ObjectEntry oeNew = targetCollection.getTarget("target").getOE();
        context.addToHistory(oeNew);
        String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.Success", context);
        String strSuccessForObject = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.SuccessForObject", context);
        resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.formatMessage(title, new String[]{context.getDirUtils().getObjectTypeDisplayName(objectClass, context)}));
        String fullname = oeNew.getFullName();
        String modifyName = ns.getUnrootedName(oeNew);
        DirUtils dirUtils = context.getDirUtils();
        String objectTypeDisplayName = dirUtils.getObjectTypeDisplayName(objectClass, context);
        String s = objectTypeDisplayName.toLowerCase(context.getLocale());
        String body = eMFrameUtils.formatMessage(strSuccessForObject, new String[]{s, fullname});
        resultStrings.put("GeneralMsg.MsgBody", body);
        this.setUIPage("dev.GenConf");
        if (req.getParameter("taskId").indexOf("fw.PreviewCreateTask") == -1) {
            resultStrings.put("GeneralMsg.ShowModifyObject", "true");
            resultStrings.put("GeneralMsg.ModifyObjectName", eMFrameUtils.pack(new String[]{modifyName}, context));
            if (this.m_modifyTask != null && this.m_modifyTask.length() > 0) {
                resultStrings.put("GeneralMsg.ModifyObjectTaskId", this.m_modifyTask);
            }
        }
        success = this.postCreate(context, name);
        if (containerName != null && treeOE != null) {
            resultStrings.put("dev.refreshOV", "true");
        }
        return true;
    }

    public static final String getEdasData(HttpServletRequest req, String key) {
        if (!key.startsWith("eDirRights$")) {
            return null;
        }
        EdasRightsData edasRightsData = (EdasRightsData)req.getAttribute("edasRights");
        if (edasRightsData == null) {
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(key, EDIR_CONNECTOR);
            st.nextToken();
            String target = st.nextToken();
            String attribute = st.nextToken();
            RightsCache rightesCache = (RightsCache)edasRightsData.get(target);
            RightsBean rightsBean = (RightsBean)rightesCache.get(attribute);
            if (rightsBean.getWriteable() && rightsBean.getReadable()) {
                return "RW";
            }
            if (rightsBean.getReadable()) {
                return "R";
            }
            return "NONE";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final boolean isSyncableAttribute(String attributeName) {
        for (int i = 0; i < Target.s_syncableAttributes.length; ++i) {
            if (!attributeName.equals(FwUtils.getSafeName(Target.s_syncableAttributes[i]))) continue;
            return true;
        }
        return false;
    }
}

