/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.LDAPSPIException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.HistoryNode;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Version;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.authenticator.AuthUtils;
import com.novell.emframe.dev.utils.LocUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.ObjectSelector;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.util.infos.RoleInfo;
import com.novell.nps.WebappUtil;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.rbs.RBSException;
import com.novell.webaccess.common.Browser;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Document;
import org.jdom.Element;

public class eMFrameUtils {
    private static int m_iUniqueStringCookie;
    private static BitSet dontNeedEncoding;
    public static final String EMPTY_STRING;
    static final byte[] s_hexTable;

    public static final String getModuleFromFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String module = null;
        int index = fullName.indexOf(47);
        if (index == -1) {
            return null;
        }
        try {
            module = fullName.substring(0, index);
        }
        catch (StringIndexOutOfBoundsException e) {
            D.log(e);
        }
        return module;
    }

    public static final String getPageFromFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String page = null;
        int index = fullName.indexOf(47);
        if (index == -1) {
            return null;
        }
        try {
            page = fullName.substring(index + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            D.log(e);
        }
        return page;
    }

    public static final org.w3c.dom.Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            D.log(pce);
            return null;
        }
    }

    public static final void saveOSState(MContext context) {
        String mode = "OS.MultiWindowMode";
        ObjectSelector.saveOSState(context.getRequest(), mode);
    }

    public static final String getDisplayName(Document taskDoc, MContext context) {
        Element root = taskDoc.getRootElement();
        return eMFrameUtils.getDisplayName(root, context);
    }

    public static final String getDisplayName(Element root, MContext context) {
        return eMFrameUtils.getDisplayName(root, "display-name-key", context);
    }

    public static final String getDisplayName(Element root, String tagName, MContext context) {
        iMgrAuthenticatorImpl auth = (iMgrAuthenticatorImpl)AuthUtils.getAuthenticator(FwAuthUtils.getPrimaryAuthenticatorName(root), context);
        return auth.getDisplayName(root, tagName, context.getRequest());
    }

    public static Locale getCurrentLocale(HttpSession session) {
        return LocUtils.getCurrentLocale(session);
    }

    public static final String getLocalizedString(String strResourceFile, String strResId, MContext context) {
        return eMFrameUtils.getLocalizedString(strResourceFile, strResId, context.getLocale());
    }

    public static final String getLocalizedString(String strResourceFile, String strResId, String strDefaultValue, MContext context) {
        return eMFrameUtils.getLocalizedString(strResourceFile, strResId, context.getLocale(), strDefaultValue);
    }

    public static final String getLocalizedString(String strResourceFile, String strResId, Locale locale) {
        return eMFrameUtils.getLocalizedString(strResourceFile, strResId, locale, null);
    }

    public static String getLocalizedString(String strResourceFile, String strResId, Locale locale, String defaultValue) {
        ResourceBundle rb = null;
        String retValue = defaultValue;
        try {
            if (strResourceFile != null && strResId != null && (rb = ResourceBundle.getBundle(strResourceFile, locale)) != null) {
                retValue = rb.getString(strResId);
            }
        }
        catch (Exception e) {
            if (e instanceof MissingResourceException) {
                try {
                    if (rb == null && (rb = ResourceBundle.getBundle(strResourceFile + "_en", locale)) != null) {
                        retValue = rb.getString(strResId);
                    }
                }
                catch (Exception e2) {}
            }
            D.log(e);
        }
        if (retValue == null && FwUtils.showDeveloperWarnings()) {
            D.log("Unable to find ressource key: " + strResId + " in resource file: " + strResourceFile);
        }
        return retValue;
    }

    public static final String getExceptionMessage(Exception e, MContext context) {
        String strException;
        if (e instanceof SPIException) {
            try {
                String strException2 = e.getLocalizedMessage();
                return strException2;
            }
            catch (MissingResourceException missingResourceException) {}
        } else if (e instanceof RBSException && (strException = eMFrameUtils.getRBSExceptionLocalizedString((RBSException)e, context)) != null) {
            return strException;
        }
        strException = e.getMessage();
        if (strException == null || strException.length() == 0) {
            strException = e.toString();
        }
        return strException;
    }

    public static final String trimQuotes(String str) {
        if (2 <= str.length()) {
            int iFirstQuoteIdx = str.indexOf("\"");
            int iLastQuoteIdx = str.lastIndexOf("\"");
            if (0 == iFirstQuoteIdx && str.length() - 1 == iLastQuoteIdx) {
                str = str.substring(1, iLastQuoteIdx);
            }
        }
        return str;
    }

    public static final String getUniqueString(String prefix, String postfix) {
        return prefix + ++m_iUniqueStringCookie + postfix;
    }

    public static final Properties parseParameters(String params) {
        return eMFrameUtils.parseParameters(params, ";");
    }

    public static final HashMap parseParameters2(String params) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String delimiter = ";";
        if (params == null) {
            return map;
        }
        StringTokenizer st = new StringTokenizer(params, delimiter);
        String strPair = null;
        String strVariableName = null;
        String strValue = null;
        int indexOfDelemeter = 0;
        while (st.hasMoreTokens()) {
            strPair = st.nextToken();
            indexOfDelemeter = strPair.indexOf("=");
            if (indexOfDelemeter == -1) {
                strVariableName = strPair;
                strValue = "";
            } else {
                strVariableName = strPair.substring(0, indexOfDelemeter);
                strValue = strPair.substring(indexOfDelemeter + 1);
            }
            ArrayList<String> list = (ArrayList<String>)map.get(strVariableName);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(strVariableName, list);
            }
            list.add(strValue);
        }
        return map;
    }

    public static final Properties parseParameters(String params, String delimiter) {
        Properties properties = new Properties();
        if (params == null) {
            return properties;
        }
        StringTokenizer st = new StringTokenizer(params, delimiter);
        String strPair = null;
        String strVariableName = null;
        String strValue = null;
        int indexOfDelemeter = 0;
        while (st.hasMoreTokens()) {
            strPair = st.nextToken();
            indexOfDelemeter = strPair.indexOf("=");
            if (indexOfDelemeter == -1) {
                strVariableName = strPair;
                strValue = "";
            } else {
                strVariableName = strPair.substring(0, indexOfDelemeter);
                strValue = strPair.substring(indexOfDelemeter + 1);
            }
            properties.put(strVariableName, strValue);
        }
        return properties;
    }

    public static final String concatProperties(Properties properties) {
        String retString = "";
        String strKey = null;
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            strKey = (String)keys.nextElement();
            retString = retString + strKey + "=" + properties.get(strKey) + ";";
        }
        return retString;
    }

    public static final Vector tokenize(String params, String delimiter) {
        Vector<String> vValues = new Vector<String>();
        if (params == null) {
            return vValues;
        }
        StringTokenizer st = new StringTokenizer(params, delimiter);
        while (st.hasMoreTokens()) {
            vValues.addElement(st.nextToken());
        }
        return vValues;
    }

    public static final String[] split(String s, String delimiter) {
        Vector<String> items = new Vector<String>();
        int delLen = delimiter.length();
        if (s == null) {
            return null;
        }
        int curPos = 0;
        boolean done = false;
        while (!done) {
            curPos = s.indexOf(delimiter);
            if (curPos == -1) {
                items.addElement(s);
                done = true;
                continue;
            }
            String curSelection = s.substring(0, curPos);
            items.addElement(curSelection);
            s = s.substring(curPos + delLen, s.length());
        }
        Object[] returnArray = new String[items.size()];
        items.copyInto(returnArray);
        return returnArray;
    }

    public static final String concatStrings(String[] strings, String delimiter) {
        String retString = "";
        if (strings != null) {
            for (int index = 0; index < strings.length; ++index) {
                retString = retString + strings[index];
                if (index + 1 == strings.length) continue;
                retString = retString + delimiter;
            }
        }
        return retString;
    }

    public static final ArrayList commaSplit(String s) {
        ArrayList<String> a = new ArrayList<String>();
        if (s == null || s.length() == 0) {
            return a;
        }
        StringBuffer val = new StringBuffer("");
        String sval = "";
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ',') {
                val.append(ch);
                continue;
            }
            if (i + 1 < s.length() && s.charAt(i + 1) == ',') {
                val.append(',');
                ++i;
                continue;
            }
            sval = val.toString();
            if ((sval = sval.trim()) != null && sval.length() > 0) {
                a.add(sval);
            }
            val.setLength(0);
        }
        sval = val.toString();
        if ((sval = sval.trim()) != null && sval.length() > 0) {
            a.add(sval);
        }
        return a;
    }

    public static final String commaSepStr(ArrayList a) {
        String s = "";
        if (a != null && a.size() > 0) {
            for (int i = 0; i < a.size(); ++i) {
                s = s + (i > 0 ? ", " : "") + eMFrameUtils.dupCommas((String)a.get(i));
            }
        }
        return s;
    }

    private static String dupCommas(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (s.indexOf(44) == -1) {
            return s;
        }
        StringBuffer ret = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ',') {
                ret.append(",,");
                continue;
            }
            ret.append(s.charAt(i));
        }
        return ret.toString();
    }

    public static void setMooErrorMessage(Properties resultStrings, String header, String body, ArrayList errors) {
        resultStrings.put("GeneralMsg.MsgTitle", header);
        resultStrings.put("GeneralMsg.MsgBody", body);
        int count = errors.size();
        resultStrings.put("MooList.Count", Integer.toString(count));
        for (int i = 0; i < count; ++i) {
            String[] error = (String[])errors.get(i);
            resultStrings.put("MooList." + i + ".Name", error[0]);
            resultStrings.put("MooList." + i + ".ErrorMsgTitle", error[1]);
            resultStrings.put("MooList." + i + ".ErrorMsgBody", error[2]);
            if (error.length <= 3) {
                resultStrings.put("MooList." + i + ".ErrorURL", "");
                continue;
            }
            resultStrings.put("MooList." + i + ".ErrorURL", error[3]);
        }
    }

    public static void setMooErrorMessage(HttpServletRequest req, String header, String body, ArrayList errors) {
        req.setAttribute("GeneralMsg.MsgTitle", (Object)header);
        req.setAttribute("GeneralMsg.MsgBody", (Object)body);
        int count = errors.size();
        req.setAttribute("MooList.Count", (Object)Integer.toString(count));
        for (int i = 0; i < count; ++i) {
            String[] error = (String[])errors.get(i);
            req.setAttribute("MooList." + i + ".Name", (Object)error[0]);
            req.setAttribute("MooList." + i + ".ErrorMsgTitle", (Object)error[1]);
            req.setAttribute("MooList." + i + ".ErrorMsgBody", (Object)error[2]);
            if (error.length <= 3) {
                req.setAttribute("MooList." + i + ".ErrorURL", (Object)"");
                continue;
            }
            req.setAttribute("MooList." + i + ".ErrorURL", (Object)error[3]);
        }
    }

    public static final String join(Collection collection, String delimiter) {
        if (collection == null) {
            return "";
        }
        Iterator iter = collection.iterator();
        String retString = "";
        while (iter.hasNext()) {
            retString = retString + iter.next();
            if (!iter.hasNext()) continue;
            retString = retString + delimiter;
        }
        return retString;
    }

    public static final String join(Collection collection) {
        return eMFrameUtils.join(collection, ",");
    }

    public static final Properties getUrlParams(Document doc) {
        List list;
        Properties hash = new Properties();
        if (doc != null && (list = doc.getRootElement().getChildren("url-param")) != null && list.size() > 0) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Element param = (Element)iter.next();
                String strKey = param.getChildTextTrim("param-key");
                String strVal = param.getChildTextTrim("param-value");
                if (strKey == null || strVal == null) continue;
                hash.put(strKey, strVal);
            }
        }
        return hash;
    }

    public static final void sortStringArray(String[] myArray) {
        Arrays.sort(myArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
        });
    }

    public static final boolean verifyTemplateExistsForDevice(MContext context, String template) {
        return template != null && !template.equals("");
    }

    public static final Throwable callVerifyForDeviceMethod(MContext context, Document doc) {
        return FwUtils.callVerifyForDeviceMethod(context, doc);
    }

    public static final boolean instanceOf(String className, Class c) {
        if (c == null) {
            return false;
        }
        if (c.getName().equals(className)) {
            return true;
        }
        return eMFrameUtils.instanceOf(className, c.getSuperclass());
    }

    public static final String toHexString(byte[] bytes) {
        byte[] buf = new byte[bytes.length * 2];
        int index = 0;
        for (int offset = 0; offset < bytes.length; ++offset) {
            int i = 1;
            while (i >= 0) {
                byte b = (byte)(bytes[offset] >> i * 4 & 0xF);
                b = b <= 9 ? (byte)(b + 48) : (byte)(b + 87);
                buf[index] = b;
                --i;
                ++index;
            }
        }
        String lowerCaseString = new String(buf);
        String upperCaseString = lowerCaseString.toUpperCase();
        return upperCaseString;
    }

    public static final int byteToDecimal(byte b) {
        int value = new Byte(b).intValue();
        if (value < 0) {
            return value + 256;
        }
        return value;
    }

    public static final byte[] hexStringToByteArray(String str) throws NumberFormatException {
        int numChars = str.length();
        int byteCount = numChars / 2 + numChars % 2;
        byte[] rval = new byte[byteCount];
        int byteIndex = 0;
        int nibbleCount = 0;
        byte byteValue = 0;
        for (int index = 0; index < numChars; ++index) {
            char nibble = str.charAt(numChars - index - 1);
            if (nibble >= '0' && nibble <= '9') {
                nibble = (char)(nibble - 48);
            } else if (nibble >= 'a' && nibble <= 'f') {
                nibble = (char)(nibble - 97);
                nibble = (char)(nibble + 10);
            } else if (nibble >= 'A' && nibble <= 'F') {
                nibble = (char)(nibble - 65);
                nibble = (char)(nibble + 10);
            } else {
                throw new NumberFormatException();
            }
            if (nibbleCount % 2 == 0) {
                byteValue = (byte)(nibble & 0xF);
            } else {
                byteValue = (byte)(byteValue | (byte)(nibble << 4));
                rval[byteIndex++] = byteValue;
            }
            ++nibbleCount;
        }
        if (nibbleCount % 2 != 0) {
            rval[byteIndex] = byteValue;
        }
        return eMFrameUtils.reverseBytes(rval);
    }

    public static byte[] reverseBytes(byte[] bytes) {
        int len = bytes.length;
        byte[] r = new byte[len];
        for (int i = 0; i < len; ++i) {
            r[i] = bytes[len - i - 1];
        }
        return r;
    }

    public static void addUnique(Collection dstCollection, Object[] sourceObjects) {
        if (sourceObjects != null) {
            for (int j = 0; j < sourceObjects.length; ++j) {
                if (dstCollection.contains(sourceObjects[j])) continue;
                dstCollection.add(sourceObjects[j]);
            }
        }
    }

    public static void addUnique(Collection collection, Collection newItems) {
        if (collection != null && newItems != null) {
            Iterator iterator = newItems.iterator();
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (collection.contains(current)) continue;
                collection.add(current);
            }
        }
    }

    public static final Properties getUrlParamsAsProperties(Document doc) {
        List children = doc.getRootElement().getChildren("url-param");
        Iterator iter = children.iterator();
        Properties properties = new Properties();
        String key = null;
        String val = null;
        while (iter.hasNext()) {
            Element param = (Element)iter.next();
            key = param.getChildTextTrim("param-key");
            val = param.getChildTextTrim("param-value");
            if (key == null || val == null) continue;
            properties.put(key, val);
        }
        return properties;
    }

    public static final void setupTargetChooser(String[] objectTypeNames, MContext context) {
        HttpServletRequest req = context.getRequest();
        if (req == null) {
            return;
        }
        String taskId = context.getTaskId();
        Document doc = FwUtils.getTaskDocument(context, taskId);
        String defaultDisplayName = eMFrameUtils.getDisplayName(doc, context);
        req.setAttribute("Task.defaultDisplayName", (Object)defaultDisplayName);
        if (objectTypeNames == null || objectTypeNames.length == 0 || objectTypeNames[0] == null || objectTypeNames[0].equals("*")) {
            objectTypeNames = context.getDirUtils().getSortedClasses();
            req.setAttribute("objectTypeNames", (Object)objectTypeNames);
            String defaultPrompt = eMFrameUtils.getLocalizedString("FwResources", "Book.objectName", context);
            req.setAttribute("TC.defaultPrompt", (Object)defaultPrompt);
            String defaultAltText = eMFrameUtils.getLocalizedString("DevResources", "General.object", context);
            req.setAttribute("Task.DefaultIcon.name", (Object)"dir/object16.gif");
            req.setAttribute("Task.DefaultIcon.alt", (Object)defaultAltText);
        } else if (objectTypeNames[0].equals("[containers]")) {
            String commaDelimited = eMFrameUtils.toOSFilterString(objectTypeNames);
            req.setAttribute("TC.osTypeFilter", (Object)commaDelimited);
            objectTypeNames = context.getDirUtils().getSelectableContainerTypes();
            req.setAttribute("objectTypeNames", (Object)objectTypeNames);
            String defaultPrompt = eMFrameUtils.getLocalizedString("FwResources", "Book.objectName", context);
            req.setAttribute("TC.defaultPrompt", (Object)defaultPrompt);
            String defaultAltText = eMFrameUtils.getLocalizedString("DevResources", "General.object", context);
            req.setAttribute("Task.DefaultIcon.name", (Object)"dir/object16.gif");
            req.setAttribute("Task.DefaultIcon.alt", (Object)defaultAltText);
        } else {
            String[] displayNames = new String[objectTypeNames.length];
            for (int i = 0; i < objectTypeNames.length; ++i) {
                String displayName = context.getDirUtils().getObjectTypeDisplayName(objectTypeNames[i], context);
                displayNames[i] = displayName != null ? displayName : objectTypeNames[i];
            }
            req.setAttribute("objectTypeNames", (Object)objectTypeNames);
            if (objectTypeNames.length > 1) {
                String pack = eMFrameUtils.pack(displayNames, context);
                req.setAttribute("TC.packedObjectTypeNames", (Object)pack);
            }
            String commaDelimited = eMFrameUtils.toOSFilterString(objectTypeNames);
            req.setAttribute("TC.osTypeFilter", (Object)commaDelimited);
            String packedRealNames = eMFrameUtils.pack(objectTypeNames, context);
            req.setAttribute("TC.packRealObjectClassNames", (Object)packedRealNames);
            String objectClass = null;
            if (objectTypeNames.length == 1) {
                objectClass = context.getDirUtils().getObjectTypeDisplayName(objectTypeNames[0], context);
                req.setAttribute("Task.DefaultIcon.name", (Object)("dir/" + context.getDirUtils().getObjectTypeImageName(objectTypeNames[0])));
                req.setAttribute("Task.DefaultIcon.alt", (Object)objectClass);
            } else {
                objectClass = eMFrameUtils.getLocalizedString("DevResources", "General.object", context);
                String defaultAltText = eMFrameUtils.getLocalizedString("DevResources", "General.object", context);
                req.setAttribute("Task.DefaultIcon.name", (Object)"dir/object16.gif");
                req.setAttribute("Task.DefaultIcon.alt", (Object)defaultAltText);
            }
            Object[] data = new String[]{objectClass};
            String prompt = null;
            if (objectClass.equalsIgnoreCase("User")) {
                prompt = eMFrameUtils.getLocalizedString("FwResources", "TC.userNameException", context);
            } else if ("Group".equals(objectTypeNames[0])) {
                prompt = eMFrameUtils.getLocalizedString("FwResources", "TC.modifyGroupPrompt", context);
            } else {
                String strFormat = eMFrameUtils.getLocalizedString("FwResources", "TC.objectName", context);
                prompt = eMFrameUtils.formatMessage(strFormat, data);
            }
            req.setAttribute("TC.defaultPrompt", (Object)prompt);
        }
        if (objectTypeNames.length == 1) {
            try {
                int i;
                ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
                AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
                ClassDefinition classDefinition = ns.getSchemaDefinition(treeOE).getClassDefinition(objectTypeNames[0]);
                AttributeDefinition[] mandatoryAttrs = classDefinition.getMandatoryAttributes();
                AttributeDefinition[] optionalAttrs = classDefinition.getOptionalAttributes();
                DirUtils dirUtils = context.getDirUtils();
                ArrayList<String> attrNames = new ArrayList<String>(mandatoryAttrs.length + optionalAttrs.length);
                ArrayList<String> attrDisplayNames = new ArrayList<String>(mandatoryAttrs.length + optionalAttrs.length);
                String attrName = null;
                for (i = 0; i < mandatoryAttrs.length; ++i) {
                    attrName = mandatoryAttrs[i].getName();
                    if (attrName == null || attrName.length() <= 0) continue;
                    attrDisplayNames.add(dirUtils.getAttributeDisplayName(attrName, context));
                    attrNames.add(eMFrameUtils.makeAttributeNameLDAPCompliant(attrName, context));
                }
                for (i = 0; i < optionalAttrs.length; ++i) {
                    attrName = optionalAttrs[i].getName();
                    if (attrName == null || attrName.length() <= 0) continue;
                    attrDisplayNames.add(dirUtils.getAttributeDisplayName(attrName, context));
                    attrNames.add(eMFrameUtils.makeAttributeNameLDAPCompliant(attrName, context));
                }
                eMFrameUtils.sortKeyValues(attrDisplayNames, attrNames, context);
                FwAttr.setFwRequestAttribute("QuickFind_AttributesDisplayNames", attrDisplayNames.toArray(new String[attrDisplayNames.size()]), req);
                FwAttr.setFwRequestAttribute("QuickFind_AttributesNames", attrNames.toArray(new String[attrNames.size()]), req);
            }
            catch (Throwable e) {
                D.log(e);
            }
        } else {
            DirUtils dirUtils = context.getDirUtils();
            String[] attrDisplayNames = dirUtils.getSortedAttributeDisplayNames(context);
            FwAttr.setFwRequestAttribute("QuickFind_AttributesDisplayNames", attrDisplayNames, req);
            String[] attrNames = dirUtils.getSortedAttrs();
            String[] ldapAttrNames = new String[attrNames.length];
            for (int i = 0; i < attrNames.length; ++i) {
                ldapAttrNames[i] = eMFrameUtils.makeAttributeNameLDAPCompliant(attrNames[i], context);
            }
            FwAttr.setFwRequestAttribute("QuickFind_AttributesNames", ldapAttrNames, req);
        }
        if (((FwTaskContext)context).getUserInfo().getHtmlDirectory().equals("pocket")) {
            HistoryNode[] historyResults = ((FwTaskContext)context).getHistory(objectTypeNames);
            req.setAttribute("History.count", (Object)String.valueOf(historyResults.length));
            for (int i = 0; i < historyResults.length; ++i) {
                req.setAttribute("History." + i + ".name", (Object)historyResults[i].getObjectName());
                req.setAttribute("History." + i + ".type", (Object)historyResults[i].getObjectType());
            }
        }
    }

    public static String makeAttributeNameLDAPCompliant(String attrName, MContext context) {
        String ret = attrName;
        MappingObject mo = context.getDirUtils().getMappingObject();
        if (mo != null) {
            try {
                ret = mo.NDSAttributeToLDAP(attrName)[0];
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static final void setupTargetChooser(MContext context, Properties resultStrings, String[] objectTypeNames) {
        eMFrameUtils.setupTargetChooser(objectTypeNames, context);
    }

    public static String toOSFilterString(String[] types) {
        String str = "";
        if (types == null || types.length < 1) {
            str = "*";
        } else {
            for (int i = 0; i < types.length; ++i) {
                str = str + eMFrameUtils.replaceWith(types[i], ",", ",,");
                if (i + 1 >= types.length) continue;
                str = str + ",";
            }
        }
        return str;
    }

    public static final String getRBSExceptionLocalizedString(RBSException ex, MContext context) {
        String str = null;
        String strResId = null;
        switch (ex.getType()) {
            case 0: {
                strResId = "RBSException.RBSScopeObjectNotFound";
                break;
            }
            case 1: {
                strResId = "RBSException.RBACRoleObjectNotFound";
                break;
            }
            default: {
                return null;
            }
        }
        str = eMFrameUtils.getLocalizedString("FwResources", strResId, context);
        if (str == null) {
            return null;
        }
        switch (ex.getType()) {
            case 0: {
                str = eMFrameUtils.formatMessage(str, new String[]{ex.getObjectName()});
                break;
            }
            case 1: {
                str = eMFrameUtils.formatMessage(str, new String[]{ex.getObjectName()});
                break;
            }
            default: {
                return null;
            }
        }
        return str;
    }

    public static final String getClassName(Document doc) {
        String className = doc.getRootElement().getChildTextTrim("class-name");
        if (className != null && className.startsWith("java:")) {
            className = className.substring("java:".length());
        }
        return className;
    }

    public static final Object[] getOperationsByObjectType(Document doc, String objectType) {
        ArrayList<String> operations = new ArrayList<String>();
        List types = doc.getRootElement().getChildren("object-type-name");
        Iterator itr = types.iterator();
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            Element name = element.getChild("object-name");
            if (!name.getTextTrim().equalsIgnoreCase(objectType)) continue;
            Iterator opsItr = element.getChildren("object-operation").iterator();
            while (opsItr.hasNext()) {
                Element nxtElement = (Element)opsItr.next();
                String operationTxt = nxtElement.getText();
                operations.add(operationTxt);
            }
        }
        Object[] arr = operations.toArray();
        return arr;
    }

    public static final void sortKeyValues(ArrayList keys, ArrayList values, MContext context) {
        int i;
        if (keys == null || values == null) {
            D.assrt(false, "sortKeyValues: keys or values array(s) are null.");
            return;
        }
        if (keys.size() != values.size()) {
            D.assrt(false, "sortKeyValues: keys and values arrays are not the same size.");
            return;
        }
        if (keys.size() == 0 || values.size() == 0) {
            return;
        }
        ArrayList<KeyValue> kva = new ArrayList<KeyValue>(keys.size());
        for (i = 0; i < keys.size(); ++i) {
            kva.add(new KeyValue((String)keys.get(i), values.get(i)));
        }
        Collections.sort(kva, new KeyValueComparator(context.getLocale()));
        for (i = 0; i < kva.size(); ++i) {
            KeyValue kv = (KeyValue)kva.get(i);
            keys.set(i, kv.getKey());
            values.set(i, kv.getValue());
        }
    }

    public static final void setMessage(String messageMode, String title, String body, MContext context) {
        String parameter;
        String templateName = null;
        if (messageMode.equals("success")) {
            templateName = "GenConf";
        } else if (messageMode.equals("error")) {
            templateName = "GenErr";
        } else if (messageMode.equals("fatal")) {
            templateName = "GenFatal";
        } else {
            D.assrt(false, "eMFrameUtils::setMessage called with unkown messageMode:" + messageMode);
            templateName = "GenConf";
        }
        HttpServletRequest req = context.getRequest();
        req.setAttribute("GeneralMsg.Mode", (Object)messageMode);
        if (title != null) {
            req.setAttribute("GeneralMsg.MsgTitle", (Object)title);
        }
        if (body != null) {
            req.setAttribute("GeneralMsg.MsgBody", (Object)body);
        }
        String paramName = "merge";
        if (messageMode.equals("error") || messageMode.equals("fatal")) {
            paramName = "error";
        }
        if ((parameter = context.getRequest().getParameter(paramName)) == null || parameter.endsWith(".xsl")) {
            ((FwTaskContext)context).getLegacyTask().setUIPage("dev/" + templateName + ".jsp");
        }
    }

    public static final void setMessage(String messageMode, String title, String plainText, String boldText, String errorDetails, MContext context) {
        if (boldText == null) {
            eMFrameUtils.setMessage(messageMode, title, plainText, context);
        } else {
            eMFrameUtils.setMessage(messageMode, title, plainText, boldText, context);
        }
        context.getRequest().setAttribute("errorDetails", (Object)errorDetails);
    }

    public static final void setMessage(String messageMode, String title, String plainText, String boldText, MContext context) {
        String parameter;
        String templateName = null;
        if (messageMode.equals("success")) {
            templateName = "GenConf";
        } else if (messageMode.equals("error")) {
            templateName = "GenErr";
        } else if (messageMode.equals("fatal")) {
            templateName = "GenFatal";
        } else {
            D.assrt(false, "eMFrameUtils::setMessage called with unkown messageMode:" + messageMode);
            templateName = "GenConf";
        }
        HttpServletRequest req = context.getRequest();
        req.setAttribute("GeneralMsg.Mode", (Object)messageMode);
        if (title != null) {
            req.setAttribute("GeneralMsg.MsgTitle", (Object)title);
        }
        if (plainText != null) {
            req.setAttribute("GeneralMsg.MsgBodyPlainText", (Object)plainText);
        }
        if (boldText != null) {
            req.setAttribute("GeneralMsg.MsgBodyBoldText", (Object)boldText);
        }
        String paramName = "merge";
        if (messageMode.equals("error") || messageMode.equals("fatal")) {
            paramName = "error";
        }
        if ((parameter = context.getRequest().getParameter(paramName)) == null || parameter.endsWith(".xsl")) {
            ((FwTaskContext)context).getLegacyTask().setUIPage("dev/" + templateName + ".jsp");
        }
    }

    public static void setErrorMessage(Throwable t, MContext context) {
        if (t instanceof SPIException) {
            eMFrameUtils.handleSPIException(t, context);
        } else if (t instanceof PluginException) {
            eMFrameUtils.handlePluginException(t, context);
        } else if (t instanceof NamespaceException) {
            eMFrameUtils.handleNamespaceException((NamespaceException)t, context);
        } else if (t instanceof RBSException) {
            eMFrameUtils.handleRBSException((RBSException)t, context);
        } else {
            eMFrameUtils.handleGenericException(t, context);
        }
    }

    public static final void out(org.w3c.dom.Document doc) {
        D.log(doc);
    }

    public static final String getSingleTarget(HttpServletRequest request) {
        LegacyTask bgi;
        JobData data;
        String targetNames = request.getParameter("targetNames");
        String[] strs = null;
        if (targetNames != null && targetNames.length() > 0) {
            strs = eMFrameUtils.unpack(targetNames, FwUtils.getMContext(request));
        }
        if (strs == null && (data = JobData.getJobData(bgi = (LegacyTask)request.getAttribute("BGI"))) != null && (strs = data.getObjectNames()) != null) {
            String[] strsCopy = new String[strs.length];
            for (int i = 0; i < strsCopy.length; ++i) {
                strsCopy[i] = DirUtils.removeRightMostName(strs[i]);
            }
            strs = strsCopy;
        }
        if (strs != null && strs.length > 0) {
            D.assrt(strs.length <= 1, "eMFrameUtils::getSingleTarget called when more than one target is available.  Returning first target.");
        }
        if (strs == null || strs.length < 1) {
            return "";
        }
        return strs[0];
    }

    public static final String getAccessMode(MContext context) {
        return (String)FwAttr.getFwAuthAttribute("User.Mode", DirAuthenticator.getDirAuth(context));
    }

    public static final boolean isTaskAssigned(String taskId, MContext context) {
        HashSet assignedTasks = (HashSet)FwAttr.getFwAuthAttr("fw.AssignedTasks", context);
        if (assignedTasks == null) {
            return false;
        }
        String lastPartOfId = taskId;
        int dot = lastPartOfId.lastIndexOf(46);
        if (dot != -1) {
            lastPartOfId = taskId.substring(dot + 1);
        }
        return assignedTasks.contains(lastPartOfId);
    }

    public static final void refreshOV(MContext context) {
        context.getRequest().setAttribute("dev.refreshOV", (Object)"true");
    }

    private static void handleGenericException(Throwable t, MContext context) {
        String body;
        String title;
        RoleList rlist = RoleList.getInstance(context);
        String taskname = context.getTaskId();
        RoleInfo rinfo = null;
        RoleInfo rwanted = null;
        String avltaskids = null;
        Iterator roleIter = rlist.getRolesByIdSortedByValue(context).values().iterator();
        boolean found = false;
        block0: while (roleIter.hasNext() && !found) {
            rinfo = (RoleInfo)roleIter.next();
            HashMap taskmap = rinfo.getTaskDocsById();
            Iterator taskiter = taskmap.keySet().iterator();
            while (taskiter.hasNext()) {
                avltaskids = (String)taskiter.next();
                if (!taskname.equals(avltaskids)) continue;
                rwanted = rinfo;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            title = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgTitleDefault", context);
            body = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.EncounteredAnUnknown", context);
        } else {
            title = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgTitlePlugin", context);
            body = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.EncounteredPluginError", context);
            body = rwanted.getDisplayName(context) + " " + body;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        t.printStackTrace(pw);
        pw.close();
        String sTrace = bos.toString();
        context.getRequest().setAttribute("errorDetails", (Object)sTrace);
        eMFrameUtils.setMessage("error", title, body, context);
    }

    private static void handleRBSException(RBSException rbs, MContext context) {
        String sTitle = null;
        String sMsg = null;
        switch (rbs.getType()) {
            case 0: {
                sMsg = eMFrameUtils.getLocalizedString("FwResources", "RBSException.RBSScopeObjectNotFound", context);
                sMsg = eMFrameUtils.formatMessage(sMsg, new String[]{rbs.getObjectName()});
                break;
            }
            case 1: {
                sMsg = eMFrameUtils.getLocalizedString("FwResources", "RBSException.RBACRoleObjectNotFound", context);
                sMsg = eMFrameUtils.formatMessage(sMsg, new String[]{rbs.getObjectName()});
                break;
            }
            default: {
                eMFrameUtils.handleGenericException((Throwable)rbs, context);
                return;
            }
        }
        sTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
        eMFrameUtils.setMessage("error", sTitle, sMsg, context);
    }

    private static void handlePluginException(Throwable t, MContext context) {
        Exception ex;
        String sTitle = null;
        String sMsg = null;
        String sBold = null;
        boolean sRewriteURLs = true;
        sMsg = ((PluginException)t).getBody();
        sTitle = ((PluginException)t).getHeader();
        sBold = ((PluginException)t).getBoldText();
        sRewriteURLs = ((PluginException)t).getRewriteURLs();
        if (!sRewriteURLs) {
            context.getRequest().setAttribute("iManRewriteURLs", (Object)"false");
        }
        if ((ex = ((PluginException)t).getException()) instanceof SPIException) {
            eMFrameUtils.handleSPIException(ex, context);
            return;
        }
        String sMsgTmp = null;
        String sHdrTmp = null;
        String sBoldTmp = null;
        while (ex != null && ex instanceof PluginException) {
            sMsgTmp = ((PluginException)ex).getBody();
            sHdrTmp = ((PluginException)ex).getHeader();
            sBoldTmp = ((PluginException)ex).getBoldText();
            sRewriteURLs = ((PluginException)ex).getRewriteURLs();
            if (!sRewriteURLs) {
                context.getRequest().setAttribute("iManRewriteURLs", (Object)"false");
            }
            if (sMsgTmp != null && sMsgTmp.length() > 0) {
                sMsg = sMsgTmp;
                sBold = sBoldTmp != null && sBoldTmp.length() > 0 ? sBoldTmp : null;
            }
            if (sHdrTmp != null && sHdrTmp.length() > 0) {
                sTitle = sHdrTmp;
            }
            ex = ((PluginException)ex).getException();
        }
        if (ex != null) {
            eMFrameUtils.setErrorMessage(ex, context);
        } else {
            if (sMsg == null) {
                sMsg = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgBodyDefault", context);
            }
            if (sTitle == null) {
                sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.MsgTitleDefault", context);
            }
        }
        if (sBold == null) {
            eMFrameUtils.setMessage("error", sTitle, sMsg, context);
        } else {
            eMFrameUtils.setMessage("error", sTitle, sMsg, sBold, context);
        }
    }

    private static void handleSPIException(Throwable t, MContext context) {
        String sHelpId = ((SPIException)t).getHelpID();
        String sTitle = null;
        String sMsg = null;
        if (t instanceof UniqueSPIException) {
            sMsg = t.getLocalizedMessage();
            int iErrCode = ((UniqueSPIException)t).getErrorCode();
            if (iErrCode == -16000) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.PasswordLong", context);
            } else if (iErrCode == -16001) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.UpperCaseMinReqFail", context);
            } else if (iErrCode == -16002) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.UpperCaseMaxReqFail", context);
            } else if (iErrCode == -16003) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.LowerCaseMinReqFail", context);
            } else if (iErrCode == -16004) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.LowerCaseMaxReqFail", context);
            } else if (iErrCode == -16005) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.NumericNotAllowed", context);
            } else if (iErrCode == -16006) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.StartNotWithNumber", context);
            } else if (iErrCode == -16007) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.EndNotWithNumber", context);
            } else if (iErrCode == -16008) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.NumericMinReqFail", context);
            } else if (iErrCode == -16009) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.NumericMaxReqFail", context);
            } else if (iErrCode == -16010) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.NonAlphaNumericNotAllowed", context);
            } else if (iErrCode == -16011) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.StartNotWithNonAlphaNumeric", context);
            } else if (iErrCode == -16012) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.EndNotWithNonAlphaNumeric", context);
            } else if (iErrCode == -16013) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.NonAlphaNumericMinReqFail", context);
            } else if (iErrCode == -16014) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.NonAlphaNumericMaxReqFail", context);
            } else if (iErrCode == -16015) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.CharReuseLimitFail", context);
            } else if (iErrCode == -16016) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.CharSequentialReuseLimitFail", context);
            } else if (iErrCode == -16017) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.UniqueCharMinReqFail", context);
            } else if (iErrCode == -16018) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.LifeTimeMinReqFail", context);
            } else if (iErrCode == -16019) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.PasswardInExclusionList", context);
            } else if (iErrCode == -16020) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.AttributeViolationDetected", context);
            } else if (iErrCode == -16021) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.PasswordExtendedDisAllowed", context);
            } else if (iErrCode == -16022) {
                sMsg = eMFrameUtils.getLocalizedString("BaseResources", "SetPassword.ReservedViolation", context);
            }
            String sErrCode = String.valueOf(iErrCode);
            Object[] sArgs = new String[]{sErrCode};
            String sHexErrCode = FwUtils.getUniqueSPIMessage((UniqueSPIException)t);
            context.getRequest().setAttribute("GeneralMsg.Error.Detail", (Object)(sHexErrCode + ".htm"));
            sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.NDSError", context);
            sTitle = eMFrameUtils.formatMessage(sTitle, sArgs);
        } else if (t instanceof LDAPSPIException) {
            sMsg = t.getLocalizedMessage();
            int iErrCode = ((LDAPSPIException)t).getErrorCode();
            String sErrCode = String.valueOf(iErrCode);
            Object[] sArgs = new String[]{sErrCode};
            String sHexErrCode = FwUtils.getLDAPSPIMessage((LDAPSPIException)t);
            context.getRequest().setAttribute("GeneralMsg.Error.Detail", (Object)("ldap_" + sHexErrCode + ".htm"));
            sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.LDAPError", context);
            sTitle = eMFrameUtils.formatMessage(sTitle, sArgs);
        } else if (t instanceof SimpleSPIException) {
            sMsg = t.getLocalizedMessage();
        } else {
            Object[] sArgs = new String[]{sHelpId};
            sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.NDSError", context);
            sTitle = eMFrameUtils.formatMessage(sTitle, sArgs);
        }
        eMFrameUtils.setMessage("error", sTitle, sMsg, context);
    }

    private static void handleNamespaceException(NamespaceException nex, MContext context) {
        String sMsg = null;
        String sTitle = null;
        eMFrameUtils.handleGenericException(nex, context);
        sMsg = nex.getMessage();
        sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.NamespaceError", context);
        eMFrameUtils.setMessage("error", sTitle, sMsg, context);
    }

    public static String toScript(String strText) {
        if (strText == null) {
            return "";
        }
        int iLen = strText.length();
        int startingLength = 0 * iLen;
        StringBuffer sbText = new StringBuffer(startingLength);
        block5: for (int i = 0; i < iLen; ++i) {
            char ch = strText.charAt(i);
            switch (ch) {
                case '\n': {
                    sbText.append('\\');
                    sbText.append('n');
                    continue block5;
                }
                case '\r': {
                    sbText.append('\\');
                    sbText.append('r');
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    sbText.append('\\');
                }
                default: {
                    sbText.append(ch);
                }
            }
        }
        return sbText.toString();
    }

    public static String urlEncode(String strText, String charset) {
        byte[] srcBytes;
        if (strText == null) {
            return EMPTY_STRING;
        }
        try {
            srcBytes = strText.getBytes(charset);
        }
        catch (UnsupportedEncodingException uee) {
            try {
                srcBytes = strText.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee2) {
                srcBytes = strText.getBytes();
            }
        }
        int iSrcLen = srcBytes.length;
        byte[] destBytes = new byte[iSrcLen * 3];
        int iDest = 0;
        for (int iSrc = 0; iSrc < iSrcLen; ++iSrc) {
            byte b = srcBytes[iSrc];
            if (b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122) {
                destBytes[iDest++] = b;
                continue;
            }
            if (b == 32) {
                destBytes[iDest++] = 43;
                continue;
            }
            destBytes[iDest++] = 37;
            int i = b >> 4 & 0xF;
            destBytes[iDest++] = s_hexTable[i];
            i = b & 0xF;
            destBytes[iDest++] = s_hexTable[i];
        }
        try {
            return new String(destBytes, 0, iDest, charset);
        }
        catch (UnsupportedEncodingException uee3) {
            try {
                return new String(destBytes, 0, iDest, "8859_1");
            }
            catch (UnsupportedEncodingException uee4) {
                return new String(destBytes, 0, iDest);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new String(destBytes, 0, iDest);
        }
    }

    public static String urlEncode(String strText) {
        return eMFrameUtils.urlEncode(strText, "utf-8");
    }

    public static String urlEncodePath(String strText, String charset) {
        byte[] srcBytes;
        if (strText == null) {
            return EMPTY_STRING;
        }
        try {
            srcBytes = strText.getBytes(charset);
        }
        catch (UnsupportedEncodingException uee) {
            try {
                srcBytes = strText.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException uee2) {
                srcBytes = strText.getBytes();
            }
        }
        int iSrcLen = srcBytes.length;
        byte[] destBytes = new byte[iSrcLen * 3];
        int iDest = 0;
        for (int iSrc = 0; iSrc < iSrcLen; ++iSrc) {
            byte b = srcBytes[iSrc];
            if (b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || b == 47 || b == 46 || b == 95 || b == 45) {
                destBytes[iDest++] = b;
                continue;
            }
            if (b == 32) {
                destBytes[iDest++] = 43;
                continue;
            }
            destBytes[iDest++] = 37;
            int i = b >> 4 & 0xF;
            destBytes[iDest++] = s_hexTable[i];
            i = b & 0xF;
            destBytes[iDest++] = s_hexTable[i];
        }
        try {
            return new String(destBytes, 0, iDest, charset);
        }
        catch (UnsupportedEncodingException uee3) {
            try {
                return new String(destBytes, 0, iDest, "8859_1");
            }
            catch (UnsupportedEncodingException uee4) {
                return new String(destBytes, 0, iDest);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new String(destBytes, 0, iDest);
        }
    }

    public static String urlEncodePath(String strText) {
        return eMFrameUtils.urlEncodePath(strText, "utf-8");
    }

    public static String formatMessage(String pattern, Object[] arguments) {
        if (pattern == null) {
            return EMPTY_STRING;
        }
        pattern = eMFrameUtils.replaceSubString(pattern, "'", "''");
        return MessageFormat.format(pattern, arguments);
    }

    public static String replaceWith(String strOrig, String strFind, String strReplace) {
        StringBuffer sb = eMFrameUtils.replaceSubstrings(strOrig, strFind, strReplace);
        return sb.toString();
    }

    public static String toDisplay(String strText) {
        return eMFrameUtils.stringToHTMLExt(strText);
    }

    private static StringBuffer replaceSubstrings(String strOrig, String strFind, String strReplace) {
        StringBuffer sb = new StringBuffer(strOrig.length() + 100);
        int iFindLen = strFind.length();
        int iLastOccurance = 0;
        int iFindPos = strOrig.indexOf(strFind);
        while (iFindPos != -1) {
            sb.append(strOrig.substring(iLastOccurance, iFindPos));
            if (strReplace.length() > 0) {
                sb.append(strReplace);
            }
            iLastOccurance = iFindPos + iFindLen;
            iFindPos = strOrig.indexOf(strFind, iLastOccurance);
        }
        sb.append(strOrig.substring(iLastOccurance));
        return sb;
    }

    public static String replaceSubString(String source, String fromSubString, String toSubString) {
        if (source.indexOf(fromSubString) == -1) {
            return source;
        }
        String workingSource = new String(source.trim());
        int iSubStringCount = 0;
        int iLastIndex = 0;
        int iCurrentIndex = 0;
        while (workingSource.indexOf(fromSubString, iLastIndex) != -1) {
            ++iSubStringCount;
            iLastIndex = workingSource.indexOf(fromSubString, iLastIndex) + fromSubString.length();
        }
        if (iSubStringCount == 0) {
            return workingSource;
        }
        int iNewStringLength = workingSource.length() + iSubStringCount * (toSubString.length() - fromSubString.length());
        char[] result = new char[iNewStringLength];
        for (int k = 0; k < iNewStringLength; ++k) {
            result[k] = 32;
        }
        boolean bDone = false;
        int iResultIndex = 0;
        iLastIndex = 0;
        iCurrentIndex = 0;
        while (!bDone) {
            iCurrentIndex = workingSource.indexOf(fromSubString, iLastIndex);
            if (iCurrentIndex == -1) {
                bDone = true;
                iCurrentIndex = workingSource.length();
            }
            for (int i = iLastIndex; i < iCurrentIndex; ++i) {
                result[iResultIndex] = workingSource.charAt(i);
                ++iResultIndex;
            }
            if (!bDone) {
                for (int j = 0; j < toSubString.length(); ++j) {
                    result[iResultIndex] = toSubString.charAt(j);
                    ++iResultIndex;
                }
            }
            iLastIndex = iCurrentIndex + fromSubString.length();
        }
        String strResult = new String(result);
        strResult = strResult.trim();
        return strResult;
    }

    public static String xmlEncode(String strText) {
        return XmlUtils.xmlEncode(strText);
    }

    public static String toTag(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        block8: for (int idx = 0; idx < len; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '<': {
                    sb.append("&#60;");
                    continue block8;
                }
                case '>': {
                    sb.append("&#62;");
                    continue block8;
                }
                case '&': {
                    sb.append("&#38;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&#34;");
                    continue block8;
                }
                case '\u001b': {
                    sb.append("&#27;");
                    continue block8;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String xmlDecode(String str) {
        return XmlUtils.xmlDecode(str);
    }

    public static String stringToHTMLExt(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        boolean bPrevWasWhite = false;
        int iLinePos = 0;
        int idx = 0;
        char ch = '\u0000';
        block11: for (idx = 0; idx < len; ++idx) {
            ch = str.charAt(idx);
            if (ch >= '\u0080') {
                sb.append("&#");
                sb.append(Integer.toString(ch));
                sb.append(';');
                ++iLinePos;
                bPrevWasWhite = false;
                continue;
            }
            switch (ch) {
                case '\n': 
                case '\r': {
                    sb.append("<BR>");
                    char nextch = '\u0000';
                    if (idx < len - 1) {
                        nextch = str.charAt(idx + 1);
                    }
                    if (ch == '\n' && nextch == '\r' || ch == '\r' && nextch == '\n') {
                        ++idx;
                    }
                    iLinePos = 0;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '<': {
                    sb.append("&lt;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '>': {
                    sb.append("&gt;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '$': {
                    sb.append("&#36;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '\u001b': {
                    sb.append("&#27;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '&': {
                    sb.append("&amp;");
                    ++iLinePos;
                    bPrevWasWhite = false;
                    continue block11;
                }
                case '\t': {
                    sb.append("&nbsp;");
                    ++iLinePos;
                    while (iLinePos % 4 != 0) {
                        sb.append("&nbsp;");
                        ++iLinePos;
                    }
                    bPrevWasWhite = true;
                    continue block11;
                }
                case ' ': {
                    if (bPrevWasWhite) {
                        sb.append("&nbsp;");
                    } else {
                        sb.append(' ');
                    }
                    ++iLinePos;
                    bPrevWasWhite = true;
                    continue block11;
                }
                case '\"': {
                    sb.append("&quot;");
                    ++iLinePos;
                    continue block11;
                }
                default: {
                    sb.append(ch);
                    bPrevWasWhite = false;
                    ++iLinePos;
                }
            }
        }
        return sb.toString();
    }

    public static String stringToXML(String str) {
        return XmlUtils.stringToXML(str);
    }

    public static final String urlEncode(String s, MContext context) {
        String charsetEncoding = "utf-8";
        if (context != null) {
            charsetEncoding = context.getRequest().getCharacterEncoding();
        }
        return eMFrameUtils.urlEncode(s, charsetEncoding);
    }

    public static final String urlDecode(String s, MContext context) {
        String charsetEncoding = "utf-8";
        if (context != null) {
            charsetEncoding = context.getRequest().getCharacterEncoding();
        }
        return eMFrameUtils.urlDecode(s, charsetEncoding);
    }

    public static final String urlDecode(String s, String encoding) {
        if (encoding == null || encoding.equals("")) {
            encoding = "8859_1";
        }
        int iOffset = 0;
        byte[] byContent = s.getBytes();
        int iContentLen = byContent.length;
        int iSrc = iOffset;
        int iDest = iOffset;
        for (int iCount = 0; iCount < iContentLen; ++iCount) {
            switch (byContent[iSrc]) {
                case 43: {
                    byContent[iDest] = 32;
                    break;
                }
                case 37: {
                    if (byContent[iSrc + 1] == 117) {
                        int i1 = 0;
                        int i2 = 0;
                        i1 = Character.digit((char)byContent[iSrc + 2], 16) * 16 + Character.digit((char)byContent[iSrc + 3], 16);
                        i2 = Character.digit((char)byContent[iSrc + 4], 16) * 16 + Character.digit((char)byContent[iSrc + 5], 16);
                        char c = (char)((i1 & 0xFF) << 8);
                        c = (char)(c | (char)(i2 & 0xFF));
                        Character ch = new Character(c);
                        String ss = ch.toString();
                        try {
                            byte[] b = ss.getBytes(encoding);
                            int ii = 0;
                            while (ii < b.length) {
                                byContent[iDest] = b[ii];
                                ++ii;
                                ++iDest;
                            }
                            --iDest;
                        }
                        catch (UnsupportedEncodingException e) {
                            D.log("Unsupported Encoding Exception (" + encoding + ")");
                        }
                        iSrc += 5;
                        iCount += 5;
                        break;
                    }
                    int iValue = Character.digit((char)byContent[iSrc + 1], 16) * 16 + Character.digit((char)byContent[iSrc + 2], 16);
                    iSrc += 2;
                    iCount += 2;
                    byContent[iDest] = (byte)iValue;
                    break;
                }
                default: {
                    byContent[iDest] = byContent[iSrc];
                }
            }
            ++iSrc;
            ++iDest;
        }
        String sContent = null;
        try {
            sContent = new String(byContent, iOffset, iDest - iOffset, encoding);
        }
        catch (UnsupportedEncodingException e) {
            D.log(e);
        }
        return sContent;
    }

    public static final String pack(String value1, String value2, MContext context) {
        String[] values = new String[]{value1, value2};
        return eMFrameUtils.pack(values, context);
    }

    public static final String pack(String[] list, MContext context) {
        if (list == null) {
            return "PP";
        }
        StringBuffer sb = new StringBuffer("P");
        for (int i = 0; i < list.length; ++i) {
            sb.append(":").append(eMFrameUtils.urlEncode(list[i], context));
        }
        return sb.append("P").toString();
    }

    public static final String[] unpack(String s, MContext context) {
        if (null == s) {
            return new String[0];
        }
        if (s.equals("PP")) {
            return new String[0];
        }
        if (!s.startsWith("P:") || !s.endsWith("P")) {
            return new String[]{s};
        }
        s = s.substring(2, s.length() - 1);
        String[] list = eMFrameUtils.split(s, ":");
        String[] ret = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = eMFrameUtils.urlDecode(list[i], context);
        }
        return ret;
    }

    public static void setMergeTemplate(MContext context, String template) {
        I18NServletRequest req = (I18NServletRequest)context.getRequest();
        req.setParameter("merge", template);
    }

    public static void setErrorTemplate(MContext context, String template) {
        FwRequest req = (FwRequest)context.getRequest();
        req.setParameter("error", template);
    }

    public static String getErrorTemplate(MContext context) {
        HttpServletRequest req = context.getRequest();
        String template = (String)req.getAttribute("error");
        if (template == null) {
            template = req.getParameter("error");
        }
        return template;
    }

    public static String getMergeTemplate(MContext context) {
        HttpServletRequest req = context.getRequest();
        String template = (String)req.getAttribute("merge");
        if (template == null) {
            template = req.getParameter("merge");
        }
        return template;
    }

    public static boolean isMS55(HttpServletRequest req) {
        boolean ver55;
        Browser b = Browser.getInstance(req);
        if (!b.getName().equals("MSIE")) {
            return false;
        }
        boolean bl = ver55 = b.getMajorVersionInt() > 5;
        if (!ver55) {
            ver55 = b.getMajorVersionInt() == 5 && b.getMinorVersionInt() >= 5;
        }
        return ver55;
    }

    public static boolean isNN6(HttpServletRequest req) {
        Browser b = Browser.getInstance(req);
        return b.getName().equals("NSN") && b.getMajorVersionInt() >= 6;
    }

    public static boolean isPalm(HttpServletRequest req) {
        return req.getHeader("User-Agent").indexOf("PalmSource") != -1;
    }

    public static String getConfigSetting(BaseGadgetInstance task, String prop, String defaultValue) {
        return task.getConfigSetting(prop, defaultValue);
    }

    public static String[] getConfigSettings(BaseGadgetInstance task, String prop) {
        return task.getConfigSettings(prop);
    }

    public static String getModulesBasePath() {
        return NPSCompatUtils.getModulesBasePath();
    }

    public static String getRealPath(String relativeURL) {
        return WebappUtil.getRealPath((String)relativeURL);
    }

    public static void refreshResourceFileMap(String map) throws FileNotFoundException {
        NPSCompatUtils.refreshResourceFileMap(map);
    }

    public static final byte[] getByteArray(InputStream is) throws IOException {
        byte[] byteData = null;
        InflaterInputStream iis = new InflaterInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tempData = new byte[1024];
        int size = 0;
        while ((size = iis.read(tempData)) != -1) {
            baos.write(tempData, 0, size);
        }
        byteData = baos.toByteArray();
        return byteData;
    }

    public static Throwable discoverRootException(Throwable ex) {
        try {
            Method m;
            Throwable rootCause;
            if (ex.getClass().getName().equals("org.apache.jasper.JasperException") && (rootCause = (Throwable)(m = ex.getClass().getMethod("getRootCause", new Class[0])).invoke((Object)ex, new Object[0])) != null) {
                return rootCause;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ex;
    }

    public static Version getVersion(MContext context) {
        String versionStr = eMFrameUtils.getLocalizedString("com.novell.emframe.version", "version", context);
        return new Version(versionStr);
    }

    public static String[] getMvedValues(String name, MContext context) {
        String pack = context.getRequest().getParameter(name + "_packedValues");
        return eMFrameUtils.unpack(pack, context);
    }

    public static void shouldRunIneDir(HttpServletRequest req) throws Exception {
    }

    public static String replaceNonAsciiWithAscii(String str, String extendedAscii, String normalAscii) {
        String acc = "";
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                acc = str.charAt(i) > '\u001f' && str.charAt(i) < '\u007f' ? acc + str.charAt(i) : acc + "&#" + str.charAt(i) + ";";
            }
            acc = acc.replaceAll(extendedAscii, normalAscii);
        } else {
            acc = str;
        }
        return acc;
    }

    public static String[] replaceNonAsciiWithAsciiForArray(String[] str, String extendedAscii, String normalAscii) {
        String[] acc = new String[str.length];
        for (int j = 0; j < str.length; ++j) {
            acc[j] = eMFrameUtils.replaceNonAsciiWithAscii(str[j], extendedAscii, normalAscii);
        }
        return acc;
    }

    static {
        int i;
        m_iUniqueStringCookie = 0;
        EMPTY_STRING = new String("");
        s_hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }

    private static class KeyValueComparator
    implements Comparator {
        private Comparator m_caseIgnoreCompare = null;

        public KeyValueComparator(Locale locale) {
            this.m_caseIgnoreCompare = Collator.getInstance(locale);
        }

        public int compare(Object kv1, Object kv2) {
            if (kv1 == null || kv2 == null) {
                D.assrt(false, "KeyValueComparator: One or both of the elements being compared are null.");
                return 0;
            }
            return this.m_caseIgnoreCompare.compare(((KeyValue)kv1).getKey(), ((KeyValue)kv2).getKey());
        }
    }

    private static class KeyValue {
        private String m_key;
        private Object m_value;

        public KeyValue(String key, Object value) {
            this.m_key = key == null ? "" : key;
            this.m_value = value;
        }

        public String getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

