/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class Anchor {
    private boolean m_initialized;
    private String m_name;
    private String m_uri;
    private Hashtable m_queryParms;
    private String m_queryString;
    private String m_docState;
    private String m_actionControl;
    private String m_callBack;
    private String m_customProcessing;

    public Anchor(String name, String uri, Hashtable queryParms) {
        this.m_name = name;
        this.m_uri = uri;
        this.m_queryParms = queryParms;
        this.m_queryString = null;
        this.setInitialized(false);
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void setInitialized(boolean initValue) {
        if (!initValue) {
            this.m_docState = null;
            this.m_actionControl = null;
            this.m_callBack = null;
            this.m_customProcessing = null;
        }
        this.m_initialized = initValue;
    }

    public String getName() {
        return this.m_name;
    }

    public String getUri() {
        return this.m_uri;
    }

    public Hashtable getQueryParms() {
        return this.m_queryParms;
    }

    public String getUrl() {
        return this.m_uri + this.getQueryString();
    }

    public String getQueryString() {
        if (this.m_queryString == null) {
            this.m_queryString = this.buildQueryString(this.m_queryParms);
        }
        return this.m_queryString;
    }

    public void setDocState(String state) {
        this.m_docState = state;
    }

    public String getDocState() {
        return this.m_docState;
    }

    public void setActionControl(String control) {
        this.m_actionControl = control;
    }

    public String getActionControl() {
        return this.m_actionControl;
    }

    public void setCallBack(String callback) {
        this.m_callBack = callback;
    }

    public String getCallBack() {
        return this.m_callBack;
    }

    public void setCustomProcessing(String enabled) {
        this.m_customProcessing = enabled;
    }

    public String getCustomProcessing() {
        return this.m_customProcessing;
    }

    private String buildQueryString(Hashtable queryParms) {
        Enumeration parms;
        StringBuffer ret = new StringBuffer();
        if (queryParms != null && (parms = queryParms.keys()) != null) {
            ArrayList names = new ArrayList();
            while (parms.hasMoreElements()) {
                names.add(parms.nextElement());
            }
            Collections.sort(names);
            for (int cnt = 0; cnt < names.size(); ++cnt) {
                String parmName = (String)names.get(cnt);
                String parmValue = (String)queryParms.get(parmName);
                ret.append(cnt == 0 ? "?" : "&");
                ret.append(parmName);
                ret.append("=");
                ret.append(parmValue);
            }
        }
        return ret.toString();
    }
}

