/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.dataTable.IconTableCell;
import com.novell.emframe.dev.dataTable.LinkTableCell;
import com.novell.emframe.dev.dataTable.TableCell;
import com.novell.emframe.dev.dataTable.TextTableCell;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookData;
import com.novell.emframe.fw.CategoryData;
import com.novell.emframe.fw.CollectionData;
import com.novell.emframe.fw.ContentData;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.InstallXMLInfo;
import com.novell.emframe.fw.ModuleData;
import com.novell.emframe.fw.RBSObjectDataSort;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.RoleData;
import com.novell.emframe.fw.TaskData;
import com.novell.emframe.fw.util.eMFrameComponentInstall;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSSchemaVerifier;
import com.novell.rbs.RBSTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class CollectionMain
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private HttpServletRequest m_req;
    private String m_selectedCollectionName;
    private String m_selectedRoleName;
    private String m_delegatedTaskStatus;
    private String m_selectedTab;
    private String m_collectionTab;
    private ArrayList m_categoryList = new ArrayList();
    private ArrayList m_roleList = new ArrayList();
    private ArrayList m_taskList = new ArrayList();
    private ArrayList m_bookList = new ArrayList();
    private ArrayList m_moduleList = new ArrayList();
    private ArrayList m_collectionList2 = new ArrayList();
    private ArrayList m_collectionList1 = new ArrayList();
    private ArrayList m_contentList = new ArrayList();
    private boolean m_isRBSSchemaValid = false;
    private boolean m_isRBSInstalled = false;
    private String m_selectedRoleDisplayName;
    private String m_packedModuleNameList;
    private String m_roleType;
    private String m_selfProvisioningRole;
    private boolean m_readXMLInfo = false;
    private String m_merge;
    private String m_nextState;
    private String m_sortModuleStatusColumn = "1";
    private String m_sortModuleStatusDirection = "Descending";
    private String m_sortCollection1Column = "1";
    private String m_sortCollection1Direction = "Descending";
    private String m_sortCollection2Column = "1";
    private String m_sortCollection2Direction = "Descending";
    private String m_sortContentColumn = "1";
    private String m_sortContentDirection = "Descending";
    private String m_sortRoleColumn = "1";
    private String m_sortRoleDirection = "Descending";
    private String m_sortTaskColumn = "1";
    private String m_sortTaskDirection = "Descending";
    private String m_sortBookColumn = "1";
    private String m_sortBookDirection = "Descending";
    private String m_sortModuleColumn = "1";
    private String m_sortModuleDirection = "Descending";
    private String m_sortCategoryColumn = "1";
    private String m_sortCategoryDirection = "Descending";
    private boolean m_isLDAP = false;
    private boolean m_readCollectionInfo = false;
    private boolean m_haveSelectedCollectionName = false;
    private boolean m_haveSelectedRoleName = false;

    public void processSecondaryGadgetResults(HttpServletRequest req, GadgetInstance secondaryGadgetInstance, String status, Object results) {
        if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create eDirectory Role")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create eGuide Role") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create eGuide Task") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create iManager Task")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create Property Book")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Delete Roles") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Delete Tasks") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Delete Categories") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("base.createrbsModule")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Delete Module")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_readCollectionInfo = true;
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Delete Books")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Book Role Assignment") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Category Role Assigment") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Role Category Assigment") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Task Role Assignment")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Page List")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Object Type")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Role Description") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Task Description") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Book Description") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Category Description") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Module Description")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Role Task")) {
            this.setRequestParam(req, "merge", "fw.ContentMain");
            this.setRequestParam(req, "nextState", "roleSelected");
            this.setRequestParam(req, "SelectedRoleFullName", RBSUtil.urlEncodePack(this.m_selectedRoleName, this.m_context));
            this.setRequestParam(req, "SelectedRoleDisplayName", RBSUtil.urlEncodePack(this.m_selectedRoleDisplayName, this.m_context));
            this.m_delegatedTaskStatus = null;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify eGuide Roles") || secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify eDirectory Roles")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Delete Collection")) {
            this.setRequestParam(req, "merge", "fw.CollectionMain");
            this.setRequestParam(req, "nextState", "initialState");
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Collection Owners")) {
            this.setRequestParam(req, "merge", "fw.CollectionMain");
            this.setRequestParam(req, "nextState", "initialState");
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create Collection")) {
            this.setRequestParam(req, "merge", "fw.CollectionMain");
            this.setRequestParam(req, "nextState", "initialState");
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = null;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Extend Schema")) {
            this.setRequestParam(req, "merge", "fw.CollectionMain");
            this.setRequestParam(req, "nextState", "initialState");
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Modify Collection Description")) {
            this.setRequestParam(req, "merge", "fw.CollectionMain");
            this.setRequestParam(req, "nextState", "initialState");
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.iManagerConfigurationWizard")) {
            this.setRequestParam(req, "merge", "fw.CollectionMain");
            this.setRequestParam(req, "nextState", "initialState");
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = null;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Out Of Date Modules")) {
            this.setRequestParam(req, "merge", this.m_merge);
            this.setRequestParam(req, "nextState", this.m_nextState);
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Not Installed Modules")) {
            this.setRequestParam(req, "merge", this.m_merge);
            this.setRequestParam(req, "nextState", this.m_nextState);
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Installed Modules")) {
            this.setRequestParam(req, "merge", this.m_merge);
            this.setRequestParam(req, "nextState", this.m_nextState);
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "collectionTab", this.m_collectionTab);
            this.m_delegatedTaskStatus = status;
        } else if (secondaryGadgetInstance.getGadgetInstanceID().startsWith("fw.Create Category")) {
            this.setRequestParam(req, "merge", "fw.RoleMain");
            this.setRequestParam(req, "nextState", "collectionSelected");
            this.setRequestParam(req, "selectedCollectionName", this.m_selectedCollectionName);
            this.setRequestParam(req, "selectedTab", this.m_selectedTab);
            this.m_delegatedTaskStatus = status;
        }
    }

    private void setRequestParam(HttpServletRequest req, String sKey, String sValue) {
        req.setAttribute(sKey, (Object)sValue);
    }

    private String getRequestAttributeOrParameter(String sKey) {
        String sValue = (String)this.m_req.getAttribute(sKey);
        if (sValue == null) {
            sValue = this.m_req.getParameter(sKey);
        }
        return sValue;
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        this.m_req = this.m_context.getRequest();
        String nextState = this.getRequestAttributeOrParameter("nextState");
        this.m_isLDAP = this.m_treeOE.getAdminNamespace().getUniqueID().equalsIgnoreCase("LDAP");
        if (this.m_req.getParameter("merge") == null && this.m_req.getAttribute("merge") != null) {
            this.setUIPage((String)this.m_req.getAttribute("merge"));
        }
        if (nextState == null || nextState.equals("initialState")) {
            return this.initialState();
        }
        if (nextState.equals("collectionSelected")) {
            return this.collectionSelected();
        }
        if (nextState.equals("roleSelected")) {
            return this.roleSelected();
        }
        if (nextState.equals("setSelectedTab")) {
            return this.setSelectedTab();
        }
        if (nextState.equals("setCollectionTab")) {
            return this.setCollectionTab();
        }
        if (nextState.equals("backToCollectionList")) {
            return this.backToCollectionList();
        }
        if (nextState.equals("backToRoleList")) {
            return this.backToRoleList();
        }
        if (nextState.equals("removeTasksFromRole")) {
            return this.removeTasksFromRole();
        }
        if (nextState.equals("outOfDateModules")) {
            return this.outOfDateModules(true);
        }
        if (nextState.equals("notInstalledModules")) {
            return this.notInstalledModules(true);
        }
        if (nextState.equals("installedModules")) {
            return this.installedModules(true);
        }
        if (nextState.equals("refreshOutOfDateModules")) {
            return this.refreshOutOfDateModules();
        }
        if (nextState.equals("refreshNotInstalledModules")) {
            return this.refreshNotInstalledModules();
        }
        if (nextState.equals("refreshInstalledModules")) {
            return this.refreshInstalledModules();
        }
        if (nextState.equals("delegateInstalledModules")) {
            return this.delegateInstalledModules();
        }
        if (nextState.equals("availableModules")) {
            return this.availableModules(true);
        }
        if (nextState.equals("refreshAvailableModules")) {
            return this.refreshAvailableModules();
        }
        if (nextState.equals("delegateNotInstalledModules")) {
            return this.delegateNotInstalledModules();
        }
        if (nextState.equals("delegateOutOfDateModules")) {
            return this.delegateOutOfDateModules();
        }
        if (nextState.equals("collectionSort")) {
            return this.collectionSort();
        }
        if (nextState.equals("contentSort")) {
            return this.contentSort();
        }
        if (nextState.equals("roleSortHandler")) {
            return this.roleSortHandler();
        }
        if (nextState.equals("taskSortHandler")) {
            return this.taskSortHandler();
        }
        if (nextState.equals("bookSortHandler")) {
            return this.bookSortHandler();
        }
        if (nextState.equals("moduleSortHandler")) {
            return this.moduleSortHandler();
        }
        if (nextState.equals("categorySortHandler")) {
            return this.categorySortHandler();
        }
        if (nextState.equals("createPropertyBook")) {
            return this.createPropertyBook();
        }
        return false;
    }

    public boolean initialState() {
        if (this.m_delegatedTaskStatus == null) {
            if (!this.isValidCollectionOwnerObjectType()) {
                return false;
            }
            this.m_collectionList2.clear();
            this.m_collectionList1.clear();
            this.m_selectedTab = "roletab";
            if (this.m_collectionTab == null) {
                this.m_collectionTab = "collection2Tab";
            }
            this.m_sortModuleStatusColumn = "1";
            this.m_sortModuleStatusDirection = "Descending";
            this.m_sortRoleColumn = "1";
            this.m_sortRoleDirection = "Descending";
            this.m_sortTaskColumn = "1";
            this.m_sortTaskDirection = "Descending";
            this.m_sortBookColumn = "1";
            this.m_sortBookDirection = "Descending";
            this.m_sortModuleColumn = "1";
            this.m_sortModuleDirection = "Descending";
            this.m_sortCategoryColumn = "1";
            this.m_sortCategoryDirection = "Descending";
            this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
            this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
            this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
            this.m_req.setAttribute("collectionTab", (Object)this.m_collectionTab);
            this.m_req.setAttribute("sortCollection1Column", (Object)this.m_sortCollection1Column);
            this.m_req.setAttribute("sortCollection1Direction", (Object)this.m_sortCollection1Direction);
            this.m_req.setAttribute("sortCollection2Column", (Object)this.m_sortCollection2Column);
            this.m_req.setAttribute("sortCollection2Direction", (Object)this.m_sortCollection2Direction);
            try {
                RBSSchemaVerifier rbsSchemaVerifier = new RBSSchemaVerifier(this.m_treeOE);
                this.m_isRBSSchemaValid = rbsSchemaVerifier.isSchemaValid();
            }
            catch (Exception exc) {
                this.m_isRBSSchemaValid = true;
            }
            try {
                this.getAllCollectionInfo();
            }
            catch (Exception exc) {
                String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
                eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                return false;
            }
            this.setCollectionTabMenu(this.m_collectionTab);
            this.m_isRBSInstalled = RBSUtil.isRBSInstalled(this.m_context);
            this.m_req.setAttribute("isRBSSchemaValid", (Object)(this.m_isRBSSchemaValid ? "true" : "false"));
            this.m_req.setAttribute("isRBSInstalled", (Object)(this.m_isRBSInstalled ? "true" : "false"));
        } else if (this.m_delegatedTaskStatus.equals("cancel")) {
            this.setCollectionTabMenu(this.m_collectionTab);
            this.m_req.setAttribute("collectionList2", (Object)this.m_collectionList2);
            this.m_req.setAttribute("collectionList1", (Object)this.m_collectionList1);
            this.m_req.setAttribute("isRBSSchemaValid", (Object)(this.m_isRBSSchemaValid ? "true" : "false"));
            this.m_req.setAttribute("isRBSInstalled", (Object)(this.m_isRBSInstalled ? "true" : "false"));
            this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
            this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
            this.m_req.setAttribute("sortCollection1Column", (Object)this.m_sortCollection1Column);
            this.m_req.setAttribute("sortCollection1Direction", (Object)this.m_sortCollection1Direction);
            this.m_req.setAttribute("sortCollection2Column", (Object)this.m_sortCollection2Column);
            this.m_req.setAttribute("sortCollection2Direction", (Object)this.m_sortCollection2Direction);
            this.m_delegatedTaskStatus = null;
        } else if (this.m_delegatedTaskStatus.equals("finished")) {
            this.setCollectionTabMenu(this.m_collectionTab);
            this.m_req.setAttribute("collectionList2", (Object)this.m_collectionList2);
            this.m_req.setAttribute("collectionList1", (Object)this.m_collectionList1);
            this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
            this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
            this.m_req.setAttribute("sortCollection1Column", (Object)this.m_sortCollection1Column);
            this.m_req.setAttribute("sortCollection1Direction", (Object)this.m_sortCollection1Direction);
            this.m_req.setAttribute("sortCollection2Column", (Object)this.m_sortCollection2Column);
            this.m_req.setAttribute("sortCollection2Direction", (Object)this.m_sortCollection2Direction);
            this.m_delegatedTaskStatus = null;
        }
        return true;
    }

    public boolean refreshInstalledModules() {
        try {
            this.getAllCollectionInfo();
        }
        catch (Exception exc) {
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        this.installedModules(false);
        return true;
    }

    public boolean refreshNotInstalledModules() {
        try {
            this.getAllCollectionInfo();
        }
        catch (Exception exc) {
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        this.notInstalledModules(false);
        return true;
    }

    public boolean refreshOutOfDateModules() {
        try {
            this.getAllCollectionInfo();
        }
        catch (Exception exc) {
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        this.outOfDateModules(false);
        return true;
    }

    private boolean checkRBSSchema() {
        boolean flag = true;
        String extendRBSSchema = this.getRequestAttributeOrParameter("extendRBSSchema");
        if (extendRBSSchema != null && extendRBSSchema.equalsIgnoreCase("true")) {
            eMFrameComponentInstall install = new eMFrameComponentInstall(this.m_treeOE, this.m_context);
            try {
                install.extendSchema();
                this.m_isRBSSchemaValid = true;
            }
            catch (Exception exc) {
                D.log(exc);
                eMFrameUtils.setErrorMessage(exc, this.m_context);
                flag = false;
            }
        }
        return flag;
    }

    public boolean notInstalledModules(boolean flag) {
        if (!this.checkRBSSchema()) {
            return false;
        }
        if (flag) {
            String sortModuleStatusColumn = this.getRequestAttributeOrParameter("sortModuleStatusColumn");
            this.m_sortModuleStatusDirection = !sortModuleStatusColumn.equalsIgnoreCase(this.m_sortModuleStatusColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortModuleStatusDirection");
            this.m_sortModuleStatusColumn = sortModuleStatusColumn;
        }
        if (this.m_haveSelectedCollectionName) {
            this.m_haveSelectedCollectionName = false;
        } else {
            String selectedCollection = this.getRequestAttributeOrParameter("selectedCollectionName");
            this.m_selectedCollectionName = eMFrameUtils.urlDecode(selectedCollection, this.m_context);
            this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        }
        CollectionData collectionData = null;
        ArrayList theList = this.m_collectionList2;
        Iterator iterator = theList.iterator();
        while (iterator.hasNext() && !this.m_selectedCollectionName.equalsIgnoreCase((collectionData = (CollectionData)iterator.next()).getObjectFDN())) {
        }
        theList = collectionData.getNotInstalledArrayList();
        String sortColumn = null;
        int column = new Integer(this.m_sortModuleStatusColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortAvailableVersion";
        }
        if (sortColumn != null) {
            Collections.sort(theList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortModuleStatusDirection));
        }
        TableCell[][] tableData = new TableCell[theList.size()][];
        int index = 0;
        Iterator iterator2 = theList.iterator();
        while (iterator2.hasNext()) {
            ModuleData element = (ModuleData)iterator2.next();
            tableData[index] = new TableCell[3];
            String iconUrl = "dev/dir/rbsModule2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Module", this.m_context.getLocale()), iconUrl, "module");
            tableData[index][1] = new TextTableCell(element.getDisplayName(), element.getObjectFDN());
            tableData[index][2] = new TextTableCell(element.getAvailableVersion(), element.getAvailableVersion());
            ++index;
        }
        this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
        this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
        return true;
    }

    public boolean installedModules(boolean flag) {
        if (!this.checkRBSSchema()) {
            return false;
        }
        if (flag) {
            String sortModuleStatusColumn = this.getRequestAttributeOrParameter("sortModuleStatusColumn");
            this.m_sortModuleStatusDirection = !sortModuleStatusColumn.equalsIgnoreCase(this.m_sortModuleStatusColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortModuleStatusDirection");
            this.m_sortModuleStatusColumn = sortModuleStatusColumn;
        }
        if (this.m_haveSelectedCollectionName) {
            this.m_haveSelectedCollectionName = false;
        } else {
            String selectedCollection = this.getRequestAttributeOrParameter("selectedCollectionName");
            this.m_selectedCollectionName = eMFrameUtils.urlDecode(selectedCollection, this.m_context);
            this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        }
        CollectionData collectionData = null;
        ArrayList theList = this.m_collectionList2;
        Iterator iterator = theList.iterator();
        while (iterator.hasNext() && !this.m_selectedCollectionName.equalsIgnoreCase((collectionData = (CollectionData)iterator.next()).getObjectFDN())) {
        }
        theList = collectionData.getInstalledArrayList();
        String sortColumn = null;
        int column = new Integer(this.m_sortModuleStatusColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortInstalledVersion";
        } else if (column == 3) {
            sortColumn = "sortAvailableVersion";
        }
        if (sortColumn != null) {
            Collections.sort(theList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortModuleStatusDirection));
        }
        TableCell[][] tableData = new TableCell[theList.size()][];
        int index = 0;
        Iterator iterator2 = theList.iterator();
        while (iterator2.hasNext()) {
            ModuleData element = (ModuleData)iterator2.next();
            tableData[index] = new TableCell[4];
            String iconUrl = "dev/dir/rbsModule2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Module", this.m_context.getLocale()), iconUrl, "module");
            tableData[index][1] = new TextTableCell(element.getDisplayName(), element.getObjectFDN());
            tableData[index][2] = new TextTableCell(element.getInstalledVersion(), element.getInstalledVersion());
            tableData[index][3] = new TextTableCell(element.getAvailableVersion(), element.getAvailableVersion());
            ++index;
        }
        this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
        this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
        return true;
    }

    public boolean outOfDateModules(boolean flag) {
        if (!this.checkRBSSchema()) {
            return false;
        }
        if (flag) {
            String sortModuleStatusColumn = this.getRequestAttributeOrParameter("sortModuleStatusColumn");
            this.m_sortModuleStatusDirection = !sortModuleStatusColumn.equalsIgnoreCase(this.m_sortModuleStatusColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortModuleStatusDirection");
            this.m_sortModuleStatusColumn = sortModuleStatusColumn;
        }
        if (this.m_haveSelectedCollectionName) {
            this.m_haveSelectedCollectionName = false;
        } else {
            String selectedCollection = this.getRequestAttributeOrParameter("selectedCollectionName");
            this.m_selectedCollectionName = eMFrameUtils.urlDecode(selectedCollection, this.m_context);
            this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        }
        CollectionData collectionData = null;
        ArrayList theList = this.m_collectionList2;
        Iterator iterator = theList.iterator();
        while (iterator.hasNext() && !this.m_selectedCollectionName.equalsIgnoreCase((collectionData = (CollectionData)iterator.next()).getObjectFDN())) {
        }
        theList = collectionData.getOutOfDateArrayList();
        String sortColumn = null;
        int column = new Integer(this.m_sortModuleStatusColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortInstalledVersion";
        } else if (column == 3) {
            sortColumn = "sortAvailableVersion";
        }
        if (sortColumn != null) {
            Collections.sort(theList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortModuleStatusDirection));
        }
        TableCell[][] tableData = new TableCell[theList.size()][];
        int index = 0;
        Iterator iterator2 = theList.iterator();
        while (iterator2.hasNext()) {
            ModuleData element = (ModuleData)iterator2.next();
            tableData[index] = new TableCell[4];
            String iconUrl = "dev/dir/rbsModule2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Module", this.m_context.getLocale()), iconUrl, "module");
            tableData[index][1] = new TextTableCell(element.getDisplayName(), element.getObjectFDN());
            tableData[index][2] = new TextTableCell(element.getInstalledVersion(), element.getInstalledVersion());
            tableData[index][3] = new TextTableCell(element.getAvailableVersion(), element.getAvailableVersion());
            ++index;
        }
        this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
        this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
        return true;
    }

    public boolean refreshAvailableModules() {
        try {
            this.getAllCollectionInfo();
        }
        catch (Exception exc) {
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        this.availableModules(false);
        return true;
    }

    public boolean availableModules(boolean flag) {
        if (!this.checkRBSSchema()) {
            return false;
        }
        if (flag) {
            String sortModuleStatusColumn = this.getRequestAttributeOrParameter("sortModuleStatusColumn");
            this.m_sortModuleStatusDirection = !sortModuleStatusColumn.equalsIgnoreCase(this.m_sortModuleStatusColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortModuleStatusDirection");
            this.m_sortModuleStatusColumn = sortModuleStatusColumn;
        }
        if (this.m_haveSelectedCollectionName) {
            this.m_haveSelectedCollectionName = false;
        } else {
            String selectedCollection = this.getRequestAttributeOrParameter("selectedCollectionName");
            this.m_selectedCollectionName = eMFrameUtils.urlDecode(selectedCollection, this.m_context);
            this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        }
        CollectionData collectionData = null;
        ArrayList theList = this.m_collectionList2;
        Iterator iterator = theList.iterator();
        while (iterator.hasNext() && !this.m_selectedCollectionName.equalsIgnoreCase((collectionData = (CollectionData)iterator.next()).getObjectFDN())) {
        }
        theList = collectionData.getAvailableArrayList();
        String sortColumn = null;
        int column = new Integer(this.m_sortModuleStatusColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortStatus";
        } else if (column == 3) {
            sortColumn = "sortInstalledVersion";
        } else if (column == 4) {
            sortColumn = "sortAvailableVersion";
        }
        if (sortColumn != null) {
            Collections.sort(theList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortModuleStatusDirection));
        }
        TableCell[][] tableData = new TableCell[theList.size()][];
        int index = 0;
        Iterator iterator2 = theList.iterator();
        while (iterator2.hasNext()) {
            ModuleData element = (ModuleData)iterator2.next();
            tableData[index] = new TableCell[5];
            String iconUrl = "dev/dir/rbsModule2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Module", this.m_context.getLocale()), iconUrl, "module");
            tableData[index][1] = new TextTableCell(element.getDisplayName(), element.getObjectFDN());
            tableData[index][2] = new TextTableCell(element.getLocalizedStatus(), element.getModuleStatus());
            tableData[index][3] = new TextTableCell(element.getInstalledVersion(), element.getInstalledVersion());
            tableData[index][4] = new TextTableCell(element.getAvailableVersion(), element.getAvailableVersion());
            ++index;
        }
        this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
        this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.m_req.setAttribute("tableData", (Object)tableData);
        return true;
    }

    private boolean collectionSelected() {
        if (this.m_delegatedTaskStatus == null) {
            String selectedCollectionNameEncoded;
            if (!this.checkRBSSchema()) {
                return false;
            }
            if (this.m_readCollectionInfo) {
                try {
                    this.getAllCollectionInfo();
                }
                catch (Exception exc) {
                    String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
                    eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                    return false;
                }
                this.m_readCollectionInfo = false;
            }
            if ((selectedCollectionNameEncoded = this.getRequestAttributeOrParameter("selectedCollectionNameEncoded")) != null && selectedCollectionNameEncoded.equals("true")) {
                String selectedCollection = this.getRequestAttributeOrParameter("selectedCollectionName");
                this.m_selectedCollectionName = eMFrameUtils.urlDecode(selectedCollection, this.m_context);
            }
            ObjectEntry collectionOE = null;
            this.m_categoryList.clear();
            this.m_roleList.clear();
            this.m_taskList.clear();
            this.m_bookList.clear();
            this.m_moduleList.clear();
            try {
                RBSObject[] rbsObject;
                RBSRole[] rbsRoleE;
                RBSRole[] rbsRole;
                collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedCollectionName);
                RBSCollection rbsCollection = new RBSCollection(collectionOE);
                RBSCategory[] rbsCategory = rbsCollection.getCategories();
                if (rbsCategory != null) {
                    for (int count = 0; count < rbsCategory.length; ++count) {
                        CategoryData categoryData = new CategoryData();
                        categoryData.setObjectFDN(this.m_ns.getUnrootedName(rbsCategory[count].getObjectEntry()));
                        String parameters = rbsCategory[count].getParameters();
                        String categoryDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsCategory[count].getObjectEntry());
                        categoryData.setDisplayName(categoryDisplayName);
                        String moduleName = this.getKeyFromParameters(parameters, "module");
                        if (moduleName != null) {
                            String moduleDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName);
                            categoryData.setModuleDisplayName(moduleDisplayName);
                        } else {
                            String displayName = eMFrameUtils.getLocalizedString("FwResources", "RBS.CustomDisplayName", this.m_context.getLocale());
                            if (displayName == null || displayName.length() == 0) {
                                displayName = "Custom";
                            }
                            categoryData.setModuleDisplayName(displayName);
                        }
                        this.m_categoryList.add(categoryData);
                    }
                }
                if ((rbsRole = rbsCollection.getSpecifiedRoles(new String[]{"iManager"})) != null) {
                    for (int count = 0; count < rbsRole.length; ++count) {
                        String expiredVersion;
                        RoleData roleData = new RoleData();
                        roleData.setRoleType("iManager");
                        roleData.setSelfManageRole("false");
                        roleData.setObjectFDN(this.m_ns.getUnrootedName(rbsRole[count].getObjectEntry()));
                        String parameters = rbsRole[count].getParameters();
                        String roleDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsRole[count].getObjectEntry());
                        roleData.setDisplayName(roleDisplayName);
                        String moduleName = this.getKeyFromParameters(parameters, "module");
                        if (moduleName != null) {
                            String moduleDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName);
                            roleData.setModuleDisplayName(moduleDisplayName);
                        } else {
                            String displayName = eMFrameUtils.getLocalizedString("FwResources", "RBS.CustomDisplayName", this.m_context.getLocale());
                            if (displayName == null || displayName.length() == 0) {
                                displayName = "Custom";
                            }
                            roleData.setModuleDisplayName(displayName);
                        }
                        String initialVersion = this.getKeyFromParameters(parameters, "required-version");
                        if (initialVersion != null) {
                            roleData.setInitialVersion(initialVersion);
                        }
                        if ((expiredVersion = this.getKeyFromParameters(parameters, "expired-version")) != null) {
                            roleData.setExpiredVersion(expiredVersion);
                        }
                        roleData.setPackedData(eMFrameUtils.pack(new String[]{roleData.getObjectFDN(), roleData.getDisplayName(), roleData.getRoleType(), roleData.getSelfManageRole()}, this.m_context));
                        this.m_roleList.add(roleData);
                    }
                }
                if ((rbsRoleE = rbsCollection.getSpecifiedRoles(new String[]{"eGuide"})) != null) {
                    for (int count = 0; count < rbsRoleE.length; ++count) {
                        String expiredVersion;
                        String initialVersion;
                        RoleData roleData = new RoleData();
                        roleData.setRoleType("eGuide");
                        roleData.setObjectFDN(this.m_ns.getUnrootedName(rbsRoleE[count].getObjectEntry()));
                        String parameters = rbsRoleE[count].getParameters();
                        String roleDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsRoleE[count].getObjectEntry());
                        roleData.setDisplayName(roleDisplayName);
                        String moduleName = this.getKeyFromParameters(parameters, "module");
                        if (moduleName != null) {
                            String moduleDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName);
                            roleData.setModuleDisplayName(moduleDisplayName);
                        } else {
                            String displayName = eMFrameUtils.getLocalizedString("FwResources", "RBS.CustomDisplayName", this.m_context.getLocale());
                            if (displayName == null || displayName.length() == 0) {
                                displayName = "Custom";
                            }
                            roleData.setModuleDisplayName(displayName);
                        }
                        String selfProvisioning = this.getKeyFromParameters(parameters, "self-provisioning");
                        if (selfProvisioning != null) {
                            roleData.setSelfManageRole(selfProvisioning);
                        }
                        if ((initialVersion = this.getKeyFromParameters(parameters, "required-version")) != null) {
                            roleData.setInitialVersion(initialVersion);
                        }
                        if ((expiredVersion = this.getKeyFromParameters(parameters, "expired-version")) != null) {
                            roleData.setExpiredVersion(expiredVersion);
                        }
                        roleData.setPackedData(eMFrameUtils.pack(new String[]{roleData.getObjectFDN(), roleData.getDisplayName(), roleData.getRoleType(), roleData.getSelfManageRole()}, this.m_context));
                        this.m_roleList.add(roleData);
                    }
                }
                if ((rbsObject = rbsCollection.getAllTasksAndBooks()) != null) {
                    for (int count = 0; count < rbsObject.length; ++count) {
                        String expiredVersion;
                        String initialVersion;
                        String displayName;
                        String moduleDisplayName;
                        String moduleName;
                        if (rbsObject[count].getObjectEntry().getObjectType().getName().equals("rbsBook2")) {
                            String expiredVersion2;
                            BookData bookData = new BookData();
                            bookData.setObjectFDN(this.m_ns.getUnrootedName(rbsObject[count].getObjectEntry()));
                            RBSBook rbsBook = new RBSBook(rbsObject[count].getObjectEntry());
                            String parameters = rbsBook.getParameters();
                            String bookDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsObject[count].getObjectEntry());
                            bookData.setDisplayName(bookDisplayName);
                            String moduleName2 = this.getKeyFromParameters(parameters, "module");
                            if (moduleName2 != null) {
                                String moduleDisplayName2 = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName2);
                                bookData.setModuleDisplayName(moduleDisplayName2);
                            } else {
                                String displayName2 = eMFrameUtils.getLocalizedString("FwResources", "RBS.CustomDisplayName", this.m_context.getLocale());
                                if (displayName2 == null || displayName2.length() == 0) {
                                    displayName2 = "Custom";
                                }
                                bookData.setModuleDisplayName(displayName2);
                            }
                            String initialVersion2 = this.getKeyFromParameters(parameters, "required-version");
                            if (initialVersion2 != null) {
                                bookData.setInitialVersion(initialVersion2);
                            }
                            if ((expiredVersion2 = this.getKeyFromParameters(parameters, "expired-version")) != null) {
                                bookData.setExpiredVersion(expiredVersion2);
                            }
                            this.m_bookList.add(bookData);
                            continue;
                        }
                        RBSTask rbsTask = new RBSTask(rbsObject[count].getObjectEntry());
                        String parameters = rbsTask.getParameters();
                        String taskType = this.getKeyFromParameters(parameters, "type");
                        if (taskType == null || !taskType.equals("eGuide")) {
                            TaskData taskData = new TaskData();
                            taskData.setObjectFDN(this.m_ns.getUnrootedName(rbsObject[count].getObjectEntry()));
                            String taskDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsObject[count].getObjectEntry());
                            taskData.setDisplayName(taskDisplayName);
                            moduleName = this.getKeyFromParameters(parameters, "module");
                            if (moduleName != null) {
                                moduleDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName);
                                taskData.setModuleDisplayName(moduleDisplayName);
                            } else {
                                displayName = eMFrameUtils.getLocalizedString("FwResources", "RBS.CustomDisplayName", this.m_context.getLocale());
                                if (displayName == null || displayName.length() == 0) {
                                    displayName = "Custom";
                                }
                                taskData.setModuleDisplayName(displayName);
                            }
                            initialVersion = this.getKeyFromParameters(parameters, "required-version");
                            if (initialVersion != null) {
                                taskData.setInitialVersion(initialVersion);
                            }
                            if ((expiredVersion = this.getKeyFromParameters(parameters, "expired-version")) != null) {
                                taskData.setExpiredVersion(expiredVersion);
                            }
                            this.m_taskList.add(taskData);
                            continue;
                        }
                        TaskData eGuideTaskData = new TaskData();
                        eGuideTaskData.setObjectFDN(this.m_ns.getUnrootedName(rbsObject[count].getObjectEntry()));
                        String eGuideTaskDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsObject[count].getObjectEntry());
                        eGuideTaskData.setDisplayName(eGuideTaskDisplayName);
                        moduleName = this.getKeyFromParameters(parameters, "module");
                        if (moduleName != null) {
                            moduleDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName);
                            eGuideTaskData.setModuleDisplayName(moduleDisplayName);
                        } else {
                            displayName = eMFrameUtils.getLocalizedString("FwResources", "RBS.CustomDisplayName", this.m_context.getLocale());
                            if (displayName == null || displayName.length() == 0) {
                                displayName = "Custom";
                            }
                            eGuideTaskData.setModuleDisplayName(displayName);
                        }
                        initialVersion = this.getKeyFromParameters(parameters, "required-version");
                        if (initialVersion != null) {
                            eGuideTaskData.setInitialVersion(initialVersion);
                        }
                        if ((expiredVersion = this.getKeyFromParameters(parameters, "expired-version")) != null) {
                            eGuideTaskData.setExpiredVersion(expiredVersion);
                        }
                        this.m_taskList.add(eGuideTaskData);
                    }
                }
                RBSModule[] rbsModule = rbsCollection.getAllModules();
                String[] moduleNameList = null;
                if (rbsModule != null) {
                    moduleNameList = new String[rbsModule.length];
                    for (int count = 0; count < rbsModule.length; ++count) {
                        ModuleData moduleData = new ModuleData();
                        String moduleName = rbsModule[count].getObjectEntry().getName();
                        moduleData.setObjectFDN(this.m_ns.getUnrootedName(rbsModule[count].getObjectEntry()));
                        String moduleDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.m_context, moduleName);
                        moduleData.setDisplayName(moduleDisplayName);
                        this.m_moduleList.add(moduleData);
                        moduleNameList[count] = moduleName;
                    }
                }
                this.m_packedModuleNameList = eMFrameUtils.pack(moduleNameList, this.m_context);
            }
            catch (Exception exc) {
                String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
                eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                return false;
            }
            this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
            this.m_req.setAttribute("categoryList", (Object)this.m_categoryList);
            this.m_req.setAttribute("roleList", (Object)this.m_roleList);
            this.m_req.setAttribute("taskList", (Object)this.m_taskList);
            this.m_req.setAttribute("bookList", (Object)this.m_bookList);
            this.m_req.setAttribute("moduleList", (Object)this.m_moduleList);
            this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
            this.setSelectedTabMenu(this.m_selectedTab);
        } else if (this.m_delegatedTaskStatus.equals("cancel")) {
            this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
            this.m_req.setAttribute("categoryList", (Object)this.m_categoryList);
            this.m_req.setAttribute("roleList", (Object)this.m_roleList);
            this.m_req.setAttribute("taskList", (Object)this.m_taskList);
            this.m_req.setAttribute("bookList", (Object)this.m_bookList);
            this.m_req.setAttribute("moduleList", (Object)this.m_moduleList);
            this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
            this.setSelectedTabMenu(this.m_selectedTab);
            this.m_delegatedTaskStatus = null;
        }
        return true;
    }

    private boolean roleSelected() {
        if (this.m_delegatedTaskStatus == null) {
            this.m_contentList.clear();
            if (this.m_haveSelectedRoleName) {
                this.m_haveSelectedRoleName = false;
            } else {
                this.m_selectedRoleName = this.getRequestAttributeOrParameter("SelectedRoleFullName");
                String[] strings = eMFrameUtils.unpack(this.m_selectedRoleName, this.m_context);
                this.m_selectedRoleName = eMFrameUtils.urlDecode(strings[0], this.m_context);
                this.m_selectedRoleDisplayName = this.getRequestAttributeOrParameter("SelectedRoleDisplayName");
                strings = eMFrameUtils.unpack(this.m_selectedRoleDisplayName, this.m_context);
                this.m_selectedRoleDisplayName = eMFrameUtils.urlDecode(strings[0], this.m_context);
            }
            ObjectEntry roleOE = null;
            try {
                roleOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedRoleName);
                RBSRole rbsRole = new RBSRole(roleOE);
                RBSObject[] rbsObject = rbsRole.getContent();
                if (rbsObject != null) {
                    for (int count = 0; count < rbsObject.length; ++count) {
                        String expiredVersion;
                        ContentData contentData = new ContentData();
                        contentData.setObjectFDN(this.m_ns.getUnrootedName(rbsObject[count].getObjectEntry()));
                        if (rbsObject[count] instanceof RBSBook) {
                            contentData.setContentType("book");
                        } else {
                            contentData.setContentType("task");
                        }
                        String parameters = ((RBSTask)rbsObject[count]).getParameters();
                        String contentDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsObject[count].getObjectEntry());
                        contentData.setDisplayName(contentDisplayName);
                        String initialVersion = this.getKeyFromParameters(parameters, "required-version");
                        if (initialVersion != null) {
                            contentData.setInitialVersion(initialVersion);
                        }
                        if ((expiredVersion = this.getKeyFromParameters(parameters, "expired-version")) != null) {
                            contentData.setExpiredVersion(expiredVersion);
                        }
                        this.m_contentList.add(contentData);
                    }
                }
            }
            catch (Exception exc) {
                String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
                eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                return false;
            }
            this.m_req.setAttribute("SelectedRoleDisplayName", (Object)this.m_selectedRoleDisplayName);
            this.m_req.setAttribute("SelectedRoleFullName", (Object)this.m_selectedRoleName);
            this.m_roleType = this.getRequestAttributeOrParameter("RBSAdmin_RoleType");
            this.m_req.setAttribute("RBSAdmin_RoleType", (Object)this.m_roleType);
            this.m_selfProvisioningRole = this.getRequestAttributeOrParameter("SelfProvisioningRole");
            this.m_req.setAttribute("SelfProvisioningRole", (Object)this.m_selfProvisioningRole);
            this.setContentMenu();
        } else {
            this.m_req.setAttribute("contentList", (Object)this.m_contentList);
            this.m_req.setAttribute("SelectedRoleDisplayName", (Object)this.m_selectedRoleDisplayName);
            this.m_req.setAttribute("SelectedRoleFullName", (Object)this.m_selectedRoleName);
            this.m_req.setAttribute("RBSAdmin_RoleType", (Object)this.m_roleType);
            this.m_req.setAttribute("SelfProvisioningRole", (Object)this.m_selfProvisioningRole);
            this.m_req.setAttribute("sortContentColumn", (Object)this.m_sortContentColumn);
            this.m_req.setAttribute("sortContentDirection", (Object)this.m_sortContentDirection);
            this.m_delegatedTaskStatus = null;
        }
        return true;
    }

    private boolean setSelectedTab() {
        this.m_selectedTab = this.getRequestAttributeOrParameter("selectedTab");
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setSelectedTabMenu(this.m_selectedTab);
        return true;
    }

    private boolean setCollectionTab() {
        this.m_collectionTab = this.getRequestAttributeOrParameter("collectionTab");
        this.m_req.setAttribute("collectionTab", (Object)this.m_collectionTab);
        this.m_req.setAttribute("collectionList1", (Object)this.m_collectionList1);
        this.m_req.setAttribute("isRBSSchemaValid", (Object)(this.m_isRBSSchemaValid ? "true" : "false"));
        this.m_req.setAttribute("isRBSInstalled", (Object)(this.m_isRBSInstalled ? "true" : "false"));
        this.setCollectionTabMenu(this.m_collectionTab);
        return true;
    }

    private boolean delegateNotInstalledModules() {
        String moduleListPacked = this.getRequestAttributeOrParameter("ModuleListPacked");
        String selectedCollectionName = this.getRequestAttributeOrParameter("selectedCollectionName");
        selectedCollectionName = eMFrameUtils.pack(new String[]{selectedCollectionName}, this.m_context);
        String delegatedFrom = this.getRequestAttributeOrParameter("delegatedFrom");
        String reinstallModule = this.getRequestAttributeOrParameter("reinstallModule");
        this.m_haveSelectedCollectionName = true;
        String url = "frameservice?NPService=fw.LaunchService&NPAction=Delegate&delegate=fw.Not Installed Modules&launcher=" + this.getRequestAttributeOrParameter("taskId") + "&lifecycle=Recreate" + "&nextState=initialState" + "&ModuleListPacked=" + moduleListPacked + "&reinstallModule=" + reinstallModule + "&selectedCollectionNameModule=" + selectedCollectionName;
        this.m_resultStrings.put("UrlTask.url", url.toString());
        this.setUIPage("fw/UrlTask.jsp");
        if (delegatedFrom.equalsIgnoreCase("NotInstalledModules")) {
            this.m_merge = "fw.NotInstalledModules";
            this.m_nextState = "refreshNotInstalledModules";
        } else if (delegatedFrom.equalsIgnoreCase("InstalledModules")) {
            this.m_merge = "fw.InstalledModules";
            this.m_nextState = "refreshInstalledModules";
        } else {
            this.m_merge = "fw.AvailableModules";
            this.m_nextState = "refreshAvailableModules";
        }
        return true;
    }

    private boolean delegateOutOfDateModules() {
        String moduleListPacked = this.getRequestAttributeOrParameter("ModuleListPacked");
        String selectedCollectionName = this.getRequestAttributeOrParameter("selectedCollectionName");
        selectedCollectionName = eMFrameUtils.pack(new String[]{selectedCollectionName}, this.m_context);
        String delegatedFrom = this.getRequestAttributeOrParameter("delegatedFrom");
        this.m_haveSelectedCollectionName = true;
        String url = "frameservice?NPService=fw.LaunchService&NPAction=Delegate&delegate=fw.Out Of Date Modules&launcher=" + this.getRequestAttributeOrParameter("taskId") + "&lifecycle=Recreate" + "&nextState=initialState" + "&ModuleListPacked=" + moduleListPacked + "&selectedCollectionNameModule=" + selectedCollectionName;
        this.m_resultStrings.put("UrlTask.url", url.toString());
        this.setUIPage("fw/UrlTask.jsp");
        if (delegatedFrom.equalsIgnoreCase("OutOfDateModules")) {
            this.m_merge = "fw.OutOfDateModules";
            this.m_nextState = "refreshOutOfDateModules";
        } else {
            this.m_merge = "fw.AvailableModules";
            this.m_nextState = "refreshAvailableModules";
        }
        return true;
    }

    private boolean delegateInstalledModules() {
        String moduleListPacked = this.getRequestAttributeOrParameter("ModuleListPacked");
        String selectedCollectionName = this.getRequestAttributeOrParameter("selectedCollectionName");
        selectedCollectionName = eMFrameUtils.pack(new String[]{selectedCollectionName}, this.m_context);
        String delegatedFrom = this.getRequestAttributeOrParameter("delegatedFrom");
        this.m_haveSelectedCollectionName = true;
        String url = "frameservice?NPService=fw.LaunchService&NPAction=Delegate&delegate=fw.Installed Modules&launcher=" + this.getRequestAttributeOrParameter("taskId") + "&lifecycle=Recreate" + "&nextState=initialState" + "&ModuleListPacked=" + moduleListPacked + "&selectedCollectionNameModule=" + selectedCollectionName;
        this.m_resultStrings.put("UrlTask.url", url.toString());
        this.setUIPage("fw/UrlTask.jsp");
        if (delegatedFrom.equalsIgnoreCase("InstalledModules")) {
            this.m_merge = "fw.InstalledModules";
            this.m_nextState = "refreshInstalledModules";
        } else if (delegatedFrom.equalsIgnoreCase("AvailableModules")) {
            this.m_merge = "fw.AvailableModules";
            this.m_nextState = "refreshAvailableModules";
        } else {
            this.m_merge = "fw.OutOfDateModules";
            this.m_nextState = "refreshOutOfDateModules";
        }
        return true;
    }

    private void setCollectionTabMenu(String collectionTab) {
        if (collectionTab.equals("collection2Tab")) {
            this.setCollection2Menu();
        } else if (collectionTab.equals("collection1Tab")) {
            this.setCollection1Menu();
        }
    }

    private void setSelectedTabMenu(String selectedTab) {
        if (selectedTab.equals("roletab")) {
            this.setRoleMenu();
        } else if (selectedTab.equals("tasktab")) {
            this.setTaskMenu();
        } else if (selectedTab.equals("booktab")) {
            this.setBookMenu();
        } else if (selectedTab.equals("moduletab")) {
            this.setModuleMenu();
        } else if (selectedTab.equals("categorytab")) {
            this.setCategoryMenu();
        }
    }

    private void setCollection2Menu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortCollection2Column);
        if (column == 1) {
            sortColumn = "sortFDNName";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_collectionList2, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortCollection2Direction));
        }
        ArrayList theCollectionList = this.m_collectionList2;
        TableCell[][] tableData = new TableCell[theCollectionList.size()][];
        int index = 0;
        Iterator iterator = theCollectionList.iterator();
        while (iterator.hasNext()) {
            CollectionData collection = (CollectionData)iterator.next();
            tableData[index] = new TableCell[6];
            String iconUrl = "dev/dir/rbsCollection2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Collection", this.m_context.getLocale()), iconUrl, "collection");
            tableData[index][1] = new LinkTableCell(collection.getObjectFDN(), collection.getObjectFDN());
            tableData[index][2] = new LinkTableCell(Integer.toString(collection.getAvailableModulesCount()), collection.getObjectFDN());
            tableData[index][3] = new LinkTableCell(Integer.toString(collection.getInstalledModulesCount()), collection.getObjectFDN());
            tableData[index][4] = new LinkTableCell(Integer.toString(collection.getOutOfDateModulesCount()), collection.getObjectFDN());
            tableData[index][5] = new LinkTableCell(Integer.toString(collection.getNotInstalledModulesCount()), collection.getObjectFDN());
            ++index;
        }
        this.m_req.setAttribute("sortCollection1Column", (Object)this.m_sortCollection1Column);
        this.m_req.setAttribute("sortCollection1Direction", (Object)this.m_sortCollection1Direction);
        this.m_req.setAttribute("sortCollection2Column", (Object)this.m_sortCollection2Column);
        this.m_req.setAttribute("sortCollection2Direction", (Object)this.m_sortCollection2Direction);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private void setCollection1Menu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortCollection1Column);
        if (column == 1) {
            sortColumn = "sortFDNName";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_collectionList1, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortCollection1Direction));
        }
        ArrayList theCollectionList = this.m_collectionList1;
        TableCell[][] tableData = new TableCell[theCollectionList.size()][];
        int index = 0;
        Iterator iterator = theCollectionList.iterator();
        while (iterator.hasNext()) {
            CollectionData collection = (CollectionData)iterator.next();
            tableData[index] = new TableCell[2];
            String iconUrl = "dev/dir/rbsCollection2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Collection", this.m_context.getLocale()), iconUrl, "collection");
            tableData[index][1] = new TextTableCell(collection.getObjectFDN(), collection.getObjectFDN());
            ++index;
        }
        this.m_req.setAttribute("sortCollection1Column", (Object)this.m_sortCollection1Column);
        this.m_req.setAttribute("sortCollection1Direction", (Object)this.m_sortCollection1Direction);
        this.m_req.setAttribute("sortCollection2Column", (Object)this.m_sortCollection2Column);
        this.m_req.setAttribute("sortCollection2Direction", (Object)this.m_sortCollection2Direction);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private void setRoleMenu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortRoleColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortModule";
        } else if (column == 3) {
            sortColumn = "sortInitialVersion";
        } else if (column == 4) {
            sortColumn = "sortExpiredVersion";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_roleList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortRoleDirection));
        }
        ArrayList theRoleList = this.m_roleList;
        TableCell[][] tableData = new TableCell[theRoleList.size()][];
        int index = 0;
        Iterator iterator = theRoleList.iterator();
        while (iterator.hasNext()) {
            RoleData role = (RoleData)iterator.next();
            tableData[index] = new TableCell[5];
            String iconUrl = "dev/dir/rbsRole2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Role", this.m_context.getLocale()), iconUrl, "role");
            tableData[index][1] = new LinkTableCell(role.getDisplayName(), role.getPackedData());
            tableData[index][2] = new TextTableCell(role.getModuleDisplayName(), role.getModuleDisplayName());
            tableData[index][3] = new TextTableCell(role.getInitialVersion(), role.getInitialVersion());
            tableData[index][4] = new TextTableCell(role.getExpiredVersion(), role.getExpiredVersion());
            ++index;
        }
        this.m_req.setAttribute("sortRoleColumn", (Object)this.m_sortRoleColumn);
        this.m_req.setAttribute("sortRoleDirection", (Object)this.m_sortRoleDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private void setTaskMenu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortTaskColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortModule";
        } else if (column == 3) {
            sortColumn = "sortInitialVersion";
        } else if (column == 4) {
            sortColumn = "sortExpiredVersion";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_taskList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortTaskDirection));
        }
        ArrayList theTaskList = this.m_taskList;
        TableCell[][] tableData = new TableCell[theTaskList.size()][];
        int index = 0;
        Iterator iterator = theTaskList.iterator();
        while (iterator.hasNext()) {
            TaskData task = (TaskData)iterator.next();
            tableData[index] = new TableCell[5];
            String iconUrl = "dev/dir/rbsTask2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Task", this.m_context.getLocale()), iconUrl, "task");
            tableData[index][1] = new TextTableCell(task.getDisplayName(), task.getObjectFDN());
            tableData[index][2] = new TextTableCell(task.getModuleDisplayName(), task.getModuleDisplayName());
            tableData[index][3] = new TextTableCell(task.getInitialVersion(), task.getInitialVersion());
            tableData[index][4] = new TextTableCell(task.getExpiredVersion(), task.getExpiredVersion());
            ++index;
        }
        this.m_req.setAttribute("sortTaskColumn", (Object)this.m_sortTaskColumn);
        this.m_req.setAttribute("sortTaskDirection", (Object)this.m_sortTaskDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private void setBookMenu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortBookColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortModule";
        } else if (column == 3) {
            sortColumn = "sortInitialVersion";
        } else if (column == 4) {
            sortColumn = "sortExpiredVersion";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_bookList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortBookDirection));
        }
        ArrayList theBookList = this.m_bookList;
        TableCell[][] tableData = new TableCell[theBookList.size()][];
        int index = 0;
        Iterator iterator = theBookList.iterator();
        while (iterator.hasNext()) {
            BookData book = (BookData)iterator.next();
            tableData[index] = new TableCell[5];
            String iconUrl = "dev/dir/rbsBook2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.PropertyBook", this.m_context.getLocale()), iconUrl, "book");
            tableData[index][1] = new TextTableCell(book.getDisplayName(), book.getObjectFDN());
            tableData[index][2] = new TextTableCell(book.getModuleDisplayName(), book.getModuleDisplayName());
            tableData[index][3] = new TextTableCell(book.getInitialVersion(), book.getInitialVersion());
            tableData[index][4] = new TextTableCell(book.getExpiredVersion(), book.getExpiredVersion());
            ++index;
        }
        this.m_req.setAttribute("sortBookColumn", (Object)this.m_sortBookColumn);
        this.m_req.setAttribute("sortBookDirection", (Object)this.m_sortBookDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private void setModuleMenu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortModuleColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_moduleList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortModuleDirection));
        }
        ArrayList theModuleList = this.m_moduleList;
        TableCell[][] tableData = new TableCell[theModuleList.size()][];
        int index = 0;
        Iterator iterator = theModuleList.iterator();
        while (iterator.hasNext()) {
            ModuleData module = (ModuleData)iterator.next();
            tableData[index] = new TableCell[2];
            String iconUrl = "dev/dir/rbsModule2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Module", this.m_context.getLocale()), iconUrl, "module");
            tableData[index][1] = new TextTableCell(module.getDisplayName(), module.getObjectFDN());
            ++index;
        }
        this.m_req.setAttribute("sortModuleColumn", (Object)this.m_sortModuleColumn);
        this.m_req.setAttribute("sortModuleDirection", (Object)this.m_sortModuleDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private void setCategoryMenu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortCategoryColumn);
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortModule";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_categoryList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortCategoryDirection));
        }
        ArrayList theCategoryList = this.m_categoryList;
        TableCell[][] tableData = new TableCell[theCategoryList.size()][];
        int index = 0;
        Iterator iterator = theCategoryList.iterator();
        while (iterator.hasNext()) {
            CategoryData category = (CategoryData)iterator.next();
            tableData[index] = new TableCell[3];
            String iconUrl = "dev/dir/rbsCategory2.gif";
            tableData[index][0] = new IconTableCell(eMFrameUtils.getLocalizedString("FwResources", "RBS.Category", this.m_context.getLocale()), iconUrl, "category");
            tableData[index][1] = new TextTableCell(category.getDisplayName(), category.getObjectFDN());
            tableData[index][2] = new TextTableCell(category.getModuleDisplayName(), category.getModuleDisplayName());
            ++index;
        }
        this.m_req.setAttribute("sortCategoryColumn", (Object)this.m_sortCategoryColumn);
        this.m_req.setAttribute("sortCategoryDirection", (Object)this.m_sortCategoryDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private boolean backToCollectionList() {
        this.m_req.setAttribute("isRBSSchemaValid", (Object)(this.m_isRBSSchemaValid ? "true" : "false"));
        this.m_req.setAttribute("collectionList2", (Object)this.m_collectionList2);
        this.m_req.setAttribute("collectionList1", (Object)this.m_collectionList1);
        this.m_selectedTab = "roletab";
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("collectionTab", (Object)this.m_collectionTab);
        this.m_sortModuleStatusColumn = "1";
        this.m_sortModuleStatusDirection = "Descending";
        this.m_req.setAttribute("sortModuleStatusColumn", (Object)this.m_sortModuleStatusColumn);
        this.m_req.setAttribute("sortModuleStatusDirection", (Object)this.m_sortModuleStatusDirection);
        this.m_sortContentColumn = "1";
        this.m_sortContentDirection = "Descending";
        this.setCollectionTabMenu(this.m_collectionTab);
        return true;
    }

    private boolean backToRoleList() {
        this.m_sortContentColumn = "1";
        this.m_sortContentDirection = "Descending";
        this.m_contentList.clear();
        this.m_selectedRoleDisplayName = "";
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("categoryList", (Object)this.m_categoryList);
        this.m_req.setAttribute("roleList", (Object)this.m_roleList);
        this.m_req.setAttribute("SelectedRoleDisplayName", (Object)this.m_selectedRoleDisplayName);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setSelectedTabMenu(this.m_selectedTab);
        return true;
    }

    private String getKeyFromParameters(String paramStr, String key) {
        if (paramStr == null || paramStr.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        if (parameters == null) {
            return null;
        }
        return (String)parameters.get(key);
    }

    private boolean removeTasksFromRole() {
        String tasksToKeepPacked = this.getRequestAttributeOrParameter("TasksToKeepPacked");
        String[] tasksToKeep = eMFrameUtils.unpack(tasksToKeepPacked, this.m_context);
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        RBSObject[] rbsContent = null;
        try {
            ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedRoleName);
            RBSRole rbsRole = new RBSRole(roleOE);
            if (tasksToKeep.length > 0) {
                rbsContent = new RBSObject[tasksToKeep.length];
                for (int i = 0; i < tasksToKeep.length; ++i) {
                    ObjectEntry contentOE = this.m_ns.getObjectEntry(this.m_treeOE, tasksToKeep[i]);
                    rbsContent[i] = new RBSTask(contentOE);
                }
            }
            rbsRole.setContent(rbsContent, dynamicGroupSearchType);
            rbsRole.update();
        }
        catch (Exception exc) {
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRole.Title", this.m_context.getLocale());
        String strBody = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRole.Success", this.m_context.getLocale());
        eMFrameUtils.setMessage("success", strTitle, strBody + this.m_selectedRoleName, this.m_context);
        this.m_haveSelectedRoleName = true;
        return true;
    }

    private void getAllCollectionInfo() throws Exception {
        RBSCollection[] rbsCollections1;
        int count;
        RBSCollection[] rbsCollections2;
        this.m_collectionList2.clear();
        this.m_collectionList1.clear();
        RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(this.m_ns.getAuthenticatedIdentity(this.m_treeOE));
        InstallXMLInfo[] installXMLInfo = this.getAllPlugins();
        if (installXMLInfo != null) {
            rbsCollections2 = rbsAssociatedObject.getAllOwnedCollections2();
            if (rbsCollections2 != null) {
                for (count = 0; count < rbsCollections2.length; ++count) {
                    int i;
                    Vector<ModuleData> installedModules = new Vector<ModuleData>();
                    Vector<ModuleData> outOfDateModules = new Vector<ModuleData>();
                    Vector<ModuleData> notInstalledModules = new Vector<ModuleData>();
                    Vector<String> noPluginsModule = new Vector<String>();
                    Vector<ModuleData> allAvailableModules = new Vector<ModuleData>();
                    CollectionData collectionData = new CollectionData();
                    collectionData.setObjectFDN(this.m_ns.getUnrootedName(rbsCollections2[count].getObjectEntry()));
                    RBSCollection rbsCollection = new RBSCollection(rbsCollections2[count].getObjectEntry());
                    RBSModule[] rbsModules = rbsCollection.getAllModules();
                    if (rbsModules != null && rbsModules.length > 0) {
                        for (int k = 0; k < rbsModules.length; ++k) {
                            noPluginsModule.add(rbsModules[k].getObjectEntry().getName());
                        }
                        for (i = 0; i < installXMLInfo.length; ++i) {
                            String fileVersion = installXMLInfo[i].getVersion();
                            String moduleID = installXMLInfo[i].getModuleName();
                            boolean found = false;
                            for (int k = 0; k < rbsModules.length; ++k) {
                                ModuleData moduleData;
                                InstallXMLInfo installInfo;
                                String modName = rbsModules[k].getObjectEntry().getName();
                                if (this.m_isLDAP) {
                                    modName = modName.substring(3);
                                }
                                if (!moduleID.equalsIgnoreCase(modName)) continue;
                                found = true;
                                String objectVersion = RBSUtil.getVersionFromElement(rbsModules[k].getrbsXMLInfo("version"));
                                if (objectVersion == null) {
                                    D.log("The version element for " + this.m_ns.getUnrootedName(rbsModules[k].getObjectEntry()) + " has not been set.  Initializing to 0.0.0.");
                                    objectVersion = "0.0.0";
                                }
                                if (RBSUtil.isModuleUpdateNeeded(objectVersion, fileVersion)) {
                                    installInfo = installXMLInfo[i].copy();
                                    installInfo.setIsUpgrade(true);
                                    moduleData = new ModuleData(installInfo.getModuleName(), installInfo.getDisplayName(), "OutOfDate", eMFrameUtils.getLocalizedString("FwResources", "RBS.ModuleStausOutOfDate", this.m_context.getLocale()), objectVersion, fileVersion);
                                    outOfDateModules.add(moduleData);
                                    allAvailableModules.add(moduleData);
                                    noPluginsModule.remove(installInfo.getModuleName());
                                    break;
                                }
                                installInfo = installXMLInfo[i].copy();
                                installInfo.setIsUpgrade(false);
                                moduleData = new ModuleData(installInfo.getModuleName(), installInfo.getDisplayName(), "Installed", eMFrameUtils.getLocalizedString("FwResources", "RBS.ModuleStausInstalled", this.m_context.getLocale()), objectVersion, fileVersion);
                                installedModules.add(moduleData);
                                allAvailableModules.add(moduleData);
                                noPluginsModule.remove(installInfo.getModuleName());
                                break;
                            }
                            if (found) continue;
                            InstallXMLInfo installInfo = installXMLInfo[i].copy();
                            installInfo.setIsUpgrade(false);
                            ModuleData moduleData = new ModuleData(installInfo.getModuleName(), installInfo.getDisplayName(), "NotInstalled", eMFrameUtils.getLocalizedString("FwResources", "RBS.ModuleStausNotInstalled", this.m_context.getLocale()), eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.NotApplicable", this.m_context.getLocale()), fileVersion);
                            notInstalledModules.add(moduleData);
                            allAvailableModules.add(moduleData);
                            noPluginsModule.remove(installInfo.getModuleName());
                        }
                    } else {
                        for (i = 0; i < installXMLInfo.length; ++i) {
                            ModuleData moduleData = new ModuleData(installXMLInfo[i].getModuleName(), installXMLInfo[i].getDisplayName(), "NotInstalled", eMFrameUtils.getLocalizedString("FwResources", "RBS.ModuleStausNotInstalled", this.m_context.getLocale()), eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.NotApplicable", this.m_context.getLocale()), installXMLInfo[i].getVersion());
                            notInstalledModules.add(moduleData);
                            allAvailableModules.add(moduleData);
                        }
                    }
                    if (noPluginsModule.size() > 0) {
                        collectionData.setNoPluginModules(noPluginsModule);
                    }
                    if (allAvailableModules.size() > 0) {
                        collectionData.setAvailableModules(allAvailableModules);
                    }
                    if (installedModules.size() > 0) {
                        collectionData.setInstalledModules(installedModules);
                    }
                    if (notInstalledModules.size() > 0) {
                        collectionData.setNotInstalledModules(notInstalledModules);
                    }
                    if (outOfDateModules.size() > 0) {
                        collectionData.setOutOfDateModules(outOfDateModules);
                    }
                    this.m_collectionList2.add(collectionData);
                }
            }
        } else {
            rbsCollections2 = rbsAssociatedObject.getAllOwnedCollections2();
            if (rbsCollections2 != null) {
                for (count = 0; count < rbsCollections2.length; ++count) {
                    Vector<String> noPlugins = new Vector<String>();
                    CollectionData collectionData = new CollectionData();
                    collectionData.setObjectFDN(this.m_ns.getUnrootedName(rbsCollections2[count].getObjectEntry()));
                    RBSCollection rbsCollection = new RBSCollection(rbsCollections2[count].getObjectEntry());
                    RBSModule[] rbsModules = rbsCollection.getAllModules();
                    if (rbsModules != null && rbsModules.length > 0) {
                        for (int k = 0; k < rbsModules.length; ++k) {
                            noPlugins.add(rbsModules[k].getObjectEntry().getName());
                        }
                    }
                    if (noPlugins.size() > 0) {
                        collectionData.setAvailableModules(noPlugins);
                    }
                    this.m_collectionList2.add(collectionData);
                }
            }
        }
        if ((rbsCollections1 = rbsAssociatedObject.getOwnedCollections()) != null) {
            for (count = 0; count < rbsCollections1.length; ++count) {
                CollectionData collectionData = new CollectionData();
                collectionData.setObjectFDN(this.m_ns.getUnrootedName(rbsCollections1[count].getObjectEntry()));
                this.m_collectionList1.add(collectionData);
            }
        }
        this.m_req.setAttribute("collectionList2", (Object)this.m_collectionList2);
        this.m_req.setAttribute("collectionList1", (Object)this.m_collectionList1);
    }

    private InstallXMLInfo[] getAllPlugins() throws SPIException, NamespaceException {
        InstallXMLInfo[] installXMLInfo = (InstallXMLInfo[])this.m_context.getAuthAttribute("InstallXMLInfo");
        if (installXMLInfo == null || !this.m_readXMLInfo) {
            this.m_readXMLInfo = true;
            installXMLInfo = RBSUtil.getAllPlugins(this.m_context, this.m_ns);
            if (installXMLInfo != null) {
                this.m_context.setAuthAttribute("InstallXMLInfo", installXMLInfo);
            }
        }
        return installXMLInfo;
    }

    boolean collectionSort() {
        String sort2Column = this.getRequestAttributeOrParameter("sortCollection2Column");
        this.m_sortCollection2Direction = !sort2Column.equalsIgnoreCase(this.m_sortCollection2Column) ? "Descending" : this.getRequestAttributeOrParameter("sortCollection2Direction");
        this.m_sortCollection2Column = sort2Column;
        String sort1Column = this.getRequestAttributeOrParameter("sortCollection1Column");
        this.m_sortCollection1Direction = !sort1Column.equalsIgnoreCase(this.m_sortCollection1Column) ? "Descending" : this.getRequestAttributeOrParameter("sortCollection1Direction");
        this.m_sortCollection1Column = sort1Column;
        this.m_req.setAttribute("collectionTab", (Object)this.m_collectionTab);
        this.setCollectionTabMenu(this.m_collectionTab);
        return true;
    }

    void setContentMenu() {
        String sortColumn = null;
        int column = new Integer(this.m_sortContentColumn);
        if (column == 0) {
            sortColumn = "sortType";
        }
        if (column == 1) {
            sortColumn = "sortDisplayName";
        } else if (column == 2) {
            sortColumn = "sortInitialVersion";
        } else if (column == 3) {
            sortColumn = "sortExpiredVersion";
        }
        if (sortColumn != null) {
            Collections.sort(this.m_contentList, new RBSObjectDataSort(this.m_context, sortColumn, this.m_sortContentDirection));
        }
        ArrayList theContentList = this.m_contentList;
        TableCell[][] tableData = new TableCell[theContentList.size()][];
        int index = 0;
        Iterator iterator = theContentList.iterator();
        while (iterator.hasNext()) {
            ContentData content = (ContentData)iterator.next();
            tableData[index] = new TableCell[4];
            String iconUrl = content.getContentType().equals("task") ? "dev/dir/rbsTask2.gif" : "dev/dir/rbsBook2.gif";
            tableData[index][0] = new IconTableCell(content.getContentType(), iconUrl, content.getContentType());
            tableData[index][1] = new TextTableCell(content.getDisplayName(), content.getObjectFDN());
            tableData[index][2] = new TextTableCell(content.getInitialVersion(), content.getInitialVersion());
            tableData[index][3] = new TextTableCell(content.getExpiredVersion(), content.getExpiredVersion());
            ++index;
        }
        this.m_req.setAttribute("sortContentColumn", (Object)this.m_sortContentColumn);
        this.m_req.setAttribute("sortContentDirection", (Object)this.m_sortContentDirection);
        this.m_req.setAttribute("tableData", (Object)tableData);
    }

    private boolean contentSort() {
        String sortColumn = this.getRequestAttributeOrParameter("sortContentColumn");
        this.m_sortContentDirection = !sortColumn.equalsIgnoreCase(this.m_sortContentColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortContentDirection");
        this.m_sortContentColumn = sortColumn;
        this.setContentMenu();
        this.m_req.setAttribute("SelectedRoleDisplayName", (Object)this.m_selectedRoleDisplayName);
        this.m_req.setAttribute("SelectedRoleFullName", (Object)this.m_selectedRoleName);
        this.m_req.setAttribute("RBSAdmin_RoleType", (Object)this.m_roleType);
        this.m_req.setAttribute("SelfProvisioningRole", (Object)this.m_selfProvisioningRole);
        return true;
    }

    private boolean roleSortHandler() {
        String sortColumn = this.getRequestAttributeOrParameter("sortRoleColumn");
        this.m_sortRoleDirection = !sortColumn.equalsIgnoreCase(this.m_sortRoleColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortRoleDirection");
        this.m_sortRoleColumn = sortColumn;
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setRoleMenu();
        return true;
    }

    private boolean taskSortHandler() {
        String sortColumn = this.getRequestAttributeOrParameter("sortTaskColumn");
        this.m_sortTaskDirection = !sortColumn.equalsIgnoreCase(this.m_sortTaskColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortTaskDirection");
        this.m_sortTaskColumn = sortColumn;
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setTaskMenu();
        return true;
    }

    private boolean bookSortHandler() {
        String sortColumn = this.getRequestAttributeOrParameter("sortBookColumn");
        this.m_sortBookDirection = !sortColumn.equalsIgnoreCase(this.m_sortBookColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortBookDirection");
        this.m_sortBookColumn = sortColumn;
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setBookMenu();
        return true;
    }

    private boolean moduleSortHandler() {
        String sortColumn = this.getRequestAttributeOrParameter("sortModuleColumn");
        this.m_sortModuleDirection = !sortColumn.equalsIgnoreCase(this.m_sortModuleColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortModuleDirection");
        this.m_sortModuleColumn = sortColumn;
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setModuleMenu();
        return true;
    }

    private boolean categorySortHandler() {
        String sortColumn = this.getRequestAttributeOrParameter("sortCategoryColumn");
        this.m_sortCategoryDirection = !sortColumn.equalsIgnoreCase(this.m_sortCategoryColumn) ? "Descending" : this.getRequestAttributeOrParameter("sortCategoryDirection");
        this.m_sortCategoryColumn = sortColumn;
        this.m_req.setAttribute("selectedTab", (Object)this.m_selectedTab);
        this.m_req.setAttribute("selectedCollectionName", (Object)this.m_selectedCollectionName);
        this.setCategoryMenu();
        return true;
    }

    private boolean createPropertyBook() {
        String str = RBSUtil.urlEncodePack(this.m_selectedCollectionName, this.m_context);
        String url = "frameservice?NPService=fw.LaunchService&NPAction=Delegate&delegate=fw.Create Property Book&launcher=" + this.getRequestAttributeOrParameter("taskId") + "&lifecycle=Recreate" + "&RBSAdmin_TaskDelegate=taskDelegate" + "&packedModuleNameList=" + this.m_packedModuleNameList + "&selectedCollectionName=" + str;
        this.m_resultStrings.put("UrlTask.url", url.toString());
        this.setUIPage("fw/UrlTask.jsp");
        return true;
    }

    private boolean isValidCollectionOwnerObjectType() {
        String collectionOwnerObjectTypes = null;
        try {
            boolean isNVDS = this.m_ns.isSupported("NVDS");
            collectionOwnerObjectTypes = RBSUtil.getCollectionOwnerObjectTypes(this.m_context, this.m_ns);
            if (collectionOwnerObjectTypes == null) {
                return false;
            }
            String[] validMemberTypes = RBSUtil.tokenizeObjectTypes(collectionOwnerObjectTypes);
            ObjectEntry whoami = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
            ObjectType objectType = whoami.getObjectType();
            String objectTypeName = objectType.getName();
            for (int i = 0; i < validMemberTypes.length; ++i) {
                if (!(isNVDS ? validMemberTypes[i].equalsIgnoreCase(objectTypeName) : com.novell.rbs.RBSUtil.isOfType((ObjectType)objectType, (String)validMemberTypes[i], (boolean)true))) continue;
                return true;
            }
        }
        catch (Exception exc) {
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        String msg = eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.InvalidCollectionOwnerObjectType", this.m_context.getLocale());
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.InvalidCollectionOwnerObjectTypeTitle", this.m_context.getLocale());
        msg = eMFrameUtils.formatMessage(msg, new String[]{collectionOwnerObjectTypes});
        eMFrameUtils.setMessage("error", strTitle, msg, this.m_context);
        return false;
    }
}

