/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CollectionsReportClass;
import com.novell.emframe.fw.CollectionsReportSort;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.ReportsExportUtil;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSCollection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class CollectionsReport
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    ArrayList m_errors = new ArrayList();
    private boolean m_stopThread;
    private boolean m_threadDone;
    private int m_reportCount = 0;
    private int m_reportsNotRead = 0;
    private String m_selectedContainerFDN;
    private ArrayList m_reportList = new ArrayList();
    private String m_inProgress = "false";
    private String m_progressCancelled = "false";
    private String m_progressMessage = "";
    private int m_totalReportsCount = 0;
    private String m_sortColumn;
    private String m_sortDirection;
    private String m_reportTime;
    private ReportThread reportThread;
    private ReportsExportUtil m_exportUtil = null;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("getCollectionsReport")) {
            return this.getCollectionsReport();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        if (nextState.equalsIgnoreCase("sortByColumn")) {
            return this.sortByColumn();
        }
        if (nextState.equalsIgnoreCase("exportReport")) {
            return this.handleExportFile();
        }
        return true;
    }

    private boolean initialState() {
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_req.setAttribute("SelectedUserFDN", (Object)"");
        return true;
    }

    private boolean getCollectionsReport() {
        this.m_totalReportsCount = 0;
        this.m_reportCount = 0;
        this.m_reportList.clear();
        this.m_selectedContainerFDN = this.m_req.getParameter("SelectedContainerFDN");
        ObjectEntry containerOE = null;
        try {
            containerOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedContainerFDN);
            ObjectType objectType = containerOE.getObjectType();
            if (!objectType.isContainer()) {
                String strError = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.WrongObject", this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, strError, this.m_context);
                return false;
            }
            this.m_context.addToHistory(containerOE);
        }
        catch (Exception exc) {
            D.log(exc);
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.Initializing", this.m_context);
        this.m_inProgress = "true";
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GetCollectionsReportForm" + "&nextState=refresh" + "&inProgress=" + this.m_inProgress + "&progressMessage=" + this.m_progressMessage + "&SelectedContainerFDN=" + this.m_selectedContainerFDN);
        this.m_resultStrings.put("UrlTask.url", url);
        this.setUIPage("fw/UrlTask.jsp");
        Date date = new Date();
        Locale locale = this.m_context.getLocale();
        String reportTime = DateFormat.getDateInstance(0, locale).format(date);
        String reportDate = DateFormat.getTimeInstance(0, locale).format(date);
        this.m_reportTime = eMFrameUtils.formatMessage("{0} ({1})", new String[]{reportTime, reportDate});
        this.m_stopThread = false;
        this.m_threadDone = false;
        this.reportThread = new ReportThread(containerOE);
        this.reportThread.start();
        return true;
    }

    private void getReport(ObjectEntry containerOE) {
        ResultModifier rm = new ResultModifier("");
        rm.addFilter(new ResultModifierFilterEntry("*", new String[]{"rbsCollection", "rbsCollection2"}));
        rm.setSubContainerSearch(true);
        ObjectEntryEnumeration children = null;
        ArrayList<Object> childrenList = new ArrayList<Object>();
        try {
            children = this.m_ns.getChildren(containerOE, rm);
            while (children.hasMoreElements()) {
                ++this.m_totalReportsCount;
                childrenList.add(children.nextElement());
            }
            for (int i = 0; i < childrenList.size(); ++i) {
                ++this.m_reportCount;
                ObjectEntry collectionOE = (ObjectEntry)childrenList.get(i);
                String objectType = collectionOE.getObjectType().getName();
                int version = 0;
                version = objectType.equals("rbsCollection") ? 1 : 2;
                String[] creatorsName = NSModel.getStrings((ObjectEntry)collectionOE, null, (String)"creatorsName");
                String creatorName = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.Unknown", this.m_context);
                if (creatorsName != null) {
                    creatorName = MappingObject.LDAPNameToNDSName(creatorsName[0]);
                }
                Date creationDate = this.m_ns.getCreationTime(collectionOE);
                Locale locale = this.m_context.getLocale();
                String time = DateFormat.getDateInstance(3, locale).format(creationDate);
                String date = DateFormat.getTimeInstance(3, locale).format(creationDate);
                RBSCollection rbsCollection = new RBSCollection(collectionOE);
                ObjectEntry[] ownersOE = rbsCollection.getOwners();
                if (ownersOE != null) {
                    for (int j = 0; j < ownersOE.length; ++j) {
                        CollectionsReportClass collection = new CollectionsReportClass();
                        collection.setCollectionFDN(this.m_ns.getUnrootedName(collectionOE));
                        collection.setVersion(version);
                        collection.setOwnerFDN(this.m_ns.getUnrootedName(ownersOE[j]));
                        collection.setCreatorFDN(creatorName);
                        collection.setCreationDate(eMFrameUtils.formatMessage("{0} ({1})", new String[]{time, date}));
                        collection.setDate(creationDate);
                        this.m_reportList.add(collection);
                    }
                } else {
                    CollectionsReportClass collection = new CollectionsReportClass();
                    collection.setCollectionFDN(this.m_ns.getUnrootedName(collectionOE));
                    collection.setVersion(version);
                    collection.setOwnerFDN(eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.Unknown", this.m_context));
                    collection.setCreatorFDN(creatorName);
                    collection.setCreationDate(eMFrameUtils.formatMessage("{0} ({1})", new String[]{time, date}));
                    collection.setDate(creationDate);
                    this.m_reportList.add(collection);
                }
                if (!this.m_stopThread) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exc) {
            D.log(exc);
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return;
        }
        this.m_sortColumn = "sortCollectionObject";
        this.m_sortDirection = "descending";
        Collections.sort(this.m_reportList, new CollectionsReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        if (!this.m_threadDone) {
            if (this.m_reportCount == 0) {
                this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.Searching", this.m_context);
            } else {
                Object[] values = new String[]{Integer.toString(this.m_reportCount), Integer.toString(this.m_totalReportsCount)};
                this.m_progressMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReport", this.m_context), values);
            }
            this.m_resultStrings.put("progressMessage", this.m_progressMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&nextState=finished");
            if (this.m_errors.size() > 0) {
                url = url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error";
            }
            this.m_resultStrings.put("UrlTask.url", url);
            this.setUIPage("fw/UrlTask.jsp");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        this.m_inProgress = "false";
        this.m_progressCancelled = "true";
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_req.setAttribute("SelectedContainerFDN", (Object)this.m_selectedContainerFDN);
        return true;
    }

    private boolean finished() {
        if (this.m_errors.size() > 0) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ErrorTitle", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ErrorBody", this.m_context);
            Object[] values = new String[]{Integer.toString(this.m_totalReportsCount - this.m_reportsNotRead), Integer.toString(this.m_totalReportsCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        } else {
            this.m_req.setAttribute("collectionReportData", (Object)this.m_reportList);
            this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
            this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
            this.m_req.setAttribute("SelectedContainerFDN", (Object)this.m_selectedContainerFDN);
            this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
            String taskId = this.m_req.getParameter("taskId");
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context));
            this.m_resultStrings.put("UrlTask.url", url);
            this.setUIPage("fw/CollectionsReport.jsp");
        }
        return true;
    }

    private boolean sortByColumn() {
        this.m_sortColumn = this.m_req.getParameter("sortColumn");
        this.m_sortDirection = this.m_req.getParameter("sortDirection");
        Collections.sort(this.m_reportList, new CollectionsReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
        this.m_req.setAttribute("collectionReportData", (Object)this.m_reportList);
        this.m_req.setAttribute("SelectedContainerFDN", (Object)this.m_selectedContainerFDN);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
        return true;
    }

    public boolean handleExportFile() {
        if (this.m_context != null && this.m_reportList != null) {
            this.m_exportUtil = new ReportsExportUtil(this.m_context, this.m_reportList);
            this.m_exportUtil.exportCollectionsReport();
        }
        return true;
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return this.m_exportUtil.sendRedirect(req, resp);
    }

    class ReportThread
    extends Thread {
        private ObjectEntry m_containerOE;

        public ReportThread(ObjectEntry containerOE) {
            this.setPriority(4);
            this.setDaemon(true);
            this.m_containerOE = containerOE;
        }

        public void run() {
            CollectionsReport.this.getReport(this.m_containerOE);
            CollectionsReport.this.m_threadDone = true;
        }
    }
}

