/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookInfo;
import com.novell.emframe.fw.BookRoleInfo;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public final class CreateBookTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;
    private String collectionName;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.namespace = this.treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("startBookWizard")) {
            return this.startBookWizard();
        }
        if (nextState.equalsIgnoreCase("nextBookObjectType")) {
            return this.nextBookObjectType();
        }
        if (nextState.equalsIgnoreCase("backBookInfoPage")) {
            return this.backBookInfoPage();
        }
        if (nextState.equalsIgnoreCase("nextBookPages")) {
            return this.nextBookPages();
        }
        if (nextState.equalsIgnoreCase("backBookObjectType")) {
            return this.backBookObjectType();
        }
        if (nextState.equalsIgnoreCase("nextBookRoles")) {
            return this.nextBookRoles();
        }
        if (nextState.equalsIgnoreCase("backBookPages")) {
            return this.backBookPages();
        }
        if (nextState.equalsIgnoreCase("nextBookSummary")) {
            return this.nextBookSummary();
        }
        if (nextState.equalsIgnoreCase("backBookRoles")) {
            return this.backBookRoles();
        }
        if (nextState.equalsIgnoreCase("finishBookWizard")) {
            return this.finishBookWizard();
        }
        return false;
    }

    private boolean startBookWizard() {
        BookInfo bookInfo = new BookInfo();
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.resultStrings.put("BookContext_Value", bookInfo.getContext());
        this.resultStrings.put("BookDescription_Value", bookInfo.getDescription());
        this.resultStrings.put("mooEnabledCheckBox", bookInfo.getMooEnabled());
        String taskDelegate = this.req.getParameter("RBSAdmin_TaskDelegate");
        if (taskDelegate != null && taskDelegate.equals("taskDelegate")) {
            bookInfo.setTaskDelegate("taskDelegate");
            String[] moduleNameList = CreateBookTask.unpack(this.req.getParameter("packedModuleNameList"));
            bookInfo.setModuleList(moduleNameList);
            bookInfo.setModuleSelectedIndex(0);
            this.resultStrings.put("SelectedModuleIndex", Integer.toString(bookInfo.getModuleSelectedIndex()));
            if (moduleNameList.length == 0) {
                this.resultStrings.put("ModuleName.Count", Integer.toString(1));
                this.resultStrings.put("ModuleName.Element.0", "");
            } else {
                this.resultStrings.put("ModuleName.Count", Integer.toString(moduleNameList.length + 1));
                this.resultStrings.put("ModuleName.Element.0", "");
                for (int i = 0; i < moduleNameList.length; ++i) {
                    this.resultStrings.put("ModuleName.Element." + (i + 1), moduleNameList[i]);
                }
            }
        }
        String[] availableObjectTypes = null;
        try {
            availableObjectTypes = RBSUtil.readObjectClassTypes(this.treeOE, this.context);
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        bookInfo.setAvailableObjectTypes(availableObjectTypes);
        bookInfo.setAssignedObjectTypes(null);
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean nextBookObjectType() {
        String mooEnabledChanged;
        String descChanged;
        String nameChanged;
        String contextChanged;
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String taskDelegate = bookInfo.getTaskDelegate();
        if (taskDelegate != null && taskDelegate.equals("taskDelegate")) {
            String selectedModuleIndex = this.req.getParameter("SelectedModuleIndex");
            int index = Integer.parseInt(selectedModuleIndex);
            bookInfo.setModuleSelectedIndex(index);
        }
        if ((contextChanged = this.req.getParameter("CreateBookFormContextChanged")).equals("true")) {
            if (this.collectionName == null) {
                this.collectionName = this.req.getParameter("selectedCollectionName");
                String[] strings = eMFrameUtils.unpack(this.collectionName, this.context);
                this.collectionName = strings[0];
            }
            String contextName = this.req.getParameter("BookContext");
            if (!this.isValidModule(contextName = RBSUtil.concatStr(this.namespace, contextName, this.collectionName), bookInfo)) {
                bookInfo.setContext(contextName);
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "CreateBook.ModuleFailureTitle", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "CreateBook.ModuleNotFound", this.context));
                return false;
            }
            this.context.addToHistory("rbsModule2", contextName);
            bookInfo.setNeedToReadRole(true);
            bookInfo.setContext(contextName);
        }
        if ((nameChanged = this.req.getParameter("CreateBookFormNameChanged")).equals("true")) {
            String bookName = this.req.getParameter("BookName");
            boolean isLDAP = this.namespace.getUniqueID().equalsIgnoreCase("LDAP");
            if (isLDAP) {
                bookName = RBSUtil.formatLDAPString(bookName);
            }
            bookInfo.setName(bookName);
            if (this.nameExists(bookName, bookInfo.getContext())) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "CreateBook.BookFailureTitle", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "CreateBook.BookFound", this.context));
                return false;
            }
        }
        if ((descChanged = this.req.getParameter("CreateBookFormDescChanged")).equals("true")) {
            bookInfo.setDescription(this.req.getParameter("BookDescription"));
        }
        if ((mooEnabledChanged = this.req.getParameter("CreateBookFormMooEnabledChanged")).equals("true")) {
            bookInfo.setMooEnabled(this.req.getParameter("mooEnabledCheckBox"));
        }
        RBSUtil.putAvailableObjectTypes(bookInfo, this.resultStrings);
        RBSUtil.putAssignedObjectTypes(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean backBookInfoPage() {
        String taskDelegate;
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookObjectTypeFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedObjectTypes(bookInfo, this.req);
            RBSUtil.getAvailableObjectTypes(bookInfo, this.req);
            String[] pageIds = null;
            try {
                pageIds = RBSUtil.readPageIds(this.context, bookInfo, this.treeOE);
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            bookInfo.setAvailablePages(pageIds);
            bookInfo.setAssignedPages(null);
        }
        if ((taskDelegate = bookInfo.getTaskDelegate()) != null && taskDelegate.equals("taskDelegate")) {
            String[] moduleNameList = bookInfo.getModuleList();
            if (moduleNameList.length == 0) {
                this.resultStrings.put("ModuleName.Count", Integer.toString(1));
                this.resultStrings.put("ModuleName.Element.0", "");
            } else {
                this.resultStrings.put("ModuleName.Count", Integer.toString(moduleNameList.length + 1));
                this.resultStrings.put("ModuleName.Element.0", "");
                for (int i = 0; i < moduleNameList.length; ++i) {
                    this.resultStrings.put("ModuleName.Element." + (i + 1), moduleNameList[i]);
                }
            }
        }
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.resultStrings.put("BookContext_Value", bookInfo.getContext());
        this.resultStrings.put("BookDescription_Value", bookInfo.getDescription());
        this.resultStrings.put("mooEnabledCheckBox", bookInfo.getMooEnabled());
        this.resultStrings.put("RBSAdmin_TaskDelegate", bookInfo.getTaskDelegate());
        this.resultStrings.put("SelectedModuleIndex", Integer.toString(bookInfo.getModuleSelectedIndex()));
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean nextBookPages() {
        String assignedObjectTypes = this.req.getParameter("AssignedObjectTypesString");
        if (assignedObjectTypes == null || assignedObjectTypes.length() == 0) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "CreateBook.ObjectTypeErrorTitle", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "BookObjectType.NoAssignedTypes", this.context));
            return false;
        }
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookObjectTypeFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedObjectTypes(bookInfo, this.req);
            RBSUtil.getAvailableObjectTypes(bookInfo, this.req);
            String[] pageIds = null;
            try {
                pageIds = RBSUtil.readPageIds(this.context, bookInfo, this.treeOE);
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            bookInfo.setAvailablePages(pageIds);
            bookInfo.setAssignedPages(null);
        }
        RBSUtil.putAvailablePages(bookInfo, this.resultStrings, this.context);
        RBSUtil.putAssignedPages(bookInfo, this.resultStrings, this.context);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean backBookObjectType() {
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookPageFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedPages(bookInfo, this.req);
            RBSUtil.getAvailablePages(bookInfo, this.req);
        }
        RBSUtil.putAvailableObjectTypes(bookInfo, this.resultStrings);
        RBSUtil.putAssignedObjectTypes(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean nextBookRoles() {
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookPageFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedPages(bookInfo, this.req);
            RBSUtil.getAvailablePages(bookInfo, this.req);
        }
        if (bookInfo.getNeedToReadRole()) {
            BookRoleInfo[] bookRoleInfo = null;
            try {
                bookRoleInfo = RBSUtil.readAvailableRoles(bookInfo, this.treeOE, this.context);
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            bookInfo.setAvailableRoles(bookRoleInfo);
            bookInfo.setNeedToReadRole(false);
            bookInfo.setAssignedRoles(null);
        }
        RBSUtil.putAvailableRoles(bookInfo, this.resultStrings);
        RBSUtil.putAssignedRoles(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean backBookPages() {
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookRoleFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedRoles(bookInfo, this.req);
            RBSUtil.getAvailableRoles(bookInfo, this.req);
        }
        RBSUtil.putAssignedPages(bookInfo, this.resultStrings, this.context);
        RBSUtil.putAvailablePages(bookInfo, this.resultStrings, this.context);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean backBookRoles() {
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        RBSUtil.putAvailableRoles(bookInfo, this.resultStrings);
        RBSUtil.putAssignedRoles(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean nextBookSummary() {
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookRoleFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedRoles(bookInfo, this.req);
            RBSUtil.getAvailableRoles(bookInfo, this.req);
        }
        RBSUtil.putAssignedPages(bookInfo, this.resultStrings, this.context);
        RBSUtil.putAssignedRoles(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", bookInfo.getName());
        this.resultStrings.put("BookMooEnabled_Value", bookInfo.getMooEnabled());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean finishBookWizard() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        try {
            NSObject bookObj = this.createRBSBook(bookInfo);
            this.context.addToHistory("rbsBook2", RBSUtil.concatStr(this.namespace, bookInfo.getName(), bookInfo.getContext()));
            RBSBook rbsBook = new RBSBook(bookObj);
            rbsBook.setPageMembership(bookInfo.getAssignedPages());
            rbsBook.setTargetObjectType(bookInfo.getAssignedObjectTypes());
            rbsBook.setEntryPoint(bookInfo.getBookEntryPoint());
            String[] pages = bookInfo.getAssignedPages();
            String pageOrders = null;
            if (pages != null) {
                pageOrders = pages[0];
                for (int i = 1; i < pages.length; ++i) {
                    pageOrders = pageOrders + "," + pages[i];
                }
            }
            Element pageOrdersElement = new Element("pageOrders");
            pageOrdersElement.addContent(pageOrders);
            Document doc = rbsBook.getrbsXMLInfo();
            if (doc == null) {
                rbsBook.setrbsXMLInfo(pageOrdersElement);
            } else {
                rbsBook.setrbsXMLInfo(pageOrdersElement);
            }
            RBSRights[] rights = FwUtils.getPagesRights(bookInfo.getAssignedPages(), this.treeOE);
            rbsBook.setRights(rights);
            if (bookInfo.getDescription().length() > 0) {
                rbsBook.setDescription(bookInfo.getDescription());
            }
            rbsBook.setParameters(bookInfo.getParameters());
            rbsBook.update();
            BookRoleInfo[] roleList = bookInfo.getAssignedRoles();
            if (roleList != null && roleList.length > 0) {
                RBSRole[] roles = new RBSRole[roleList.length];
                for (int i = 0; i < roleList.length; ++i) {
                    String roleName = roleList[i].getFullName();
                    ObjectEntry roleOE = this.namespace.getObjectEntry(roleName);
                    roles[i] = new RBSRole(roleOE);
                }
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                rbsBook.setContentMembership(roles, dynamicGroupSearchType);
            }
            rbsBook.update();
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "CreateRBSBookSuccessTitle", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "CreateRBSBookSuccess", this.context));
            return true;
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
    }

    private boolean isValidModule(String objectFDN, BookInfo bookInfo) {
        try {
            ObjectEntry objectEntry = this.namespace.getObjectEntry(this.treeOE, objectFDN);
            String objectType = objectEntry.getObjectType().getName();
            if (objectType.equals("rbsModule2")) {
                bookInfo.setContextOE(objectEntry);
                return true;
            }
            return false;
        }
        catch (SPIException e) {
            return false;
        }
    }

    private boolean nameExists(String name, String context) {
        try {
            this.namespace.getObjectEntry(RBSUtil.concatStr(this.namespace, name, context));
        }
        catch (SPIException e) {
            return false;
        }
        return true;
    }

    private NSObject createRBSBook(BookInfo bookInfo) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        NSObject bookObj = null;
        ObjectEntry contextOE = bookInfo.getContextOE();
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.namespace.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)"rbsBook2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.namespace.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)bookInfo.getName());
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry bookOE = this.namespace.createObjectEntry(contextOE, bookInfo.getName(), "rbsBook2");
        bookObj = this.namespace.createNSObject(bookOE, attrOV);
        this.namespace.create(bookObj);
        return bookObj;
    }

    public static final String[] unpack(String s) {
        if (null == s) {
            return new String[0];
        }
        if (s.equals("PP")) {
            return new String[0];
        }
        if (!s.startsWith("P:") || !s.endsWith("P")) {
            return new String[]{s};
        }
        s = s.substring(2, s.length() - 1);
        String[] list = eMFrameUtils.split(s, ":");
        String[] ret = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = list[i];
        }
        return ret;
    }
}

