/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.util.eMFrameComponentInstall;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CreateRBSCollectionTask
extends Task {
    private static final long serialVersionUID = 1L;
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    ObjectEntry m_treeOE;
    AdminNamespace m_ns;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        try {
            this.m_treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCreateRBSCollection")) {
            return this.doCreateRBSCollection();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        String extendRBSSchema = this.req.getParameter("extendRBSSchema");
        if (extendRBSSchema != null && extendRBSSchema.equalsIgnoreCase("true")) {
            eMFrameComponentInstall install = new eMFrameComponentInstall(this.m_treeOE, this.context);
            try {
                install.extendSchema();
            }
            catch (Exception exc) {
                D.log(exc);
                eMFrameUtils.setErrorMessage(exc, this.context);
                return false;
            }
        }
        String collectionContainmentTypes = "";
        try {
            collectionContainmentTypes = RBSUtil.getCollectionContainmentTypes(this.context, this.m_treeOE);
        }
        catch (Exception exc) {
            D.log(exc);
            eMFrameUtils.setErrorMessage(exc, this.context);
            return false;
        }
        this.resultStrings.put("CollectionContainmentTypes", collectionContainmentTypes);
        return true;
    }

    private boolean doCreateRBSCollection() {
        String collectionContext;
        boolean rbsEnabled = FwUtils.isRBSEnabled(this.context);
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        String collectionName = this.req.getParameter("Collection_Name");
        boolean isLDAP = this.m_ns.getUniqueID().equalsIgnoreCase("LDAP");
        if (isLDAP) {
            collectionName = RBSUtil.formatLDAPString(collectionName);
        }
        if (!RBSUtil.preCheckCreateCollection(this.context, this.resultStrings, this.m_treeOE, collectionContext = this.req.getParameter("CollectionContext_Name"), collectionName)) {
            return false;
        }
        try {
            String versionNumber = eMFrameUtils.getLocalizedString("com.novell.emframe.version", "version", this.context);
            eMFrameComponentInstall install = new eMFrameComponentInstall(this.m_treeOE, this.context);
            install.createRBSCollection(collectionContext, collectionName, versionNumber);
            RBSUtil.setRBSInstalledGlobalFlag(this.context, this.m_treeOE.getName());
            RBSUtil.setTreeNameInConfig(this.context, this.m_treeOE.getName());
            DirRoleList roleList = RBSUtil.getDirRoleList(this.context);
            roleList.setCollectionOwner(true);
            FwDirUtils.updateAccessMode(this.context);
        }
        catch (Exception exc) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", exc.toString());
            return false;
        }
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_SUCCESS", this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION", this.context));
        this.context.addToHistory("rbsCollection2", collectionName + "." + collectionContext);
        try {
            ObjectEntry containerOE = this.m_ns.getObjectEntry(this.m_treeOE, collectionContext);
            this.context.addToHistory(containerOE);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!rbsEnabled) {
            this.resultStrings.put("GeneralMsg.Url", "webacc?taskId=dev.Empty&merge=fw.Body&showInstallWizard=false&view=Config");
            this.resultStrings.put("target", "target=Mainscreen");
        }
        return true;
    }
}

