/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.NetwareServiceUtil;
import com.novell.emframe.fw.ObjectSelector;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.servlet.FwSession;
import com.novell.emframe.fw.studio.TemplateBuilderUtils;
import com.novell.emframe.fw.util.RBSObjectInstaller;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.XMLFileReader;
import com.novell.nps.WebappUtil;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StylesheetSet;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import com.novell.nps.serviceProviders.HTMLParser;
import com.novell.nps.serviceProviders.web.PortalURL;
import com.novell.nps.serviceProviders.web.PortalURLException;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.nps.utils.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CreateServerAdminTask
extends Task {
    private static final long serialVersionUID = 1L;
    private static final String CREATE_SERVER_ADMIN_TASK_TAG = "com.novell.emframe.fw.CreateServerAdminTask";
    private static final String DT = "CreateServerAdminTask";
    private static final String BACKSTATE = "backState";
    private static final String NEXTSTATE = "nextState";
    private static final String INITIALSTATE = "initialState";
    private static final String WEBLINK_NODE = "WebLink";
    private String serviceKey = null;
    private String serverAddress = null;
    private String taskName = null;
    private String taskCollection = null;
    private String taskRole = null;
    private TaskContext m_context = null;
    private String createResultHeader = null;
    private String createResultBody = null;
    private Vector webLinkElements = new Vector(11, 1);
    private boolean triedLoadingServices = false;
    private String wizardURL;
    private String wizardURLData;
    private boolean usesBasic = true;
    private static final String BASIC_REQUIRED = "Basic Required";
    private static final String CUST0M_SERVICE_KEY = "123456";
    private String formParams = null;
    private String nextState = null;
    private String taskCreateError = null;

    private void loadServices() {
        int i;
        String xmlFilesLoc;
        String[] fileList;
        if (SystemUtils.isNetWare() && (fileList = this.getXmlFiles(xmlFilesLoc = new String("SYS:/adminsrv/XMLData"))) != null) {
            for (i = 0; i < fileList.length; ++i) {
                NetwareServiceUtil.parseServiceDocument(fileList[i], this.webLinkElements, this.m_context);
            }
        }
        if ((fileList = this.getXmlFiles(xmlFilesLoc = new String(WebappUtil.getRealPath((String)"/WEB-INF") + "/tools/XMLData"))) != null) {
            for (i = 0; i < fileList.length; ++i) {
                NetwareServiceUtil.parseServiceDocument(fileList[i], this.webLinkElements, this.m_context);
            }
        }
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        HttpServletRequest req = this.m_context.getRequest();
        if (req.getParameter(BACKSTATE) != null) {
            if (this.nextState == null || this.nextState.equalsIgnoreCase("FindServiceUrl") || this.nextState.equalsIgnoreCase("findServer")) {
                this.nextState = INITIALSTATE;
            } else if (this.nextState.equalsIgnoreCase("customGetParams")) {
                this.nextState = "FindServiceUrl";
            } else if (this.nextState.equalsIgnoreCase("CustomSettingsSummary")) {
                this.nextState = this.usesBasic ? "FindServiceUrl" : "customGetParams";
            } else if (this.nextState.equalsIgnoreCase("getTaskName")) {
                this.nextState = this.wizardURL == null ? "findServer" : "CustomSettingsSummary";
            }
        } else {
            this.nextState = req.getParameter(NEXTSTATE);
            if (this.nextState == null) {
                this.nextState = INITIALSTATE;
            }
        }
        if (!this.triedLoadingServices) {
            this.loadServices();
            this.triedLoadingServices = true;
        }
        String readParam = null;
        readParam = req.getParameter("URL");
        if (readParam != null) {
            this.wizardURL = readParam;
            this.wizardURLData = null;
            this.formParams = null;
            this.usesBasic = false;
        }
        if ((readParam = req.getParameter("serviceKey")) != null) {
            this.serviceKey = readParam;
            if (this.serviceKey != null && this.serviceKey.equalsIgnoreCase(CUST0M_SERVICE_KEY)) {
                this.nextState = "FindServiceUrl";
            }
        }
        if ((readParam = req.getParameter("PARAMS")) != null) {
            this.formParams = readParam;
        }
        if ((readParam = req.getParameter("IsBasicAuthentication")) != null) {
            this.usesBasic = readParam.equalsIgnoreCase("on");
        }
        if ((readParam = req.getParameter("serviceLoc")) != null) {
            this.serverAddress = readParam;
        }
        if ((readParam = req.getParameter("taskName")) != null) {
            this.taskName = readParam;
        }
        if ((readParam = req.getParameter("taskCollection")) != null) {
            this.taskCollection = readParam;
        }
        if ((readParam = req.getParameter("taskRole")) != null) {
            this.taskRole = readParam;
        }
        if ((readParam = req.getParameter("createServiceTask")) != null) {
            Document m_document = this.createTaskDocument();
            try {
                this.createTheTask(this.taskCollection, m_document);
            }
            catch (PluginException e) {
                this.taskCreateError = e.getMessage();
                D.log(e);
                this.nextState = "getTaskName";
            }
            if (!this.nextState.equalsIgnoreCase("getTaskName")) {
                if (this.taskRole != null && this.taskRole.length() > 0) {
                    this.m_context.addToHistory("rbsRole2", this.taskRole);
                }
                this.m_context.addToHistory("rbsTask2", this.taskName + ".NetWareCustom." + this.taskCollection);
            }
        }
        return true;
    }

    private void createTheTask(String rbsCollectionName, Document m_document) throws PluginException {
        TemplateBuilderUtils.validateContainment(this.taskCollection, this.taskName, "rbsTask2", this.m_context);
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        String authName = "eDir";
        try {
            if (ns.isSupported("NVDS")) {
                authName = "NVDS";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        ModuleClassObject moduleClassObject = null;
        XMLFileReader xmlFileReader = new XMLFileReader(ns);
        try {
            moduleClassObject = xmlFileReader.readFile(m_document, authName);
        }
        catch (JDOMException e) {
            D.log(e);
            D.log(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.READ_XML_FILE_FAILURE", this.m_context));
            D.log(e);
        }
        RBSObjectInstaller installer = new RBSObjectInstaller(treeOE, moduleClassObject);
        try {
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
            installer.install(rbsCollectionName, dynamicGroupSearchType);
            this.createResultHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.InstallTaskSuccess", this.m_context);
            this.createResultBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.InstallTaskSuccessLong", this.m_context);
        }
        catch (Exception e) {
            D.log(e);
            this.createResultHeader = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.INSTALL_PACKAGE_FAILURE", this.m_context);
            this.createResultBody = eMFrameUtils.getExceptionMessage(e, this.m_context);
        }
    }

    private Document createTaskDocument() {
        Element selectedService;
        Element moduleId = new Element("id");
        moduleId.addContent("NetWareCustom");
        Element moduleVer = new Element("required-version");
        moduleVer.addContent("1.0");
        Element moduleRes = new Element("resource-properties-file");
        Element moduleDesc = new Element("description");
        moduleDesc.addContent("NetWare server admin task module description");
        Element module = new Element("module");
        module.addContent(moduleId);
        module.addContent(moduleVer);
        module.addContent(moduleRes);
        module.addContent(moduleDesc);
        Element taskId = new Element("id");
        taskId.addContent("NetWareCustom." + this.taskName);
        Element taskVer = new Element("version");
        taskVer.addContent("1.0");
        Element className = new Element("class-name");
        className.addContent("com.novell.emframe.fw.NetWareServiceLauncher");
        Element taskDesc = new Element("description");
        taskDesc.addContent("NetWare server admin task description");
        Element task = new Element("task");
        task.addContent(taskId);
        task.addContent(taskVer);
        task.addContent(className);
        task.addContent(taskDesc);
        Element roleAssign = null;
        if (this.taskRole != null && this.taskRole.trim().length() > 0) {
            D.assrt(this.taskRole.toLowerCase().endsWith(this.taskCollection.toLowerCase()), "TaskBuilder: The role must be in the collection");
            String roleName = this.taskRole.substring(0, this.taskRole.length() - this.taskCollection.length() - 1);
            roleAssign = new Element("role-assignment");
            roleAssign.addContent(roleName);
            task.addContent(roleAssign);
        }
        Element rbsXmlInfo = new Element("rbs-xml-info");
        if (!this.serviceKey.equalsIgnoreCase(CUST0M_SERVICE_KEY)) {
            selectedService = (Element)this.webLinkElements.get(Integer.parseInt(this.serviceKey));
            Element webLinkEl = selectedService.getChild(WEBLINK_NODE);
            Element selectedServer = new Element("ServerAddress");
            selectedServer.addContent(this.serverAddress);
            webLinkEl.addContent(selectedServer);
            rbsXmlInfo.addContent((Element)selectedService.clone());
        } else {
            selectedService = new Element("SERVICE");
            Element ProdInfo = new Element("ProductInfo");
            Element Name2 = new Element("Name");
            ProdInfo.addContent(Name2);
            Element Icon = new Element("Icon");
            ProdInfo.addContent(Icon);
            Element InformationLink = new Element("InformationLink");
            ProdInfo.addContent(InformationLink);
            selectedService.addContent(ProdInfo);
            Element WebLink = new Element(WEBLINK_NODE);
            Element URLDesc = new Element("ULRDescriptor");
            WebLink.addContent(URLDesc);
            Element URL2 = new Element("URL");
            URL2.addContent(this.wizardURL);
            WebLink.addContent(URL2);
            Element RequestType = new Element("RequestType");
            RequestType.addContent(String.valueOf(this.usesBasic));
            WebLink.addContent(RequestType);
            Element formParamsEl = new Element("CustomFormParams");
            formParamsEl.addContent(this.formParams);
            WebLink.addContent(formParamsEl);
            Element selectedServer = new Element("ServerAddress");
            selectedServer.addContent(this.serverAddress);
            WebLink.addContent(selectedServer);
            selectedService.addContent(WebLink);
            rbsXmlInfo.addContent((Element)selectedService.clone());
        }
        task.addContent(rbsXmlInfo);
        Element root = new Element("install");
        root.addContent(module);
        root.addContent(task);
        return new Document(root);
    }

    public void getData(HttpServletRequest req, BufferedWriter out, org.w3c.dom.Document domTree) throws GadgetInstanceException {
        ObjectSelector.saveOSState(req, "");
        if (this.m_context == null) {
            this.m_context = eMFrameFactory.getTaskContext(req);
        }
        try {
            XmlUtils.writeStartTag(CREATE_SERVER_ADMIN_TASK_TAG, out);
            if (this.nextState == null) {
                this.nextState = INITIALSTATE;
            }
            if (this.nextState.equalsIgnoreCase("customGetParams")) {
                if (this.wizardURLData == null) {
                    if (this.wizardURL == null || this.wizardURL.length() == 0 || this.wizardURL.equalsIgnoreCase("http://")) {
                        this.nextState = "FindServiceUrl";
                    } else {
                        this.wizardURLData = this.processUrl(this.wizardURL, req);
                        if (this.wizardURLData == null || this.wizardURLData.equalsIgnoreCase(BASIC_REQUIRED)) {
                            this.usesBasic = true;
                            this.nextState = "CustomSettingsSummary";
                        } else {
                            this.usesBasic = false;
                            XmlUtils.writeCDataTag("wizardURLData", this.wizardURLData, out);
                        }
                    }
                } else {
                    String newURL = req.getParameter("URL");
                    if (newURL != null) {
                        this.wizardURL = newURL;
                    }
                    Properties params = this.getWizardFormAuthParams(req);
                    this.formParams = this.convertParamsToString(params);
                    this.nextState = "CustomSettingsSummary";
                }
            }
            if (this.nextState.equalsIgnoreCase("FindServiceUrl")) {
                XmlUtils.writeTag("FindServiceUrl", "FindServiceUrl", out);
                XmlUtils.writeTag("URL", this.wizardURL, out);
            }
            if (this.nextState.equalsIgnoreCase("CustomSettingsSummary")) {
                XmlUtils.writeStartTag("CustomSettingsSummary", out);
                XmlUtils.writeCDataTag("URL", this.wizardURL, out);
                XmlUtils.writeCDataTag("PARAMS", this.formParams, out);
                if (this.usesBasic) {
                    XmlUtils.writeTag("IsBasicAuthentication", "true", out);
                } else {
                    XmlUtils.writeTag("IsBasicAuthentication", "false", out);
                }
                XmlUtils.writeEndTag("CustomSettingsSummary", out);
            }
            if (this.nextState.equalsIgnoreCase("createSummary")) {
                XmlUtils.writeStartTag("createSummary", out);
                if (this.serviceKey != null) {
                    XmlUtils.writeTag("ResultHeader", this.createResultHeader, out);
                    XmlUtils.writeTag("ResultBody", this.createResultBody, out);
                }
                XmlUtils.writeEndTag("createSummary", out);
            }
            if (this.nextState.equalsIgnoreCase("getTaskName")) {
                XmlUtils.writeTag("getTaskName", "taskDetails", out);
                XmlUtils.writeCDataTag("taskName", this.taskName, out);
                XmlUtils.writeCDataTag("taskRole", this.taskRole, out);
                XmlUtils.writeCDataTag("taskCollection", this.taskCollection, out);
                if (this.taskCreateError != null) {
                    XmlUtils.writeCDataTag("taskCreateError", this.taskCreateError, out);
                    this.taskCreateError = null;
                }
            }
            if (this.nextState.equalsIgnoreCase("findServer")) {
                XmlUtils.writeTag("FindServerLocation", "FindServerLocation", out);
            }
            if (this.nextState.equalsIgnoreCase(INITIALSTATE)) {
                Enumeration theServices = this.webLinkElements.elements();
                Element service = null;
                int i = 0;
                while (theServices.hasMoreElements()) {
                    service = (Element)theServices.nextElement();
                    XmlUtils.writeStartTag("NetWareService", out);
                    XmlUtils.writeTag("NWServiceProductName", service.getChild("ProductInfo").getChildText("Name"), out);
                    XmlUtils.writeTag("NWServiceIcon", service.getChild("ProductInfo").getChildText("Icon"), out);
                    XmlUtils.writeTag("NWServiceInfoLink", service.getChild("ProductInfo").getChildText("InformationLink"), out);
                    XmlUtils.writeTag("NWServiceIndex", String.valueOf(i), out);
                    XmlUtils.writeTag("WebLinkDesc", service.getChild(WEBLINK_NODE).getChildText("URLDescriptor"), out);
                    ++i;
                    XmlUtils.writeEndTag("NetWareService", out);
                }
                Properties attribs = new Properties();
                attribs.setProperty("type", "other");
                XmlUtils.writeStartTag("NetWareService", attribs, out);
                XmlUtils.writeTag("NWServiceProductName", "other", out);
                XmlUtils.writeTag("NWServiceIcon", "", out);
                XmlUtils.writeTag("NWServiceInfoLink", "", out);
                XmlUtils.writeTag("NWServiceIndex", String.valueOf(i), out);
                XmlUtils.writeTag("WebLinkDesc", "", out);
                XmlUtils.writeEndTag("NetWareService", out);
            }
            XmlUtils.writeEndTag(CREATE_SERVER_ADMIN_TASK_TAG, out);
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    private String processUrl(String url, HttpServletRequest req) {
        String parsedURL = null;
        if (url != null && url.length() > 5 && url.substring(url.length() - 5).indexOf(".css") == -1) {
            try {
                try {
                    StringWriter outBuffer = new StringWriter();
                    BufferedWriter out = new BufferedWriter(outBuffer);
                    Properties params = null;
                    PortalURL newURL = new PortalURL((PortalSession)((FwSession)req.getSession()), url);
                    HttpURLConnection con = null;
                    con = (HttpURLConnection)newURL.openGet(params);
                    InputStream in = con.getInputStream();
                    String host = newURL.getHost();
                    if (newURL.getPort() != -1) {
                        host = host + ":" + newURL.getPort();
                    }
                    HTMLParser.parseURL((BufferedWriter)out, (InputStream)in, (String)(req.getContextPath() + req.getServletPath()), (String)this.getGadgetInstanceID(), (String)newURL.getProtocol(), (String)host, (String)newURL.getFile(), (String)(req.getServerName() + ":" + req.getServerPort()), (String)con.getContentEncoding(), (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false, (PortalSession)this.session);
                    out.flush();
                    out.close();
                    outBuffer.flush();
                    outBuffer.close();
                    parsedURL = outBuffer.toString();
                }
                catch (PortalURLException e) {
                    if (e.getMessage().equals(PortalURLException.BASIC_REQUIRED)) {
                        parsedURL = BASIC_REQUIRED;
                    }
                }
            }
            catch (IOException io) {
                D.log(io);
            }
            catch (ClassCastException e) {
                D.log(e);
            }
        }
        return parsedURL;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    private String[] getXmlFiles(String xmlDir) {
        File[] fileList;
        File fXmlDir;
        String[] retArray = null;
        if (xmlDir != null && (fXmlDir = new File(xmlDir)) != null && fXmlDir.isDirectory() && (fileList = fXmlDir.listFiles()) != null) {
            int i;
            TreeSet<String> sortedList = new TreeSet<String>();
            for (i = 0; i < fileList.length; ++i) {
                String fileExt;
                String filePath = fileList[i].getAbsolutePath();
                int iIndex = filePath.lastIndexOf(46);
                if (iIndex == -1 || (fileExt = filePath.substring(iIndex)) == null || !fileExt.equalsIgnoreCase(".xml")) continue;
                sortedList.add(filePath);
            }
            Iterator fi = sortedList.iterator();
            retArray = new String[sortedList.size()];
            i = 0;
            while (fi.hasNext()) {
                retArray[i++] = (String)fi.next();
            }
        }
        return retArray;
    }

    public void getStylesheetAndResourceSets(HttpServletRequest req, StylesheetSetMap ssMap, ResourceSetMap rsMap) {
        StylesheetSetMap stylesheetSets = new StylesheetSetMap();
        StylesheetSet ssSet = new StylesheetSet("fw");
        ssSet.add((Object)"CreateServerAdminTask.xsl");
        ssSet.add((Object)"CreateServerAdminTask_lang.xsl");
        ssSet.add((Object)"include.xsl");
        ssSet.add((Object)"main_lang.xsl");
        stylesheetSets.put(ssSet);
        StylesheetSet ssGrpSet = new StylesheetSet("dev");
        ssGrpSet.add((Object)"include.xsl");
        ssGrpSet.add((Object)"main_lang.xsl");
        stylesheetSets.put(ssGrpSet);
        ssMap.putAll((Map)stylesheetSets);
    }

    private Properties getWizardFormAuthParams(HttpServletRequest req) {
        Enumeration theNames = req.getParameterNames();
        Properties params = new Properties();
        while (theNames.hasMoreElements()) {
            String currentParam = (String)theNames.nextElement();
            if (currentParam.equals("URL") || currentParam.equals("GI_ID") || currentParam.equals("FULLPAGE") || currentParam.equals("STATE") || currentParam.equals("WIZARD_STATE") || currentParam.equals("FIND") || currentParam.equals("START") || currentParam.equals("FINISHRECORD") || currentParam.equals("NPAction") || currentParam.equals("SKIPWIZARD")) continue;
            params.setProperty(currentParam, req.getParameter(currentParam));
            D.log("Params : " + currentParam + " = " + req.getParameter(currentParam));
        }
        if (params.size() == 0) {
            params = null;
        }
        return params;
    }

    private String convertParamsToString(Properties params) {
        String result = null;
        if (params != null) {
            Enumeration<Object> theNames = params.keys();
            while (theNames.hasMoreElements()) {
                String currentParam = (String)theNames.nextElement();
                if (result == null) {
                    result = currentParam + "=" + params.getProperty(currentParam);
                    continue;
                }
                result = result + "&" + currentParam + "=" + params.getProperty(currentParam);
            }
        }
        return result;
    }
}

