/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.studio.TemplateBuilderUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class CreatorWizardTask
extends MTask {
    public static final String HTMLPARAM_JAVA_CLASS_NAME = "JavaClassname";
    public static final String HTMLPARAM_SELECTED_CLASS = "SelectedClass";
    public static final String HTMLPARAM_MERGE_TEMPLATE = "MergeTemplate";
    HttpServletRequest m_req;
    MContext m_context;
    Task m_creator;

    public void execute(MContext context) {
        this.m_context = context;
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            if (!this.outputSchemaClasses()) {
                D.log("There was an error getting the classes!");
                eMFrameUtils.setMessage("error", "", "", context);
            }
            return;
        }
        if (nextState.equalsIgnoreCase("CreatorWizardSummary")) {
            String selectedClass = this.m_req.getParameter(HTMLPARAM_SELECTED_CLASS);
            if (selectedClass.equals("Alias")) {
                this.m_req.setAttribute(HTMLPARAM_JAVA_CLASS_NAME, (Object)"com.novell.emframe.base.CreateAliasTask");
                this.m_req.setAttribute(HTMLPARAM_MERGE_TEMPLATE, (Object)"base.CrtAlias");
            } else if (selectedClass.equals("User")) {
                this.m_req.setAttribute(HTMLPARAM_JAVA_CLASS_NAME, (Object)"com.novell.emframe.base.CreateUserAcctTask");
                this.m_req.setAttribute(HTMLPARAM_MERGE_TEMPLATE, (Object)"base.CrtUserAcct");
            } else {
                this.m_req.setAttribute(HTMLPARAM_JAVA_CLASS_NAME, (Object)"com.novell.emframe.fw.GenericCreator");
            }
            D.log("Show the creator summary!");
            return;
        }
        if (nextState.equalsIgnoreCase("CreatorWizardFinish")) {
            D.log("Finish the creator registration!");
            String selectedClass = this.m_req.getParameter(HTMLPARAM_SELECTED_CLASS);
            String javaClass = this.m_req.getParameter(HTMLPARAM_JAVA_CLASS_NAME);
            String mergeTemplate = this.m_req.getParameter(HTMLPARAM_MERGE_TEMPLATE);
            D.log("Register " + selectedClass + " to generic creator!!!");
            if (null == javaClass || javaClass.length() == 0) {
                if (selectedClass.equals("Alias")) {
                    javaClass = "com.novell.emframe.base.CreateAliasTask";
                    mergeTemplate = "base.CrtAlias";
                } else if (selectedClass.equals("User")) {
                    javaClass = "com.novell.emframe.base.CreateUserAcctTask";
                    mergeTemplate = "base.CrtUserAcct";
                } else {
                    javaClass = "com.novell.emframe.fw.GenericCreator";
                }
            }
            try {
                Class.forName(javaClass);
            }
            catch (ClassNotFoundException e) {
                D.log(e);
                String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardFailureTitle", context);
                String strBody = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardClassNotFound", context);
                eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{javaClass}), context);
                return;
            }
            if (CreatorWizardTask.registerClass(this.m_context, selectedClass, javaClass, mergeTemplate, false)) {
                String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardSuccessTitle", context);
                String strBody = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardSuccessExplain", context);
                eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{selectedClass}), context);
                return;
            }
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardFailureTitle", context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardFailureExplain", context);
            eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{selectedClass}), context);
            return;
        }
    }

    private boolean outputSchemaClasses() {
        SchemaDefinition schemaDef;
        HttpServletRequest req = this.m_context.getRequest();
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        try {
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            AdminNamespace namespace = treeOE.getAdminNamespace();
            schemaDef = namespace.getSchemaDefinition(treeOE);
        }
        catch (Exception ex) {
            D.log(ex);
            req.setAttribute("GeneralMsg.MsgBodyId", (Object)eMFrameUtils.getExceptionMessage(ex, this.m_context));
            return false;
        }
        ClassDefinition[] classDef = schemaDef.getClassDefinitions();
        ArrayList<String> objArray = new ArrayList<String>();
        for (int i = 0; i < classDef.length; ++i) {
            String temp = classDef[i].getName();
            if (classDef[i].isAuxiliary() || temp.equalsIgnoreCase("[Anything]") || temp.equalsIgnoreCase("[Nothing]") || !classDef[i].isEffective() || temp.startsWith("rbs") || temp.startsWith("bh") || temp.equals("Bindery Object") || temp.equals("Bindery Queue") || temp.equals("zenpolAssociation") || temp.equals("DM:Association") || temp.equals("Deleted File") || temp.equals("IWS:Domain") || temp.equals("Printer") || temp.equals("Print Server") || temp.equals("Queue") || temp.equals("Workstation Group") || temp.startsWith("NLS")) continue;
            objArray.add(classDef[i].getName());
        }
        eMFrameUtils.sortKeyValues(objArray, objArray, this.m_context);
        if (objArray.size() == 0) {
            String strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.InitialTaskFailure", this.m_context);
            String strCommonError = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.InitialTaskFailureExplain", this.m_context);
            eMFrameUtils.setMessage("error", strFailure, strCommonError, this.m_context);
            return false;
        }
        int count = 0;
        for (int i = 0; i < objArray.size(); ++i) {
            Document creatorDoc = GlobalRegistry.getCreatorDoc((String)objArray.get(i), this.m_context);
            if (null != creatorDoc) continue;
            req.setAttribute("Sch_ClassList.name." + count, objArray.get(i));
            ++count;
        }
        req.setAttribute("Sch_ClassList.Count", (Object)Integer.toString(count));
        this.setUIPage("fw/CreatorWizard1.jsp");
        return true;
    }

    public static boolean registerClass(MContext context, String className, String javaClass, String mergeTemplate, boolean shouldAddEDASStuff) {
        Document doc = null;
        doc = CreatorWizardTask.createXMLContent(context, className, javaClass, mergeTemplate, shouldAddEDASStuff);
        String xmlDirPath = iManager.getAbsModulesPath() + "/custom/plugins";
        File xmlDirectory = new File(xmlDirPath);
        File xmlFile = null;
        try {
            if (!xmlDirectory.exists()) {
                xmlDirectory.mkdirs();
            }
            String tmpClass = context.getDirUtils().getSafeName(className);
            xmlFile = new File(xmlDirectory, "creator" + tmpClass + ".xml");
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage(e, context);
            return false;
        }
        boolean success = CreatorWizardTask.outputXMLFile(context, doc, xmlFile);
        if (!success) {
            return false;
        }
        List list = doc.getRootElement().getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Element element = (Element)iterator.next();
                Document newDoc = new Document((Element)element.clone());
                GlobalRegistry.addNode(newDoc, xmlFile);
            }
            catch (Throwable t) {
                D.log(t);
            }
        }
        return true;
    }

    public static boolean unRegisterClass(MContext context, String className) {
        String xmlDirPath = iManager.getAbsModulesPath() + "/custom/plugins";
        File xmlDirectory = new File(xmlDirPath);
        File xmlFile = null;
        try {
            if (!xmlDirectory.exists()) {
                xmlDirectory.mkdirs();
            }
            String tmpClass = context.getDirUtils().getSafeName(className);
            xmlFile = new File(xmlDirectory, "creator" + tmpClass + ".xml");
            TemplateBuilderUtils.removePluginXmlFromFile(xmlFile, "base.CreateCustom" + tmpClass);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage(e, context);
            return false;
        }
        return true;
    }

    private static Document createXMLContent(MContext context, String className, String javaClass, String mergeTemplate, boolean shouldAddEDASStuff) {
        Element objectCreator = new Element("object-creator");
        String safeName = context.getDirUtils().getSafeName(className);
        objectCreator.addContent(new Element("id").setText("base.CreateCustom" + safeName));
        objectCreator.addContent(new Element("object-type-name").setText(className));
        objectCreator.addContent(new Element("version").setText("1.0"));
        objectCreator.addContent(new Element("required-version").setText("1.0"));
        objectCreator.addContent(new Element("class-name").setText(javaClass));
        if (shouldAddEDASStuff) {
            Element param1 = new Element("url-param");
            param1.addContent(new Element("param-key").setText("eDirSearch"));
            param1.addContent(new Element("param-value").setText(safeName));
            objectCreator.addContent(param1);
            Element param2 = new Element("url-param");
            param2.addContent(new Element("param-key").setText("eDirCommand"));
            param2.addContent(new Element("param-value").setText("preCreate"));
            objectCreator.addContent(param2);
        }
        if (mergeTemplate != null && mergeTemplate.length() > 0) {
            objectCreator.addContent(new Element("merge-template").setText(mergeTemplate));
        }
        try {
            ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
            if (treeOE.getAdminNamespace().getUniqueID().equalsIgnoreCase("LDAP")) {
                Element auth = new Element("auth-assignment");
                auth.addContent(new Element("id").setText("dir"));
                Element setting = new Element("setting");
                setting.addContent(new Element("name").setText("system"));
                setting.addContent(new Element("value").setText("NVDS"));
                auth.addContent(setting);
                objectCreator.addContent(auth);
            }
        }
        catch (Exception ex) {
            D.log(ex);
        }
        Element root = new Element("plugins");
        root.addContent(objectCreator);
        return new Document(root);
    }

    private static boolean outputXMLFile(MContext context, Document doc, File xmlFile) {
        XMLOutputter outputter = new XMLOutputter("   ", true);
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(xmlFile));
            outputter.output(doc, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            D.log(e);
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardErrorTitle", context), eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardError", context), context);
            return false;
        }
        catch (IOException e) {
            D.log(e);
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardErrorTitle", context), eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardError", context), context);
            return false;
        }
        return true;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            MContext context = eMFrameFactory.getMContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

