/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class DeleteCollections
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private HttpServletRequest m_req;
    private ArrayList m_errors = new ArrayList();
    private DeleteThread m_deleteThread;
    private boolean m_stopThread;
    private boolean m_threadDone;
    private String m_mainProgressMessage = "";
    private String m_alreadyMessage = "";
    private String m_abortMessage = "";
    private String[] m_collectionList;
    private int m_collectionsNotDeleted = 0;
    private int m_totalCollectionCount = 0;
    private int m_DeletingCount = 0;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        return true;
    }

    public boolean initialState() {
        this.m_collectionList = eMFrameUtils.unpack(this.m_req.getParameter("PackedCollectionsToDelete"), this.m_context);
        if (this.m_collectionList.length > 0) {
            this.m_mainProgressMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollections", this.m_context.getLocale());
            this.m_abortMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.AbortStop", this.m_context.getLocale());
            this.m_totalCollectionCount = this.m_collectionList.length;
            this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GenericProgress&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh" + "&progressCount=" + "" + "&mainProgressMessage=" + this.m_mainProgressMessage + "&alreadyMessage=" + this.m_alreadyMessage + "&abortMessage=" + this.m_abortMessage);
            this.m_resultStrings.put("UrlTask.url", url.toString());
            this.setUIPage("fw/UrlTask.jsp");
            this.m_stopThread = false;
            this.m_threadDone = false;
            this.m_deleteThread = new DeleteThread();
            this.m_deleteThread.start();
        }
        return true;
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            this.m_resultStrings.put("progressCount", "");
            if (this.m_DeletingCount == 0) {
                this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            } else {
                Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalCollectionCount)};
                this.m_alreadyMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionNumber", this.m_context.getLocale()), values);
            }
            this.m_resultStrings.put("mainProgressMessage", this.m_mainProgressMessage);
            this.m_resultStrings.put("alreadyMessage", this.m_alreadyMessage);
            this.m_resultStrings.put("abortMessage", this.m_abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            url = this.m_errors.isEmpty() ? url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true" : url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error";
            this.m_resultStrings.put("UrlTask.url", url.toString());
            this.setUIPage("fw/UrlTask.jsp");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestAborted", this.m_context.getLocale());
        String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteCollection", this.m_context.getLocale()) + "\n";
        Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalCollectionCount)};
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        return true;
    }

    private boolean finished() {
        Object[] values;
        String strBody;
        String strTitle;
        if (this.m_errors.isEmpty()) {
            strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestSucceeded", this.m_context.getLocale());
            strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteCollection", this.m_context.getLocale()) + "\n";
            values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalCollectionCount)};
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        } else {
            strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestError", this.m_context.getLocale());
            strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteCollection", this.m_context.getLocale()) + "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.CollectionsNotDeleted", this.m_context.getLocale());
            values = new String[]{Integer.toString(this.m_totalCollectionCount - this.m_collectionsNotDeleted), Integer.toString(this.m_totalCollectionCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        }
        ObjectEntry whoami = null;
        try {
            whoami = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(whoami);
            RBSCollection[] rbsCollections = rbsAssociatedObject.getAllOwnedCollections2();
            if (rbsCollections == null) {
                DirRoleList roleList = RBSUtil.getDirRoleList(this.m_context);
                roleList.setCollectionOwner(false);
                FwDirUtils.updateAccessMode(this.m_context);
            }
        }
        catch (Exception exc) {
            D.log(exc);
        }
        return true;
    }

    private void doCollectionDelete() {
        this.m_errors.clear();
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        int index = 0;
        while (index < this.m_collectionList.length && !this.m_stopThread) {
            ObjectEntry collectionOE = null;
            this.m_DeletingCount = index + 1;
            try {
                collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_collectionList[index]);
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_collectionsNotDeleted;
                this.m_errors.add(new String[]{this.m_collectionList[index], eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                ++index;
                continue;
            }
            RBSRole[] rbsRoles = null;
            RBSCategory[] rbsCategories = null;
            RBSCollection rbsCollection = new RBSCollection(collectionOE);
            try {
                rbsRoles = rbsCollection.getRoles();
                rbsCategories = rbsCollection.getCategories();
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_collectionsNotDeleted;
                this.m_errors.add(new String[]{this.m_collectionList[index], eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                ++index;
                continue;
            }
            if (rbsRoles != null) {
                for (int count = 0; count < rbsRoles.length; ++count) {
                    try {
                        rbsRoles[count].setMembers(null, dynamicGroupSearchType);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    ObjectEntry[] children = null;
                    try {
                        children = rbsRoles[count].getChildren();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    if (children != null) {
                        for (int i = 0; i < children.length; ++i) {
                            try {
                                this.m_ns.delete(children[i]);
                                continue;
                            }
                            catch (Exception exc) {
                                D.log(exc);
                                this.m_errors.add(new String[]{this.m_ns.getUnrootedName(children[i]), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                            }
                        }
                    }
                    try {
                        rbsRoles[count].setCategoryMembership(null);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    try {
                        rbsRoles[count].update();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    try {
                        this.m_ns.delete(rbsRoles[count].getObjectEntry());
                        continue;
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsRoles[count].getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    }
                }
            }
            if (rbsCategories != null) {
                for (int count = 0; count < rbsCategories.length; ++count) {
                    try {
                        this.m_ns.delete(rbsCategories[count].getObjectEntry());
                        continue;
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsRoles[count].getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    }
                }
            }
            RBSObject[] rbsObjects = null;
            try {
                rbsObjects = rbsCollection.getAllTasksAndBooks();
            }
            catch (Exception exc) {
                D.log(exc);
                this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsCollection.getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
            if (rbsObjects != null) {
                for (int count = 0; count < rbsObjects.length; ++count) {
                    try {
                        this.m_ns.delete(rbsObjects[count].getObjectEntry());
                        continue;
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsObjects[count].getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    }
                }
            }
            RBSModule[] rbsModules = null;
            try {
                rbsModules = rbsCollection.getAllModules();
            }
            catch (Exception exc) {
                D.log(exc);
                this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsCollection.getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
            if (rbsModules != null) {
                for (int count = 0; count < rbsModules.length; ++count) {
                    try {
                        this.m_ns.delete(rbsModules[count].getObjectEntry());
                        continue;
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsModules[count].getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    }
                }
            }
            try {
                rbsCollection.setOwners(null);
                rbsCollection.update();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.m_ns.delete(rbsCollection.getObjectEntry());
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_collectionsNotDeleted;
                this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsCollection.getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCollectionRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
            ++index;
        }
    }

    class DeleteThread
    extends Thread {
        public DeleteThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            DeleteCollections.this.doCollectionDelete();
            DeleteCollections.this.m_threadDone = true;
        }
    }
}

