/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Deletor;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public class DeleteObjectTask
extends Task {
    private static final long serialVersionUID = 8926408510366901738L;
    public static final String HTMLPARAM_OBJECTNAME = "DeleteObjectName";
    public static final String STR_TARGETOBJECT = "objectTypeName";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String STR_TARGETOBJECTDISPNAME = "objectTypeNameForDisplay";
    public static final String STR_TARGETOBJECTGIFNAME = "objectTypeNameForGif";
    Vector m_objectVector = null;
    ArrayList m_errors = new ArrayList();
    String m_targetNames = null;
    String m_targetObjectDispName = null;
    String m_targetObjectGifName = null;
    private String m_objectName = null;
    private int m_totalObjects = 0;
    private boolean m_err = false;
    private String m_translatedClass = "";
    private String m_gifName = "";
    private DeleteThread thread;
    private boolean stopThread;
    private boolean threadDone;
    private String mainProgressMessage = "";
    private String alreadyMessage = "";
    private String abortMessage = "";

    public boolean execute(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        if (this.m_targetNames == null) {
            this.m_targetNames = req.getParameter("targetNames");
            if (this.m_targetNames != null && this.m_targetNames.length() > 0) {
                ((I18NServletRequest)req).setParameter("merge", "dev.GenMsg");
                String title = eMFrameUtils.getLocalizedString("FwResources", "DeleteObject.DeleteObjectTitle", context);
                String body = eMFrameUtils.getLocalizedString("FwResources", "DeleteObject.DeleteWarning", context);
                resultStrings.put("GeneralMsg.Url", "webacc?taskId=" + this.getGadgetInstanceID() + "&merge=dev.GenConf&error=dev.MooGenErr&nextState=doDeleteObject");
                String names = this.m_targetNames.substring(2, this.m_targetNames.length() - 1);
                if (names.indexOf(":") == -1) {
                    body = body + "\n" + eMFrameUtils.urlDecode(names, context);
                }
                eMFrameUtils.setMessage("success", title, body, context);
                resultStrings.put("GeneralMsg.Icon", "dev/notice32.gif");
                resultStrings.put("GeneralMsg.ShowCancelButton", "true");
                this.m_objectVector = this.getTargetObjects(req);
                return true;
            }
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            this.m_objectVector = this.getTargetObjects(req);
            String[] targetObjArray = this.m_objectVector.toArray(new String[this.m_objectVector.size()]);
            this.setUpUI(targetObjArray, context, resultStrings);
            eMFrameUtils.setupTargetChooser(targetObjArray, context);
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doDeleteObject")) {
            this.m_objectName = this.m_targetNames;
            if (this.m_objectName == null || this.m_objectName.length() == 0) {
                this.m_objectName = req.getParameter(HTMLPARAM_OBJECTNAME);
            } else {
                this.m_targetNames = null;
            }
            this.setupProgress(context, resultStrings);
            return true;
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh(context, resultStrings);
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel(context, resultStrings);
        }
        if (nextState.equalsIgnoreCase("error")) {
            return this.error(context, resultStrings);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private void setUpUI(String[] targetObjArray, TaskContext context, Properties resultStrings) {
        if (!targetObjArray[0].equals("*") && targetObjArray.length == 1) {
            this.m_translatedClass = context.getDirUtils().getObjectTypeDisplayName(targetObjArray[0], context);
            this.m_gifName = context.getDirUtils().getObjectTypeImageName(targetObjArray[0]);
        } else {
            this.m_gifName = this.m_targetObjectGifName != null ? context.getDirUtils().getObjectTypeImageName(this.m_targetObjectGifName) : "object16.gif";
            this.m_translatedClass = this.m_targetObjectDispName != null ? context.getDirUtils().getObjectTypeDisplayName(this.m_targetObjectDispName, context) : eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Objects", context);
        }
        resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, this.m_translatedClass);
        resultStrings.put(HTMLPARAM_GIFNAME, this.m_gifName);
    }

    private boolean doDeleteObject(String objectName, Vector validObjects, TaskContext context) {
        String errUrl;
        String strError = null;
        ObjectEntry srcObjectOE = null;
        boolean err = false;
        this.m_totalObjects = 0;
        this.m_errors.clear();
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace namespace = treeOE.getAdminNamespace();
        ObjectEntryEnumeration objEnum = null;
        ObjectEntry oeTrustee = null;
        try {
            oeTrustee = namespace.getAuthenticatedIdentity(treeOE);
            TargetObjects objTargets = new TargetObjects(objectName, context);
            Exception[] errors = objTargets.getErrors();
            String[] badObjects = objTargets.getBadObjectNames();
            if (badObjects != null && errors != null) {
                for (int badcount = 0; badcount < badObjects.length; ++badcount) {
                    if (errors == null || errors.length <= 0) continue;
                    D.log(errors[badcount]);
                    err = true;
                    errUrl = "";
                    strError = eMFrameUtils.getExceptionMessage(errors[badcount], context);
                    if (errors[badcount] instanceof UniqueSPIException) {
                        errUrl = FwUtils.getUniqueSPIMessage((UniqueSPIException)errors[badcount]) + ".htm";
                    }
                    this.m_errors.add(new String[]{badObjects[badcount], eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.NotFound", context), new String[]{badObjects[badcount]}), errUrl});
                }
            }
            if (objTargets.getCount() > 0) {
                if (objTargets.isMultiple()) {
                    objEnum = objTargets.getObjectEntryEnumeration();
                    if (objEnum.hasMoreElements()) {
                        srcObjectOE = (ObjectEntry)objEnum.nextElement();
                    }
                } else {
                    srcObjectOE = objTargets.getObjectEntry();
                }
            } else {
                err = true;
            }
        }
        catch (Exception e) {
            D.log(e);
            return false;
        }
        while (srcObjectOE != null && !this.stopThread) {
            ObjectEntry nextObjectOE;
            block25: {
                nextObjectOE = this.getNextEntry(objEnum);
                ObjectType objType = srcObjectOE.getObjectType();
                if (oeTrustee.getFullName().equalsIgnoreCase(srcObjectOE.getFullName())) {
                    err = true;
                    D.log("Cannot delete the logged in user object: " + srcObjectOE.getFullName());
                    this.m_errors.add(new String[]{srcObjectOE.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.ErrorAunthenticatedUser", context), new String[]{srcObjectOE.getFullName()}), ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                boolean foundObj = false;
                if (validObjects != null && !((String)validObjects.elementAt(0)).equalsIgnoreCase("*")) {
                    for (int cnt = 0; cnt < validObjects.size(); ++cnt) {
                        if (!DirUtils.isOfType(objType, (String)validObjects.elementAt(cnt), false) && !this.isOfAuxType(srcObjectOE, (String)validObjects.elementAt(cnt), context)) continue;
                        foundObj = true;
                    }
                } else if (((String)validObjects.elementAt(0)).equalsIgnoreCase("*")) {
                    foundObj = true;
                }
                if (!foundObj) {
                    err = true;
                    D.log("Cannot delete this type of object: " + objType);
                    this.m_errors.add(new String[]{srcObjectOE.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.InvalidTargetObject", context), ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                try {
                    if (this.deleteIfRegistered(srcObjectOE, context)) break block25;
                    namespace.delete(srcObjectOE);
                    context.removeFromHistory(namespace.getUnrootedName(srcObjectOE));
                    JobData data = JobData.getJobData((GadgetInstance)this);
                    if (null == data) break block25;
                    data.setObjectNames(new String[]{namespace.getUnrootedName(srcObjectOE)});
                }
                catch (SPIException spie) {
                    err = true;
                    D.log(spie);
                    strError = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), context);
                    errUrl = "";
                    if (spie instanceof UniqueSPIException) {
                        errUrl = FwUtils.getUniqueSPIMessage((UniqueSPIException)spie);
                    }
                    this.m_errors.add(new String[]{srcObjectOE.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), strError, errUrl});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (SnapinVetoException sve) {
                    err = true;
                    D.log(sve);
                    strError = eMFrameUtils.getExceptionMessage((Exception)((Object)sve), context);
                    this.m_errors.add(new String[]{srcObjectOE.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), strError, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (ClassNotFoundException cx) {
                    err = true;
                    D.log(cx);
                    strError = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.WrongPackage", context);
                    this.m_errors.add(new String[]{srcObjectOE.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), strError, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (PluginException pe) {
                    err = true;
                    D.log(pe);
                    strError = pe.getHeader() + ":" + pe.getBody();
                    this.m_errors.add(new String[]{srcObjectOE.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context), strError, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
            }
            srcObjectOE = nextObjectOE;
            ++this.m_totalObjects;
        }
        return !err;
    }

    private ObjectEntry getNextEntry(ObjectEntryEnumeration objEnum) {
        ObjectEntry oeNext = null;
        if (objEnum != null) {
            try {
                oeNext = (ObjectEntry)objEnum.nextElement();
            }
            catch (Throwable e) {
                oeNext = null;
            }
        }
        return oeNext;
    }

    public boolean deleteIfRegistered(ObjectEntry oe, TaskContext context) throws ClassNotFoundException, PluginException {
        String objectClass = oe.getObjectType().getName();
        String oeFullName = oe.getFullName();
        try {
            Document deletorDoc = GlobalRegistry.getDeletorDoc(objectClass);
            if (deletorDoc != null) {
                String deletorClass = eMFrameUtils.getClassName(deletorDoc);
                Deletor newDeletor = new Deletor();
                Class<?> c = Class.forName(deletorClass);
                newDeletor = (Deletor)c.newInstance();
                newDeletor.doDelete(oe, context);
                D.log("This object type is registered: " + oeFullName + "(" + oe.getObjectType().getName() + ")");
                return true;
            }
            D.log("No registration found for the selected object type: " + oe.getObjectType().getName());
            return false;
        }
        catch (InstantiationException e) {
            D.log(e);
            return false;
        }
        catch (IllegalAccessException e) {
            D.log(e);
            return false;
        }
    }

    public Vector getTargetObjects(HttpServletRequest req) {
        Vector<String> validObjects = new Vector<String>(5);
        String targetObjects = req.getParameter(STR_TARGETOBJECT);
        this.m_targetObjectDispName = req.getParameter(STR_TARGETOBJECTDISPNAME);
        this.m_targetObjectGifName = req.getParameter(STR_TARGETOBJECTGIFNAME);
        D.log("Deleting-------------" + targetObjects);
        if (targetObjects != null) {
            StringTokenizer st = new StringTokenizer(targetObjects, ",");
            String strObject = null;
            while (st.hasMoreTokens()) {
                strObject = st.nextToken();
                validObjects.addElement(strObject);
            }
        }
        return validObjects;
    }

    public boolean isOfAuxType(ObjectEntry objOE, String targetType, TaskContext context) {
        return context.getDirUtils().isAuxClass(targetType) && context.getDirUtils().isOfAuxClass(objOE, targetType);
    }

    public void setupProgress(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        this.mainProgressMessage = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.DeletingObjects", context);
        this.abortMessage = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.ToStop", context);
        this.alreadyMessage = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.ObjectsDeleted", context);
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(req.getParameter("taskId"), context) + "&merge=fw.GenericProgress&User.context=" + req.getParameter("User.context") + "&nextState=refresh" + "&progressCount=" + this.m_totalObjects + "&mainProgressMessage=" + this.mainProgressMessage + "&alreadyMessage=" + this.alreadyMessage + "&abortMessage=" + this.abortMessage);
        resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)req).setParameter("merge", "fw.UrlTask");
        this.stopThread = false;
        this.threadDone = false;
        this.thread = new DeleteThread(context);
        this.thread.start();
    }

    private boolean refresh(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        String taskId = req.getParameter("taskId");
        String userContext = req.getParameter("User.context");
        D.log("refresh state");
        if (!this.threadDone) {
            resultStrings.put("progressCount", new Long(this.m_totalObjects).toString());
            resultStrings.put("mainProgressMessage", this.mainProgressMessage);
            resultStrings.put("alreadyMessage", this.alreadyMessage);
            resultStrings.put("abortMessage", this.abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, context) + "&User.context=" + userContext + "&nextState=error");
            url = this.m_err ? (this.m_totalObjects == 0 && this.m_errors.isEmpty() ? url + "&merge=dev.GenErr&GeneralMsg.Mode=error" : url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error") : url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true";
            if (this.m_totalObjects + this.m_errors.size() >= 7000) {
                url = url + "&GeneralMsg.countWarning=true";
            }
            resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)req).setParameter("merge", "fw.UrlTask");
        }
        return true;
    }

    private boolean cancel(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        D.log("cancel state");
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(req.getParameter("taskId"), context) + "&merge=fw.DelObject&User.context=" + req.getParameter("User.context") + "&nextState=" + "initialState" + "&TranslatedClass=" + this.m_translatedClass + "&GifName=" + this.m_gifName);
        resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)req).setParameter("merge", "fw.UrlTask");
        this.stopThread = true;
        return true;
    }

    private boolean error(TaskContext context, Properties resultStrings) {
        D.log("error state");
        if (this.m_err) {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.ErrorForObject", context);
            if (this.m_totalObjects == 0 && this.m_errors.isEmpty()) {
                eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.ErrorNoObjectsFound", context), context);
            } else {
                eMFrameUtils.setMooErrorMessage(resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.m_totalObjects)}), this.m_errors);
            }
        } else {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Success", context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.SuccessForObject", context);
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.m_totalObjects)}), context);
        }
        return true;
    }

    private void startDeleting(TaskContext context) {
        if (!this.stopThread) {
            this.m_err = !this.doDeleteObject(this.m_objectName, this.m_objectVector, context);
        }
    }

    class DeleteThread
    extends Thread {
        TaskContext m_context;

        public DeleteThread(TaskContext context) {
            this.m_context = context;
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            try {
                DeleteObjectTask.this.startDeleting(this.m_context);
            }
            catch (Throwable t) {
                D.log(t);
            }
            DeleteObjectTask.this.threadDone = true;
        }
    }
}

