/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.nps.utils.Utils;
import com.novell.rbs.RBSTask;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class DeleteTasks
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private HttpServletRequest m_req;
    private ArrayList m_errors = new ArrayList();
    private DeleteThread m_deleteThread;
    private boolean m_stopThread;
    private boolean m_threadDone;
    private String m_mainProgressMessage = "";
    private String m_alreadyMessage = "";
    private String m_abortMessage = "";
    private String[] m_taskList;
    private int m_tasksNotDeleted = 0;
    private int m_totalTaskCount = 0;
    private int m_DeletingCount = 0;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        return true;
    }

    public boolean initialState() {
        this.m_taskList = eMFrameUtils.unpack(this.m_req.getParameter("PackedTasksToDelete"), this.m_context);
        if (this.m_taskList.length > 0) {
            this.m_mainProgressMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTasks", this.m_context.getLocale());
            this.m_abortMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.AbortStop", this.m_context.getLocale());
            this.m_totalTaskCount = this.m_taskList.length;
            this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GenericProgress&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh" + "&progressCount=" + "" + "&mainProgressMessage=" + this.m_mainProgressMessage + "&alreadyMessage=" + this.m_alreadyMessage + "&abortMessage=" + this.m_abortMessage);
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
            this.m_stopThread = false;
            this.m_threadDone = false;
            this.m_deleteThread = new DeleteThread();
            this.m_deleteThread.start();
        }
        return true;
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            this.m_resultStrings.put("progressCount", "");
            if (this.m_DeletingCount == 0) {
                this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            } else {
                Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalTaskCount)};
                this.m_alreadyMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTaskNumber", this.m_context.getLocale()), values);
            }
            this.m_resultStrings.put("mainProgressMessage", this.m_mainProgressMessage);
            this.m_resultStrings.put("alreadyMessage", this.m_alreadyMessage);
            this.m_resultStrings.put("abortMessage", this.m_abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            url = this.m_errors.isEmpty() ? url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true" : url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error";
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTaskRequestAborted", this.m_context.getLocale());
        String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteTask", this.m_context.getLocale()) + "\n";
        Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalTaskCount)};
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        return true;
    }

    private boolean finished() {
        if (this.m_errors.isEmpty()) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTaskRequestSucceeded", this.m_context.getLocale());
            String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteTask", this.m_context.getLocale()) + "\n";
            Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalTaskCount)};
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        } else {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTaskRequestError", this.m_context.getLocale());
            String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteTask", this.m_context.getLocale()) + "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.TasksNotDeleted", this.m_context.getLocale());
            Object[] values = new String[]{Integer.toString(this.m_totalTaskCount - this.m_tasksNotDeleted), Integer.toString(this.m_totalTaskCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        }
        return true;
    }

    private void doTaskDelete() {
        this.m_errors.clear();
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        int index = 0;
        while (index < this.m_taskList.length && !this.m_stopThread) {
            ObjectEntry taskOE = null;
            this.m_DeletingCount = index + 1;
            try {
                taskOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_taskList[index]);
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_tasksNotDeleted;
                this.m_errors.add(new String[]{this.m_taskList[index], eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTaskRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                ++index;
                continue;
            }
            RBSTask rbsTask = new RBSTask(taskOE);
            try {
                rbsTask.setContentMembership(null, dynamicGroupSearchType);
                rbsTask.update();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.m_ns.delete(rbsTask.getObjectEntry());
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_tasksNotDeleted;
                this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsTask.getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteTaskRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
            ++index;
        }
    }

    class DeleteThread
    extends Thread {
        public DeleteThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            DeleteTasks.this.doTaskDelete();
            DeleteTasks.this.m_threadDone = true;
        }
    }
}

