/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.util.RBSObjectInstaller;
import com.novell.emframe.fw.xmlinfos.BookClassObject;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.PageClassObject;
import com.novell.emframe.fw.xmlinfos.RoleClassObject;
import com.novell.emframe.fw.xmlinfos.TaskClassObject;
import com.novell.emframe.fw.xmlinfos.XMLFileReader;
import com.novell.emframe.fw.xmlinfos.XMLFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DeveloperTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private Hashtable userObjects;
    private AdminNamespace ns;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        ObjectEntry treeOE = RBSUtil.getTreeOE(context);
        this.ns = treeOE.getAdminNamespace();
        this.userObjects = context.getAuthenticator().getAuthContext();
        String nextState = this.req.getParameter("nextState");
        String selectedButton = "";
        selectedButton = nextState == null || !nextState.equals("DeveloperIntroPage") ? this.req.getParameter("Task.SelectedButton") : "HeaderButton";
        if (nextState.equals("DeveloperIntroPage")) {
            return this.NextPageDeveloperIntro(selectedButton);
        }
        if (nextState.equals("DeveloperFilePage")) {
            return this.NextPageDeveloperFile(selectedButton);
        }
        if (nextState.equals("DeveloperModulePage")) {
            return this.NextPageDeveloperModule(selectedButton);
        }
        if (nextState.equals("DeveloperRoleListPage")) {
            return this.NextPageDeveloperRoleList(selectedButton);
        }
        if (nextState.equals("DeveloperRolePage")) {
            return this.NextPageDeveloperRole(selectedButton);
        }
        if (nextState.equals("DeveloperTaskListPage")) {
            return this.NextPageDeveloperTaskList(selectedButton);
        }
        if (nextState.equals("DeveloperTaskPage")) {
            return this.NextPageDeveloperTask(selectedButton);
        }
        if (nextState.equals("DeveloperPageListPage")) {
            return this.NextPageDeveloperPageList(selectedButton);
        }
        if (nextState.equals("DeveloperPagePage")) {
            return this.NextPageDeveloperPage(selectedButton);
        }
        if (nextState.equals("DeveloperBookListPage")) {
            return this.NextPageDeveloperBookList(selectedButton);
        }
        if (nextState.equals("DeveloperBookPage")) {
            return this.NextPageDeveloperBook(selectedButton);
        }
        if (nextState.equals("DeveloperSummaryPage")) {
            return this.NextPageDeveloperSummary(selectedButton);
        }
        if (nextState.equals("DeveloperFinishPage")) {
            return this.NextPageDeveloperFinish(selectedButton);
        }
        if (nextState.equals("DeveloperCreatePage")) {
            return this.NextPageDeveloperCreate(selectedButton);
        }
        if (nextState.equals("HomePage")) {
            return this.NextPageHomePage(selectedButton);
        }
        if (nextState.equals("OutputXML")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)context.getAuthAttribute("ModuleClassObject");
            XMLFileWriter xmlFileWriter = new XMLFileWriter();
            String content = xmlFileWriter.getString(moduleClassObject);
            resultStrings.put("xmlFileData", content);
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperFile(String selectedButton) {
        if (selectedButton.equals("NextIntroButton")) {
            return true;
        }
        return selectedButton.equals("BackModuleButton");
    }

    private boolean NextPageDeveloperIntro(String selectedButton) {
        if (selectedButton.equals("HeaderButton")) {
            return true;
        }
        return selectedButton.equals("BackFileButton");
    }

    private boolean NextPageDeveloperModule(String selectedButton) {
        if (selectedButton.equals("NextFileButton")) {
            String fileType = this.req.getParameter("DF_FileSelection");
            if (fileType == null || fileType.length() == 0) {
                return false;
            }
            if (fileType.equals("DF_NewFile")) {
                ModuleClassObject moduleClassObject = new ModuleClassObject();
                this.PutModuleClassObject(moduleClassObject);
                this.userObjects.put("ModuleClassObject", moduleClassObject);
                return true;
            }
            if (fileType.equals("DF_ExistingFile")) {
                ModuleClassObject moduleClassObject;
                ((FwRequest)this.req).parseMultipartRequest(null);
                String tempFile = this.req.getParameter("DF_FileName.tempFile");
                if (tempFile == null || tempFile.length() == 0) {
                    return false;
                }
                String authName = "eDir";
                try {
                    if (this.ns.isSupported("NVDS")) {
                        authName = "NVDS";
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                XMLFileReader xmlFileReader = new XMLFileReader(this.ns);
                try {
                    moduleClassObject = xmlFileReader.readFile(tempFile, authName);
                }
                catch (Exception e) {
                    D.log(e);
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "DevelopersForm.FileOption.ErrorTitle", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "DevelopersForm.FileOption.ErrorFileNotFound", this.context));
                    eMFrameUtils.setErrorMessage(e, this.context);
                    return false;
                }
                this.PutModuleClassObject(moduleClassObject);
                this.userObjects.put("ModuleClassObject", moduleClassObject);
                return true;
            }
        } else if (selectedButton.equals("BackRoleListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutModuleClassObject(moduleClassObject);
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperTask(String selectedButton) {
        if (selectedButton.equals("AddTaskListButton")) {
            TaskClassObject taskClassObject = new TaskClassObject(this.ns);
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            try {
                this.PutTaskClassObject(taskClassObject, moduleClassObject.getRoleList());
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            this.resultStrings.put("AddOrModify_Value", "AddTask");
            this.resultStrings.put("DT_Task_List_Value", moduleClassObject.getTaskListCommaDelimitedString());
            this.userObjects.put("TaskClassObject", taskClassObject);
            return true;
        }
        if (selectedButton.equals("ModifyTaskListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            TaskClassObject taskClassObject = moduleClassObject.getTask(selectedItem);
            try {
                this.PutTaskClassObject(taskClassObject, moduleClassObject.getRoleList());
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            this.resultStrings.put("AddOrModify_Value", "ModifyTask");
            this.resultStrings.put("DT_Task_List_Value", moduleClassObject.getTaskListCommaDelimitedString());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperSummary(String selectedButton) {
        if (selectedButton.equals("NextBookListButton") || selectedButton.equals("BackFinishButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            String[] roleList = moduleClassObject.getRoleList();
            Vector[] taskListV = null;
            if (roleList != null) {
                int i;
                taskListV = new Vector[roleList.length];
                eMFrameUtils.sortStringArray(roleList);
                for (i = 0; i < roleList.length; ++i) {
                    int k;
                    int j;
                    Vector<Object> tempListV = new Vector<Object>();
                    block1: for (j = 0; j < moduleClassObject.getTaskCount(); ++j) {
                        TaskClassObject taskClassObject = moduleClassObject.getTask(j);
                        String[] taskRoles = taskClassObject.getRoleList();
                        if (taskRoles == null) continue;
                        for (k = 0; k < taskRoles.length; ++k) {
                            if (!taskRoles[k].equals(roleList[i])) continue;
                            tempListV.add(taskClassObject.getName());
                            continue block1;
                        }
                    }
                    block3: for (j = 0; j < moduleClassObject.getBookCount(); ++j) {
                        BookClassObject bookClassObject = moduleClassObject.getBook(j);
                        String[] bookRoles = bookClassObject.getRoleList();
                        if (bookRoles == null) continue;
                        for (k = 0; k < bookRoles.length; ++k) {
                            if (!bookRoles[k].equals(roleList[i])) continue;
                            tempListV.add(bookClassObject.getName());
                            continue block3;
                        }
                    }
                    Object[] content = new String[tempListV.size()];
                    tempListV.copyInto(content);
                    eMFrameUtils.sortStringArray((String[])content);
                    tempListV.removeAllElements();
                    for (int j2 = 0; j2 < content.length; ++j2) {
                        tempListV.add(content[j2]);
                    }
                    taskListV[i] = tempListV;
                }
                this.resultStrings.put("DF_Role.Count", Integer.toString(roleList.length));
                for (i = 0; i < roleList.length; ++i) {
                    this.resultStrings.put("DF_RoleName." + i, roleList[i]);
                    Vector task = taskListV[i];
                    this.resultStrings.put("DF_Task.Count." + i, Integer.toString(task.size()));
                    for (int j = 0; j < task.size(); ++j) {
                        this.resultStrings.put("DF_TaskName." + i + "." + j, task.elementAt(j));
                    }
                }
            } else {
                int j;
                Vector<String> taskList = new Vector<String>();
                this.resultStrings.put("DF_Role.Count", Integer.toString(0));
                for (j = 0; j < moduleClassObject.getTaskCount(); ++j) {
                    TaskClassObject taskClassObject = moduleClassObject.getTask(j);
                    taskList.add(taskClassObject.getName());
                }
                for (j = 0; j < moduleClassObject.getBookCount(); ++j) {
                    BookClassObject bookClassObject = moduleClassObject.getBook(j);
                    taskList.add(bookClassObject.getName());
                }
                Object[] content = new String[taskList.size()];
                taskList.copyInto(content);
                eMFrameUtils.sortStringArray((String[])content);
                this.resultStrings.put("DF_Task.Count", Integer.toString(content.length));
                for (int i = 0; i < content.length; ++i) {
                    this.resultStrings.put("DF_TaskName." + i, content[i]);
                }
            }
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperCreate(String selectedButton) {
        if (selectedButton.equals("CreateCreateButton")) {
            ObjectEntry treeOE = RBSUtil.getTreeOE(this.context);
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            RBSObjectInstaller installer = new RBSObjectInstaller(treeOE, moduleClassObject);
            try {
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                installer.install(this.req.getParameter("DC_InstallContext_Name"), dynamicGroupSearchType);
                String[] args = new String[]{moduleClassObject.getModuleName()};
                String strArgs = eMFrameUtils.concatStrings(args, "\n");
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.INSTALL_PACKAGE", this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.INSTALL_PACKAGE_SUCCESS", this.context));
                this.resultStrings.put("GeneralMsg.MsgBodyBoldText", strArgs);
                String taskId = this.req.getParameter("taskId");
                String userContext = this.req.getParameter("User.context");
                String url = new String("webacc?taskId=" + taskId + "&merge=fw.DeveloperCreate&User.context=" + userContext + "&nextState=DeveloperCreatePage" + "&Task.SelectedButton=NextFinishButton");
                this.setUIPage("dev/GenConf.jsp");
                this.resultStrings.put("GeneralMsg.Url", url);
                return true;
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        }
        return selectedButton.equals("NextFinishButton");
    }

    private boolean NextPageDeveloperRole(String selectedButton) {
        if (selectedButton.equals("AddRoleListButton")) {
            RoleClassObject roleClassObject = new RoleClassObject();
            this.PutRoleClassObject(roleClassObject);
            this.resultStrings.put("AddOrModify_Value", "AddRole");
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.resultStrings.put("DR_Role_List_Value", moduleClassObject.getRoleListCommaDelimitedString());
            this.userObjects.put("RoleClassObject", roleClassObject);
            return true;
        }
        if (selectedButton.equals("ModifyRoleListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            RoleClassObject roleClassObject = moduleClassObject.getRole(selectedItem);
            if (roleClassObject == null) {
                return false;
            }
            this.PutRoleClassObject(roleClassObject);
            this.resultStrings.put("AddOrModify_Value", "ModifyRole");
            this.resultStrings.put("DR_Role_List_Value", moduleClassObject.getRoleListCommaDelimitedString());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperRoleList(String selectedButton) {
        if (selectedButton.equals("NextModuleButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.SaveModuleClassObject(moduleClassObject);
            this.PutList(moduleClassObject.getRoleList());
            return true;
        }
        if (selectedButton.equals("OkRoleButton")) {
            String addOrModify = this.req.getParameter("AddOrModify");
            if (addOrModify == null || addOrModify.length() == 0) {
                return false;
            }
            if (addOrModify.equals("ModifyRole")) {
                String newName;
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                RoleClassObject roleClassObject = moduleClassObject.getRole();
                String oldName = roleClassObject.getName();
                if (!oldName.equalsIgnoreCase(newName = this.req.getParameter("DR_RoleName_Name"))) {
                    Vector tasks = moduleClassObject.getTasks();
                    block0: for (int i = 0; i < tasks.size(); ++i) {
                        TaskClassObject taskClassObject = (TaskClassObject)tasks.elementAt(i);
                        Vector roleList = taskClassObject.getRoles();
                        for (int j = 0; j < roleList.size(); ++j) {
                            String roleName = (String)roleList.elementAt(j);
                            if (!roleName.equalsIgnoreCase(oldName)) continue;
                            roleList.setElementAt(newName, j);
                            continue block0;
                        }
                    }
                    Vector books = moduleClassObject.getBooks();
                    block2: for (int i = 0; i < books.size(); ++i) {
                        BookClassObject bookClassObject = (BookClassObject)books.elementAt(i);
                        Vector roleList = bookClassObject.getRoles();
                        for (int j = 0; j < roleList.size(); ++j) {
                            String roleName = (String)roleList.elementAt(j);
                            if (!roleName.equalsIgnoreCase(oldName)) continue;
                            roleList.setElementAt(newName, j);
                            continue block2;
                        }
                    }
                }
                this.SaveRoleClassObject(roleClassObject);
                this.PutList(moduleClassObject.getRoleList());
                return true;
            }
            if (addOrModify.equals("AddRole")) {
                RoleClassObject roleClassObject = (RoleClassObject)this.userObjects.get("RoleClassObject");
                this.SaveRoleClassObject(roleClassObject);
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                moduleClassObject.addRole(roleClassObject);
                this.PutList(moduleClassObject.getRoleList());
                return true;
            }
            return false;
        }
        if (selectedButton.equals("DeleteRoleListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            moduleClassObject.removeRole(selectedItem);
            Vector tasks = moduleClassObject.getTasks();
            block4: for (int i = 0; i < tasks.size(); ++i) {
                TaskClassObject taskClassObject = (TaskClassObject)tasks.elementAt(i);
                Vector roleList = taskClassObject.getRoles();
                for (int j = 0; j < roleList.size(); ++j) {
                    String roleName = (String)roleList.elementAt(j);
                    if (!roleName.equalsIgnoreCase(selectedItem)) continue;
                    roleList.removeElementAt(j);
                    continue block4;
                }
            }
            Vector books = moduleClassObject.getBooks();
            block6: for (int i = 0; i < books.size(); ++i) {
                BookClassObject bookClassObject = (BookClassObject)books.elementAt(i);
                Vector roleList = bookClassObject.getRoles();
                for (int j = 0; j < roleList.size(); ++j) {
                    String roleName = (String)roleList.elementAt(j);
                    if (!roleName.equalsIgnoreCase(selectedItem)) continue;
                    roleList.removeElementAt(j);
                    continue block6;
                }
            }
            this.PutList(moduleClassObject.getRoleList());
            return true;
        }
        if (selectedButton.equals("BackTaskListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutModuleClassObject(moduleClassObject);
            this.PutList(moduleClassObject.getRoleList());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperTaskList(String selectedButton) {
        if (selectedButton.equals("NextRoleListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutList(moduleClassObject.getTaskList());
            return true;
        }
        if (selectedButton.equals("OkTaskButton")) {
            String addOrModify = this.req.getParameter("AddOrModify");
            if (addOrModify == null || addOrModify.length() == 0) {
                return false;
            }
            if (addOrModify.equals("ModifyTask")) {
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                TaskClassObject taskClassObject = moduleClassObject.getTask();
                this.SaveTaskClassObject(taskClassObject, null);
                this.PutList(moduleClassObject.getTaskList());
                return true;
            }
            if (addOrModify.equals("AddTask")) {
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                TaskClassObject taskClassObject = (TaskClassObject)this.userObjects.get("TaskClassObject");
                this.SaveTaskClassObject(taskClassObject, moduleClassObject.getModuleName());
                moduleClassObject.addTask(taskClassObject);
                this.PutList(moduleClassObject.getTaskList());
                return true;
            }
            return false;
        }
        if (selectedButton.equals("DeleteTaskListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            moduleClassObject.removeTask(selectedItem);
            this.PutList(moduleClassObject.getTaskList());
            return true;
        }
        if (selectedButton.equals("BackPageListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutList(moduleClassObject.getTaskList());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperPageList(String selectedButton) {
        if (selectedButton.equals("NextTaskListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutList(moduleClassObject.getPageList());
            return true;
        }
        if (selectedButton.equals("OkPageButton")) {
            String addOrModify = this.req.getParameter("AddOrModify");
            if (addOrModify == null || addOrModify.length() == 0) {
                return false;
            }
            if (addOrModify.equals("ModifyPage")) {
                String newName;
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                PageClassObject pageClassObject = moduleClassObject.getPage();
                String oldName = pageClassObject.getName();
                if (!oldName.equalsIgnoreCase(newName = this.req.getParameter("DP_TaskName_Name"))) {
                    Vector books = moduleClassObject.getBooks();
                    block0: for (int i = 0; i < books.size(); ++i) {
                        BookClassObject bookClassObject = (BookClassObject)books.elementAt(i);
                        Vector pageList = bookClassObject.getPages();
                        for (int j = 0; j < pageList.size(); ++j) {
                            String pageName = (String)pageList.elementAt(j);
                            if (!pageName.equalsIgnoreCase(oldName)) continue;
                            pageList.setElementAt(newName, j);
                            continue block0;
                        }
                    }
                }
                this.SavePageClassObject(pageClassObject);
                this.PutList(moduleClassObject.getPageList());
                return true;
            }
            if (addOrModify.equals("AddPage")) {
                PageClassObject pageClassObject = (PageClassObject)this.userObjects.get("PageClassObject");
                this.SavePageClassObject(pageClassObject);
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                moduleClassObject.addPage(pageClassObject);
                this.PutList(moduleClassObject.getPageList());
                return true;
            }
            return false;
        }
        if (selectedButton.equals("DeletePageListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            moduleClassObject.removePage(selectedItem);
            Vector books = moduleClassObject.getBooks();
            block2: for (int i = 0; i < books.size(); ++i) {
                BookClassObject bookClassObject = (BookClassObject)books.elementAt(i);
                Vector pageList = bookClassObject.getPages();
                for (int j = 0; j < pageList.size(); ++j) {
                    String pageName = (String)pageList.elementAt(j);
                    if (!pageName.equalsIgnoreCase(selectedItem)) continue;
                    pageList.removeElementAt(j);
                    continue block2;
                }
            }
            this.PutList(moduleClassObject.getPageList());
            return true;
        }
        if (selectedButton.equals("BackBookListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutList(moduleClassObject.getPageList());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperBookList(String selectedButton) {
        if (selectedButton.equals("NextPageListButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutList(moduleClassObject.getBookList());
            return true;
        }
        if (selectedButton.equals("BackSummaryButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.PutList(moduleClassObject.getBookList());
            return true;
        }
        if (selectedButton.equals("OkBookButton")) {
            String addOrModify = this.req.getParameter("AddOrModify");
            if (addOrModify == null || addOrModify.length() == 0) {
                return false;
            }
            if (addOrModify.equals("ModifyBook")) {
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                BookClassObject bookClassObject = moduleClassObject.getBook();
                this.SaveBookClassObject(bookClassObject, null);
                this.PutList(moduleClassObject.getBookList());
                return true;
            }
            if (addOrModify.equals("AddBook")) {
                ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
                BookClassObject bookClassObject = (BookClassObject)this.userObjects.get("BookClassObject");
                this.SaveBookClassObject(bookClassObject, moduleClassObject.getModuleName());
                moduleClassObject.addBook(bookClassObject);
                this.PutList(moduleClassObject.getBookList());
                return true;
            }
            return false;
        }
        if (selectedButton.equals("DeleteBookListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            moduleClassObject.removeBook(selectedItem);
            this.PutList(moduleClassObject.getBookList());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperFinish(String selectedButton) {
        if (selectedButton.equals("BackCreateButton")) {
            return true;
        }
        if (selectedButton.equals("NextSummaryButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            String tempDirPath = this.context.getWebappHome() + "/temp";
            File tempDir = new File(tempDirPath);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            try {
                File tempFile = File.createTempFile("install", ".xml", tempDir);
                XMLFileWriter xmlFileWriter = new XMLFileWriter();
                xmlFileWriter.writeTempFile(tempFile, moduleClassObject);
                tempFile.deleteOnExit();
                Vector downloadableFiles = (Vector)this.context.getAuthAttribute("dev.DownloadableFiles");
                downloadableFiles.add("temp/" + tempFile.getName());
                this.resultStrings.put("TempInstall.XML.FileName", tempFile.getName());
            }
            catch (IOException ioe) {
                D.log(ioe);
                eMFrameUtils.setErrorMessage(ioe, this.context);
                return false;
            }
            return true;
        }
        if (selectedButton.equals("SaveFinishButton")) {
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            String fileUploadPath = SystemConfig.getSystemConfig(this.context).getSetting("File.Upload.path");
            XMLFileWriter xmlFileWriter = new XMLFileWriter();
            try {
                xmlFileWriter.writeFile(fileUploadPath, moduleClassObject);
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperBook(String selectedButton) {
        if (selectedButton.equals("AddBookListButton")) {
            BookClassObject bookClassObject = new BookClassObject(this.ns);
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            try {
                this.PutBookClassObject(bookClassObject, moduleClassObject.getRoleList(), moduleClassObject.getPageList());
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            this.resultStrings.put("AddOrModify_Value", "AddBook");
            this.resultStrings.put("DB_Book_List_Value", moduleClassObject.getBookListCommaDelimitedString());
            this.userObjects.put("BookClassObject", bookClassObject);
            return true;
        }
        if (selectedButton.equals("ModifyBookListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            BookClassObject bookClassObject = moduleClassObject.getBook(selectedItem);
            if (bookClassObject == null) {
                return false;
            }
            try {
                this.PutBookClassObject(bookClassObject, moduleClassObject.getRoleList(), moduleClassObject.getPageList());
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            this.resultStrings.put("AddOrModify_Value", "ModifyBook");
            this.resultStrings.put("DB_Book_List_Value", moduleClassObject.getBookListCommaDelimitedString());
            return true;
        }
        return false;
    }

    private boolean NextPageDeveloperPage(String selectedButton) {
        if (selectedButton.equals("AddPageListButton")) {
            PageClassObject pageClassObject = new PageClassObject(this.ns);
            this.PutPageClassObject(pageClassObject);
            this.resultStrings.put("AddOrModify_Value", "AddPage");
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            this.resultStrings.put("DP_Page_List_Value", moduleClassObject.getPageListCommaDelimitedString());
            this.userObjects.put("PageClassObject", pageClassObject);
            return true;
        }
        if (selectedButton.equals("ModifyPageListButton")) {
            String selectedItem = this.req.getParameter("Selected_Item");
            if (selectedItem == null || selectedItem.length() == 0) {
                return false;
            }
            ModuleClassObject moduleClassObject = (ModuleClassObject)this.userObjects.get("ModuleClassObject");
            PageClassObject pageClassObject = moduleClassObject.getPage(selectedItem);
            this.PutPageClassObject(pageClassObject);
            this.resultStrings.put("AddOrModify_Value", "ModifyPage");
            this.resultStrings.put("DP_Page_List_Value", moduleClassObject.getPageListCommaDelimitedString());
            return true;
        }
        return false;
    }

    private boolean NextPageHomePage(String selectedButton) {
        return selectedButton.equals("FinishCreateButton");
    }

    private void PutModuleClassObject(ModuleClassObject moduleClassObj) {
        this.resultStrings.put("DM_ModuleName_Value", moduleClassObj.getModuleName());
        this.resultStrings.put("DM_Version_Value", moduleClassObj.getVersion());
        this.resultStrings.put("DM_ResourceBundle_Value", moduleClassObj.getResourceBundle());
        this.resultStrings.put("DM_DescriptionData_Value", moduleClassObj.getDescData());
    }

    private void SaveRoleClassObject(RoleClassObject roleClassObject) {
        roleClassObject.setName(this.req.getParameter("DR_RoleName_Name"));
        roleClassObject.setVersion(this.req.getParameter("DR_Version_Name"));
        roleClassObject.setDisplayNameKey(this.req.getParameter("DR_DisplayNameKey_Name"));
        roleClassObject.setDescKeyData(this.req.getParameter("DR_DescNameKey_Name"));
        roleClassObject.setDescData(this.req.getParameter("DR_DescriptionData_Name"));
        roleClassObject.setMiscData(this.unPackMiscData(this.req.getParameter("DR_MiscellaneousData_Name")));
    }

    private void PutRoleClassObject(RoleClassObject roleClassObject) {
        this.resultStrings.put("DR_RoleName_Value", roleClassObject.getName());
        this.resultStrings.put("DR_Version_Value", roleClassObject.getVersion());
        this.resultStrings.put("DR_DisplayNameKey_Value", roleClassObject.getDisplayNameKey());
        this.resultStrings.put("DR_DescNameKey_Value", roleClassObject.getDescKeyData());
        this.resultStrings.put("DR_DescriptionData_Value", roleClassObject.getDescData());
        this.resultStrings.put("DR_MiscellaneousData_Value", this.packMiscData(roleClassObject.getMiscData()));
    }

    private void SaveModuleClassObject(ModuleClassObject moduleClassObject) {
        moduleClassObject.setModuleName(this.req.getParameter("DM_ModuleName_Name"));
        moduleClassObject.setVersion(this.req.getParameter("DM_Version_Name"));
        moduleClassObject.setResourceBundle(this.req.getParameter("DM_ResourceBundle_Name"));
        moduleClassObject.setDescData(this.req.getParameter("DM_DescriptionData_Name"));
    }

    private void SaveTaskClassObject(TaskClassObject taskClassObject, String moduleName) {
        taskClassObject.setType(this.req.getParameter("DT_TaskType_Name"));
        if (moduleName == null) {
            taskClassObject.setName(this.req.getParameter("DT_TaskName_Name"));
        } else {
            taskClassObject.setName(moduleName + "." + this.req.getParameter("DT_TaskName_Name"));
        }
        taskClassObject.setVersion(this.req.getParameter("DT_Version_Name"));
        taskClassObject.setRequiredVersion(this.req.getParameter("DT_Required_Version_Name"));
        taskClassObject.setClassPath(this.req.getParameter("DT_TaskClassPath_Name"));
        taskClassObject.setDisplayNameKey(this.req.getParameter("DT_DisplayNameKey_Name"));
        taskClassObject.setDescKeyData(this.req.getParameter("DT_DescNameKey_Name"));
        taskClassObject.setMergeTemplateName(this.req.getParameter("DT_MergeTemplateName_Name"));
        taskClassObject.setErrorTemplateName(this.req.getParameter("DT_ErrorTemplateName_Name"));
        taskClassObject.setDescData(this.req.getParameter("DT_DescriptionData_Name"));
        taskClassObject.setMiscData(this.unPackMiscData(this.req.getParameter("DT_MiscellaneousData_Name")));
        taskClassObject.setAttrListWithCommaDelimitedString(this.req.getParameter("DT_AttrList_Name"), this.req);
        taskClassObject.setRoleListWithCommaDelimitedString(this.req.getParameter("DT_RoleList"), this.req);
    }

    private void PutTaskClassObject(TaskClassObject taskClassObject, String[] availableRoleList) throws Exception {
        int count;
        this.resultStrings.put("DT_TaskType_Value", taskClassObject.getType());
        this.resultStrings.put("DT_TaskName_Value", taskClassObject.getName());
        this.resultStrings.put("DT_Version_Value", taskClassObject.getVersion());
        this.resultStrings.put("DT_Required_Version_Value", taskClassObject.getRequiredVersion());
        this.resultStrings.put("DT_TaskClassPath_Value", taskClassObject.getClassPath());
        this.resultStrings.put("DT_DisplayNameKey_Value", taskClassObject.getDisplayNameKey());
        this.resultStrings.put("DT_DescNameKey_Value", taskClassObject.getDescKeyData());
        this.resultStrings.put("DT_MergeTemplateName_Value", taskClassObject.getMergeTemplateName());
        this.resultStrings.put("DT_ErrorTemplateName_Value", taskClassObject.getErrorTemplateName());
        this.resultStrings.put("DT_DescriptionData_Value", taskClassObject.getDescData());
        this.resultStrings.put("DT_MiscellaneousData_Value", this.packMiscData(taskClassObject.getMiscData()));
        String[] assignedAttrList = taskClassObject.getAttrList();
        if (assignedAttrList != null) {
            for (count = 0; count < assignedAttrList.length; ++count) {
                this.resultStrings.put("DT_AttrList.Element." + count, assignedAttrList[count]);
            }
        }
        this.resultStrings.put("DT_AttrList.Count", Integer.toString(count));
        count = 0;
        String[] availableAttrs = this.PutSchemaAttributes();
        if (assignedAttrList != null && availableAttrs != null) {
            availableAttrs = RBSUtil.removeAssignedFromAvailable(availableAttrs, assignedAttrList);
        }
        if (availableAttrs != null) {
            while (count < availableAttrs.length) {
                this.resultStrings.put("Sch_AttrList.Element." + count, availableAttrs[count]);
                ++count;
            }
            this.resultStrings.put("Sch_AttrList.Count", Integer.toString(availableAttrs.length));
        } else {
            this.resultStrings.put("Sch_AttrList.Count", Integer.toString(0));
        }
        String[] assignedRoleList = taskClassObject.getRoleList();
        if (assignedRoleList != null) {
            for (count = 0; count < assignedRoleList.length; ++count) {
                this.resultStrings.put("AssignedRoleList.Element." + count, assignedRoleList[count]);
            }
        }
        this.resultStrings.put("AssignedRoleList.Count", Integer.toString(count));
        count = 0;
        if (availableRoleList != null && assignedRoleList != null) {
            availableRoleList = RBSUtil.removeAssignedFromAvailable(availableRoleList, assignedRoleList);
        }
        if (availableRoleList != null) {
            while (count < availableRoleList.length) {
                this.resultStrings.put("AvailableRoleList.Element." + count, availableRoleList[count]);
                ++count;
            }
            this.resultStrings.put("AvailableRoleList.Count", Integer.toString(count));
        } else {
            this.resultStrings.put("AvailableRoleList.Count", Integer.toString(0));
        }
    }

    private void SaveBookClassObject(BookClassObject bookClassObject, String moduleName) {
        if (moduleName == null) {
            bookClassObject.setName(this.req.getParameter("DB_TaskName_Name"));
        } else {
            bookClassObject.setName(moduleName + "." + this.req.getParameter("DB_TaskName_Name"));
        }
        bookClassObject.setVersion(this.req.getParameter("DB_Version_Name"));
        bookClassObject.setDescKeyData(this.req.getParameter("DB_DescNameKey_Name"));
        bookClassObject.setClassPath(this.req.getParameter("DB_TaskClassPath_Name"));
        bookClassObject.setDisplayNameKey(this.req.getParameter("DB_DisplayNameKey_Name"));
        bookClassObject.setDescData(this.req.getParameter("DB_DescriptionData_Name"));
        bookClassObject.setMiscData(this.unPackMiscData(this.req.getParameter("DB_MiscellaneousData_Name")));
        bookClassObject.setRoleListWithCommaDelimitedString(this.req.getParameter("DB_RoleList"), this.req);
        bookClassObject.setPageListWithCommaDelimitedString(this.req.getParameter("DB_PageList"), this.req);
        bookClassObject.setObjectClassTypeWithCommaDelimitedString(this.req.getParameter("DB_Assigned_ClassList_Name"), this.req);
    }

    private void PutBookClassObject(BookClassObject bookClassObject, String[] availableRoleList, String[] availablePageList) throws SPIException {
        int count;
        this.resultStrings.put("DB_TaskName_Value", bookClassObject.getName());
        this.resultStrings.put("DB_Version_Value", bookClassObject.getVersion());
        this.resultStrings.put("DB_Version_Value", bookClassObject.getVersion());
        this.resultStrings.put("DB_DescNameKey_Value", bookClassObject.getDescKeyData());
        this.resultStrings.put("DB_DisplayNameKey_Value", bookClassObject.getDisplayNameKey());
        this.resultStrings.put("DB_DescriptionData_Value", bookClassObject.getDescData());
        this.resultStrings.put("DB_MiscellaneousData_Value", this.packMiscData(bookClassObject.getMiscData()));
        String[] assignedRoleList = bookClassObject.getRoleList();
        if (assignedRoleList != null) {
            for (count = 0; count < assignedRoleList.length; ++count) {
                this.resultStrings.put("AssignedRoleList.Element." + count, assignedRoleList[count]);
            }
        }
        this.resultStrings.put("AssignedRoleList.Count", Integer.toString(count));
        count = 0;
        if (assignedRoleList != null && availableRoleList != null) {
            availableRoleList = RBSUtil.removeAssignedFromAvailable(availableRoleList, assignedRoleList);
        }
        if (availableRoleList != null) {
            while (count < availableRoleList.length) {
                this.resultStrings.put("AvailableRoleList.Element." + count, availableRoleList[count]);
                ++count;
            }
        }
        this.resultStrings.put("AvailableRoleList.Count", Integer.toString(count));
        String[] assignedPageList = bookClassObject.getPageList();
        if (assignedPageList != null) {
            for (count = 0; count < assignedPageList.length; ++count) {
                this.resultStrings.put("AssignedPageList.Element." + count, assignedPageList[count]);
            }
        }
        this.resultStrings.put("AssignedPageList.Count", Integer.toString(count));
        count = 0;
        if (assignedPageList != null && availablePageList != null) {
            availablePageList = RBSUtil.removeAssignedFromAvailable(availablePageList, assignedPageList);
        }
        if (availablePageList != null) {
            while (count < availablePageList.length) {
                this.resultStrings.put("AvailablePageList.Element." + count, availablePageList[count]);
                ++count;
            }
        }
        this.resultStrings.put("AvailablePageList.Count", Integer.toString(count));
        String[] assignedClasses = bookClassObject.getObjectClassType();
        this.resultStrings.put("DB_Assigned_ClassList.Count", Integer.toString(assignedClasses.length));
        for (count = 0; count < assignedClasses.length; ++count) {
            this.resultStrings.put("DB_Assigned_ClassList.Element." + count, assignedClasses[count]);
        }
        count = 0;
        String[] availableClasses = this.PutSchemaClasses();
        if (availableClasses != null && assignedClasses != null) {
            availableClasses = RBSUtil.removeAssignedFromAvailable(availableClasses, assignedClasses);
        }
        if (availableClasses != null) {
            while (count < availableClasses.length) {
                this.resultStrings.put("Sch_ClassList.Element." + count, availableClasses[count]);
                ++count;
            }
        }
        this.resultStrings.put("Sch_ClassList.Count", Integer.toString(count));
    }

    private void PutPageClassObject(PageClassObject pageClassObject) {
        this.resultStrings.put("DP_TaskName_Value", pageClassObject.getName());
    }

    private void SavePageClassObject(PageClassObject pageClassObject) {
        pageClassObject.setName(this.req.getParameter("DP_TaskName_Name"));
    }

    private String[] PutSchemaAttributes() throws Exception {
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.context);
        String[] availableAttrs = RBSUtil.readAttributes(treeOE);
        Vector<String> attrs = new Vector<String>();
        if (availableAttrs != null) {
            for (int i = 0; i < availableAttrs.length; ++i) {
                attrs.add(availableAttrs[i]);
            }
        }
        attrs.add("[Create Object]");
        attrs.add("[Delete Object]");
        attrs.add("[Rename Object]");
        availableAttrs = null;
        if (attrs.size() > 0) {
            availableAttrs = attrs.toArray(new String[attrs.size()]);
        }
        return availableAttrs;
    }

    private String[] PutSchemaClasses() throws SPIException {
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        NDSSchemaDefinition schemaDef = (NDSSchemaDefinition)ns.getSchemaDefinition(treeOE);
        ClassDefinition[] classDef = schemaDef.getClassDefinitions();
        Vector<String> classes = new Vector<String>();
        if (classDef != null) {
            for (int i = 0; i < classDef.length; ++i) {
                classes.add(classDef[i].getName());
            }
        }
        String[] availableClasses = null;
        if (classes.size() > 0) {
            availableClasses = classes.toArray(new String[classes.size()]);
        }
        return availableClasses;
    }

    private void PutList(String[] list) {
        int count;
        if (list != null) {
            for (count = 0; count < list.length; ++count) {
                this.resultStrings.put("List.Element." + count, list[count]);
            }
        }
        this.resultStrings.put("List.Count", Integer.toString(count));
    }

    public String packMiscData(String miscData) {
        StringTokenizer stringTokenizer = new StringTokenizer(miscData, ";");
        int count = stringTokenizer.countTokens();
        String[] str = new String[count];
        int c1 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            str[c1] = stringTokenizer.nextToken();
            ++c1;
        }
        String pStr = eMFrameUtils.pack(str, this.context);
        return pStr;
    }

    public String unPackMiscData(String packData) {
        if (packData.length() == 0) {
            return "";
        }
        String[] str = eMFrameUtils.unpack(packData, this.context);
        if (str.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < str.length; ++i) {
            if (i != 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(str[i]);
        }
        String pStr = stringBuffer.toString();
        return pStr;
    }
}

