/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.util.infos.RoleInfo;
import com.novell.emframe.fw.util.infos.RoleInfoLight;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;

public class DirRoleList
extends RoleList {
    private RBSAssociatedObject m_rbsUserAssocObject = null;
    private ObjectEntry m_user = null;
    private boolean m_bRolesValid = false;
    private boolean m_bCollectionOwner;

    public DirRoleList(ObjectEntry user) {
        this.m_user = user;
    }

    public RBSAssociatedObject getRBSUserAssociatedObject() {
        return this.m_rbsUserAssocObject;
    }

    public boolean isCollectionOwnerMode(MContext context) {
        if (this.m_bRolesValid) {
            return this.m_bCollectionOwner;
        }
        String s = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.ShowRolesInOwnedCollections.enable");
        if (s != null && s.equals("false")) {
            return false;
        }
        if (this.m_rbsUserAssocObject == null) {
            this.m_rbsUserAssocObject = new RBSAssociatedObject(this.m_user);
        }
        try {
            RBSCollection[] clist = this.m_rbsUserAssocObject.getOwnedCollections2();
            return clist != null && clist.length != 0;
        }
        catch (Exception e) {
            D.log(e);
            return false;
        }
    }

    public void setCollectionOwner(boolean flag) {
        this.m_bCollectionOwner = flag;
    }

    public void doUpdateFromDirectory(MContext context, boolean bOnlyValidIfFound) {
        iMgrAuthenticator auth = context.getAuthenticator();
        if (auth == null) {
            D.log("DirRoleList: No authentication context found.  Returning without updating roles.");
            return;
        }
        FwAttr.removeFwAuthAttribute("fw.tasksByType", auth);
        HashSet<String> roles = new HashSet<String>();
        this.m_hmRolesById.clear();
        this.m_hmAllTasksById.clear();
        ArrayList lightRoles = new ArrayList();
        try {
            this.m_rbsUserAssocObject = new RBSAssociatedObject(this.m_user);
            String roleDiscoveryDomain = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.Role.discoveryDomain");
            if (roleDiscoveryDomain == null || !roleDiscoveryDomain.equals("parent") && !roleDiscoveryDomain.equals("partition") && !roleDiscoveryDomain.equals("root")) {
                D.log("PrincipalRoleList: Provider.eMFrame.Role.discoveryDomain not valid in config file, setting to parent, value is:" + roleDiscoveryDomain);
                roleDiscoveryDomain = "parent";
            }
            String dynamicGroupDiscoveryDomain = null;
            String dynamicGroupSearchType = null;
            String dynamicGroupEnabled = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.enable");
            if (dynamicGroupEnabled == null || !dynamicGroupEnabled.equalsIgnoreCase("false") && !dynamicGroupEnabled.equalsIgnoreCase("true")) {
                D.log("RoleList: Provider.eMFrame.DynamicGroup.enable not valid in config file, dynamic groups will not be used for role discovery, value is:" + dynamicGroupEnabled);
            } else if (dynamicGroupEnabled.equalsIgnoreCase("true")) {
                D.log("dynamicGroupEnabled is true.");
                dynamicGroupDiscoveryDomain = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.discoveryDomain");
                if (dynamicGroupDiscoveryDomain == null || !dynamicGroupDiscoveryDomain.equalsIgnoreCase("parent") && !dynamicGroupDiscoveryDomain.equalsIgnoreCase("partition") && !dynamicGroupDiscoveryDomain.equalsIgnoreCase("root")) {
                    D.log("RoleList: Provider.eMFrame.DynamicGroup.discoveryDomain not valid in config file, setting to parent, value is:" + dynamicGroupDiscoveryDomain);
                    dynamicGroupDiscoveryDomain = "parent";
                }
                if ((dynamicGroupSearchType = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.Searchtype")) == null || !dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjectsOnly") && !dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
                    D.log("RoleList: Provider.eMFrame.DynamicGroup.Searchtype not valid in config file, setting to DynamicGroupObjectsOnly, value is:" + dynamicGroupSearchType);
                    dynamicGroupSearchType = "DynamicGroupObjectsOnly";
                }
            } else {
                D.log("dynamicGroupEnabled is false.");
            }
            FwAttr.removeFwAuthAttribute("fw.AssignedTasks", auth);
            RBSAssociation[] assc = this.m_rbsUserAssocObject.getSpecifiedRoleAssociations2(new String[]{"iManager"}, roleDiscoveryDomain, dynamicGroupDiscoveryDomain, dynamicGroupSearchType);
            if (assc != null) {
                for (int i = 0; i < assc.length; ++i) {
                    RBSRole role = assc[i].getRole();
                    String name = role.getObjectEntry().getFullName();
                    if (roles.contains(name)) {
                        D.log("RoleList: Not adding duplicate role to users roles list - " + name);
                        continue;
                    }
                    roles.add(name);
                    lightRoles.add(new RoleInfoLight(role.getObjectEntry(), role, name, true, context));
                }
            }
        }
        catch (Exception e) {
            D.log("RoleList RBS Exception: " + e.toString());
            D.log(e);
        }
        try {
            String s = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.ShowRolesInOwnedCollections.enable");
            if (s != null && s.equals("false")) {
                this.m_bCollectionOwner = false;
            } else {
                RBSCollection[] collections = this.m_rbsUserAssocObject.getOwnedCollections2();
                if (collections == null || collections.length == 0) {
                    this.m_bCollectionOwner = false;
                } else {
                    this.m_bCollectionOwner = true;
                    for (int i = 0; i < collections.length; ++i) {
                        RBSCollection collection = collections[i];
                        ArrayList collectionRoles = RoleInfoLight.getRoles(collection);
                        lightRoles.addAll(collectionRoles);
                    }
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        this.m_bRolesValid = bOnlyValidIfFound ? lightRoles.size() > 0 : true;
        lightRoles = DirRoleList.combineDuplicateRoles(lightRoles);
        HttpSession session = context.getRequest().getSession();
        session.removeAttribute("fw.NPSRegCache");
        Iterator i = lightRoles.iterator();
        while (i.hasNext()) {
            RoleInfoLight roleInfoLight = (RoleInfoLight)i.next();
            RoleInfo roleInfo = roleInfoLight.convert(context);
            this.addRoleInfo(roleInfo);
        }
        HashMap npsMap = (HashMap)auth.getAttribute("fw.NPSRegCache");
        if (npsMap == null) {
            npsMap = new HashMap();
        }
    }

    public void updateFromReg(MContext context) {
        ArrayList roleDocs = Registry.getRegistry("Install").getRolesInView("AllTasks");
        Iterator iterRoleDocs = roleDocs.iterator();
        while (iterRoleDocs.hasNext()) {
            Document roleDoc = (Document)iterRoleDocs.next();
            Element root = roleDoc.getRootElement();
            String roleId = root.getChildTextTrim("id");
            RoleInfo ri = new RoleInfo(roleDoc, context);
            Map tasksFromFileSystem = Registry.getRegistry("Install").getTasksInRoleById(roleId);
            ri.setTasks(tasksFromFileSystem, context);
            this.addRoleInfo(ri);
        }
        this.m_bRolesValid = true;
    }

    public boolean hasRolesInDirectory(FwTaskContext context) {
        if (!this.m_bRolesValid) {
            this.doUpdateFromDirectory(context, true);
        }
        return this.m_hmRolesById.size() > 0;
    }

    public void invalidate(MContext context) {
        this.m_bRolesValid = false;
    }
}

