/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.EmailSMTPServer;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.utils.Log;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class EmailConfigTask
extends Task {
    private static final long serialVersionUID = 1L;
    private static String DT = "EmailConfigTask";
    private static String DEFAULT_SMPT_SERVER_COUNT = "2";
    private SystemConfig sc = new SystemConfig();

    public boolean execute(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        String sNumServers = req.getParameter("NumSMTPServers");
        this.updateSMTPSettings(req, sNumServers, context);
        if (sNumServers == null) {
            sNumServers = DEFAULT_SMPT_SERVER_COUNT;
        }
        req.setAttribute("Email.SMTPSender", (Object)this.sc.getSetting("Email.SMTPSender", "ServerAdmin@noreply.com"));
        sNumServers = this.sc.getSetting("SMTPServerCount", sNumServers);
        int iNum = Integer.parseInt(sNumServers);
        for (int i = 1; i <= iNum; ++i) {
            Object oServer = this.sc.getObjectSetting("Email.SMTPServer" + i);
            if (oServer != null) {
                EmailSMTPServer server = (EmailSMTPServer)oServer;
                req.setAttribute("server" + i, (Object)server.getServer());
                req.setAttribute("user" + i, (Object)server.getUsername());
                req.setAttribute("password" + i, (Object)server.getPassword());
                continue;
            }
            req.setAttribute("server" + i, (Object)"");
            req.setAttribute("user" + i, (Object)"");
            req.setAttribute("password" + i, (Object)"");
        }
        return true;
    }

    private void updateSMTPSettings(HttpServletRequest req, String sNumServers, TaskContext context) {
        boolean bCommitChanges = false;
        String sSenderAddr = req.getParameter("SenderAddr");
        if (sSenderAddr != null) {
            try {
                this.sc.setSetting("Email.SMTPSender", sSenderAddr);
                bCommitChanges = true;
            }
            catch (ConfigException e) {
                Log.log((String)DT, (int)3, (Throwable)e);
            }
        }
        if (sNumServers != null) {
            int iNum = Integer.parseInt(sNumServers);
            for (int i = 1; i <= iNum; ++i) {
                if (req.getParameter("server" + i) != null) {
                    EmailSMTPServer server = new EmailSMTPServer(req.getParameter("server" + i), req.getParameter("user" + i), req.getParameter("password" + i));
                    try {
                        this.sc.setObjectSetting("Email.SMTPServer" + i, server);
                        bCommitChanges = true;
                    }
                    catch (ConfigException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    this.sc.removeSetting("Email.SMTPServer" + i);
                    bCommitChanges = true;
                    continue;
                }
                catch (ConfigException e) {
                    Log.log((String)DT, (int)3, (Throwable)e);
                }
            }
        }
        if (bCommitChanges) {
            try {
                this.sc.writeSettings();
                this.setUIPage("dev/GenConf.jsp");
                req.setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "Email.Success", context));
                req.setAttribute("GeneralMsg.MsgBodyPlainText", (Object)eMFrameUtils.getLocalizedString("FwResources", "Email.SMTPNewSettingsSaved", context));
            }
            catch (ConfigException e) {
                e.printStackTrace();
                this.setUIPage("dev/GenErr.jsp");
                req.setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "Email.Failure", context));
                req.setAttribute("GeneralMsg.MsgBodyPlainText", (Object)e.getLocalizedMessage());
            }
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

