/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.nps.utils.Log;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;

public class EmailEvent {
    private String m_sEventID = null;
    private String m_sFromCN = null;
    private String m_sFromAddr = m_sc.getSetting("Email.SMTPSender", "ServerAdmin@noreply.com");
    private Vector m_vToAddrs = null;
    private String m_sSubject = null;
    private String m_sMessage = null;
    private static String DT = "EmailEvent";
    private static SystemConfig m_sc = new SystemConfig();

    public EmailEvent(TaskContext context, String sEventID, Vector vToAddrs) {
        this.m_sFromCN = FwAuthUtils.getUserId(context.getRequest());
        Registry reg = Registry.getRegistry("Install");
        Document dom = reg.getEmailEventPlugin(sEventID);
        if (dom != null) {
            Element root = dom.getRootElement();
            try {
                String propsFile = root.getChild("resource-properties-file").getText();
                if (propsFile != null) {
                    this.m_sSubject = eMFrameUtils.getLocalizedString(propsFile, root.getChild("subject-key").getTextTrim(), context.getLocale());
                    this.m_sMessage = eMFrameUtils.getLocalizedString(propsFile, root.getChild("message-key").getTextTrim(), context.getLocale());
                }
            }
            catch (Exception e) {
                Log.log((String)DT, (int)3, (Throwable)e);
            }
            if (this.m_sSubject == null) {
                this.m_sSubject = root.getChild("subject-key").getTextTrim();
            }
            if (this.m_sMessage == null) {
                this.m_sMessage = root.getChild("message-key").getTextTrim();
            }
        }
        this.m_sSubject = m_sc.getSetting("Email.EventSubject." + sEventID, this.m_sSubject);
        this.m_sMessage = m_sc.getSetting("Email.EventMessage." + sEventID, this.m_sMessage);
        this.m_sSubject = NPSCompatUtils.parseMacroString(this.m_sSubject, context);
        this.m_sMessage = NPSCompatUtils.parseMacroString(this.m_sMessage, context);
        this.m_sEventID = sEventID;
        this.m_vToAddrs = vToAddrs;
    }

    public String getSenderCN() {
        return this.m_sFromCN;
    }

    public String getSenderAddr() {
        return this.m_sFromAddr;
    }

    public void addSendTo(String emailAddr) {
        if (this.m_vToAddrs == null) {
            this.m_vToAddrs = new Vector();
        }
        this.m_vToAddrs.add(emailAddr);
    }

    public void removeSendTo(String emailAddr) {
        if (this.m_vToAddrs != null) {
            this.m_vToAddrs.remove(emailAddr);
        }
    }

    public String getEventID() {
        return this.m_sEventID;
    }

    public Vector getSendToAddrs() {
        return this.m_vToAddrs;
    }

    public String getSubjectString() {
        return this.m_sSubject;
    }

    public String getMessageString() {
        return this.m_sMessage;
    }
}

