/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.EmailEvent;
import com.novell.emframe.fw.EmailEventService;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.nps.utils.Log;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class EmailNotifyConfigTask
extends Task {
    private static final long serialVersionUID = 1L;
    private SystemConfig m_sc = null;
    private static String DT = "EmailNotifyConfig";
    private static final String EVENT_SUBJECT = "eventSubject";
    private static final String EVENT_MESSAGE = "eventMessage";
    private static final String EVENT_ADDRS = "eventAddrs";
    private static final String EVENT_OVERRIDE = "eventAddrOverride";
    private static Hashtable ht_sampleEvent = null;
    private static final String EVENT_ID = "eventID";

    public boolean execute(TaskContext context, Properties resultStrings) {
        String action;
        HttpServletRequest req = context.getRequest();
        Registry reg = Registry.getRegistry("Install");
        Hashtable events = reg.getAllEmailEventPlugins();
        if (events.isEmpty()) {
            events = this.getSampleEvent();
        }
        if (this.m_sc == null) {
            this.m_sc = new SystemConfig();
        }
        if ((action = req.getParameter("EmailAction")) != null) {
            if (action.equalsIgnoreCase("EditEvent")) {
                this.doEditEvent(req);
                this.setUIPage("fw/EmailEditItem.jsp");
                return true;
            }
            if (action.equalsIgnoreCase("UpdateEvent")) {
                this.doUpdateEvent(req);
            } else {
                String sTestID;
                if (action.equalsIgnoreCase("UpdateList")) {
                    this.doUpdateList(req, context);
                    return true;
                }
                if (action.equalsIgnoreCase("FireTestEvent") && (sTestID = req.getParameter("TestEvent")) != null && sTestID.length() > 0) {
                    this.testEvent(sTestID, context, events);
                }
            }
        }
        this.setUIPage("fw/EmailNotifyConfigTask.jsp");
        this.setEventsOnRequest(req, events);
        req.setAttribute("System.Config", (Object)this.m_sc);
        if (this.m_sc.getSetting("Email.EventAdminAddrs") != null) {
            req.setAttribute("Email.EventAdminAddrs", (Object)this.m_sc.getSetting("Email.EventAdminAddrs"));
        } else {
            req.setAttribute("Email.EventAdminAddrs", (Object)"");
        }
        return true;
    }

    private synchronized Hashtable getSampleEvent() {
        if (ht_sampleEvent == null) {
            Document dom = new Document();
            Element rootElem = new Element("email-event");
            Element first = new Element("id");
            first.setText("SampleEvent");
            rootElem.addContent(first);
            Element second = new Element("resource-properties-file");
            second.setText("SampleTaskStrings");
            rootElem.addContent(second);
            Element third = new Element("display-name-key");
            third.setText("SampleEventKey");
            rootElem.addContent(third);
            Element fourth = new Element("description-key");
            fourth.setText("SampleEventDescriptionKey");
            rootElem.addContent(fourth);
            dom.setRootElement(rootElem);
            Hashtable<String, Document> temp = new Hashtable<String, Document>();
            temp.put("SampleEvent", dom);
            ht_sampleEvent = temp;
        }
        return ht_sampleEvent;
    }

    private void setEventsOnRequest(HttpServletRequest req, Hashtable events) {
        req.setAttribute("System.Email.Events", (Object)events);
        String[] saSelected = this.m_sc.getSettings("Email.EventsSelected");
        if (saSelected != null) {
            for (int i = 0; i < saSelected.length; ++i) {
                String s = saSelected[i];
                req.setAttribute(s, (Object)"selected");
            }
        }
    }

    private void doUpdateList(HttpServletRequest req, TaskContext context) {
        String sEmailAddr = req.getParameter("EmailAddress");
        try {
            if (sEmailAddr != null && sEmailAddr.length() > 0) {
                this.m_sc.setSetting("Email.EventAdminAddrs", sEmailAddr);
            } else {
                this.m_sc.removeSetting("Email.EventAdminAddrs");
            }
        }
        catch (ConfigException e) {
            Log.log((String)DT, (int)3, (Throwable)e);
        }
        String[] saEvents = req.getParameterValues("SelectedEvents");
        try {
            if (saEvents != null && saEvents.length > 0) {
                this.m_sc.setSetting("Email.EventsSelected", saEvents);
            } else {
                this.m_sc.removeSetting("Email.EventsSelected");
            }
        }
        catch (ConfigException e) {
            Log.log((String)DT, (int)3, (Throwable)e);
        }
        try {
            this.m_sc.writeSettings();
            this.setUIPage("dev/GenConf.jsp");
            req.setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "Email.Success", context));
            req.setAttribute("GeneralMsg.MsgBodyPlainText", (Object)eMFrameUtils.getLocalizedString("FwResources", "Task.Event.NewEventsSaved", context));
        }
        catch (ConfigException e) {
            Log.log((String)DT, (int)3, (Throwable)e);
            this.setUIPage("dev/GenErr.jsp");
            req.setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "Email.Failure", context));
            req.setAttribute("GeneralMsg.MsgBodyPlainText", (Object)e.getLocalizedMessage());
        }
    }

    private void doEditEvent(HttpServletRequest req) {
        String eventID = req.getParameter("EventID");
        if (eventID != null) {
            String subject = this.m_sc.getSetting("Email.EventSubject." + eventID, "");
            String message = this.m_sc.getSetting("Email.EventMessage." + eventID, "");
            String addrs = this.m_sc.getSetting("Email.EventAltAddrs." + eventID, "");
            String override = this.m_sc.getSetting("Email.EventAddrOverride." + eventID, "false");
            req.setAttribute(EVENT_ID, (Object)eventID);
            req.setAttribute(EVENT_SUBJECT, (Object)subject);
            req.setAttribute(EVENT_MESSAGE, (Object)message);
            req.setAttribute(EVENT_ADDRS, (Object)addrs);
            req.setAttribute(EVENT_OVERRIDE, (Object)override);
        }
    }

    private void doUpdateEvent(HttpServletRequest req) {
        String eventID = req.getParameter(EVENT_ID);
        if (eventID != null) {
            String subject = req.getParameter(EVENT_SUBJECT);
            String message = req.getParameter(EVENT_MESSAGE);
            String addrs = req.getParameter(EVENT_ADDRS);
            String override = req.getParameter(EVENT_OVERRIDE);
            try {
                if (subject != null && subject.length() > 0) {
                    this.m_sc.setSetting("Email.EventSubject." + eventID, subject);
                } else {
                    this.m_sc.removeSetting("Email.EventSubject." + eventID);
                }
                if (message != null && message.length() > 0) {
                    this.m_sc.setSetting("Email.EventMessage." + eventID, message);
                } else {
                    this.m_sc.removeSetting("Email.EventMessage." + eventID);
                }
                if (addrs != null && addrs.length() > 0) {
                    this.m_sc.setSetting("Email.EventAltAddrs." + eventID, addrs);
                } else {
                    this.m_sc.removeSetting("Email.EventAltAddrs." + eventID);
                }
                if (override != null && override.length() > 0) {
                    this.m_sc.setSetting("Email.EventAddrOverride." + eventID, "true");
                } else {
                    this.m_sc.removeSetting("Email.EventAddrOverride." + eventID);
                }
                this.m_sc.writeSettings();
            }
            catch (ConfigException e) {
                Log.log((String)DT, (int)3, (Throwable)e);
            }
        }
    }

    private void testEvent(String eventID, TaskContext context, Hashtable events) {
        Document dom = (Document)events.get(eventID);
        if (dom != null) {
            EmailEvent event = new EmailEvent(context, eventID, null);
            EmailEventService.postEventEmail(event);
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

