/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.eDirAccessService;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.EdasRightsData;
import com.novell.emframe.fw.FakeRightsCache;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.studio.TemplateBuilder;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ExtendObjectTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_OBJECTNAME = "DeleteObjectName";
    public static final String STR_TARGETOBJECT = "objectTypeName";
    HttpServletRequest req;
    TaskContext m_context;
    Properties m_resultStrings;
    Vector objectVector = null;
    public boolean isMultipleObject = false;

    public boolean execute(TaskContext context, Properties resultStrings) {
        String nextState;
        if (this.objectVector == null) {
            this.objectVector = new Vector(10);
        }
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.req = context.getRequest();
        String scripting = this.req.getParameter("scripting");
        if (scripting == null || scripting.equalsIgnoreCase("true")) {
            // empty if block
        }
        if ((nextState = this.req.getParameter("nextState")) == null || nextState == null || nextState.equalsIgnoreCase("initialState")) {
            this.m_resultStrings.put("Task.nextMerge", this.req.getParameter("merge"));
            this.m_resultStrings.put("Task.nextState", "doShowExtensions");
            this.m_resultStrings.put("Task.Icon.name", "dir/auxclass.gif");
            this.m_resultStrings.put("Task.Icon.alt", eMFrameUtils.getLocalizedString("BaseResources", "ExtendIconAlt", context));
            this.m_resultStrings.put("Task.displayName", eMFrameUtils.getLocalizedString("BaseResources", "ExtendObjectTaskDisplayName", context));
            this.m_resultStrings.put("TC.prompt", eMFrameUtils.getLocalizedString("BaseResources", "ExtendPrompt", context));
            this.m_resultStrings.put("TC.multipleObjectEnabled", "true");
            this.setUIPage("dev/TC.jsp");
            eMFrameUtils.setupTargetChooser(null, context);
            return true;
        }
        if (nextState.equalsIgnoreCase("doShowExtensions")) {
            this.m_resultStrings.put("Task.nextState", "doExtendObject");
            String[] targets = eMFrameUtils.unpack(this.req.getParameter("eDir$target"), context);
            this.m_resultStrings.put("Task.targetDisplayName", this.getTargetDisplayName(targets));
            this.m_resultStrings.put("Task.targetCount", "" + targets.length);
            if (targets.length > 1) {
                this.isMultipleObject = true;
            }
            return this.doShowExtensions(targets);
        }
        if (nextState.equalsIgnoreCase("doShowClasses")) {
            String[] targets = eMFrameUtils.unpack(this.req.getParameter("eDir$target"), context);
            this.m_resultStrings.put("Task.targetDisplayName", this.getTargetDisplayName(targets));
            this.m_resultStrings.put("Task.targetCount", "" + targets.length);
            if (targets.length > 1) {
                this.isMultipleObject = true;
            }
            return this.doShowClasses(targets);
        }
        if (nextState.equalsIgnoreCase("doExtendObject")) {
            String className = eMFrameUtils.replaceNonAsciiWithAscii(this.req.getParameter("className"), "&#160;", " ");
            String[] targets = eMFrameUtils.unpack(this.req.getParameter("eDir$target"), context);
            this.m_resultStrings.put("Task.targetDisplayName", this.getTargetDisplayName(targets));
            this.m_resultStrings.put("Task.targetCount", "" + targets.length);
            if (targets.length > 1) {
                this.isMultipleObject = true;
            }
            if (this.doExtendObject(className, targets)) {
                return this.doShowExtensions(targets);
            }
            return false;
        }
        if (nextState.equalsIgnoreCase("doRemoveObject")) {
            String className = eMFrameUtils.replaceNonAsciiWithAscii(this.req.getParameter("className"), "&#160;", " ");
            String[] targets = eMFrameUtils.unpack(this.req.getParameter("eDir$target"), context);
            this.m_resultStrings.put("Task.targetDisplayName", this.getTargetDisplayName(targets));
            this.m_resultStrings.put("Task.targetCount", "" + targets.length);
            if (targets.length > 1) {
                this.isMultipleObject = true;
            }
            if (this.doRemoveClass(className, targets)) {
                return this.doShowExtensions(targets);
            }
            return false;
        }
        if (nextState.equalsIgnoreCase("doRemoveClasses")) {
            String[] targets = eMFrameUtils.unpack(this.req.getParameter("eDir$target"), context);
            this.m_resultStrings.put("Task.targetDisplayName", this.getTargetDisplayName(targets));
            if (targets.length > 1) {
                this.isMultipleObject = true;
            }
            return this.doShowExtensionsMulObj(targets);
        }
        if (nextState.equalsIgnoreCase("doEDAS")) {
            String[] targets = eMFrameUtils.unpack(this.req.getParameter("eDir$target"), context);
            eDirAccessService edas = new eDirAccessService();
            boolean result = edas.execute(context, this.m_resultStrings);
            if (targets.length > 1) {
                this.setUIPage("fw/Progress.jsp");
            }
            return result;
        }
        if (nextState.equalsIgnoreCase("progress") || nextState.equalsIgnoreCase("progress.cancel")) {
            eDirAccessService edas = new eDirAccessService();
            boolean result = edas.execute(context, this.m_resultStrings);
            return result;
        }
        return true;
    }

    private AttributeDefinition[] filterAttributeArray(AttributeDefinition[] ada) {
        AttributeDefinition[] newArray = new AttributeDefinition[ada.length - 1];
        int j = 0;
        for (int i = 0; i < ada.length; ++i) {
            if (ada[i].getName().equalsIgnoreCase("Object Class") || ada[i].getName().equalsIgnoreCase("objectClass")) continue;
            newArray[j++] = ada[i];
        }
        return newArray;
    }

    private boolean doExtendObject(String className, String[] targets) {
        String aDN = null;
        ObjectEntry targetOE = null;
        NSObject nsObj = null;
        boolean mandatoryAttrTobeShown = false;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
        AttributeDefinition[] attributeDefs = null;
        try {
            for (int j = 0; j < targets.length; ++j) {
                aDN = targets[j];
                targetOE = ns.getObjectEntry(treeOE, aDN);
                SchemaDefinition sd = ns.getSchemaDefinition(targetOE);
                ClassDefinition cd = sd.getClassDefinition(className);
                nsObj = ns.getDetails(targetOE);
                attributeDefs = cd.getMandatoryAttributes();
                ObjectAttribute[] oaa = null;
                if (attributeDefs.length == 0) {
                    oaa = new ObjectAttribute[]{};
                    nsObj.addAuxiliaryClassDefinition(cd, oaa);
                    ns.update(nsObj);
                    continue;
                }
                for (int i = 0; i < attributeDefs.length; ++i) {
                    String objclassAttr = SchemaUtil.translateNDAPAttr((ObjectEntry)targetOE, (String)"Object Class");
                    if (!attributeDefs[i].getName().equals(objclassAttr)) continue;
                    attributeDefs = this.filterAttributeArray(attributeDefs);
                    break;
                }
                if (attributeDefs.length == 0) {
                    oaa = new ObjectAttribute[]{};
                    nsObj.addAuxiliaryClassDefinition(cd, oaa);
                    ns.update(nsObj);
                    continue;
                }
                mandatoryAttrTobeShown = true;
            }
            if (mandatoryAttrTobeShown) {
                mandatoryAttrTobeShown = false;
                String client = ((FwTaskContext)((Object)this.m_context)).getUserInfo().getHtmlDirectory();
                DirUtils dirUtils = ((FwTaskContext)((Object)this.m_context)).getDirUtils();
                String[] superClasses = dirUtils.getSuperClasses(className);
                UiHandler[] handlers = TemplateBuilder.getDefaultHandlers(this.m_context, attributeDefs, client, className, superClasses, true, false);
                String tempDir = iManager.getAbsModulesPath() + "/temp/skins/default/devices/" + client + "/";
                String safeclassName = dirUtils.getSafeName(className) + TemplateBuilder.getVersionString(this.m_context);
                File file = new File(tempDir + "auxcreator" + safeclassName + ".jsp");
                if (!file.exists()) {
                    TemplateBuilder.createTemplate(this.m_context, handlers, client, false, "TemplateBuilder_skeletonAuxExtension.jsp", null, true, "temp", "auxcreator" + safeclassName + ".jsp", true);
                }
                this.setUIPage("temp/auxcreator" + safeclassName + ".jsp");
                this.m_resultStrings.put("auxillaryClassExtension", dirUtils.getSafeName(className));
                this.m_resultStrings.put("Task.displayName", eMFrameUtils.getLocalizedString("BaseResources", "ExtendObjectTaskDisplayName", this.m_context));
                for (int cntr = 0; cntr < attributeDefs.length; ++cntr) {
                    String temp = dirUtils.getSafeName(attributeDefs[cntr].getName()) + "DisplayName";
                    this.m_resultStrings.put(temp, dirUtils.getAttributeDisplayName(attributeDefs[cntr].getName(), this.m_context));
                }
                eDirAccessService edas = new eDirAccessService();
                this.req.setAttribute("eDirCommand", (Object)"read");
                this.req.setAttribute("eDirSearch", (Object)"*");
                ((I18NServletRequest)this.req).setParameter("eDir$target", eMFrameUtils.pack(targets, this.m_context));
                edas.init(this.m_context, null);
                edas.execute(this.m_context, this.m_resultStrings);
                this.m_context.getRequest().setAttribute("edasRights", (Object)new EdasRightsData(new FakeRightsCache()));
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        return true;
    }

    private boolean doRemoveClass(String className, String[] targets) {
        String aDN = null;
        ObjectEntry oe = null;
        NSObject nsObj = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
        try {
            for (int i = 0; i < targets.length; ++i) {
                aDN = targets[i];
                oe = ns.getObjectEntry(treeOE, aDN);
                SchemaDefinition sd = ns.getSchemaDefinition(oe);
                ClassDefinition cd = sd.getClassDefinition(className);
                nsObj = ns.getDetails(oe);
                nsObj.deleteAuxiliaryClassDefinition(cd);
                ns.update(nsObj);
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        return true;
    }

    private boolean doShowExtensionsMulObj(String[] targets) {
        String aDN = null;
        ObjectEntry oe = null;
        NSObject nsObj = null;
        ClassDefinition[] defs = null;
        ArrayList[] classLists = new ArrayList[targets.length];
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
        try {
            int i;
            for (i = 0; i < targets.length; ++i) {
                aDN = targets[i];
                oe = ns.getObjectEntry(treeOE, aDN);
                this.m_context.addToHistory(oe);
                nsObj = ns.getDetails(oe);
                defs = nsObj.getClassDefinitions();
                classLists[i] = new ArrayList();
                this.m_resultStrings.put("PreviewFilter." + i + ".name", aDN);
                this.m_resultStrings.put("PreviewFilter." + i + ".typeIcon", this.m_context.getDirUtils().getObjectTypeImageName(oe.getTypeName()));
                for (int j = 0; j < defs.length; ++j) {
                    if (!defs[j].isAuxiliary()) continue;
                    classLists[i].add(defs[j].getName());
                }
            }
            this.m_resultStrings.put("PreviewFilter.count", "" + targets.length);
            this.m_resultStrings.put("isMultipleObject", "" + this.isMultipleObject);
            for (i = 0; i < classLists.length - 1; ++i) {
                classLists[i + 1].retainAll(classLists[i]);
            }
            int classes = 0;
            for (int i2 = 0; i2 < classLists[classLists.length - 1].size(); ++i2) {
                this.m_resultStrings.put("auxClass." + classes, classLists[classLists.length - 1].get(i2));
                ++classes;
            }
            this.m_resultStrings.put("auxClass.count", "" + classes);
        }
        catch (SPIException e) {
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        return true;
    }

    private boolean doShowExtensions(String[] targets) {
        if (this.isMultipleObject) {
            return this.doShowExtensionsMulObj(targets);
        }
        String aDN = null;
        ObjectEntry oe = null;
        NSObject nsObj = null;
        ClassDefinition[] defs = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
        aDN = targets[0];
        try {
            oe = ns.getObjectEntry(treeOE, aDN);
            this.m_context.addToHistory(oe);
            nsObj = ns.getDetails(oe);
            defs = nsObj.getClassDefinitions();
            int classes = 0;
            for (int i = 0; i < defs.length; ++i) {
                if (!defs[i].isAuxiliary()) continue;
                this.m_resultStrings.put("auxClass." + classes, defs[i].getName());
                ++classes;
            }
            this.m_resultStrings.put("auxClass.count", "" + classes);
        }
        catch (SPIException e) {
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        return true;
    }

    private boolean doShowClasses(String[] targets) {
        Vector<String> vCurrent = new Vector<String>();
        String aDN = null;
        ObjectEntry oe = null;
        NSObject nsObj = null;
        ClassDefinition[] defs = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = (AdminNamespace)treeOE.getNamespace();
        aDN = targets[0];
        try {
            oe = ns.getObjectEntry(treeOE, aDN);
            nsObj = ns.getDetails(oe);
            defs = nsObj.getClassDefinitions();
            for (int i = 0; i < defs.length; ++i) {
                if (!defs[i].isAuxiliary()) continue;
                vCurrent.add(new String(defs[i].getName()));
            }
            SchemaDefinition sd = ns.getSchemaDefinition(treeOE);
            defs = sd.getClassDefinitions();
            Arrays.sort(defs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ClassDefinition c1 = (ClassDefinition)o1;
                    ClassDefinition c2 = (ClassDefinition)o2;
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            int classes = 0;
            for (int j = 0; j < defs.length; ++j) {
                String className = new String(defs[j].getName());
                boolean tempMultipleObj = false;
                if (this.isMultipleObject) {
                    tempMultipleObj = false;
                } else if (vCurrent.contains(className)) {
                    tempMultipleObj = true;
                }
                if (!defs[j].isAuxiliary() || tempMultipleObj || defs[j].getName().equals("Partition") || defs[j].getName().equals("federationBoundary")) continue;
                if (defs[j].getMandatoryAttributes().length != 0) {
                    this.m_resultStrings.put("auxClassHasMandatory." + classes, "true");
                } else {
                    this.m_resultStrings.put("auxClassHasMandatory." + classes, "false");
                }
                this.m_resultStrings.put("auxClass." + classes, className);
                ++classes;
            }
            this.m_resultStrings.put("auxClass.count", "" + classes);
        }
        catch (SPIException e) {
            D.log("SPIException: " + e.getMessage());
        }
        return true;
    }

    private String getTargetDisplayName(String[] targets) {
        String targetDisplayName;
        if (targets.length > 1) {
            Object[] params = new String[]{"" + targets.length};
            String pattern = eMFrameUtils.getLocalizedString("DevResources", "General.nObjects", this.m_context);
            targetDisplayName = eMFrameUtils.formatMessage(pattern, params);
        } else {
            targetDisplayName = targets[0];
        }
        return targetDisplayName;
    }
}

